/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.io.IOException;
import java.io.Writer;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TreeSet;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.Globals;
import net.sf.jabref.export.FieldFormatter;
import net.sf.jabref.util.StringUtil;

public class BibtexEntryWriter {
    private static final Map<String, String> tagDisplayNameMap = new HashMap<String, String>();
    private static final int maxFieldLength;
    private final FieldFormatter fieldFormatter;
    private final boolean write;
    private final boolean writeFieldCameCaseName = Globals.prefs.getBoolean("writeFieldCamelCase");
    private final boolean writeFieldAddSpaces = Globals.prefs.getBoolean("writeFieldAddSpaces");
    private final boolean includeEmptyFields = Globals.prefs.getBoolean("includeEmptyFields");
    private final int writeFieldSortStyle = Globals.prefs.getInt("writefieldSortStyle");

    public BibtexEntryWriter(FieldFormatter fieldFormatter, boolean bl) {
        this.fieldFormatter = fieldFormatter;
        this.write = bl;
    }

    public void write(BibtexEntry bibtexEntry, Writer writer) throws IOException {
        switch (this.writeFieldSortStyle) {
            case 0: {
                this.writeNewStyle(bibtexEntry, writer);
                break;
            }
            case 1: {
                this.writeOldStyle(bibtexEntry, writer);
                break;
            }
            case 2: {
                this.writeUserDefinedOrder(bibtexEntry, writer);
            }
        }
    }

    private void writeNewStyle(BibtexEntry bibtexEntry, Writer writer) throws IOException {
        writer.write('@' + bibtexEntry.getType().getName() + '{');
        String string = StringUtil.shaveString(bibtexEntry.getField("bibtexkey"));
        writer.write((string == null ? "" : string) + ',' + Globals.NEWLINE);
        HashMap hashMap = new HashMap();
        hashMap.put("bibtexkey", null);
        boolean bl = this.writeField(bibtexEntry, writer, "title", false, false);
        hashMap.put("title", null);
        Object[] objectArray = bibtexEntry.getRequiredFields();
        if (objectArray != null) {
            Arrays.sort(objectArray);
            for (Object object : objectArray) {
                if (hashMap.containsKey(object)) continue;
                bl |= this.writeField(bibtexEntry, writer, (String)object, bl, false);
                hashMap.put(object, null);
            }
        }
        objectArray = bibtexEntry.getOptionalFields();
        int n = 1;
        int n2 = 0;
        if (objectArray != null) {
            Arrays.sort(objectArray);
            for (Object object : objectArray) {
                if (hashMap.containsKey(object)) continue;
                bl |= this.writeField(bibtexEntry, writer, (String)object, bl, false);
                hashMap.put(object, null);
                n = 0;
                n2 = 1;
            }
        }
        TreeSet<String> treeSet = new TreeSet<String>();
        for (String string2 : bibtexEntry.getAllFields()) {
            boolean bl2;
            boolean bl3 = bl2 = this.write ? BibtexFields.isWriteableField(string2) : BibtexFields.isDisplayableField(string2);
            if (hashMap.containsKey(string2) || !bl2) continue;
            treeSet.add(string2);
        }
        n = n2;
        for (String string3 : treeSet) {
            bl |= this.writeField(bibtexEntry, writer, string3, bl, false);
            n = 0;
        }
        writer.write((bl ? Globals.NEWLINE : "") + '}' + Globals.NEWLINE);
    }

    private void writeOldStyle(BibtexEntry bibtexEntry, Writer writer) throws IOException {
        writer.write('@' + bibtexEntry.getType().getName().toUpperCase(Locale.US) + '{');
        String string = StringUtil.shaveString(bibtexEntry.getField("bibtexkey"));
        writer.write((string == null ? "" : string) + ',' + Globals.NEWLINE);
        HashMap hashMap = new HashMap();
        hashMap.put("bibtexkey", null);
        boolean bl = false;
        String[] stringArray = bibtexEntry.getRequiredFields();
        if (stringArray != null) {
            for (String string2 : stringArray) {
                bl |= this.writeField(bibtexEntry, writer, string2, bl, false);
                hashMap.put(string2, null);
            }
        }
        if ((stringArray = bibtexEntry.getOptionalFields()) != null) {
            for (String string2 : stringArray) {
                if (hashMap.containsKey(string2)) continue;
                bl |= this.writeField(bibtexEntry, writer, string2, bl, false);
                hashMap.put(string2, null);
            }
        }
        TreeSet treeSet = new TreeSet();
        for (String string3 : bibtexEntry.getAllFields()) {
            boolean bl2;
            boolean bl3 = bl2 = this.write ? BibtexFields.isWriteableField(string3) : BibtexFields.isDisplayableField(string3);
            if (hashMap.containsKey(string3) || !bl2) continue;
            treeSet.add(string3);
        }
        Iterator<String> iterator = treeSet.iterator();
        while (iterator.hasNext()) {
            String string4 = iterator.next();
            bl |= this.writeField(bibtexEntry, writer, string4, bl, false);
        }
        writer.write((bl ? Globals.NEWLINE : "") + '}' + Globals.NEWLINE);
    }

    private void writeUserDefinedOrder(BibtexEntry bibtexEntry, Writer writer) throws IOException {
        writer.write('@' + bibtexEntry.getType().getName() + '{');
        String string = StringUtil.shaveString(bibtexEntry.getField("bibtexkey"));
        writer.write((string == null ? "" : string) + ',' + Globals.NEWLINE);
        HashMap hashMap = new HashMap();
        hashMap.put("bibtexkey", null);
        boolean bl = false;
        String[] stringArray = bibtexEntry.getUserDefinedFields();
        if (stringArray != null) {
            for (String string2 : stringArray) {
                if (hashMap.containsKey(string2)) continue;
                bl |= this.writeField(bibtexEntry, writer, string2, bl, false);
                hashMap.put(string2, null);
            }
        }
        int n = 0;
        TreeSet<String> treeSet = new TreeSet<String>();
        for (String string3 : bibtexEntry.getAllFields()) {
            boolean bl2;
            boolean bl3 = bl2 = this.write ? BibtexFields.isWriteableField(string3) : BibtexFields.isDisplayableField(string3);
            if (hashMap.containsKey(string3) || !bl2) continue;
            treeSet.add(string3);
        }
        int n2 = n;
        for (String string3 : treeSet) {
            bl |= this.writeField(bibtexEntry, writer, string3, bl, false);
            n2 = 0;
        }
        writer.write((bl ? Globals.NEWLINE : "") + '}' + Globals.NEWLINE);
    }

    private boolean writeField(BibtexEntry bibtexEntry, Writer writer, String string, boolean bl, boolean bl2) throws IOException {
        String string2 = bibtexEntry.getField(string);
        if (string2 != null || this.includeEmptyFields) {
            if (bl) {
                writer.write(',' + Globals.NEWLINE);
            }
            if (bl2) {
                writer.write(Globals.NEWLINE);
            }
            writer.write("  " + this.getFieldDisplayName(string) + " = ");
            try {
                writer.write(this.fieldFormatter.format(string2, string));
            }
            catch (Throwable throwable) {
                throw new IOException(Globals.lang("Error in field") + " '" + string + "': " + throwable.getMessage());
            }
            return true;
        }
        return false;
    }

    private String getFieldDisplayName(String string) {
        if (string.isEmpty()) {
            string = "UNKNOWN";
        }
        String string2 = "";
        if (this.writeFieldAddSpaces) {
            for (int i = maxFieldLength - string.length(); i > 0; --i) {
                string2 = string2 + " ";
            }
        }
        String string3 = this.writeFieldCameCaseName ? (tagDisplayNameMap.containsKey(string.toLowerCase()) ? tagDisplayNameMap.get(string.toLowerCase()) + string2 : (string.charAt(0) + "").toUpperCase() + string.substring(1) + string2) : string + string2;
        return string3;
    }

    static {
        tagDisplayNameMap.put("bibtexkey", "BibTeXKey");
        tagDisplayNameMap.put("howpublished", "HowPublished");
        tagDisplayNameMap.put("lastchecked", "LastChecked");
        tagDisplayNameMap.put("isbn", "ISBN");
        tagDisplayNameMap.put("issn", "ISSN");
        tagDisplayNameMap.put("UNKNOWN", "UNKNOWN");
        int n = 0;
        for (BibtexEntryType bibtexEntryType : BibtexEntryType.getAllValues()) {
            if (bibtexEntryType.getRequiredFields() != null) {
                for (String string : bibtexEntryType.getRequiredFields()) {
                    n = Math.max(n, string.length());
                }
            }
            if (bibtexEntryType.getOptionalFields() == null) continue;
            for (String string : bibtexEntryType.getOptionalFields()) {
                n = Math.max(n, string.length());
            }
        }
        maxFieldLength = n;
    }
}

