/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

public class BibtexString {
    private String _name;
    private String _content;
    private String _id;
    private Type _type;

    public BibtexString(String string, String string2, String string3) {
        this._id = string;
        this._name = string2;
        this._content = string3;
        this._type = Type.get(string2);
    }

    public BibtexString(String string, String string2, String string3, Type type) {
        this._id = string;
        this._name = string2;
        this._content = string3;
        this._type = type;
    }

    public String getId() {
        return this._id;
    }

    public void setId(String string) {
        this._id = string;
    }

    public String getName() {
        return this._name;
    }

    public void setName(String string) {
        this._name = string;
        this._type = Type.get(string);
    }

    public String getContent() {
        return this._content == null ? "" : this._content;
    }

    public void setContent(String string) {
        this._content = string;
    }

    public Object clone() {
        return new BibtexString(this._id, this._name, this._content);
    }

    public Type getType() {
        return this._type;
    }

    public static enum Type {
        AUTHOR("a"),
        INSTITUTION("i"),
        PUBLISHER("p"),
        OTHER("");

        private final String prefix;

        private Type(String string2) {
            this.prefix = string2;
        }

        public static Type get(String string) {
            if (string.length() <= 1) {
                return OTHER;
            }
            if (!(string.charAt(1) + "").toUpperCase().equals(string.charAt(1) + "")) {
                return OTHER;
            }
            for (Type type : Type.values()) {
                if (!type.prefix.equals(string.charAt(0) + "")) continue;
                return type;
            }
            return OTHER;
        }
    }
}

