/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JTextField;
import net.sf.jabref.FocusRequester;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.FileDialogs;

public class BrowseAction
extends AbstractAction
implements ActionListener {
    private static final long serialVersionUID = 3007593430933681310L;
    private final JFrame frame;
    private final JTextField comp;
    private final boolean dir;
    private final JComponent focusTarget;

    public static BrowseAction buildForDir(JFrame jFrame, JTextField jTextField) {
        return new BrowseAction(jFrame, jTextField, true, null);
    }

    public static BrowseAction buildForDir(JTextField jTextField) {
        return new BrowseAction(null, jTextField, true, null);
    }

    public static BrowseAction buildForFile(JTextField jTextField) {
        return new BrowseAction(null, jTextField, false, null);
    }

    public static BrowseAction buildForFile(JTextField jTextField, JComponent jComponent) {
        return new BrowseAction(null, jTextField, false, jComponent);
    }

    public static BrowseAction buildForDir(JTextField jTextField, JComponent jComponent) {
        return new BrowseAction(null, jTextField, true, jComponent);
    }

    private BrowseAction(JFrame jFrame, JTextField jTextField, boolean bl, JComponent jComponent) {
        super(Globals.lang("Browse"));
        this.frame = jFrame;
        this.dir = bl;
        this.comp = jTextField;
        this.focusTarget = jComponent;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String string = this.askUser();
        if (string != null) {
            File file = new File(string);
            this.comp.setText(file.getPath());
            if (this.focusTarget != null) {
                new FocusRequester(this.focusTarget);
            }
        }
    }

    private String askUser() {
        if (this.dir) {
            return FileDialogs.getNewDir(this.frame, new File(this.comp.getText()), "_non__", 0, false);
        }
        return FileDialogs.getNewFile(this.frame, new File(this.comp.getText()), "_non__", 0, false);
    }
}

