/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.TreeSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.jabref.BasePanel;
import net.sf.jabref.FocusRequester;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MetaData;
import net.sf.jabref.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class ContentSelectorDialog2
extends JDialog {
    private static final long serialVersionUID = 1L;
    private ActionListener wordEditFieldListener = null;
    private final GridBagLayout gbl = new GridBagLayout();
    private final GridBagConstraints con = new GridBagConstraints();
    private final JPanel fieldPan = new JPanel();
    private final JPanel wordPan = new JPanel();
    private final JPanel buttonPan = new JPanel();
    private final JPanel fieldNamePan = new JPanel();
    private final JPanel wordEditPan = new JPanel();
    final String WORD_EMPTY_TEXT = Globals.lang("<no field>");
    private final String WORD_FIRSTLINE_TEXT = Globals.lang("<select word>");
    private final String FIELD_FIRST_LINE = Globals.lang("<field name>");
    private final MetaData metaData;
    private String currentField = null;
    TreeSet<String> fieldSet;
    private final JabRefFrame frame;
    private final BasePanel panel;
    private final JButton help = new JButton(Globals.lang("Help"));
    private final JButton newField = new JButton(Globals.lang("New"));
    private final JButton removeField = new JButton(Globals.lang("Remove"));
    private final JButton newWord = new JButton(Globals.lang("New"));
    private final JButton removeWord = new JButton(Globals.lang("Remove"));
    private final JButton ok = new JButton(Globals.lang("Ok"));
    private final JButton cancel = new JButton();
    private final JButton apply = new JButton(Globals.lang("Apply"));
    private final DefaultListModel fieldListModel = new DefaultListModel();
    private DefaultListModel wordListModel = new DefaultListModel();
    private final JList fieldList = new JList(this.fieldListModel);
    private final JList wordList = new JList(this.wordListModel);
    private final JTextField fieldNameField = new JTextField("", 20);
    private final JTextField wordEditField = new JTextField("", 20);
    private final JScrollPane fPane = new JScrollPane(this.fieldList);
    private final JScrollPane wPane = new JScrollPane(this.wordList);
    private final HashMap<String, DefaultListModel> wordListModels = new HashMap();
    private final ArrayList<String> removedFields = new ArrayList();
    private static final Log LOGGER = LogFactory.getLog(ContentSelectorDialog2.class);

    public ContentSelectorDialog2(Window window, JabRefFrame jabRefFrame, BasePanel basePanel, boolean bl, MetaData metaData, String string) {
        super(window, Globals.lang("Setup selectors"));
        this.setModal(bl);
        this.metaData = metaData;
        this.frame = jabRefFrame;
        this.panel = basePanel;
        this.currentField = string;
        this.initLayout();
        this.setupFieldSelector();
        this.setupWordSelector();
        this.setupActions();
        Util.bindCloseDialogKeyToCancelAction(this.rootPane, this.cancel.getAction());
        int n = this.fieldListModel.indexOf(this.currentField);
        if (n >= 0) {
            this.fieldList.setSelectedIndex(n);
        }
        this.pack();
    }

    private void setupActions() {
        this.wordList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ContentSelectorDialog2.this.wordEditField.setText((String)ContentSelectorDialog2.this.wordList.getSelectedValue());
                ContentSelectorDialog2.this.wordEditField.selectAll();
                new FocusRequester(ContentSelectorDialog2.this.wordEditField);
            }
        });
        this.newWord.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ContentSelectorDialog2.this.newWordAction();
            }
        });
        this.wordEditFieldListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ContentSelectorDialog2.this.wordList.getSelectedIndex();
                String string = (String)ContentSelectorDialog2.this.wordList.getSelectedValue();
                String string2 = ContentSelectorDialog2.this.wordEditField.getText();
                if (string2.equals("") || string2.equals(string)) {
                    return;
                }
                if (ContentSelectorDialog2.this.wordListModel.contains(string2)) {
                    n = ContentSelectorDialog2.this.wordListModel.indexOf(string2);
                    ContentSelectorDialog2.this.wordList.ensureIndexIsVisible(n);
                    return;
                }
                int n2 = ContentSelectorDialog2.this.findPos(ContentSelectorDialog2.this.wordListModel, string2);
                if (n >= 0) {
                    ContentSelectorDialog2.this.wordListModel.remove(n);
                    if (n2 > n) {
                        --n2;
                    }
                }
                ContentSelectorDialog2.this.wordListModel.add(n2, string2);
                ContentSelectorDialog2.this.wordList.ensureIndexIsVisible(n2);
                ContentSelectorDialog2.this.wordEditField.selectAll();
            }
        };
        this.wordEditField.addActionListener(this.wordEditFieldListener);
        this.removeWord.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ContentSelectorDialog2.this.wordList.getSelectedIndex();
                if (n == -1) {
                    return;
                }
                ContentSelectorDialog2.this.wordListModel.remove(n);
                ContentSelectorDialog2.this.wordEditField.setText("");
                if (ContentSelectorDialog2.this.wordListModel.size() > 0) {
                    ContentSelectorDialog2.this.wordList.setSelectedIndex(Math.min(n, ContentSelectorDialog2.this.wordListModel.size() - 1));
                }
            }
        });
        this.fieldList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                ContentSelectorDialog2.this.currentField = (String)ContentSelectorDialog2.this.fieldList.getSelectedValue();
                ContentSelectorDialog2.this.fieldNameField.setText("");
                ContentSelectorDialog2.this.setupWordSelector();
            }
        });
        this.newField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!ContentSelectorDialog2.this.fieldListModel.get(0).equals(ContentSelectorDialog2.this.FIELD_FIRST_LINE)) {
                    ContentSelectorDialog2.this.fieldListModel.add(0, ContentSelectorDialog2.this.FIELD_FIRST_LINE);
                }
                ContentSelectorDialog2.this.fieldList.setSelectedIndex(0);
                ContentSelectorDialog2.this.fPane.getVerticalScrollBar().setValue(0);
                ContentSelectorDialog2.this.fieldNameField.setEnabled(true);
                ContentSelectorDialog2.this.fieldNameField.setText(ContentSelectorDialog2.this.currentField);
                ContentSelectorDialog2.this.fieldNameField.selectAll();
                new FocusRequester(ContentSelectorDialog2.this.fieldNameField);
            }
        });
        this.fieldNameField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ContentSelectorDialog2.this.fieldNameField.transferFocus();
            }
        });
        this.fieldNameField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusLost(FocusEvent focusEvent) {
                String string = ContentSelectorDialog2.this.fieldNameField.getText();
                ContentSelectorDialog2.this.fieldNameField.setText("");
                ContentSelectorDialog2.this.fieldNameField.setEnabled(false);
                if (!ContentSelectorDialog2.this.FIELD_FIRST_LINE.equals(string) && !"".equals(string)) {
                    int n;
                    ContentSelectorDialog2.this.fieldListModel.remove(0);
                    if (ContentSelectorDialog2.this.fieldListModel.contains(string)) {
                        n = ContentSelectorDialog2.this.fieldListModel.indexOf(string);
                    } else {
                        n = ContentSelectorDialog2.this.findPos(ContentSelectorDialog2.this.fieldListModel, string);
                        ContentSelectorDialog2.this.fieldListModel.add(Math.max(0, n), string);
                    }
                    ContentSelectorDialog2.this.fieldList.setSelectedIndex(n);
                    ContentSelectorDialog2.this.fieldList.ensureIndexIsVisible(n);
                    ContentSelectorDialog2.this.currentField = string;
                    ContentSelectorDialog2.this.setupWordSelector();
                    ContentSelectorDialog2.this.newWordAction();
                }
            }
        });
        this.removeField.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = ContentSelectorDialog2.this.fieldList.getSelectedIndex();
                if (n == -1) {
                    return;
                }
                String string = (String)ContentSelectorDialog2.this.fieldListModel.get(n);
                ContentSelectorDialog2.this.removedFields.add(string);
                ContentSelectorDialog2.this.fieldListModel.remove(n);
                ContentSelectorDialog2.this.wordListModels.remove(string);
                ContentSelectorDialog2.this.fieldNameField.setText("");
                if (ContentSelectorDialog2.this.fieldListModel.size() > 0) {
                    ContentSelectorDialog2.this.fieldList.setSelectedIndex(Math.min(n, ContentSelectorDialog2.this.wordListModel.size() - 1));
                }
            }
        });
        this.help.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ((ContentSelectorDialog2)ContentSelectorDialog2.this).frame.helpDiag.showPage("ContentSelectorHelp.html");
            }
        });
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    ContentSelectorDialog2.this.applyChanges();
                    ContentSelectorDialog2.this.dispose();
                }
                catch (Exception exception) {
                    LOGGER.info("Could not apply changes in \"Setup selectors\"", exception);
                    JOptionPane.showMessageDialog(ContentSelectorDialog2.this.frame, Globals.lang("Could not apply changes."));
                }
            }
        });
        this.apply.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!ContentSelectorDialog2.this.wordEditField.getText().equals("")) {
                    ContentSelectorDialog2.this.wordEditFieldListener.actionPerformed(null);
                }
                try {
                    ContentSelectorDialog2.this.applyChanges();
                }
                catch (Exception exception) {
                    LOGGER.info("Could not apply changes in \"Setup selectors\"", exception);
                    JOptionPane.showMessageDialog(ContentSelectorDialog2.this.frame, Globals.lang("Could not apply changes."));
                }
            }
        });
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ContentSelectorDialog2.this.dispose();
            }
        };
        abstractAction.putValue("Name", Globals.lang("Cancel"));
        this.cancel.setAction(abstractAction);
    }

    private void newWordAction() {
        if (this.wordListModel.size() == 0 || !this.wordListModel.get(0).equals(this.WORD_FIRSTLINE_TEXT)) {
            this.wordListModel.add(0, this.WORD_FIRSTLINE_TEXT);
        }
        this.wordList.setSelectedIndex(0);
        this.wPane.getVerticalScrollBar().setValue(0);
    }

    private void applyChanges() {
        boolean bl = false;
        for (String string : this.removedFields) {
            this.metaData.remove("selector_" + string);
            bl = true;
        }
        for (String string : this.wordListModels.keySet()) {
            if (string == null || this.FIELD_FIRST_LINE.equals(string)) continue;
            DefaultListModel defaultListModel = this.wordListModels.get(string);
            if (defaultListModel.size() > 0) {
                for (int i = 0; i < defaultListModel.size() && defaultListModel.get(i).equals(this.WORD_FIRSTLINE_TEXT); ++i) {
                }
            }
            Vector<String> vector = this.metaData.getData("selector_" + string);
            boolean bl2 = false;
            if (vector == null) {
                bl2 = true;
                vector = new Vector();
                bl = true;
            } else {
                vector.clear();
            }
            for (int i = i; i < defaultListModel.size(); ++i) {
                String string2 = (String)defaultListModel.get(i);
                vector.add(string2);
            }
            if (!bl2) continue;
            this.metaData.putData("selector_" + string, vector);
        }
        this.panel.markNonUndoableBaseChanged();
        if (bl) {
            this.panel.rebuildAllEntryEditors();
        } else {
            this.panel.updateAllContentSelectors();
        }
        this.panel.getAutoCompleters().addContentSelectorValuesToAutoCompleters(this.panel.metaData);
    }

    private void setupFieldSelector() {
        this.fieldListModel.clear();
        TreeSet<String> treeSet = new TreeSet<String>();
        for (String string : this.metaData) {
            if (!string.startsWith("selector_")) continue;
            treeSet.add(string.substring("selector_".length()));
        }
        if (treeSet.size() == 0) {
            this.fieldListModel.addElement("author");
            this.fieldListModel.addElement("journal");
            this.fieldListModel.addElement("keywords");
            this.fieldListModel.addElement("publisher");
        } else {
            for (String string : treeSet) {
                this.fieldListModel.addElement(string);
            }
        }
        if (this.currentField == null) {
            this.fieldList.setSelectedIndex(0);
        } else {
            int n = this.fieldListModel.indexOf(this.currentField);
            if (n != -1) {
                this.fieldList.setSelectedIndex(n);
            }
        }
    }

    private void setupWordSelector() {
        this.wordListModel = this.wordListModels.get(this.currentField);
        if (this.wordListModel != null) {
            this.wordList.setModel(this.wordListModel);
        } else {
            this.wordListModel = new DefaultListModel();
            this.wordList.setModel(this.wordListModel);
            this.wordListModels.put(this.currentField, this.wordListModel);
            Vector<String> vector = this.metaData.getData("selector_" + this.currentField);
            if (vector != null) {
                TreeSet<String> treeSet = new TreeSet<String>(vector);
                int n = 0;
                for (String string : treeSet) {
                    this.wordListModel.add(n, string);
                    ++n;
                }
            }
        }
    }

    private int findPos(DefaultListModel defaultListModel, String string) {
        for (int i = 0; i < defaultListModel.size(); ++i) {
            String string2 = (String)defaultListModel.get(i);
            if (string.compareToIgnoreCase(string2) >= 0) continue;
            return i;
        }
        return defaultListModel.size();
    }

    private void initLayout() {
        this.fieldNameField.setEnabled(false);
        this.fieldList.setVisibleRowCount(4);
        this.wordList.setVisibleRowCount(10);
        this.fieldList.setPrototypeCellValue("Uren luren himmelturen, ja Besseggen.");
        this.wordList.setPrototypeCellValue("Uren luren himmelturen, ja Besseggen.");
        this.fieldPan.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Globals.lang("Field name")));
        this.wordPan.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Globals.lang("Keyword")));
        this.fieldPan.setLayout(this.gbl);
        this.wordPan.setLayout(this.gbl);
        this.con.insets = new Insets(2, 2, 2, 2);
        this.con.fill = 1;
        this.con.gridwidth = 2;
        this.con.weightx = 1.0;
        this.con.weighty = 1.0;
        this.con.gridx = 0;
        this.con.gridy = 0;
        this.gbl.setConstraints(this.fPane, this.con);
        this.fieldPan.add(this.fPane);
        this.gbl.setConstraints(this.wPane, this.con);
        this.wordPan.add(this.wPane);
        this.con.gridwidth = 1;
        this.con.gridx = 2;
        this.con.gridheight = 2;
        this.gbl.setConstraints(this.fieldNamePan, this.con);
        this.fieldPan.add(this.fieldNamePan);
        this.gbl.setConstraints(this.wordEditPan, this.con);
        this.wordPan.add(this.wordEditPan);
        this.con.gridx = 0;
        this.con.gridy = 1;
        this.con.weightx = 0.0;
        this.con.weighty = 0.0;
        this.con.gridwidth = 1;
        this.con.gridheight = 1;
        this.con.fill = 0;
        this.con.anchor = 17;
        this.gbl.setConstraints(this.newField, this.con);
        this.fieldPan.add(this.newField);
        this.gbl.setConstraints(this.newWord, this.con);
        this.wordPan.add(this.newWord);
        this.con.gridx = 1;
        this.gbl.setConstraints(this.removeField, this.con);
        this.fieldPan.add(this.removeField);
        this.gbl.setConstraints(this.removeWord, this.con);
        this.wordPan.add(this.removeWord);
        this.con.anchor = 17;
        this.con.gridx = 0;
        this.con.gridy = 0;
        this.gbl.setConstraints(this.fieldNameField, this.con);
        this.fieldNamePan.add(this.fieldNameField);
        this.gbl.setConstraints(this.wordEditField, this.con);
        this.wordEditPan.add(this.wordEditField);
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder(this.buttonPan);
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addButton((JComponent)this.ok);
        buttonBarBuilder.addButton((JComponent)this.apply);
        buttonBarBuilder.addButton((JComponent)this.cancel);
        buttonBarBuilder.addRelatedGap();
        buttonBarBuilder.addButton((JComponent)this.help);
        buttonBarBuilder.addGlue();
        this.con.fill = 1;
        this.getContentPane().setLayout(this.gbl);
        this.con.weightx = 1.0;
        this.con.weighty = 0.5;
        this.con.gridwidth = 1;
        this.con.gridheight = 1;
        this.con.gridx = 0;
        this.con.gridy = 0;
        this.gbl.setConstraints(this.fieldPan, this.con);
        this.getContentPane().add(this.fieldPan);
        this.con.gridy = 1;
        this.gbl.setConstraints(this.wordPan, this.con);
        this.getContentPane().add(this.wordPan);
        this.con.weighty = 0.0;
        this.con.gridy = 2;
        this.con.insets = new Insets(12, 2, 2, 2);
        this.gbl.setConstraints(this.buttonPan, this.con);
        this.getContentPane().add(this.buttonPan);
    }
}

