/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collections;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.Globals;
import net.sf.jabref.util.StringUtil;
import net.sf.jabref.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class CustomEntryType
extends BibtexEntryType {
    private final String name;
    private String[] req;
    private final String[] opt;
    private String[] priOpt;
    private String[][] reqSets = null;
    private static final Log LOGGER = LogFactory.getLog(CustomEntryType.class);

    public CustomEntryType(String string, String[] stringArray, String[] stringArray2, String[] stringArray3) {
        this.name = StringUtil.nCase(string);
        this.parseRequiredFields(stringArray);
        this.priOpt = stringArray2;
        this.opt = Util.arrayConcat(stringArray2, stringArray3);
    }

    public CustomEntryType(String string, String[] stringArray, String[] stringArray2) {
        this(string, stringArray, stringArray2, new String[0]);
    }

    private CustomEntryType(String string, String string2, String string3) {
        this.name = StringUtil.nCase(string);
        if (string2.isEmpty()) {
            this.req = new String[0];
        } else {
            this.parseRequiredFields(string2);
        }
        this.opt = string3.isEmpty() ? new String[0] : string3.split(";");
    }

    private void parseRequiredFields(String string) {
        String[] stringArray = string.split(";");
        this.parseRequiredFields(stringArray);
    }

    private void parseRequiredFields(String[] stringArray) {
        ArrayList arrayList = new ArrayList();
        ArrayList<String[]> arrayList2 = new ArrayList<String[]>();
        for (String string : stringArray) {
            String[] stringArray2 = string.split("/");
            Collections.addAll(arrayList, stringArray2);
            if (stringArray2.length <= 1) continue;
            arrayList2.add(stringArray2);
        }
        this.req = arrayList.toArray(new String[arrayList.size()]);
        if (!arrayList2.isEmpty()) {
            this.reqSets = (String[][])arrayList2.toArray((T[])new String[arrayList2.size()][]);
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String[] getOptionalFields() {
        return this.opt;
    }

    @Override
    public String[] getRequiredFields() {
        return this.req;
    }

    @Override
    public String[] getPrimaryOptionalFields() {
        return this.priOpt;
    }

    @Override
    public String[] getSecondaryOptionalFields() {
        return Util.getRemainder(this.opt, this.priOpt);
    }

    @Override
    public String[] getRequiredFieldsForCustomization() {
        return this.getRequiredFieldsString().split(";");
    }

    @Override
    public String describeRequiredFields() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.req.length; ++i) {
            stringBuilder.append(this.req[i]);
            stringBuilder.append(i <= this.req.length - 1 && this.req.length > 1 ? ", " : "");
        }
        return stringBuilder.toString();
    }

    public String describeOptionalFields() {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.opt.length; ++i) {
            stringBuilder.append(this.opt[i]);
            stringBuilder.append(i <= this.opt.length - 1 && this.opt.length > 1 ? ", " : "");
        }
        return stringBuilder.toString();
    }

    @Override
    public boolean hasAllRequiredFields(BibtexEntry bibtexEntry, BibtexDatabase bibtexDatabase) {
        int n;
        if (bibtexEntry.getField("bibtexkey") == null) {
            return false;
        }
        boolean[] blArray = new boolean[this.req.length];
        for (n = 0; n < this.req.length; ++n) {
            blArray[n] = BibtexDatabase.getResolvedField(this.req[n], bibtexEntry, bibtexDatabase) != null;
        }
        for (n = 0; n < this.req.length; ++n) {
            if (blArray[n] || this.isCoupledFieldSet(this.req[n], bibtexEntry, bibtexDatabase)) continue;
            return false;
        }
        return true;
    }

    private boolean isCoupledFieldSet(String string, BibtexEntry bibtexEntry, BibtexDatabase bibtexDatabase) {
        if (this.reqSets == null) {
            return false;
        }
        for (String[] stringArray : this.reqSets) {
            boolean bl = false;
            boolean bl2 = false;
            for (String string2 : stringArray) {
                if (string2.equalsIgnoreCase(string)) {
                    bl = true;
                    continue;
                }
                if (BibtexDatabase.getResolvedField(string2, bibtexEntry, bibtexDatabase) == null) continue;
                bl2 = true;
            }
            if (!bl || !bl2) continue;
            return true;
        }
        return false;
    }

    public String getRequiredFieldsString() {
        StringBuilder stringBuilder = new StringBuilder();
        int n = 0;
        for (int i = 0; i < this.req.length; ++i) {
            if (this.reqSets == null || n == this.reqSets.length) {
                stringBuilder.append(this.req[i]);
            } else if (this.req[i].equals(this.reqSets[n][0])) {
                for (int j = 0; j < this.reqSets[n].length; ++j) {
                    stringBuilder.append(this.reqSets[n][j]);
                    if (j >= this.reqSets[n].length - 1) continue;
                    stringBuilder.append('/');
                }
                i += this.reqSets[n].length - 1;
                ++n;
            } else {
                stringBuilder.append(this.req[i]);
            }
            if (i >= this.req.length - 1) continue;
            stringBuilder.append(';');
        }
        return stringBuilder.toString();
    }

    public void save(Writer writer) throws IOException {
        writer.write("@comment{");
        writer.write("jabref-entrytype: ");
        writer.write(this.getName());
        writer.write(": req[");
        writer.write(this.getRequiredFieldsString());
        writer.write("] opt[");
        StringBuilder stringBuilder = new StringBuilder();
        for (int i = 0; i < this.opt.length; ++i) {
            stringBuilder.append(this.opt[i]);
            if (i >= this.opt.length - 1) continue;
            stringBuilder.append(';');
        }
        writer.write(stringBuilder.toString());
        writer.write("]}" + Globals.NEWLINE);
    }

    public static CustomEntryType parseEntryType(String string) {
        try {
            String string2 = string.substring("jabref-entrytype: ".length());
            int n = string2.indexOf(58);
            String string3 = string2.substring(0, n);
            string2 = string2.substring(n + 2);
            int n2 = string2.indexOf(93);
            if (n2 < 4) {
                throw new IndexOutOfBoundsException();
            }
            String string4 = string2.substring(4, n2);
            int n3 = string2.indexOf(93, n2 + 1);
            String string5 = string2.substring(n2 + 6, n3);
            return new CustomEntryType(string3, string4, string5);
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            LOGGER.info("Ill-formed entrytype comment in BibTeX file.", indexOutOfBoundsException);
            return null;
        }
    }
}

