/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.util.HashMap;
import java.util.HashSet;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;

public class DuplicateCheck {
    static final int NOT_EQUAL = 0;
    static final int EQUAL = 1;
    static final int EMPTY_IN_ONE = 2;
    static final int EMPTY_IN_TWO = 3;
    static final int EMPTY_IN_BOTH = 4;
    public static double duplicateThreshold = 0.75;
    private static final double doubtRange = 0.05;
    private static final double reqWeight = 3.0;
    private static final HashMap<String, Double> fieldWeights = new HashMap();

    public static boolean isDuplicate(BibtexEntry bibtexEntry, BibtexEntry bibtexEntry2) {
        if (bibtexEntry.getType() != bibtexEntry2.getType()) {
            return false;
        }
        String[] stringArray = bibtexEntry.getType().getRequiredFields();
        double[] dArray = stringArray == null ? new double[]{0.0, 0.0} : DuplicateCheck.compareFieldSet(stringArray, bibtexEntry, bibtexEntry2);
        if (Math.abs(dArray[0] - duplicateThreshold) > 0.05) {
            return dArray[0] >= duplicateThreshold;
        }
        stringArray = bibtexEntry.getType().getOptionalFields();
        if (stringArray != null) {
            double[] dArray2 = DuplicateCheck.compareFieldSet(stringArray, bibtexEntry, bibtexEntry2);
            double d = (3.0 * dArray[0] * dArray[1] + dArray2[0] * dArray2[1]) / (dArray[1] * 3.0 + dArray2[1]);
            return d >= duplicateThreshold;
        }
        return dArray[0] >= duplicateThreshold;
    }

    private static double[] compareFieldSet(String[] stringArray, BibtexEntry bibtexEntry, BibtexEntry bibtexEntry2) {
        double d = 0.0;
        double d2 = 0.0;
        for (String string : stringArray) {
            double d3 = fieldWeights.containsKey(string) ? fieldWeights.get(string) : 1.0;
            d2 += d3;
            int n = DuplicateCheck.compareSingleField(string, bibtexEntry, bibtexEntry2);
            if (n == 1) {
                d += d3;
                continue;
            }
            if (n != 4) continue;
            d2 -= d3;
        }
        if (d2 > 0.0) {
            return new double[]{d / d2, d2};
        }
        return new double[]{0.5, 0.0};
    }

    private static int compareSingleField(String string, BibtexEntry bibtexEntry, BibtexEntry bibtexEntry2) {
        String string2 = bibtexEntry.getField(string);
        String string3 = bibtexEntry2.getField(string);
        if (string2 == null) {
            if (string3 == null) {
                return 4;
            }
            return 2;
        }
        if (string3 == null) {
            return 3;
        }
        if (string.equals("author") || string.equals("editor")) {
            String string4;
            String string5 = AuthorList.fixAuthor_lastNameOnlyCommas(string2, false).replaceAll(" and ", " ").toLowerCase();
            double d = DuplicateCheck.correlateByWords(string5, string4 = AuthorList.fixAuthor_lastNameOnlyCommas(string3, false).replaceAll(" and ", " ").toLowerCase(), false);
            if (d > 0.8) {
                return 1;
            }
            return 0;
        }
        if (string.equals("pages")) {
            if ((string2 = string2.replaceAll("[- ]+", "-")).equals(string3 = string3.replaceAll("[- ]+", "-"))) {
                return 1;
            }
            return 0;
        }
        if (string.equals("journal")) {
            double d = DuplicateCheck.correlateByWords(string2 = string2.replaceAll("\\.", "").toLowerCase(), string3 = string3.replaceAll("\\.", "").toLowerCase(), true);
            if (d > 0.8) {
                return 1;
            }
            return 0;
        }
        double d = DuplicateCheck.correlateByWords(string2 = string2.toLowerCase(), string3 = string3.toLowerCase(), false);
        if (d > 0.8) {
            return 1;
        }
        return 0;
    }

    public static double compareEntriesStrictly(BibtexEntry bibtexEntry, BibtexEntry bibtexEntry2) {
        HashSet<String> hashSet = new HashSet<String>();
        hashSet.addAll(bibtexEntry.getAllFields());
        hashSet.addAll(bibtexEntry2.getAllFields());
        int n = 0;
        for (String string : hashSet) {
            String string2 = bibtexEntry.getField(string);
            String string3 = bibtexEntry2.getField(string);
            if ((string2 == null || string3 == null || !string2.equals(string3)) && (string2 != null || string3 != null)) continue;
            ++n;
        }
        if (n == hashSet.size()) {
            return 1.01;
        }
        return (double)n / (double)hashSet.size();
    }

    public static BibtexEntry containsDuplicate(BibtexDatabase bibtexDatabase, BibtexEntry bibtexEntry) {
        for (BibtexEntry bibtexEntry2 : bibtexDatabase.getEntries()) {
            if (!DuplicateCheck.isDuplicate(bibtexEntry, bibtexEntry2)) continue;
            return bibtexEntry2;
        }
        return null;
    }

    private static double correlateByWords(String string, String string2, boolean bl) {
        String[] stringArray = string.split("\\s");
        String[] stringArray2 = string2.split("\\s");
        int n = Math.min(stringArray.length, stringArray2.length);
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            double d = DuplicateCheck.correlateStrings(stringArray[i], stringArray2[i], bl);
            if (!(d < 0.75)) continue;
            ++n2;
        }
        double d = (double)n2 / (double)n;
        return 1.0 - d;
    }

    private static double correlateStrings(String string, String string2, boolean bl) {
        int n = Math.min(string.length(), string2.length());
        if (bl && n == 1) {
            return string.charAt(0) == string2.charAt(0) ? 1.0 : 0.0;
        }
        if (string.length() == 1 && string2.length() == 1) {
            return string.equals(string2) ? 1.0 : 0.0;
        }
        if (n == 0) {
            return string.isEmpty() && string2.isEmpty() ? 1.0 : 0.0;
        }
        if (bl) {
            if (string.length() > n) {
                string = string.substring(0, n);
            }
            if (string2.length() > n) {
                string2 = string2.substring(0, n);
            }
        }
        double[] dArray = DuplicateCheck.numberizeString(string);
        double[] dArray2 = DuplicateCheck.numberizeString(string2);
        if (!bl) {
            if (dArray.length < dArray2.length) {
                dArray = DuplicateCheck.stretchArray(dArray, dArray2.length);
            } else if (dArray2.length < dArray.length) {
                dArray2 = DuplicateCheck.stretchArray(dArray2, dArray.length);
            }
        }
        return DuplicateCheck.corrCoef(dArray, dArray2);
    }

    private static double corrCoef(double[] dArray, double[] dArray2) {
        double d = 0.0;
        double d2 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d += dArray[i];
            d2 += dArray2[i];
        }
        d /= (double)dArray.length;
        d2 /= (double)dArray2.length;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        for (int i = 0; i < dArray.length; ++i) {
            d3 += (dArray[i] - d) * (dArray[i] - d);
            d4 += (dArray2[i] - d2) * (dArray2[i] - d2);
            d5 += (dArray[i] - d) * (dArray2[i] - d2);
        }
        d3 = Math.sqrt(d3);
        d4 = Math.sqrt(d4);
        if (d3 > 0.0 && d4 > 0.0) {
            return d5 / (d3 * d4);
        }
        return 0.0;
    }

    private static double[] numberizeString(String string) {
        double[] dArray = new double[string.length()];
        for (int i = 0; i < string.length(); ++i) {
            dArray[i] = string.charAt(i);
        }
        return dArray;
    }

    private static double[] stretchArray(double[] dArray, int n) {
        if (n <= dArray.length || dArray.length == 0) {
            return dArray;
        }
        double d = (double)dArray.length / (double)n;
        double[] dArray2 = new double[n];
        for (int i = 0; i < dArray2.length; ++i) {
            double d2 = (double)i * d;
            int n2 = (int)Math.floor(d2);
            double d3 = d2 - Math.floor(d2);
            dArray2[i] = d3 * dArray[Math.min(dArray.length - 1, n2 + 1)] + (1.0 - d3) * dArray[n2];
        }
        return dArray2;
    }

    public static void main(String[] stringArray) {
        String string = "Characterization of Calanus finmarchicus habitat in the North Sea";
        String string2 = "Characterization of Calunus finmarchicus habitat in the North Sea";
        String string3 = "Characterization of Calanus glacialissss habitat in the South Sea";
        System.out.println(DuplicateCheck.correlateByWords(string, string2, false));
        System.out.println(DuplicateCheck.correlateByWords(string, string3, false));
        System.out.println(DuplicateCheck.correlateByWords(string2, string3, false));
    }

    static {
        fieldWeights.put("author", 2.5);
        fieldWeights.put("editor", 2.5);
        fieldWeights.put("title", 3.0);
        fieldWeights.put("journal", 2.0);
    }
}

