/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.util.Comparator;
import net.sf.jabref.AuthorList;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexFields;

public class EntryComparator
implements Comparator<BibtexEntry> {
    private final String sortField;
    private final boolean descending;
    private boolean binary = false;
    private final boolean numeric;
    private final Comparator<BibtexEntry> next;

    public EntryComparator(boolean bl, boolean bl2, String string, Comparator<BibtexEntry> comparator) {
        this.binary = bl;
        this.sortField = string;
        this.descending = bl2;
        this.next = comparator;
        this.numeric = BibtexFields.isNumeric(this.sortField);
    }

    public EntryComparator(boolean bl, boolean bl2, String string) {
        this.binary = bl;
        this.sortField = string;
        this.descending = bl2;
        this.next = null;
        this.numeric = BibtexFields.isNumeric(this.sortField);
    }

    @Override
    public int compare(BibtexEntry bibtexEntry, BibtexEntry bibtexEntry2) throws ClassCastException {
        int n;
        Object object;
        if (bibtexEntry == bibtexEntry2) {
            return 0;
        }
        Object object2 = bibtexEntry.getField(this.sortField);
        Object object3 = bibtexEntry2.getField(this.sortField);
        if (this.binary) {
            if (object2 != null) {
                return object3 == null ? -1 : (this.next != null ? this.next.compare(bibtexEntry, bibtexEntry2) : this.idCompare(bibtexEntry, bibtexEntry2));
            }
            return object3 == null ? (this.next != null ? this.next.compare(bibtexEntry, bibtexEntry2) : this.idCompare(bibtexEntry, bibtexEntry2)) : 1;
        }
        if (this.sortField.equals("author") || this.sortField.equals("editor")) {
            if (object2 != null) {
                object2 = AuthorList.fixAuthorForAlphabetization((String)object2).toLowerCase();
            }
            if (object3 != null) {
                object3 = AuthorList.fixAuthorForAlphabetization((String)object3).toLowerCase();
            }
        } else if (this.sortField.equals("entrytype")) {
            object2 = bibtexEntry.getType().getName();
            object3 = bibtexEntry2.getType().getName();
        } else if (this.numeric) {
            try {
                Integer n2 = Integer.parseInt((String)object2);
                object = Integer.parseInt((String)object3);
                object2 = n2;
                object3 = object;
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (object2 == null && object3 == null) {
            return this.next != null ? this.next.compare(bibtexEntry, bibtexEntry2) : this.idCompare(bibtexEntry, bibtexEntry2);
        }
        if (object2 != null && object3 == null) {
            return -1;
        }
        if (object2 == null && object3 != null) {
            return 1;
        }
        if (object2 instanceof Integer && object3 instanceof Integer) {
            n = -((Integer)object2).compareTo((Integer)object3);
        } else if (object3 instanceof Integer) {
            object = new Integer(object2.toString());
            n = -((Integer)object).compareTo((Integer)object3);
        } else if (object2 instanceof Integer) {
            object = new Integer(object3.toString());
            n = -((Integer)object2).compareTo((Integer)object);
        } else {
            object = ((String)object2).toLowerCase();
            String string = ((String)object3).toLowerCase();
            int n3 = ((String)object).compareTo(string);
            n = -n3;
        }
        if (n != 0) {
            return this.descending ? n : -n;
        }
        if (this.next != null) {
            return this.next.compare(bibtexEntry, bibtexEntry2);
        }
        return this.idCompare(bibtexEntry, bibtexEntry2);
    }

    private int idCompare(BibtexEntry bibtexEntry, BibtexEntry bibtexEntry2) {
        return bibtexEntry.getId().compareTo(bibtexEntry2.getId());
    }
}

