/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.DatabaseChangeEvent;
import net.sf.jabref.DatabaseChangeListener;

public class EntrySorter
implements DatabaseChangeListener {
    private final ArrayList<BibtexEntry> set = new ArrayList();
    private final Comparator<BibtexEntry> comp;
    private String[] idArray;
    private BibtexEntry[] entryArray;
    private boolean changed = false;

    public EntrySorter(Map<String, BibtexEntry> map, Comparator<BibtexEntry> comparator) {
        this.comp = comparator;
        Set<String> set = map.keySet();
        for (Map.Entry<String, BibtexEntry> entry : map.entrySet()) {
            this.set.add(entry.getValue());
        }
        this.changed = true;
        this.index();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void index() {
        ArrayList<BibtexEntry> arrayList = this.set;
        synchronized (arrayList) {
            if (this.changed) {
                Collections.sort(this.set, this.comp);
                this.changed = false;
            }
            int n = this.set.size();
            this.idArray = new String[n];
            this.entryArray = new BibtexEntry[n];
            int n2 = 0;
            for (BibtexEntry bibtexEntry : this.set) {
                this.idArray[n2] = bibtexEntry.getId();
                this.entryArray[n2] = bibtexEntry;
                ++n2;
            }
        }
    }

    public boolean isOutdated() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getIdAt(int n) {
        ArrayList<BibtexEntry> arrayList = this.set;
        synchronized (arrayList) {
            return this.idArray[n];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BibtexEntry getEntryAt(int n) {
        ArrayList<BibtexEntry> arrayList = this.set;
        synchronized (arrayList) {
            return this.entryArray[n];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getEntryCount() {
        ArrayList<BibtexEntry> arrayList = this.set;
        synchronized (arrayList) {
            if (this.entryArray != null) {
                return this.entryArray.length;
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void databaseChanged(DatabaseChangeEvent databaseChangeEvent) {
        ArrayList<BibtexEntry> arrayList = this.set;
        synchronized (arrayList) {
            switch (databaseChangeEvent.getType()) {
                case ADDED_ENTRY: {
                    int n = -Collections.binarySearch(this.set, databaseChangeEvent.getEntry(), this.comp) - 1;
                    this.set.add(n, databaseChangeEvent.getEntry());
                    break;
                }
                case REMOVED_ENTRY: {
                    this.set.remove(databaseChangeEvent.getEntry());
                    this.changed = true;
                    break;
                }
                case CHANGED_ENTRY: {
                    int n = Collections.binarySearch(this.set, databaseChangeEvent.getEntry(), this.comp);
                    int n2 = this.set.indexOf(databaseChangeEvent.getEntry());
                    if (n >= 0) break;
                    this.set.remove(n2);
                    this.set.add(-n - 1, databaseChangeEvent.getEntry());
                }
            }
        }
    }
}

