/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jabref.BrowseAction;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.PrefsDialog3;
import net.sf.jabref.PrefsTab;
import net.sf.jabref.external.ExternalFileTypeEditor;
import net.sf.jabref.external.PushToApplication;
import net.sf.jabref.external.PushToApplicationButton;
import net.sf.jabref.external.PushToEmacs;
import net.sf.jabref.external.PushToLatexEditor;
import net.sf.jabref.external.PushToLyx;
import net.sf.jabref.external.PushToTeXstudio;
import net.sf.jabref.external.PushToVim;
import net.sf.jabref.external.PushToWinEdt;
import net.sf.jabref.help.HelpAction;
import net.sf.jabref.help.HelpDialog;

public class ExternalTab
extends JPanel
implements PrefsTab {
    private final JabRefPreferences _prefs;
    private final JabRefFrame _frame;
    private final JTextField pdfDir;
    private final JTextField regExpTextField;
    private final JTextField fileDir;
    private final JTextField psDir;
    private final JTextField emailSubject;
    private final JCheckBox bibLocationAsFileDir;
    private final JCheckBox bibLocAsPrimaryDir;
    private final JCheckBox runAutoFileSearch;
    private final JCheckBox allowFileAutoOpenBrowse;
    private final JCheckBox openFoldersOfAttachedFiles;
    private final JRadioButton useRegExpComboBox;
    private final JRadioButton matchExactKeyOnly = new JRadioButton(Globals.lang("Autolink only files that match the BibTeX key"));
    private final JRadioButton matchStartsWithKey = new JRadioButton(Globals.lang("Autolink files with names starting with the BibTeX key"));

    public ExternalTab(JabRefFrame jabRefFrame, PrefsDialog3 prefsDialog3, JabRefPreferences jabRefPreferences, HelpDialog helpDialog) {
        this._prefs = jabRefPreferences;
        this._frame = jabRefFrame;
        this.setLayout(new BorderLayout());
        this.psDir = new JTextField(25);
        this.pdfDir = new JTextField(25);
        this.fileDir = new JTextField(25);
        this.bibLocationAsFileDir = new JCheckBox(Globals.lang("Allow file links relative to each bib file's location"));
        this.bibLocAsPrimaryDir = new JCheckBox(Globals.lang("Use the bib file location as primary file directory"));
        this.bibLocAsPrimaryDir.setToolTipText(Globals.lang("When downloading files, or moving linked files to the file directory, prefer the bib file location rather than the file directory set above"));
        this.bibLocationAsFileDir.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                ExternalTab.this.bibLocAsPrimaryDir.setEnabled(ExternalTab.this.bibLocationAsFileDir.isSelected());
            }
        });
        JButton jButton = new JButton(Globals.lang("Manage external file types"));
        this.runAutoFileSearch = new JCheckBox(Globals.lang("When opening file link, search for matching file if no link is defined"));
        this.allowFileAutoOpenBrowse = new JCheckBox(Globals.lang("Automatically open browse dialog when creating new file link"));
        this.regExpTextField = new JTextField(25);
        this.useRegExpComboBox = new JRadioButton(Globals.lang("Use Regular Expression Search"));
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                ExternalTab.this.regExpTextField.setEditable(ExternalTab.this.useRegExpComboBox.isSelected());
            }
        };
        this.useRegExpComboBox.addItemListener(itemListener);
        jButton.addActionListener(ExternalFileTypeEditor.getAction(prefsDialog3));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.matchExactKeyOnly);
        buttonGroup.add(this.matchStartsWithKey);
        buttonGroup.add(this.useRegExpComboBox);
        FormLayout formLayout = new FormLayout("1dlu, 8dlu, left:pref, 4dlu, fill:150dlu, 4dlu, fill:pref", "");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.appendSeparator(Globals.lang("External file links"));
        JPanel jPanel = new JPanel();
        defaultFormBuilder.append(jPanel);
        JLabel jLabel = new JLabel(Globals.lang("Main file directory") + ':');
        defaultFormBuilder.append(jLabel);
        defaultFormBuilder.append(this.fileDir);
        BrowseAction browseAction = BrowseAction.buildForDir(this._frame, this.fileDir);
        defaultFormBuilder.append(new JButton(browseAction));
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(new JPanel());
        defaultFormBuilder.append((Component)this.bibLocationAsFileDir, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(new JPanel());
        defaultFormBuilder.append((Component)this.bibLocAsPrimaryDir, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(new JPanel());
        defaultFormBuilder.append((Component)this.matchStartsWithKey, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(new JPanel());
        defaultFormBuilder.append((Component)this.matchExactKeyOnly, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(new JPanel());
        defaultFormBuilder.append(this.useRegExpComboBox);
        defaultFormBuilder.append(this.regExpTextField);
        HelpAction helpAction = new HelpAction(helpDialog, "ExternalFiles.html#RegularExpressionSearch", Globals.lang("Help on Regular Expression Search"), GUIGlobals.getIconUrl("helpSmall"));
        defaultFormBuilder.append(helpAction.getIconButton());
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(new JPanel());
        defaultFormBuilder.append((Component)this.runAutoFileSearch, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(new JPanel());
        defaultFormBuilder.append(this.allowFileAutoOpenBrowse);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.appendSeparator(Globals.lang("Sending of emails"));
        defaultFormBuilder.append(new JPanel());
        jLabel = new JLabel(Globals.lang("Subject for sending an email with references").concat(":"));
        defaultFormBuilder.append(jLabel);
        this.emailSubject = new JTextField(25);
        defaultFormBuilder.append(this.emailSubject);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(new JPanel());
        this.openFoldersOfAttachedFiles = new JCheckBox(Globals.lang("Automatically open folders of attached files"));
        defaultFormBuilder.append(this.openFoldersOfAttachedFiles);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.appendSeparator(Globals.lang("Legacy file fields"));
        jPanel = new JPanel();
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder.append((Component)new JLabel("<html>" + Globals.lang("Note that these settings are used for the legacy <b>pdf</b> and <b>ps</b> fields only.<br>For most users, setting the <b>Main file directory</b> above should be sufficient.") + "</html>"), 5);
        defaultFormBuilder.nextLine();
        jPanel = new JPanel();
        defaultFormBuilder.append(jPanel);
        jLabel = new JLabel(Globals.lang("Main PDF directory") + ':');
        defaultFormBuilder.append(jLabel);
        defaultFormBuilder.append(this.pdfDir);
        browseAction = BrowseAction.buildForDir(this._frame, this.pdfDir);
        defaultFormBuilder.append(new JButton(browseAction));
        defaultFormBuilder.nextLine();
        jPanel = new JPanel();
        defaultFormBuilder.append(jPanel);
        jLabel = new JLabel(Globals.lang("Main PS directory") + ':');
        defaultFormBuilder.append(jLabel);
        defaultFormBuilder.append(this.psDir);
        browseAction = BrowseAction.buildForDir(this._frame, this.psDir);
        defaultFormBuilder.append(new JButton(browseAction));
        defaultFormBuilder.nextLine();
        defaultFormBuilder.appendSeparator(Globals.lang("External programs"));
        defaultFormBuilder.nextLine();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridLayout(2, 3));
        this.addSettingsButton(new PushToLyx(), jPanel2);
        this.addSettingsButton(new PushToEmacs(), jPanel2);
        this.addSettingsButton(new PushToWinEdt(), jPanel2);
        this.addSettingsButton(new PushToVim(), jPanel2);
        this.addSettingsButton(new PushToLatexEditor(), jPanel2);
        this.addSettingsButton(new PushToTeXstudio(), jPanel2);
        defaultFormBuilder.append(new JPanel());
        defaultFormBuilder.append((Component)jPanel2, 3);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder.append(jButton);
        jPanel = defaultFormBuilder.getPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)jPanel, "Center");
    }

    private void addSettingsButton(final PushToApplication pushToApplication, JPanel jPanel) {
        JButton jButton = new JButton(Globals.lang("Settings for %0", pushToApplication.getApplicationName()), pushToApplication.getIcon());
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PushToApplicationButton.showSettingsDialog(ExternalTab.this._frame, pushToApplication, pushToApplication.getSettingsPanel());
            }
        });
        jPanel.add(jButton);
    }

    @Override
    public void setValues() {
        this.pdfDir.setText(this._prefs.get("pdfDirectory"));
        this.psDir.setText(this._prefs.get("psDirectory"));
        this.fileDir.setText(this._prefs.get("fileDirectory"));
        this.bibLocationAsFileDir.setSelected(this._prefs.getBoolean("bibLocationAsFileDir"));
        this.bibLocAsPrimaryDir.setSelected(this._prefs.getBoolean("bibLocAsPrimaryDir"));
        this.bibLocAsPrimaryDir.setEnabled(this.bibLocationAsFileDir.isSelected());
        this.runAutoFileSearch.setSelected(this._prefs.getBoolean("runAutomaticFileSearch"));
        this.regExpTextField.setText(this._prefs.get("regExpSearchExpression"));
        this.allowFileAutoOpenBrowse.setSelected(this._prefs.getBoolean("allowFileAutoOpenBrowse"));
        this.emailSubject.setText(this._prefs.get("emailSubject"));
        this.openFoldersOfAttachedFiles.setSelected(this._prefs.getBoolean("openFoldersOfAttachedFiles"));
        if (this._prefs.getBoolean("useRegExpSearch")) {
            this.useRegExpComboBox.setSelected(true);
        } else if (this._prefs.getBoolean("autolinkExactKeyOnly")) {
            this.matchExactKeyOnly.setSelected(true);
        } else {
            this.matchStartsWithKey.setSelected(true);
        }
    }

    @Override
    public void storeSettings() {
        this._prefs.putBoolean("useRegExpSearch", this.useRegExpComboBox.isSelected());
        if (this.useRegExpComboBox.isSelected()) {
            this._prefs.put("regExpSearchExpression", this.regExpTextField.getText());
        }
        this._prefs.put("pdfDirectory", this.pdfDir.getText());
        this._prefs.put("psDirectory", this.psDir.getText());
        this._prefs.put("fileDirectory", this.fileDir.getText());
        this._prefs.putBoolean("bibLocationAsFileDir", this.bibLocationAsFileDir.isSelected());
        this._prefs.putBoolean("bibLocAsPrimaryDir", this.bibLocAsPrimaryDir.isSelected());
        this._prefs.putBoolean("autolinkExactKeyOnly", this.matchExactKeyOnly.isSelected());
        this._prefs.putBoolean("runAutomaticFileSearch", this.runAutoFileSearch.isSelected());
        this._prefs.putBoolean("allowFileAutoOpenBrowse", this.allowFileAutoOpenBrowse.isSelected());
        this._prefs.put("emailSubject", this.emailSubject.getText());
        this._prefs.putBoolean("openFoldersOfAttachedFiles", this.openFoldersOfAttachedFiles.isSelected());
    }

    @Override
    public boolean readyToClose() {
        return true;
    }

    @Override
    public String getTabName() {
        return Globals.lang("External programs");
    }
}

