/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Color;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JTextField;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import net.sf.jabref.FieldEditor;
import net.sf.jabref.FieldEditorFocusListener;
import net.sf.jabref.FieldNameLabel;
import net.sf.jabref.FieldTextMenu;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.AutoCompleteListener;
import net.sf.jabref.util.StringUtil;

public class FieldTextField
extends JTextField
implements FieldEditor {
    private final String fieldName;
    private final JLabel label;
    private UndoManager undo;
    private AutoCompleteListener autoCompleteListener = null;

    public FieldTextField(String string, String string2, boolean bl) {
        super(string2);
        this.setupUndoRedo();
        this.updateFont();
        this.addFocusListener(Globals.focusListener);
        if (bl) {
            this.addFocusListener(new FieldEditorFocusListener());
        }
        this.fieldName = string;
        this.label = new FieldNameLabel(' ' + StringUtil.nCase(this.fieldName) + ' ');
        this.setBackground(GUIGlobals.validFieldBackgroundColor);
        this.setForeground(GUIGlobals.editorTextColor);
        FieldTextMenu fieldTextMenu = new FieldTextMenu(this);
        this.addMouseListener(fieldTextMenu);
        this.label.addMouseListener(fieldTextMenu);
    }

    private void setupUndoRedo() {
        this.undo = new UndoManager();
        Document document = this.getDocument();
        document.addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                FieldTextField.this.undo.addEdit(undoableEditEvent.getEdit());
            }
        });
        this.getActionMap().put("Undo", new AbstractAction("Undo"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (FieldTextField.this.undo.canUndo()) {
                        FieldTextField.this.undo.undo();
                    }
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
            }
        });
        this.getInputMap().put(Globals.prefs.getKey("Undo"), "Undo");
        this.getActionMap().put("Redo", new AbstractAction("Redo"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (FieldTextField.this.undo.canRedo()) {
                        FieldTextField.this.undo.redo();
                    }
                }
                catch (CannotRedoException cannotRedoException) {
                    // empty catch block
                }
            }
        });
        this.getInputMap().put(Globals.prefs.getKey("Redo"), "Redo");
    }

    @Override
    public void setText(String string) {
        super.setText(string);
        if (this.undo != null) {
            this.undo.discardAllEdits();
        }
    }

    @Override
    public void append(String string) {
        this.setText(this.getText() + string);
    }

    @Override
    public String getFieldName() {
        return this.fieldName;
    }

    @Override
    public JLabel getLabel() {
        return this.label;
    }

    @Override
    public void setLabelColor(Color color) {
        this.label.setForeground(color);
        throw new NullPointerException("ok");
    }

    @Override
    public JComponent getPane() {
        return this;
    }

    @Override
    public JComponent getTextComponent() {
        return this;
    }

    @Override
    public void setActiveBackgroundColor() {
        this.setBackground(GUIGlobals.activeBackground);
    }

    @Override
    public void setValidBackgroundColor() {
        this.setBackground(GUIGlobals.validFieldBackgroundColor);
    }

    @Override
    public void setInvalidBackgroundColor() {
        this.setBackground(GUIGlobals.invalidFieldBackgroundColor);
    }

    @Override
    public void updateFontColor() {
        this.setForeground(GUIGlobals.editorTextColor);
    }

    @Override
    public void updateFont() {
        this.setFont(GUIGlobals.CURRENTFONT);
    }

    @Override
    public void paste(String string) {
        int n = this.getSelectionEnd() - this.getSelectionStart();
        if (n < 1) {
            int n2 = this.getCaretPosition();
            this.select(n2, n2);
        }
        this.replaceSelection(string);
    }

    @Override
    public boolean hasUndoInformation() {
        return false;
    }

    @Override
    public void undo() {
    }

    @Override
    public boolean hasRedoInformation() {
        return false;
    }

    @Override
    public void redo() {
    }

    @Override
    public void addUndoableEditListener(UndoableEditListener undoableEditListener) {
        this.getDocument().addUndoableEditListener(undoableEditListener);
    }

    @Override
    public void setAutoCompleteListener(AutoCompleteListener autoCompleteListener) {
        this.autoCompleteListener = autoCompleteListener;
    }

    @Override
    public void clearAutoCompleteSuggestion() {
        if (this.autoCompleteListener != null) {
            this.autoCompleteListener.clearCurrentSuggestion(this);
        }
    }
}

