/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.event.ActionEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URL;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.text.JTextComponent;
import net.sf.jabref.ClipBoardManager;
import net.sf.jabref.FieldEditor;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.util.CaseChangeMenu;
import net.sf.jabref.util.GoogleUrlCleaner;
import net.sf.jabref.util.NameListNormalizer;

public class FieldTextMenu
implements MouseListener {
    private final FieldEditor myFieldName;
    private final JPopupMenu inputMenu = new JPopupMenu();
    private final CopyAction copyAct = new CopyAction();

    public FieldTextMenu(FieldEditor fieldEditor) {
        this.myFieldName = fieldEditor;
        PasteAction pasteAction = new PasteAction();
        this.inputMenu.add(pasteAction);
        this.inputMenu.add(this.copyAct);
        this.inputMenu.addSeparator();
        this.inputMenu.add(new ReplaceAction());
        this.inputMenu.add(new UrlAction());
        if (this.myFieldName.getTextComponent() instanceof JTextComponent) {
            this.inputMenu.add(new CaseChangeMenu((JTextComponent)this.myFieldName.getTextComponent()));
        }
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
        this.maybeShowPopup(mouseEvent);
    }

    private void maybeShowPopup(MouseEvent mouseEvent) {
        if (mouseEvent.isPopupTrigger() && this.myFieldName != null) {
            this.myFieldName.requestFocus();
            String string = this.myFieldName.getSelectedText();
            boolean bl = false;
            if (string != null && !string.isEmpty()) {
                bl = true;
            }
            this.copyAct.setEnabled(bl);
            this.inputMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
        }
    }

    class UrlAction
    extends BasicAction {
        public UrlAction() {
            super("Clean Google URL");
            this.putValue("ShortDescription", Globals.lang("If possible, clean URL that Google search returned"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (FieldTextMenu.this.myFieldName.getText().isEmpty()) {
                return;
            }
            String string = FieldTextMenu.this.myFieldName.getText();
            FieldTextMenu.this.myFieldName.setText(GoogleUrlCleaner.cleanUrl(string));
        }
    }

    class ReplaceAction
    extends BasicAction {
        public ReplaceAction() {
            super("Normalize to BibTeX name format");
            this.putValue("ShortDescription", Globals.lang("If possible, normalize this list of names to conform to standard BibTeX name formatting"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (FieldTextMenu.this.myFieldName.getText().isEmpty()) {
                return;
            }
            String string = FieldTextMenu.this.myFieldName.getText();
            FieldTextMenu.this.myFieldName.setText(NameListNormalizer.normalizeAuthorList(string));
        }
    }

    class CopyAction
    extends BasicAction {
        public CopyAction() {
            super("Copy to clipboard", "Copy to clipboard", GUIGlobals.getIconUrl("copy"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                String string;
                if (FieldTextMenu.this.myFieldName != null && (string = FieldTextMenu.this.myFieldName.getSelectedText()) != null && !string.isEmpty()) {
                    ClipBoardManager.clipBoard.setClipboardContents(string);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    class PasteAction
    extends BasicAction {
        public PasteAction() {
            super("Paste from clipboard", "Paste from clipboard", GUIGlobals.getIconUrl("paste"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            try {
                String string = ClipBoardManager.clipBoard.getClipboardContents();
                if (string != null && !string.isEmpty() && FieldTextMenu.this.myFieldName != null) {
                    FieldTextMenu.this.myFieldName.paste(string);
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    static abstract class BasicAction
    extends AbstractAction {
        public BasicAction(String string, String string2, URL uRL) {
            super(Globals.lang(string), new ImageIcon(uRL));
            this.putValue("ShortDescription", Globals.lang(string2));
        }

        public BasicAction(String string, String string2, URL uRL, KeyStroke keyStroke) {
            super(Globals.lang(string), new ImageIcon(uRL));
            this.putValue("AcceleratorKey", keyStroke);
            this.putValue("ShortDescription", Globals.lang(string2));
        }

        public BasicAction(String string) {
            super(Globals.lang(string));
        }

        public BasicAction(String string, KeyStroke keyStroke) {
            super(Globals.lang(string));
            this.putValue("AcceleratorKey", keyStroke);
        }

        @Override
        public abstract void actionPerformed(ActionEvent var1);
    }
}

