/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.PrefsTab;

public class FileSortTab
extends JPanel
implements PrefsTab {
    private final JabRefPreferences _prefs;
    private final JRadioButton saveInOriginalOrder;
    private final JRadioButton saveInTableOrder;
    private final JRadioButton saveInSpecifiedOrder;
    private JCheckBox savePriDesc;
    private JCheckBox saveSecDesc;
    private JCheckBox saveTerDesc;
    private JTextField savePriField;
    private JTextField saveSecField;
    private JTextField saveTerField;
    private JComboBox savePriSort;
    private JComboBox saveSecSort;
    private JComboBox saveTerSort;
    private final JRadioButton exportInOriginalOrder;
    private final JRadioButton exportInTableOrder;
    private final JRadioButton exportInSpecifiedOrder;
    private JCheckBox exportPriDesc;
    private JCheckBox exportSecDesc;
    private JCheckBox exportTerDesc;
    private JTextField exportPriField;
    private JTextField exportSecField;
    private JTextField exportTerField;
    private JComboBox exportPriSort;
    private JComboBox exportSecSort;
    private JComboBox exportTerSort;

    public FileSortTab(JabRefFrame jabRefFrame, JabRefPreferences jabRefPreferences) {
        this._prefs = jabRefPreferences;
        FormLayout formLayout = new FormLayout("4dlu, left:pref, 4dlu, fill:pref", "");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.leadingColumnOffset(1);
        this.saveInOriginalOrder = new JRadioButton(Globals.lang("Save entries in their original order"));
        this.saveInTableOrder = new JRadioButton(Globals.lang("Save in current table sort order"));
        this.saveInSpecifiedOrder = new JRadioButton(Globals.lang("Save entries ordered as specified"));
        Serializable serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add(this.saveInOriginalOrder);
        ((ButtonGroup)serializable).add(this.saveInTableOrder);
        ((ButtonGroup)serializable).add(this.saveInSpecifiedOrder);
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = actionEvent.getSource() == FileSortTab.this.saveInSpecifiedOrder;
                FileSortTab.this.savePriSort.setEnabled(bl);
                FileSortTab.this.savePriField.setEnabled(bl);
                FileSortTab.this.savePriDesc.setEnabled(bl);
                FileSortTab.this.saveSecSort.setEnabled(bl);
                FileSortTab.this.saveSecField.setEnabled(bl);
                FileSortTab.this.saveSecDesc.setEnabled(bl);
                FileSortTab.this.saveTerSort.setEnabled(bl);
                FileSortTab.this.saveTerField.setEnabled(bl);
                FileSortTab.this.saveTerDesc.setEnabled(bl);
            }
        };
        this.saveInOriginalOrder.addActionListener(actionListener);
        this.saveInTableOrder.addActionListener(actionListener);
        this.saveInSpecifiedOrder.addActionListener(actionListener);
        ArrayList<String> arrayList = new ArrayList<String>(Arrays.asList(BibtexFields.getAllFieldNames()));
        arrayList.add("bibtexkey");
        Collections.sort(arrayList);
        String[] stringArray = arrayList.toArray(new String[arrayList.size()]);
        this.savePriSort = new JComboBox<String>(stringArray);
        this.saveSecSort = new JComboBox<String>(stringArray);
        this.saveTerSort = new JComboBox<String>(stringArray);
        this.savePriField = new JTextField(10);
        this.saveSecField = new JTextField(10);
        this.saveTerField = new JTextField(10);
        this.savePriSort.insertItemAt(Globals.lang("<select>"), 0);
        this.saveSecSort.insertItemAt(Globals.lang("<select>"), 0);
        this.saveTerSort.insertItemAt(Globals.lang("<select>"), 0);
        this.savePriSort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (FileSortTab.this.savePriSort.getSelectedIndex() > 0) {
                    FileSortTab.this.savePriField.setText(FileSortTab.this.savePriSort.getSelectedItem().toString());
                    FileSortTab.this.savePriSort.setSelectedIndex(0);
                }
            }
        });
        this.saveSecSort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (FileSortTab.this.saveSecSort.getSelectedIndex() > 0) {
                    FileSortTab.this.saveSecField.setText(FileSortTab.this.saveSecSort.getSelectedItem().toString());
                    FileSortTab.this.saveSecSort.setSelectedIndex(0);
                }
            }
        });
        this.saveTerSort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (FileSortTab.this.saveTerSort.getSelectedIndex() > 0) {
                    FileSortTab.this.saveTerField.setText(FileSortTab.this.saveTerSort.getSelectedItem().toString());
                    FileSortTab.this.saveTerSort.setSelectedIndex(0);
                }
            }
        });
        this.savePriDesc = new JCheckBox(Globals.lang("Descending"));
        this.saveSecDesc = new JCheckBox(Globals.lang("Descending"));
        this.saveTerDesc = new JCheckBox(Globals.lang("Descending"));
        defaultFormBuilder.appendSeparator(Globals.lang("Save sort order"));
        defaultFormBuilder.append((Component)this.saveInOriginalOrder, 1);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.saveInTableOrder, 1);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.saveInSpecifiedOrder, 1);
        defaultFormBuilder.nextLine();
        FormLayout formLayout2 = new FormLayout("right:pref, 8dlu, fill:pref, 4dlu, fill:60dlu, 4dlu, left:pref", "");
        DefaultFormBuilder defaultFormBuilder2 = new DefaultFormBuilder(formLayout2);
        JLabel jLabel = new JLabel(Globals.lang("Primary sort criterion"));
        defaultFormBuilder2.append(jLabel);
        defaultFormBuilder2.append(this.savePriSort);
        defaultFormBuilder2.append(this.savePriField);
        defaultFormBuilder2.append(this.savePriDesc);
        defaultFormBuilder2.nextLine();
        jLabel = new JLabel(Globals.lang("Secondary sort criterion"));
        defaultFormBuilder2.append(jLabel);
        defaultFormBuilder2.append(this.saveSecSort);
        defaultFormBuilder2.append(this.saveSecField);
        defaultFormBuilder2.append(this.saveSecDesc);
        defaultFormBuilder2.nextLine();
        jLabel = new JLabel(Globals.lang("Tertiary sort criterion"));
        defaultFormBuilder2.append(jLabel);
        defaultFormBuilder2.append(this.saveTerSort);
        defaultFormBuilder2.append(this.saveTerField);
        defaultFormBuilder2.append(this.saveTerDesc);
        JPanel jPanel = defaultFormBuilder2.getPanel();
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder.nextLine();
        this.exportInOriginalOrder = new JRadioButton(Globals.lang("Export entries in their original order"));
        this.exportInTableOrder = new JRadioButton(Globals.lang("Export in current table sort order"));
        this.exportInSpecifiedOrder = new JRadioButton(Globals.lang("Export entries ordered as specified"));
        serializable = new ButtonGroup();
        ((ButtonGroup)serializable).add(this.exportInOriginalOrder);
        ((ButtonGroup)serializable).add(this.exportInTableOrder);
        ((ButtonGroup)serializable).add(this.exportInSpecifiedOrder);
        actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                boolean bl = actionEvent.getSource() == FileSortTab.this.exportInSpecifiedOrder;
                FileSortTab.this.exportPriSort.setEnabled(bl);
                FileSortTab.this.exportPriField.setEnabled(bl);
                FileSortTab.this.exportPriDesc.setEnabled(bl);
                FileSortTab.this.exportSecSort.setEnabled(bl);
                FileSortTab.this.exportSecField.setEnabled(bl);
                FileSortTab.this.exportSecDesc.setEnabled(bl);
                FileSortTab.this.exportTerSort.setEnabled(bl);
                FileSortTab.this.exportTerField.setEnabled(bl);
                FileSortTab.this.exportTerDesc.setEnabled(bl);
            }
        };
        this.exportInOriginalOrder.addActionListener(actionListener);
        this.exportInTableOrder.addActionListener(actionListener);
        this.exportInSpecifiedOrder.addActionListener(actionListener);
        arrayList = new ArrayList<String>(Arrays.asList(BibtexFields.getAllFieldNames()));
        arrayList.add("bibtexkey");
        Collections.sort(arrayList);
        stringArray = arrayList.toArray(new String[arrayList.size()]);
        this.exportPriSort = new JComboBox<String>(stringArray);
        this.exportSecSort = new JComboBox<String>(stringArray);
        this.exportTerSort = new JComboBox<String>(stringArray);
        this.exportPriField = new JTextField(10);
        this.exportSecField = new JTextField(10);
        this.exportTerField = new JTextField(10);
        this.exportPriSort.insertItemAt(Globals.lang("<select>"), 0);
        this.exportSecSort.insertItemAt(Globals.lang("<select>"), 0);
        this.exportTerSort.insertItemAt(Globals.lang("<select>"), 0);
        this.exportPriSort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (FileSortTab.this.exportPriSort.getSelectedIndex() > 0) {
                    FileSortTab.this.exportPriField.setText(FileSortTab.this.exportPriSort.getSelectedItem().toString());
                    FileSortTab.this.exportPriSort.setSelectedIndex(0);
                }
            }
        });
        this.exportSecSort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (FileSortTab.this.exportSecSort.getSelectedIndex() > 0) {
                    FileSortTab.this.exportSecField.setText(FileSortTab.this.exportSecSort.getSelectedItem().toString());
                    FileSortTab.this.exportSecSort.setSelectedIndex(0);
                }
            }
        });
        this.exportTerSort.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (FileSortTab.this.exportTerSort.getSelectedIndex() > 0) {
                    FileSortTab.this.exportTerField.setText(FileSortTab.this.exportTerSort.getSelectedItem().toString());
                    FileSortTab.this.exportTerSort.setSelectedIndex(0);
                }
            }
        });
        this.exportPriDesc = new JCheckBox(Globals.lang("Descending"));
        this.exportSecDesc = new JCheckBox(Globals.lang("Descending"));
        this.exportTerDesc = new JCheckBox(Globals.lang("Descending"));
        defaultFormBuilder.appendSeparator(Globals.lang("Export sort order"));
        defaultFormBuilder.append((Component)this.exportInOriginalOrder, 1);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.exportInTableOrder, 1);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.exportInSpecifiedOrder, 1);
        defaultFormBuilder.nextLine();
        formLayout2 = new FormLayout("right:pref, 8dlu, fill:pref, 4dlu, fill:60dlu, 4dlu, left:pref", "");
        defaultFormBuilder2 = new DefaultFormBuilder(formLayout2);
        jLabel = new JLabel(Globals.lang("Primary sort criterion"));
        defaultFormBuilder2.append(jLabel);
        defaultFormBuilder2.append(this.exportPriSort);
        defaultFormBuilder2.append(this.exportPriField);
        defaultFormBuilder2.append(this.exportPriDesc);
        defaultFormBuilder2.nextLine();
        jLabel = new JLabel(Globals.lang("Secondary sort criterion"));
        defaultFormBuilder2.append(jLabel);
        defaultFormBuilder2.append(this.exportSecSort);
        defaultFormBuilder2.append(this.exportSecField);
        defaultFormBuilder2.append(this.exportSecDesc);
        defaultFormBuilder2.nextLine();
        jLabel = new JLabel(Globals.lang("Tertiary sort criterion"));
        defaultFormBuilder2.append(jLabel);
        defaultFormBuilder2.append(this.exportTerSort);
        defaultFormBuilder2.append(this.exportTerField);
        defaultFormBuilder2.append(this.exportTerDesc);
        defaultFormBuilder.append(defaultFormBuilder2.getPanel());
        defaultFormBuilder.nextLine();
        serializable = defaultFormBuilder.getPanel();
        ((JComponent)serializable).setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout());
        this.add((Component)serializable, "Center");
    }

    @Override
    public void setValues() {
        if (this._prefs.getBoolean("saveInOriginalOrder")) {
            this.saveInOriginalOrder.setSelected(true);
        } else if (this._prefs.getBoolean("saveInSpecifiedOrder")) {
            this.saveInSpecifiedOrder.setSelected(true);
        } else {
            this.saveInTableOrder.setSelected(true);
        }
        boolean bl = this._prefs.getBoolean("saveInSpecifiedOrder");
        this.savePriSort.setEnabled(bl);
        this.savePriField.setEnabled(bl);
        this.savePriDesc.setEnabled(bl);
        this.saveSecSort.setEnabled(bl);
        this.saveSecField.setEnabled(bl);
        this.saveSecDesc.setEnabled(bl);
        this.saveTerSort.setEnabled(bl);
        this.saveTerField.setEnabled(bl);
        this.saveTerDesc.setEnabled(bl);
        this.savePriField.setText(this._prefs.get("savePriSort"));
        this.saveSecField.setText(this._prefs.get("saveSecSort"));
        this.saveTerField.setText(this._prefs.get("saveTerSort"));
        this.savePriSort.setSelectedIndex(0);
        this.saveSecSort.setSelectedIndex(0);
        this.saveTerSort.setSelectedIndex(0);
        this.savePriDesc.setSelected(this._prefs.getBoolean("savePriDescending"));
        this.saveSecDesc.setSelected(this._prefs.getBoolean("saveSecDescending"));
        this.saveTerDesc.setSelected(this._prefs.getBoolean("saveTerDescending"));
        if (this._prefs.getBoolean("exportInOriginalOrder")) {
            this.exportInOriginalOrder.setSelected(true);
        } else if (this._prefs.getBoolean("exportInSpecifiedOrder")) {
            this.exportInSpecifiedOrder.setSelected(true);
        } else {
            this.exportInTableOrder.setSelected(true);
        }
        bl = this._prefs.getBoolean("exportInSpecifiedOrder");
        this.exportPriSort.setEnabled(bl);
        this.exportPriField.setEnabled(bl);
        this.exportPriDesc.setEnabled(bl);
        this.exportSecSort.setEnabled(bl);
        this.exportSecField.setEnabled(bl);
        this.exportSecDesc.setEnabled(bl);
        this.exportTerSort.setEnabled(bl);
        this.exportTerField.setEnabled(bl);
        this.exportTerDesc.setEnabled(bl);
        this.exportPriField.setText(this._prefs.get("exportPriSort"));
        this.exportSecField.setText(this._prefs.get("exportSecSort"));
        this.exportTerField.setText(this._prefs.get("exportTerSort"));
        this.exportPriSort.setSelectedIndex(0);
        this.exportSecSort.setSelectedIndex(0);
        this.exportTerSort.setSelectedIndex(0);
        this.exportPriDesc.setSelected(this._prefs.getBoolean("exportPriDescending"));
        this.exportSecDesc.setSelected(this._prefs.getBoolean("exportSecDescending"));
        this.exportTerDesc.setSelected(this._prefs.getBoolean("exportTerDescending"));
    }

    @Override
    public void storeSettings() {
        this._prefs.putBoolean("saveInOriginalOrder", this.saveInOriginalOrder.isSelected());
        this._prefs.putBoolean("saveInSpecifiedOrder", this.saveInSpecifiedOrder.isSelected());
        this._prefs.putBoolean("savePriDescending", this.savePriDesc.isSelected());
        this._prefs.putBoolean("saveSecDescending", this.saveSecDesc.isSelected());
        this._prefs.putBoolean("saveTerDescending", this.saveTerDesc.isSelected());
        this._prefs.put("savePriSort", this.savePriField.getText().toLowerCase().trim());
        this._prefs.put("saveSecSort", this.saveSecField.getText().toLowerCase().trim());
        this._prefs.put("saveTerSort", this.saveTerField.getText().toLowerCase().trim());
        this._prefs.putBoolean("exportInOriginalOrder", this.exportInOriginalOrder.isSelected());
        this._prefs.putBoolean("exportInSpecifiedOrder", this.exportInSpecifiedOrder.isSelected());
        this._prefs.putBoolean("exportPriDescending", this.exportPriDesc.isSelected());
        this._prefs.putBoolean("exportSecDescending", this.exportSecDesc.isSelected());
        this._prefs.putBoolean("exportTerDescending", this.exportTerDesc.isSelected());
        this._prefs.put("exportPriSort", this.exportPriField.getText().toLowerCase().trim());
        this._prefs.put("exportSecSort", this.exportSecField.getText().toLowerCase().trim());
        this._prefs.put("exportTerSort", this.exportTerField.getText().toLowerCase().trim());
    }

    @Override
    public boolean readyToClose() {
        return true;
    }

    @Override
    public String getTabName() {
        return Globals.lang("File Sorting");
    }
}

