/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JRootPane;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.filechooser.FileSystemView;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRef;
import net.sf.jabref.JabRefExecutorService;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.imports.EntryFromFileCreator;
import net.sf.jabref.imports.EntryFromFileCreatorManager;
import net.sf.jabref.imports.UnlinkedFilesCrawler;
import net.sf.jabref.imports.UnlinkedPDFFileFilter;
import net.sf.jabref.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class FindUnlinkedFilesDialog
extends JDialog {
    private static final long serialVersionUID = -5778378185253640030L;
    public static final String ACTION_COMMAND = "findUnlinkedFiles";
    public static final String ACTION_TITLE = Globals.lang("Find unlinked files") + "...";
    public static final String ACTION_ICON = "toggleSearch";
    public static final String ACTION_KEYBINDING_ACTION = "Find unlinked files";
    public static final String ACTION_SHORT_DESCRIPTION = Globals.lang("Searches for unlinked PDF files on the file system");
    private static final String GLOBAL_PREFS_WORKING_DIRECTORY_KEY = "findUnlinkedFilesWD";
    private static final String GLOBAL_PREFS_DIALOG_SIZE_KEY = "findUnlinkedFilesDialogSize";
    private JabRefFrame frame;
    private BibtexDatabase database;
    private EntryFromFileCreatorManager creatorManager;
    private UnlinkedFilesCrawler crawler;
    private File lastSelectedDirectory;
    private TreeModel treeModel;
    private JPanel panelDirectory;
    private JPanel panelSearchArea;
    private JPanel panelFiles;
    private JPanel panelOptions;
    private JPanel panelButtons;
    private JPanel panelEntryTypesSelection;
    private JPanel panelImportArea;
    private JButton buttonBrowse;
    private JButton buttonScan;
    private JButton buttonApply;
    private JButton buttonClose;
    private JButton buttonOptionSelectAll;
    private JButton buttonOptionUnselectAll;
    private JButton buttonOptionExpandAll;
    private JButton buttonOptionCollapseAll;
    private JCheckBox checkboxCreateKeywords;
    private JTextField textfieldDirectoryPath;
    private JLabel labelDirectoryDescription;
    private JLabel labelFileTypesDescription;
    private JLabel labelFilesDescription;
    private JLabel labelEntryTypeDescription;
    private JLabel labelSearchingDirectoryInfo;
    private JLabel labelImportingInfo;
    private JTree tree;
    private JScrollPane scrollpaneTree;
    private JComboBox comboBoxFileTypeSelection;
    private JComboBox comboBoxEntryTypeSelection;
    private JProgressBar progressBarSearching;
    private JProgressBar progressBarImporting;
    private JFileChooser fileChooser;
    private MouseListener treeMouseListener;
    private Action actionSelectAll;
    private Action actionUnselectAll;
    private Action actionExpandTree;
    private Action actionCollapseTree;
    private ComponentListener dialogPositionListener;
    private int[] threadState = new int[]{1};
    private boolean checkBoxWhyIsThereNoGetSelectedStupidSwing = false;
    private static final Log LOGGER = LogFactory.getLog(FindUnlinkedFilesDialog.class);

    private FindUnlinkedFilesDialog() {
    }

    public FindUnlinkedFilesDialog(Frame frame, JabRefFrame jabRefFrame, BasePanel basePanel) {
        super(frame, Globals.lang(ACTION_KEYBINDING_ACTION), true);
        this.frame = jabRefFrame;
        this.restoreSizeOfDialog();
        this.database = basePanel.getDatabase();
        this.creatorManager = new EntryFromFileCreatorManager();
        this.crawler = new UnlinkedFilesCrawler(this.database);
        this.lastSelectedDirectory = this.loadLastSelectedDirectory();
        this.initialize();
        this.buttonApply.setEnabled(false);
    }

    @Override
    protected JRootPane createRootPane() {
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindUnlinkedFilesDialog.this.setVisible(false);
            }
        };
        JRootPane jRootPane = new JRootPane();
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        jRootPane.registerKeyboardAction(actionListener, keyStroke, 2);
        return jRootPane;
    }

    private void storeSizeOfDialog() {
        Dimension dimension = this.getSize();
        String string = dimension.width + ";" + dimension.height;
        Globals.prefs.put(GLOBAL_PREFS_DIALOG_SIZE_KEY, string);
    }

    private void restoreSizeOfDialog() {
        String string = Globals.prefs.get(GLOBAL_PREFS_DIALOG_SIZE_KEY);
        Dimension dimension = null;
        if (string != null) {
            try {
                String[] stringArray = string.split(";");
                dimension = new Dimension(new Integer(stringArray[0]), new Integer(stringArray[1]));
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (dimension != null) {
            this.setPreferredSize(dimension);
        }
    }

    private void initialize() {
        this.initializeActions();
        this.initComponents();
        this.createTree();
        this.createFileTypesCombobox();
        this.createEntryTypesCombobox();
        this.initLayout();
        this.setupActions();
        this.pack();
    }

    private void initializeActions() {
        this.actionSelectAll = new AbstractAction(Globals.lang("Select all")){
            private static final long serialVersionUID = 9153126361571985383L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CheckableTreeNode checkableTreeNode = (CheckableTreeNode)FindUnlinkedFilesDialog.this.tree.getModel().getRoot();
                checkableTreeNode.setSelected(true);
                FindUnlinkedFilesDialog.this.tree.invalidate();
                FindUnlinkedFilesDialog.this.tree.repaint();
            }
        };
        this.actionUnselectAll = new AbstractAction(Globals.lang("Unselect all")){
            private static final long serialVersionUID = -9012913268030356450L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CheckableTreeNode checkableTreeNode = (CheckableTreeNode)FindUnlinkedFilesDialog.this.tree.getModel().getRoot();
                checkableTreeNode.setSelected(false);
                FindUnlinkedFilesDialog.this.tree.invalidate();
                FindUnlinkedFilesDialog.this.tree.repaint();
            }
        };
        this.actionExpandTree = new AbstractAction(Globals.lang("Expand all")){
            private static final long serialVersionUID = -4794088095435302433L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CheckableTreeNode checkableTreeNode = (CheckableTreeNode)FindUnlinkedFilesDialog.this.tree.getModel().getRoot();
                FindUnlinkedFilesDialog.this.expandTree(FindUnlinkedFilesDialog.this.tree, new TreePath(checkableTreeNode), true);
            }
        };
        this.actionCollapseTree = new AbstractAction(Globals.lang("Collapse all")){
            private static final long serialVersionUID = 6007246730370326456L;

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CheckableTreeNode checkableTreeNode = (CheckableTreeNode)FindUnlinkedFilesDialog.this.tree.getModel().getRoot();
                FindUnlinkedFilesDialog.this.expandTree(FindUnlinkedFilesDialog.this.tree, new TreePath(checkableTreeNode), false);
            }
        };
        this.dialogPositionListener = new ComponentAdapter(){

            @Override
            public void componentResized(ComponentEvent componentEvent) {
                FindUnlinkedFilesDialog.this.storeSizeOfDialog();
            }

            @Override
            public void componentMoved(ComponentEvent componentEvent) {
                FindUnlinkedFilesDialog.this.storeSizeOfDialog();
            }
        };
    }

    private void storeLastSelectedDirectory(File file) {
        this.lastSelectedDirectory = file;
        if (file != null) {
            Globals.prefs.put(GLOBAL_PREFS_WORKING_DIRECTORY_KEY, file.getAbsolutePath());
        }
    }

    private File loadLastSelectedDirectory() {
        String string = Globals.prefs.get(GLOBAL_PREFS_WORKING_DIRECTORY_KEY);
        if (string == null) {
            string = Globals.prefs.get("workingDirectory");
        }
        this.lastSelectedDirectory = new File(string);
        if (this.lastSelectedDirectory.isFile()) {
            this.lastSelectedDirectory = this.lastSelectedDirectory.getParentFile();
        }
        return this.lastSelectedDirectory;
    }

    private File chooseDirectory() {
        String string;
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setAutoscrolls(true);
            this.fileChooser.setDialogTitle(Globals.lang("Select Directory"));
            this.fileChooser.setApproveButtonText(Globals.lang("Choose Directory"));
            this.fileChooser.setApproveButtonToolTipText(Globals.lang("Use the selected directory to start with the search."));
            this.fileChooser.setFileSelectionMode(1);
        }
        if ((string = this.textfieldDirectoryPath.getText()) == null || string.equals("")) {
            this.fileChooser.setCurrentDirectory(this.lastSelectedDirectory);
        } else {
            this.fileChooser.setCurrentDirectory(new File(string));
        }
        int n = this.fileChooser.showOpenDialog(this.frame);
        if (n == 1) {
            return null;
        }
        File file = this.fileChooser.getSelectedFile();
        String string2 = "";
        if (file != null) {
            string2 = file.getAbsolutePath();
        }
        this.textfieldDirectoryPath.setText(string2);
        return file;
    }

    private void disOrEnableDialog(boolean bl) {
        if (bl) {
            this.tree.addMouseListener(this.treeMouseListener);
        } else {
            this.tree.removeMouseListener(this.treeMouseListener);
        }
        this.disOrEnableAllElements(this, bl);
    }

    private void disOrEnableAllElements(Container container, boolean bl) {
        Component[] componentArray;
        for (Component component : componentArray = container.getComponents()) {
            if (component instanceof Container) {
                this.disOrEnableAllElements((Container)component, bl);
            }
            component.setEnabled(bl);
        }
    }

    private void expandTree(JTree jTree, TreePath treePath, boolean bl) {
        TreeNode treeNode = (TreeNode)treePath.getLastPathComponent();
        if (treeNode.getChildCount() >= 0) {
            Enumeration<? extends TreeNode> enumeration = treeNode.children();
            while (enumeration.hasMoreElements()) {
                TreePath treePath2 = treePath.pathByAddingChild(enumeration.nextElement());
                this.expandTree(jTree, treePath2, bl);
            }
        }
        if (bl) {
            jTree.expandPath(treePath);
        } else {
            jTree.collapsePath(treePath);
        }
    }

    private void startSearch() {
        final File file = new File(this.textfieldDirectoryPath.getText());
        if (!file.exists() || !file.isDirectory()) {
            this.textfieldDirectoryPath.setText("");
            return;
        }
        this.storeLastSelectedDirectory(file);
        this.progressBarSearching.setMinimumSize(new Dimension(this.buttonScan.getSize().width, this.progressBarSearching.getMinimumSize().height));
        this.progressBarSearching.setVisible(true);
        this.progressBarSearching.setString("");
        this.labelSearchingDirectoryInfo.setVisible(true);
        this.buttonScan.setVisible(false);
        this.disOrEnableDialog(false);
        this.labelSearchingDirectoryInfo.setEnabled(true);
        final FileFilter fileFilter = (FileFilter)this.comboBoxFileTypeSelection.getSelectedItem();
        this.threadState = new int[]{1};
        JabRefExecutorService.INSTANCE.execute(new Runnable(){

            @Override
            public void run() {
                UnlinkedPDFFileFilter unlinkedPDFFileFilter = new UnlinkedPDFFileFilter(fileFilter, FindUnlinkedFilesDialog.this.database);
                CheckableTreeNode checkableTreeNode = FindUnlinkedFilesDialog.this.crawler.searchDirectory(file, unlinkedPDFFileFilter, FindUnlinkedFilesDialog.this.threadState, new ChangeListener(){
                    int counter = 0;

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        FindUnlinkedFilesDialog.this.progressBarSearching.setString(++this.counter + " files found");
                    }
                });
                FindUnlinkedFilesDialog.this.searchFinishedHandler(checkableTreeNode);
            }
        });
    }

    private void startImport() {
        if (this.treeModel == null) {
            return;
        }
        this.setDefaultCloseOperation(0);
        CheckableTreeNode checkableTreeNode = (CheckableTreeNode)this.treeModel.getRoot();
        final List<File> list = this.getFileListFromNode(checkableTreeNode);
        if (list == null || list.isEmpty()) {
            return;
        }
        this.progressBarImporting.setVisible(true);
        this.labelImportingInfo.setVisible(true);
        this.buttonApply.setVisible(false);
        this.buttonClose.setVisible(false);
        this.disOrEnableDialog(false);
        this.labelImportingInfo.setEnabled(true);
        this.progressBarImporting.setMinimum(0);
        this.progressBarImporting.setMaximum(list.size());
        this.progressBarImporting.setValue(0);
        this.progressBarImporting.setString("");
        final BibtexEntryType bibtexEntryType = ((BibtexEntryTypeWrapper)this.comboBoxEntryTypeSelection.getSelectedItem()).entryType;
        this.threadState = new int[]{1};
        JabRefExecutorService.INSTANCE.execute(new Runnable(){

            @Override
            public void run() {
                LinkedList<String> linkedList = new LinkedList<String>();
                int n = FindUnlinkedFilesDialog.this.creatorManager.addEntriesFromFiles(list, FindUnlinkedFilesDialog.this.database, FindUnlinkedFilesDialog.this.frame.basePanel(), bibtexEntryType, FindUnlinkedFilesDialog.this.checkBoxWhyIsThereNoGetSelectedStupidSwing, new ChangeListener(){
                    int counter = 0;

                    @Override
                    public void stateChanged(ChangeEvent changeEvent) {
                        FindUnlinkedFilesDialog.this.progressBarImporting.setValue(++this.counter);
                        FindUnlinkedFilesDialog.this.progressBarImporting.setString(this.counter + " of " + FindUnlinkedFilesDialog.this.progressBarImporting.getMaximum());
                    }
                }, linkedList);
                FindUnlinkedFilesDialog.this.importFinishedHandler(n, linkedList);
            }
        });
    }

    private void importFinishedHandler(int n, List<String> list) {
        if (list != null && list.size() > 0) {
            JOptionPane.showMessageDialog(this, "The import finished with warnings:\nThere " + (list.size() > 1 ? "were " : "was ") + list.size() + (list.size() > 1 ? " files" : " file") + (list.size() > 1 ? " which" : " that") + " could not be imported.", Globals.lang("Warning"), 2);
        }
        this.progressBarImporting.setVisible(false);
        this.labelImportingInfo.setVisible(false);
        this.buttonApply.setVisible(true);
        this.buttonClose.setVisible(true);
        this.disOrEnableDialog(true);
        this.setDefaultCloseOperation(2);
        this.frame.basePanel().markBaseChanged();
    }

    private void searchFinishedHandler(CheckableTreeNode checkableTreeNode) {
        this.treeModel = new DefaultTreeModel(checkableTreeNode);
        this.tree.setModel(this.treeModel);
        this.tree.setRootVisible(checkableTreeNode.getChildCount() > 0);
        this.tree.invalidate();
        this.tree.repaint();
        this.progressBarSearching.setVisible(false);
        this.labelSearchingDirectoryInfo.setVisible(false);
        this.buttonScan.setVisible(true);
        this.actionSelectAll.actionPerformed(null);
        this.disOrEnableDialog(true);
        this.buttonApply.setEnabled(true);
    }

    private void setupActions() {
        this.buttonBrowse.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = FindUnlinkedFilesDialog.this.chooseDirectory();
                FindUnlinkedFilesDialog.this.storeLastSelectedDirectory(file);
            }
        });
        this.buttonScan.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindUnlinkedFilesDialog.this.startSearch();
            }
        });
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindUnlinkedFilesDialog.this.startImport();
            }
        };
        this.buttonApply.addActionListener(actionListener);
        this.buttonClose.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                FindUnlinkedFilesDialog.this.dispose();
            }
        });
    }

    private List<File> getFileListFromNode(CheckableTreeNode checkableTreeNode) {
        Serializable serializable;
        ArrayList<File> arrayList = new ArrayList<File>();
        Enumeration<TreeNode> enumeration = checkableTreeNode.depthFirstEnumeration();
        ArrayList<Serializable> arrayList2 = new ArrayList<Serializable>();
        while (enumeration.hasMoreElements()) {
            Object object;
            serializable = (CheckableTreeNode)enumeration.nextElement();
            if (!((DefaultMutableTreeNode)serializable).isLeaf() || !((CheckableTreeNode)serializable).getSelected() || (object = ((FileNodeWrapper)((DefaultMutableTreeNode)serializable).getUserObject()).file) == null || !((File)object).isFile()) continue;
            arrayList.add((File)object);
            arrayList2.add(serializable);
        }
        serializable = (DefaultTreeModel)this.tree.getModel();
        for (CheckableTreeNode checkableTreeNode2 : arrayList2) {
            DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)checkableTreeNode2.getParent();
            ((DefaultTreeModel)serializable).removeNodeFromParent(checkableTreeNode2);
            while (defaultMutableTreeNode != null && defaultMutableTreeNode.isLeaf()) {
                DefaultMutableTreeNode defaultMutableTreeNode2 = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent();
                if (defaultMutableTreeNode2 != null) {
                    ((DefaultTreeModel)serializable).removeNodeFromParent(defaultMutableTreeNode);
                }
                defaultMutableTreeNode = defaultMutableTreeNode2;
            }
        }
        this.tree.invalidate();
        this.tree.repaint();
        return arrayList;
    }

    private void initComponents() {
        this.addComponentListener(this.dialogPositionListener);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                ((FindUnlinkedFilesDialog)FindUnlinkedFilesDialog.this).threadState[0] = 0;
            }
        });
        this.panelDirectory = new JPanel();
        this.panelSearchArea = new JPanel();
        this.panelFiles = new JPanel();
        this.panelOptions = new JPanel();
        this.panelEntryTypesSelection = new JPanel();
        this.panelButtons = new JPanel();
        this.panelImportArea = new JPanel();
        this.buttonBrowse = new JButton(Globals.lang("Browse..."));
        this.buttonBrowse.setMnemonic('B');
        this.buttonBrowse.setToolTipText(Globals.lang("Opens the file browser."));
        this.buttonScan = new JButton(Globals.lang("Scan directory"));
        this.buttonScan.setMnemonic('S');
        this.buttonScan.setToolTipText(Globals.lang("Searches the selected directory for unlinked files."));
        this.buttonApply = new JButton(Globals.lang("Apply"));
        this.buttonApply.setMnemonic('I');
        this.buttonApply.setToolTipText(Globals.lang("Starts the import of bibtex entries."));
        this.buttonClose = new JButton(Globals.lang("Close"));
        this.buttonClose.setToolTipText(Globals.lang("Leave this dialog."));
        this.buttonClose.setMnemonic('C');
        this.buttonOptionSelectAll = new JButton();
        this.buttonOptionSelectAll.setMnemonic('A');
        this.buttonOptionSelectAll.setAction(this.actionSelectAll);
        this.buttonOptionUnselectAll = new JButton();
        this.buttonOptionUnselectAll.setMnemonic('U');
        this.buttonOptionUnselectAll.setAction(this.actionUnselectAll);
        this.buttonOptionExpandAll = new JButton();
        this.buttonOptionExpandAll.setMnemonic('E');
        this.buttonOptionExpandAll.setAction(this.actionExpandTree);
        this.buttonOptionCollapseAll = new JButton();
        this.buttonOptionCollapseAll.setMnemonic('L');
        this.buttonOptionCollapseAll.setAction(this.actionCollapseTree);
        this.checkboxCreateKeywords = new JCheckBox(Globals.lang("Create directory based keywords"));
        this.checkboxCreateKeywords.setToolTipText(Globals.lang("Creates keywords in created entrys with directory pathnames"));
        this.checkboxCreateKeywords.setSelected(this.checkBoxWhyIsThereNoGetSelectedStupidSwing);
        this.checkboxCreateKeywords.addItemListener(new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                FindUnlinkedFilesDialog.this.checkBoxWhyIsThereNoGetSelectedStupidSwing = !FindUnlinkedFilesDialog.this.checkBoxWhyIsThereNoGetSelectedStupidSwing;
            }
        });
        this.textfieldDirectoryPath = new JTextField();
        this.textfieldDirectoryPath.setText(this.lastSelectedDirectory == null ? "" : this.lastSelectedDirectory.getAbsolutePath());
        this.labelDirectoryDescription = new JLabel(Globals.lang("Select a directory where the search shall start."));
        this.labelFileTypesDescription = new JLabel(Globals.lang("Select file type:"));
        this.labelFilesDescription = new JLabel(Globals.lang("These files are not linked in the active database."));
        this.labelEntryTypeDescription = new JLabel(Globals.lang("Entry type to be created:"));
        this.labelSearchingDirectoryInfo = new JLabel(Globals.lang("Searching file system..."));
        this.labelSearchingDirectoryInfo.setHorizontalAlignment(0);
        this.labelSearchingDirectoryInfo.setVisible(false);
        this.labelImportingInfo = new JLabel(Globals.lang("Importing into Database..."));
        this.labelImportingInfo.setHorizontalAlignment(0);
        this.labelImportingInfo.setVisible(false);
        this.tree = new JTree();
        this.scrollpaneTree = new JScrollPane(this.tree);
        this.scrollpaneTree.setWheelScrollingEnabled(true);
        this.progressBarSearching = new JProgressBar();
        this.progressBarSearching.setIndeterminate(true);
        this.progressBarSearching.setVisible(false);
        this.progressBarSearching.setStringPainted(true);
        this.progressBarImporting = new JProgressBar();
        this.progressBarImporting.setIndeterminate(false);
        this.progressBarImporting.setVisible(false);
        this.progressBarImporting.setStringPainted(true);
    }

    private void initLayout() {
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.panelDirectory.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Globals.lang("Select directory")));
        this.panelFiles.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Globals.lang("Select files")));
        this.panelEntryTypesSelection.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Globals.lang("Bibtex entry creation")));
        Insets insets = new Insets(6, 6, 6, 6);
        Insets insets2 = new Insets(3, 2, 3, 1);
        Insets insets3 = new Insets(0, 0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gridBagLayout, this.panelSearchArea, this.buttonScan, 2, 13, insets3, 0, 1, 1, 1, 1.0, 1.0, 40, 10);
        FindUnlinkedFilesDialog.addComponent(gridBagLayout, this.panelSearchArea, this.labelSearchingDirectoryInfo, 2, 13, insets3, 0, 2, 1, 1, 0.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gridBagLayout, this.panelSearchArea, this.progressBarSearching, 2, 13, insets3, 0, 3, 1, 1, 0.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gridBagLayout, this.panelDirectory, this.labelDirectoryDescription, null, 17, new Insets(6, 6, 0, 6), 0, 0, 3, 1, 0.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gridBagLayout, this.panelDirectory, this.textfieldDirectoryPath, 2, null, insets, 0, 1, 2, 1, 1.0, 1.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gridBagLayout, this.panelDirectory, this.buttonBrowse, 2, 13, insets, 2, 1, 1, 1, 0.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gridBagLayout, this.panelDirectory, this.labelFileTypesDescription, 0, 17, new Insets(18, 6, 18, 3), 0, 3, 1, 1, 0.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gridBagLayout, this.panelDirectory, this.comboBoxFileTypeSelection, 2, 17, new Insets(18, 3, 18, 6), 1, 3, 1, 1, 1.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gridBagLayout, this.panelDirectory, this.panelSearchArea, 2, 13, new Insets(18, 6, 18, 6), 2, 3, 1, 1, 0.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gridBagLayout, this.panelFiles, this.labelFilesDescription, 2, 17, new Insets(6, 6, 0, 6), 0, 0, 1, 1, 0.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gridBagLayout, this.panelFiles, this.scrollpaneTree, 1, 10, insets, 0, 1, 1, 1, 1.0, 1.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gridBagLayout, this.panelFiles, this.panelOptions, 0, 12, insets, 1, 1, 1, 1, 0.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gridBagLayout, this.panelOptions, this.buttonOptionSelectAll, 2, 11, insets3, 0, 0, 1, 1, 1.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gridBagLayout, this.panelOptions, this.buttonOptionUnselectAll, 2, 11, insets3, 0, 1, 1, 1, 0.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gridBagLayout, this.panelOptions, this.buttonOptionExpandAll, 2, 11, new Insets(6, 0, 0, 0), 0, 2, 1, 1, 0.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gridBagLayout, this.panelOptions, this.buttonOptionCollapseAll, 2, 11, insets3, 0, 3, 1, 1, 0.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gridBagLayout, this.panelEntryTypesSelection, this.labelEntryTypeDescription, 0, 17, insets, 0, 0, 1, 1, 0.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gridBagLayout, this.panelEntryTypesSelection, this.comboBoxEntryTypeSelection, 0, 17, insets, 1, 0, 1, 1, 1.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gridBagLayout, this.panelEntryTypesSelection, this.checkboxCreateKeywords, 2, 17, insets, 0, 1, 2, 1, 0.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gridBagLayout, this.panelImportArea, this.labelImportingInfo, 2, 10, new Insets(6, 6, 0, 6), 0, 1, 1, 1, 1.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gridBagLayout, this.panelImportArea, this.progressBarImporting, 2, 10, new Insets(0, 6, 6, 6), 0, 2, 1, 1, 1.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gridBagLayout, this.panelButtons, this.panelImportArea, 0, 13, insets2, 1, 0, 1, 1, 0.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gridBagLayout, this.getContentPane(), this.panelDirectory, 2, 10, insets, 0, 0, 1, 1, 0.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gridBagLayout, this.getContentPane(), this.panelFiles, 1, 18, new Insets(12, 6, 2, 2), 0, 1, 1, 1, 1.0, 1.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gridBagLayout, this.getContentPane(), this.panelEntryTypesSelection, 2, 16, new Insets(12, 6, 2, 2), 0, 2, 1, 1, 0.0, 0.0, 0, 0);
        FindUnlinkedFilesDialog.addComponent(gridBagLayout, this.getContentPane(), this.panelButtons, 2, 10, new Insets(10, 6, 10, 6), 0, 3, 1, 1, 0.0, 0.0, 0, 0);
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addButton((JComponent)this.buttonApply);
        buttonBarBuilder.addButton((JComponent)this.buttonClose);
        buttonBarBuilder.addGlue();
        buttonBarBuilder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.panelImportArea.add((Component)buttonBarBuilder.getPanel(), 0);
        this.pack();
    }

    private static void addComponent(GridBagLayout gridBagLayout, Container container, Component component, Integer n, Integer n2, Insets insets, int n3, int n4, int n5, int n6, double d, double d2, int n7, int n8) {
        container.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = n3;
        gridBagConstraints.gridy = n4;
        gridBagConstraints.gridwidth = n5;
        gridBagConstraints.gridheight = n6;
        gridBagConstraints.weightx = d;
        gridBagConstraints.weighty = d2;
        gridBagConstraints.ipadx = n7;
        gridBagConstraints.ipady = n8;
        if (n != null) {
            gridBagConstraints.fill = n;
        }
        if (insets != null) {
            gridBagConstraints.insets = insets;
        }
        if (n2 != null) {
            gridBagConstraints.anchor = n2;
        }
        gridBagLayout.setConstraints(component, gridBagConstraints);
        container.add(component);
    }

    private void createTree() {
        this.treeMouseListener = new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                int n = mouseEvent.getX();
                int n2 = mouseEvent.getY();
                int n3 = FindUnlinkedFilesDialog.this.tree.getRowForLocation(n, n2);
                TreePath treePath = FindUnlinkedFilesDialog.this.tree.getPathForRow(n3);
                if (treePath != null) {
                    CheckableTreeNode checkableTreeNode = (CheckableTreeNode)treePath.getLastPathComponent();
                    if (mouseEvent.getClickCount() == 2) {
                        Object object = checkableTreeNode.getUserObject();
                        if (object instanceof FileNodeWrapper && checkableTreeNode.isLeaf()) {
                            FileNodeWrapper fileNodeWrapper = (FileNodeWrapper)object;
                            try {
                                Util.openExternalViewer(JabRef.jrf.basePanel().metaData(), fileNodeWrapper.file.getAbsolutePath(), "pdf");
                            }
                            catch (IOException iOException) {
                                LOGGER.info("Error opening file", iOException);
                            }
                        }
                    } else {
                        checkableTreeNode.check();
                        FindUnlinkedFilesDialog.this.tree.invalidate();
                        FindUnlinkedFilesDialog.this.tree.repaint();
                    }
                }
            }
        };
        CheckableTreeNode checkableTreeNode = new CheckableTreeNode("ROOT");
        DefaultTreeModel defaultTreeModel = new DefaultTreeModel(checkableTreeNode);
        this.tree.setModel(defaultTreeModel);
        this.tree.setRootVisible(false);
        CheckboxTreeCellRenderer checkboxTreeCellRenderer = new CheckboxTreeCellRenderer();
        this.tree.setCellRenderer(checkboxTreeCellRenderer);
        this.tree.addMouseListener(this.treeMouseListener);
    }

    private void createFileTypesCombobox() {
        List<FileFilter> list = this.creatorManager.getFileFilterList();
        Vector<FileFilter> vector = new Vector<FileFilter>();
        for (FileFilter fileFilter : list) {
            vector.add(fileFilter);
        }
        this.comboBoxFileTypeSelection = new JComboBox(vector);
        this.comboBoxFileTypeSelection.setRenderer(new DefaultListCellRenderer(){
            private static final long serialVersionUID = 8503499454763947465L;

            @Override
            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                EntryFromFileCreator entryFromFileCreator;
                JLabel jLabel = (JLabel)super.getListCellRendererComponent((JList<?>)jList, object, n, bl, bl2);
                if (object instanceof EntryFromFileCreator && (entryFromFileCreator = (EntryFromFileCreator)object).getExternalFileType() != null) {
                    jLabel.setIcon(entryFromFileCreator.getExternalFileType().getIcon());
                }
                return jLabel;
            }
        });
    }

    private void createEntryTypesCombobox() {
        Iterator<BibtexEntryType> iterator = BibtexEntryType.getAllValues().iterator();
        Vector<BibtexEntryTypeWrapper> vector = new Vector<BibtexEntryTypeWrapper>();
        vector.add(new BibtexEntryTypeWrapper(null));
        while (iterator.hasNext()) {
            vector.add(new BibtexEntryTypeWrapper(iterator.next()));
        }
        this.comboBoxEntryTypeSelection = new JComboBox(vector);
    }

    public static class FileNodeWrapper {
        public final File file;
        public final int fileCount;

        public FileNodeWrapper(File file) {
            this(file, 0);
        }

        public FileNodeWrapper(File file, int n) {
            this.file = file;
            this.fileCount = n;
        }

        public String toString() {
            return this.file.getName();
        }
    }

    private static class CheckboxTreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 3737245079578074387L;
        final FileSystemView fsv = FileSystemView.getFileSystemView();

        private CheckboxTreeCellRenderer() {
        }

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            Component component = super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            CheckableTreeNode checkableTreeNode = (CheckableTreeNode)object;
            FileNodeWrapper fileNodeWrapper = (FileNodeWrapper)checkableTreeNode.getUserObject();
            JPanel jPanel = new JPanel();
            JCheckBox jCheckBox = checkableTreeNode.getCheckbox();
            jCheckBox.setSelected(checkableTreeNode.getSelected());
            try {
                this.setIcon(this.fsv.getSystemIcon(fileNodeWrapper.file));
            }
            catch (Exception exception) {
                // empty catch block
            }
            jPanel.setBackground(component.getBackground());
            jCheckBox.setBackground(component.getBackground());
            GridBagLayout gridBagLayout = new GridBagLayout();
            FindUnlinkedFilesDialog.addComponent(gridBagLayout, jPanel, jCheckBox, null, null, null, 0, 0, 1, 1, 0.0, 0.0, 0, 0);
            FindUnlinkedFilesDialog.addComponent(gridBagLayout, jPanel, component, 2, null, new Insets(1, 2, 0, 0), 1, 0, 1, 1, 1.0, 0.0, 0, 0);
            if (fileNodeWrapper.fileCount > 0) {
                JLabel jLabel = new JLabel("(" + fileNodeWrapper.fileCount + " file" + (fileNodeWrapper.fileCount > 1 ? "s" : "") + ")");
                FindUnlinkedFilesDialog.addComponent(gridBagLayout, jPanel, jLabel, null, null, new Insets(1, 2, 0, 0), 2, 0, 1, 1, 0.0, 0.0, 0, 0);
            }
            return jPanel;
        }
    }

    public static class CheckableTreeNode
    extends DefaultMutableTreeNode {
        private static final long serialVersionUID = -1131241777605570737L;
        private boolean isSelected;
        private JCheckBox checkbox = new JCheckBox();

        public CheckableTreeNode(Object object) {
            super(object);
        }

        public JCheckBox getCheckbox() {
            return this.checkbox;
        }

        public void setCheckbox(JCheckBox jCheckBox) {
            this.checkbox = jCheckBox;
        }

        public void check() {
            this.setSelected(!this.isSelected);
        }

        public void setSelected(boolean bl) {
            this.isSelected = bl;
            Enumeration<TreeNode> enumeration = this.children();
            while (enumeration.hasMoreElements()) {
                CheckableTreeNode checkableTreeNode = (CheckableTreeNode)enumeration.nextElement();
                checkableTreeNode.setSelected(bl);
            }
        }

        public boolean getSelected() {
            return this.isSelected;
        }
    }

    private static class BibtexEntryTypeWrapper {
        final BibtexEntryType entryType;

        BibtexEntryTypeWrapper(BibtexEntryType bibtexEntryType) {
            this.entryType = bibtexEntryType;
        }

        public String toString() {
            if (this.entryType == null) {
                return Globals.lang("<No selection>");
            }
            return this.entryType.getName();
        }
    }
}

