/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import net.sf.jabref.FontSelectorDialog;

class FontSelector
extends JButton {
    private static final long serialVersionUID = 7745223550102664896L;
    private static final String PLAIN = "plain";
    private static final String BOLD = "bold";
    private static final String BOLD_ITALIC = "bold-italic";
    private static final String ITALIC = "italic";

    public FontSelector() {
        this(new Font("SansSerif", 0, 10));
    }

    private FontSelector(Font font) {
        this.setFont(font);
        this.setRequestFocusEnabled(false);
        this.addActionListener(new ActionHandler());
    }

    @Override
    public void setFont(Font font) {
        super.setFont(font);
        this.updateText();
    }

    private void updateText() {
        String string;
        Font font = this.getFont();
        switch (font.getStyle()) {
            case 0: {
                string = PLAIN;
                break;
            }
            case 1: {
                string = BOLD;
                break;
            }
            case 2: {
                string = ITALIC;
                break;
            }
            case 3: {
                string = BOLD_ITALIC;
                break;
            }
            default: {
                string = "UNKNOWN!!!???";
            }
        }
        this.setText(font.getFamily() + " " + font.getSize() + " " + string);
    }

    private class ActionHandler
    implements ActionListener {
        private ActionHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Font font = new FontSelectorDialog(FontSelector.this, FontSelector.this.getFont()).getSelectedFont();
            if (font != null) {
                FontSelector.this.setFont(font);
            }
        }
    }
}

