/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.text.SimpleDateFormat;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.PrefsTab;
import net.sf.jabref.help.HelpAction;

public class GeneralTab
extends JPanel
implements PrefsTab {
    private final JCheckBox defSort;
    private final JCheckBox ctrlClick;
    private final JCheckBox useOwner;
    private final JCheckBox overwriteOwner;
    private final JCheckBox keyDuplicateWarningDialog;
    private final JCheckBox keyEmptyWarningDialog;
    private final JCheckBox enforceLegalKeys;
    private final JCheckBox confirmDelete;
    private final JCheckBox allowEditing;
    private final JCheckBox memoryStick;
    private final JCheckBox useImportInspector;
    private final JCheckBox useImportInspectorForSingle;
    private final JCheckBox inspectionWarnDupli;
    private final JCheckBox useTimeStamp;
    private final JCheckBox updateTimeStamp;
    private final JCheckBox overwriteTimeStamp;
    private final JCheckBox markImportedEntries;
    private final JCheckBox unmarkAllEntriesBeforeImporting;
    private final JTextField defOwnerField;
    private final JTextField timeStampFormat;
    private final JTextField timeStampField;
    private final JabRefPreferences _prefs;
    private final JComboBox language = new JComboBox<String>(GUIGlobals.LANGUAGES.keySet().toArray(new String[GUIGlobals.LANGUAGES.keySet().size()]));
    private final JComboBox encodings = new JComboBox<String>(Globals.ENCODINGS);

    public GeneralTab(JabRefFrame jabRefFrame, JabRefPreferences jabRefPreferences) {
        this._prefs = jabRefPreferences;
        this.setLayout(new BorderLayout());
        this.allowEditing = new JCheckBox(Globals.lang("Allow editing in table cells"));
        this.memoryStick = new JCheckBox(Globals.lang("Load and Save preferences from/to jabref.xml on start-up (memory stick mode)"));
        this.defSort = new JCheckBox(Globals.lang("Sort Automatically"));
        this.ctrlClick = new JCheckBox(Globals.lang("Open right-click menu with Ctrl+left button"));
        this.useOwner = new JCheckBox(Globals.lang("Mark new entries with owner name") + ':');
        this.useTimeStamp = new JCheckBox(Globals.lang("Mark new entries with addition date") + ". " + Globals.lang("Date format") + ':');
        this.useTimeStamp.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                GeneralTab.this.updateTimeStamp.setEnabled(GeneralTab.this.useTimeStamp.isSelected());
            }
        });
        this.updateTimeStamp = new JCheckBox(Globals.lang("Update timestamp on modification"));
        this.overwriteOwner = new JCheckBox(Globals.lang("Overwrite"));
        this.overwriteTimeStamp = new JCheckBox(Globals.lang("Overwrite"));
        this.overwriteOwner.setToolTipText(Globals.lang("If a pasted or imported entry already has the field set, overwrite."));
        this.overwriteTimeStamp.setToolTipText(Globals.lang("If a pasted or imported entry already has the field set, overwrite."));
        this.keyDuplicateWarningDialog = new JCheckBox(Globals.lang("Show warning dialog when a duplicate BibTeX key is entered"));
        this.keyEmptyWarningDialog = new JCheckBox(Globals.lang("Show warning dialog when an empty BibTeX key is entered"));
        this.enforceLegalKeys = new JCheckBox(Globals.lang("Enforce legal characters in BibTeX keys"));
        this.confirmDelete = new JCheckBox(Globals.lang("Show confirmation dialog when deleting entries"));
        this.useImportInspector = new JCheckBox(Globals.lang("Display imported entries in an inspection window before they are added."));
        this.useImportInspectorForSingle = new JCheckBox(Globals.lang("Use inspection window also when a single entry is imported."));
        this.markImportedEntries = new JCheckBox(Globals.lang("Mark entries imported into an existing database"));
        this.unmarkAllEntriesBeforeImporting = new JCheckBox(Globals.lang("Unmark all entries before importing new entries into an existing database"));
        this.defOwnerField = new JTextField();
        this.timeStampFormat = new JTextField();
        this.timeStampField = new JTextField();
        HelpAction helpAction = new HelpAction(jabRefFrame.helpDiag, "OwnerHelp.html", "Help", GUIGlobals.getIconUrl("helpSmall"));
        HelpAction helpAction2 = new HelpAction(jabRefFrame.helpDiag, "TimeStampHelp.html", "Help", GUIGlobals.getIconUrl("helpSmall"));
        this.inspectionWarnDupli = new JCheckBox(Globals.lang("Warn about unresolved duplicates when closing inspection window"));
        Insets insets = new Insets(0, 12, 3, 0);
        this.useImportInspectorForSingle.setMargin(insets);
        this.inspectionWarnDupli.setMargin(insets);
        this.useImportInspector.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                GeneralTab.this.useImportInspectorForSingle.setEnabled(GeneralTab.this.useImportInspector.isSelected());
                GeneralTab.this.inspectionWarnDupli.setEnabled(GeneralTab.this.useImportInspector.isSelected());
            }
        });
        FormLayout formLayout = new FormLayout("8dlu, 1dlu, left:170dlu, 4dlu, fill:pref, 4dlu, fill:pref, 4dlu, left:pref, 4dlu, left:pref, 4dlu, left:pref", "");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        defaultFormBuilder.appendSeparator(Globals.lang("General"));
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.useImportInspector, 13);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(new JPanel());
        defaultFormBuilder.append((Component)this.useImportInspectorForSingle, 11);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(new JPanel());
        defaultFormBuilder.append((Component)this.inspectionWarnDupli, 11);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.ctrlClick, 13);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.confirmDelete, 13);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.keyDuplicateWarningDialog, 13);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.keyEmptyWarningDialog, 13);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.enforceLegalKeys, 13);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.memoryStick, 13);
        defaultFormBuilder.append((Component)this.useOwner, 3);
        defaultFormBuilder.append(this.defOwnerField);
        defaultFormBuilder.append(this.overwriteOwner);
        defaultFormBuilder.append((Component)new JPanel(), 3);
        JButton jButton = new JButton(helpAction);
        jButton.setText(null);
        jButton.setPreferredSize(new Dimension(24, 24));
        defaultFormBuilder.append(jButton);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.useTimeStamp, 3);
        defaultFormBuilder.append(this.timeStampFormat);
        defaultFormBuilder.append(this.overwriteTimeStamp);
        defaultFormBuilder.append(Globals.lang("Field name") + ':');
        defaultFormBuilder.append(this.timeStampField);
        jButton = new JButton(helpAction2);
        jButton.setText(null);
        jButton.setPreferredSize(new Dimension(24, 24));
        defaultFormBuilder.append(jButton);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(new JPanel());
        defaultFormBuilder.append((Component)this.updateTimeStamp, 2);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.markImportedEntries, 13);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append((Component)this.unmarkAllEntriesBeforeImporting, 13);
        defaultFormBuilder.nextLine();
        JLabel jLabel = new JLabel(Globals.lang("Language") + ':');
        defaultFormBuilder.append((Component)jLabel, 3);
        defaultFormBuilder.append(this.language);
        defaultFormBuilder.nextLine();
        jLabel = new JLabel(Globals.lang("Default encoding") + ':');
        defaultFormBuilder.append((Component)jLabel, 3);
        defaultFormBuilder.append(this.encodings);
        JPanel jPanel = defaultFormBuilder.getPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)jPanel, "Center");
    }

    @Override
    public void setValues() {
        this.allowEditing.setSelected(this._prefs.getBoolean("allowTableEditing"));
        this.defSort.setSelected(this._prefs.getBoolean("defaultAutoSort"));
        this.ctrlClick.setSelected(this._prefs.getBoolean("ctrlClick"));
        this.useOwner.setSelected(this._prefs.getBoolean("useOwner"));
        this.overwriteOwner.setSelected(this._prefs.getBoolean("overwriteOwner"));
        this.useTimeStamp.setSelected(this._prefs.getBoolean("useTimeStamp"));
        this.overwriteTimeStamp.setSelected(this._prefs.getBoolean("overwriteTimeStamp"));
        this.updateTimeStamp.setSelected(this._prefs.getBoolean("updateTimestamp"));
        this.updateTimeStamp.setEnabled(this.useTimeStamp.isSelected());
        this.keyDuplicateWarningDialog.setSelected(this._prefs.getBoolean("dialogWarningForDuplicateKey"));
        this.keyEmptyWarningDialog.setSelected(this._prefs.getBoolean("dialogWarningForEmptyKey"));
        this.enforceLegalKeys.setSelected(this._prefs.getBoolean("enforceLegalBibtexKey"));
        this.memoryStick.setSelected(this._prefs.getBoolean("memoryStickMode"));
        this.confirmDelete.setSelected(this._prefs.getBoolean("confirmDelete"));
        this.defOwnerField.setText(this._prefs.get("defaultOwner"));
        this.timeStampFormat.setText(this._prefs.get("timeStampFormat"));
        this.timeStampField.setText(this._prefs.get("timeStampField"));
        this.useImportInspector.setSelected(this._prefs.getBoolean("useImportInspectionDialog"));
        this.useImportInspectorForSingle.setSelected(this._prefs.getBoolean("useImportInspectionDialogForSingle"));
        this.inspectionWarnDupli.setSelected(this._prefs.getBoolean("warnAboutDuplicatesInInspection"));
        this.useImportInspectorForSingle.setEnabled(this.useImportInspector.isSelected());
        this.inspectionWarnDupli.setEnabled(this.useImportInspector.isSelected());
        this.markImportedEntries.setSelected(this._prefs.getBoolean("markImportedEntries"));
        this.unmarkAllEntriesBeforeImporting.setSelected(this._prefs.getBoolean("unmarkAllEntriesBeforeImporting"));
        String string = this._prefs.get("defaultEncoding");
        for (int i = 0; i < Globals.ENCODINGS.length; ++i) {
            if (!Globals.ENCODINGS[i].equalsIgnoreCase(string)) continue;
            this.encodings.setSelectedIndex(i);
            break;
        }
        String string2 = this._prefs.get("language");
        int n = 0;
        for (String string3 : GUIGlobals.LANGUAGES.values()) {
            if (string3.equals(string2)) {
                this.language.setSelectedIndex(n);
            }
            ++n;
        }
    }

    @Override
    public void storeSettings() {
        this._prefs.putBoolean("useOwner", this.useOwner.isSelected());
        this._prefs.putBoolean("overwriteOwner", this.overwriteOwner.isSelected());
        this._prefs.putBoolean("useTimeStamp", this.useTimeStamp.isSelected());
        this._prefs.putBoolean("overwriteTimeStamp", this.overwriteTimeStamp.isSelected());
        this._prefs.putBoolean("updateTimestamp", this.updateTimeStamp.isSelected());
        this._prefs.putBoolean("dialogWarningForDuplicateKey", this.keyDuplicateWarningDialog.isSelected());
        this._prefs.putBoolean("dialogWarningForEmptyKey", this.keyEmptyWarningDialog.isSelected());
        this._prefs.putBoolean("enforceLegalBibtexKey", this.enforceLegalKeys.isSelected());
        if (this._prefs.getBoolean("memoryStickMode") && !this.memoryStick.isSelected()) {
            JOptionPane.showMessageDialog(null, Globals.lang("To disable the memory stick mode rename or remove the jabref.xml file in the same folder as JabRef."), Globals.lang("Memory Stick Mode"), 1);
        }
        this._prefs.putBoolean("memoryStickMode", this.memoryStick.isSelected());
        this._prefs.putBoolean("confirmDelete", this.confirmDelete.isSelected());
        this._prefs.putBoolean("allowTableEditing", this.allowEditing.isSelected());
        this._prefs.putBoolean("ctrlClick", this.ctrlClick.isSelected());
        this._prefs.putBoolean("useImportInspectionDialog", this.useImportInspector.isSelected());
        this._prefs.putBoolean("useImportInspectionDialogForSingle", this.useImportInspectorForSingle.isSelected());
        this._prefs.putBoolean("warnAboutDuplicatesInInspection", this.inspectionWarnDupli.isSelected());
        String string = this.defOwnerField.getText().trim();
        this._prefs.put("defaultOwner", string);
        this._prefs.WRAPPED_USERNAME = '[' + string + ']';
        this._prefs.put("timeStampFormat", this.timeStampFormat.getText().trim());
        this._prefs.put("timeStampField", this.timeStampField.getText().trim());
        this._prefs.put("defaultEncoding", (String)this.encodings.getSelectedItem());
        this._prefs.putBoolean("markImportedEntries", this.markImportedEntries.isSelected());
        this._prefs.putBoolean("unmarkAllEntriesBeforeImporting", this.unmarkAllEntriesBeforeImporting.isSelected());
        if (!GUIGlobals.LANGUAGES.get(this.language.getSelectedItem()).equals(this._prefs.get("language"))) {
            this._prefs.put("language", GUIGlobals.LANGUAGES.get(this.language.getSelectedItem()));
            Globals.setLanguage(GUIGlobals.LANGUAGES.get(this.language.getSelectedItem()), "");
            Globals.prefs.setLanguageDependentDefaultValues();
            JOptionPane.showMessageDialog(null, Globals.lang("You have changed the language setting.").concat(" ").concat(Globals.lang("You must restart JabRef for this to come into effect.")), Globals.lang("Changed language settings"), 2);
        }
    }

    @Override
    public boolean readyToClose() {
        try {
            new SimpleDateFormat(this.timeStampFormat.getText());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            JOptionPane.showMessageDialog(null, Globals.lang("The chosen date format for new entries is not valid"), Globals.lang("Invalid date format"), 0);
            return false;
        }
        return true;
    }

    @Override
    public String getTabName() {
        return Globals.lang("General");
    }
}

