/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.regex.Matcher;
import javax.swing.AbstractAction;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import javax.swing.text.Keymap;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;
import net.sf.jabref.Globals;
import net.sf.jabref.SearchTextListener;

public class JTextAreaWithHighlighting
extends JTextArea
implements SearchTextListener {
    private ArrayList<String> wordsToHighlight;
    private UndoManager undo;

    public JTextAreaWithHighlighting() {
        this.setupUndoRedo();
    }

    JTextAreaWithHighlighting(String string) {
        super(string);
        this.setupUndoRedo();
    }

    public JTextAreaWithHighlighting(Document document) {
        super(document);
        this.setupUndoRedo();
    }

    public JTextAreaWithHighlighting(int n, int n2) {
        super(n, n2);
        this.setupUndoRedo();
    }

    public JTextAreaWithHighlighting(String string, int n, int n2) {
        super(string, n, n2);
        this.setupUndoRedo();
    }

    public JTextAreaWithHighlighting(Document document, String string, int n, int n2) {
        super(document, string, n, n2);
        this.setupUndoRedo();
    }

    private void setupUndoRedo() {
        this.undo = new UndoManager();
        Document document = this.getDocument();
        document.addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent undoableEditEvent) {
                JTextAreaWithHighlighting.this.undo.addEdit(undoableEditEvent.getEdit());
            }
        });
        this.getActionMap().put("Undo", new AbstractAction("Undo"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (JTextAreaWithHighlighting.this.undo.canUndo()) {
                        JTextAreaWithHighlighting.this.undo.undo();
                    }
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
            }
        });
        this.getInputMap().put(Globals.prefs.getKey("Undo"), "Undo");
        this.getActionMap().put("Redo", new AbstractAction("Redo"){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                try {
                    if (JTextAreaWithHighlighting.this.undo.canRedo()) {
                        JTextAreaWithHighlighting.this.undo.redo();
                    }
                }
                catch (CannotRedoException cannotRedoException) {
                    // empty catch block
                }
            }
        });
        boolean bl = true;
        KeyStroke keyStroke = Globals.prefs.getKey("Redo");
        if (Globals.prefs.getBoolean("editorEMACSkeyBindings")) {
            int n;
            Keymap keymap = this.getKeymap();
            KeyStroke[] keyStrokeArray = keymap.getBoundKeyStrokes();
            for (n = 0; n < keyStrokeArray.length && !keyStrokeArray[n].equals(keyStroke); ++n) {
            }
            if (n < keyStrokeArray.length) {
                bl = false;
            }
        }
        if (bl) {
            this.getInputMap().put(keyStroke, "Redo");
        }
    }

    private void highLight(ArrayList<String> arrayList) {
        Highlighter highlighter = this.getHighlighter();
        highlighter.removeAllHighlights();
        if (arrayList == null || arrayList.isEmpty() || arrayList.get(0).isEmpty()) {
            return;
        }
        String string = this.getText();
        if (string.isEmpty()) {
            return;
        }
        Matcher matcher = Globals.getPatternForWords(arrayList).matcher(string);
        while (matcher.find()) {
            try {
                highlighter.addHighlight(matcher.start(), matcher.end(), DefaultHighlighter.DefaultPainter);
            }
            catch (BadLocationException badLocationException) {
                System.out.println(badLocationException);
            }
        }
    }

    @Override
    public void setText(String string) {
        super.setText(string);
        if (Globals.prefs.getBoolean("highLightWords")) {
            this.highLight(this.wordsToHighlight);
        }
        if (this.undo != null) {
            this.undo.discardAllEdits();
        }
    }

    @Override
    public void searchText(ArrayList<String> arrayList) {
        if (Globals.prefs.getBoolean("highLightWords")) {
            this.wordsToHighlight = arrayList;
            this.highLight(arrayList);
        } else if (this.wordsToHighlight != null) {
            this.wordsToHighlight = null;
            this.highLight(null);
        }
    }
}

