/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadFactory;

public class JabRefExecutorService
implements Executor {
    public static final JabRefExecutorService INSTANCE = new JabRefExecutorService();
    private final ExecutorService executorService = Executors.newCachedThreadPool(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable runnable) {
            Thread thread = new Thread(runnable);
            thread.setName("JabRef CachedThreadPool");
            return thread;
        }
    });
    private final ConcurrentLinkedQueue<Thread> startedThreads = new ConcurrentLinkedQueue();

    private JabRefExecutorService() {
    }

    @Override
    public void execute(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        this.executorService.execute(runnable);
    }

    public void executeAndWait(Runnable runnable) {
        if (runnable == null) {
            return;
        }
        Future<?> future = this.executorService.submit(runnable);
        while (true) {
            try {
                future.get();
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            catch (ExecutionException executionException) {
                executionException.printStackTrace();
                continue;
            }
            break;
        }
    }

    public void executeWithLowPriorityInOwnThread(Runnable runnable, String string) {
        Thread thread;
        AutoCleanupRunnable autoCleanupRunnable = new AutoCleanupRunnable(runnable, this.startedThreads);
        autoCleanupRunnable.thread = thread = new Thread(autoCleanupRunnable);
        thread.setName("JabRef - " + string + " - low prio");
        this.startedThreads.add(thread);
        thread.setPriority(1);
        thread.start();
    }

    public void executeInOwnThread(Thread thread) {
        this.startedThreads.add(thread);
        thread.start();
    }

    public void executeWithLowPriorityInOwnThreadAndWait(Runnable runnable) {
        Thread thread = new Thread(runnable);
        thread.setName("JabRef low prio");
        this.startedThreads.add(thread);
        thread.setPriority(1);
        thread.start();
        this.waitForThreadToFinish(thread);
    }

    private void waitForThreadToFinish(Thread thread) {
        while (true) {
            try {
                thread.join();
                this.startedThreads.remove(thread);
                return;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public void shutdownEverything() {
        this.executorService.shutdown();
        for (Thread thread : this.startedThreads) {
            thread.interrupt();
        }
        this.startedThreads.clear();
    }

    private static class AutoCleanupRunnable
    implements Runnable {
        private final Runnable runnable;
        private final ConcurrentLinkedQueue<Thread> startedThreads;
        public Thread thread;

        private AutoCleanupRunnable(Runnable runnable, ConcurrentLinkedQueue<Thread> concurrentLinkedQueue) {
            this.runnable = runnable;
            this.startedThreads = concurrentLinkedQueue;
        }

        @Override
        public void run() {
            try {
                this.runnable.run();
            }
            finally {
                this.startedThreads.remove(this.thread);
            }
        }
    }
}

