/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.looks.HeaderStyle;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.MouseAdapter;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.SortedSet;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToggleButton;
import javax.swing.JToolBar;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.AutoLinkFilesAction;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.BibtexFields;
import net.sf.jabref.DuplicateCheck;
import net.sf.jabref.DuplicateResolverDialog;
import net.sf.jabref.EntryTypeDialog;
import net.sf.jabref.FileHistory;
import net.sf.jabref.FindUnlinkedFilesDialog;
import net.sf.jabref.FocusRequester;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.IdGenerator;
import net.sf.jabref.JabRef;
import net.sf.jabref.JabRefExecutorService;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.KeyBindingsDialog;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.MarkEntriesAction;
import net.sf.jabref.MetaData;
import net.sf.jabref.MnemonicAwareAction;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.PrefsDialog3;
import net.sf.jabref.RightClickMenu;
import net.sf.jabref.SearchManager2;
import net.sf.jabref.SidePaneManager;
import net.sf.jabref.export.AutoSaveManager;
import net.sf.jabref.export.ExportCustomizationDialog;
import net.sf.jabref.export.ExportFormats;
import net.sf.jabref.export.SaveAllAction;
import net.sf.jabref.export.SaveDatabaseAction;
import net.sf.jabref.external.ExternalFileTypeEditor;
import net.sf.jabref.external.PushToApplicationButton;
import net.sf.jabref.groups.EntryTableTransferHandler;
import net.sf.jabref.groups.GroupSelector;
import net.sf.jabref.gui.BibtexKeyPatternDialog;
import net.sf.jabref.gui.DatabasePropertiesDialog;
import net.sf.jabref.gui.DragDropPopupPane;
import net.sf.jabref.gui.EntryCustomizationDialog2;
import net.sf.jabref.gui.ErrorConsoleAction;
import net.sf.jabref.gui.GenFieldsCustomizer;
import net.sf.jabref.gui.ImportInspectionDialog;
import net.sf.jabref.gui.SortTabsAction;
import net.sf.jabref.gui.SysTray;
import net.sf.jabref.gui.WaitForSaveOperation;
import net.sf.jabref.gui.menus.help.ForkMeOnGitHubAction;
import net.sf.jabref.help.HelpAction;
import net.sf.jabref.help.HelpDialog;
import net.sf.jabref.imports.EntryFetcher;
import net.sf.jabref.imports.GeneralFetcher;
import net.sf.jabref.imports.ImportCustomizationDialog;
import net.sf.jabref.imports.ImportFormat;
import net.sf.jabref.imports.ImportFormats;
import net.sf.jabref.imports.ImportMenuItem;
import net.sf.jabref.imports.OpenDatabaseAction;
import net.sf.jabref.imports.ParserResult;
import net.sf.jabref.journals.ManageJournalsAction;
import net.sf.jabref.oo.OpenOfficePanel;
import net.sf.jabref.plugin.PluginCore;
import net.sf.jabref.plugin.PluginInstallerAction;
import net.sf.jabref.plugin.core.JabRefPlugin;
import net.sf.jabref.plugin.core.generated._JabRefPlugin;
import net.sf.jabref.specialfields.Printed;
import net.sf.jabref.specialfields.Priority;
import net.sf.jabref.specialfields.Quality;
import net.sf.jabref.specialfields.Rank;
import net.sf.jabref.specialfields.ReadStatus;
import net.sf.jabref.specialfields.Relevance;
import net.sf.jabref.specialfields.SpecialFieldDropDown;
import net.sf.jabref.sql.importer.DbImportAction;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableInsertEntry;
import net.sf.jabref.undo.UndoableRemoveEntry;
import net.sf.jabref.util.ManageKeywordsAction;
import net.sf.jabref.util.MassSetFieldAction;
import net.sf.jabref.util.StringUtil;
import net.sf.jabref.util.Util;
import net.sf.jabref.wizard.auximport.gui.FromAuxDialog;
import net.sf.jabref.wizard.integrity.gui.IntegrityWizard;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class JabRefFrame
extends JFrame
implements OutputPrinter {
    private static final long serialVersionUID = 1L;
    final JSplitPane contentPane = new JSplitPane();
    final JabRefPreferences prefs = Globals.prefs;
    private PrefsDialog3 prefsDialog = null;
    private int lastTabbedPanelSelectionIndex = -1;
    public SidePaneManager sidePaneManager;
    JTabbedPane tabbedPane;
    private final Insets marg = new Insets(1, 0, 2, 0);
    private final JabRef jabRef;
    private static final Log LOGGER = LogFactory.getLog(JabRefFrame.class);
    final ToolBar tlb = new ToolBar();
    private final JMenuBar mb = new JMenuBar();
    private final JMenu pluginMenu = JabRefFrame.subMenu("Plugins");
    private boolean addedToPluginMenu = false;
    private final GridBagLayout gbl = new GridBagLayout();
    private final GridBagConstraints con = new GridBagConstraints();
    final JLabel statusLine = new JLabel("", 2);
    private final JLabel statusLabel = new JLabel(Globals.lang("Status") + ':', 2);
    private final JProgressBar progressBar = new JProgressBar();
    private final FileHistory fileHistory = new FileHistory(this.prefs, this);
    private SysTray sysTray = null;
    public final HelpDialog helpDiag = new HelpDialog(this);
    public JToggleButton groupToggle;
    public JToggleButton searchToggle;
    public JToggleButton previewToggle;
    public JToggleButton highlightAny;
    public JToggleButton highlightAll;
    final OpenDatabaseAction open = new OpenDatabaseAction(this, true);
    private final AbstractAction close = new CloseDatabaseAction();
    private final AbstractAction quit = new CloseAction();
    private final AbstractAction selectKeys = new SelectKeysAction();
    private final AbstractAction newDatabaseAction = new NewDatabaseAction();
    private final AbstractAction newSubDatabaseAction = new NewSubDatabaseAction();
    private final AbstractAction integrityCheckAction = new IntegrityCheckAction();
    private final AbstractAction forkMeOnGitHubAction = new ForkMeOnGitHubAction();
    private final AbstractAction help = new HelpAction("JabRef help", this.helpDiag, "BaseFrameHelp.html", Globals.lang("JabRef help"), this.prefs.getKey("Help"));
    private final AbstractAction contents = new HelpAction("Help contents", this.helpDiag, "Contents.html", Globals.lang("Help contents"), GUIGlobals.getIconUrl("helpContents"));
    private final AbstractAction about = new HelpAction("About JabRef", this.helpDiag, "About.html", Globals.lang("About JabRef"), GUIGlobals.getIconUrl("about"));
    private final AbstractAction editEntry = new GeneralAction("edit", "Edit entry", Globals.lang("Edit entry"), this.prefs.getKey("Edit entry"));
    private final AbstractAction focusTable = new GeneralAction("focusTable", "Focus entry table", Globals.lang("Move the keyboard focus to the entry table"), this.prefs.getKey("Focus entry table"));
    private final AbstractAction save = new GeneralAction("save", "Save database", Globals.lang("Save database"), this.prefs.getKey("Save database"));
    private final AbstractAction saveAs = new GeneralAction("saveAs", "Save database as ...", Globals.lang("Save database as ..."), this.prefs.getKey("Save database as ..."));
    private final AbstractAction saveAll = new SaveAllAction(this);
    private final AbstractAction saveSelectedAs = new GeneralAction("saveSelectedAs", "Save selected as ...", Globals.lang("Save selected as ..."), GUIGlobals.getIconUrl("saveAs"));
    private final AbstractAction saveSelectedAsPlain = new GeneralAction("saveSelectedAsPlain", "Save selected as plain BibTeX ...", Globals.lang("Save selected as plain BibTeX ..."), GUIGlobals.getIconUrl("saveAs"));
    private final AbstractAction exportAll = ExportFormats.getExportAction(this, false);
    private final AbstractAction exportSelected = ExportFormats.getExportAction(this, true);
    private final AbstractAction importCurrent = ImportFormats.getImportAction(this, false);
    private final AbstractAction importNew = ImportFormats.getImportAction(this, true);
    final AbstractAction nextTab = new ChangeTabAction(true);
    final AbstractAction prevTab = new ChangeTabAction(false);
    private final AbstractAction sortTabs = new SortTabsAction(this);
    private final AbstractAction undo = new GeneralAction("undo", "Undo", Globals.lang("Undo"), this.prefs.getKey("Undo"));
    private final AbstractAction redo = new GeneralAction("redo", "Redo", Globals.lang("Redo"), this.prefs.getKey("Redo"));
    final AbstractAction forward = new GeneralAction("forward", "Forward", Globals.lang("Forward"), "right", this.prefs.getKey("Forward"));
    final AbstractAction back = new GeneralAction("back", "Back", Globals.lang("Back"), "left", this.prefs.getKey("Back"));
    private final AbstractAction delete = new GeneralAction("delete", "Delete", Globals.lang("Delete"), this.prefs.getKey("Delete"));
    private final AbstractAction copy = new EditAction("copy", GUIGlobals.getIconUrl("copy"));
    private final AbstractAction paste = new EditAction("paste", GUIGlobals.getIconUrl("paste"));
    private final AbstractAction cut = new EditAction("cut", GUIGlobals.getIconUrl("cut"));
    private final AbstractAction mark = new GeneralAction("markEntries", "Mark entries", Globals.lang("Mark entries"), this.prefs.getKey("Mark entries"));
    private final AbstractAction unmark = new GeneralAction("unmarkEntries", "Unmark entries", Globals.lang("Unmark entries"), this.prefs.getKey("Unmark entries"));
    private final AbstractAction unmarkAll = new GeneralAction("unmarkAll", "Unmark all");
    private final AbstractAction toggleRelevance = new GeneralAction(Relevance.getInstance().getValues().get(0).getActionName(), Relevance.getInstance().getValues().get(0).getMenuString(), Relevance.getInstance().getValues().get(0).getToolTipText());
    private final AbstractAction toggleQualityAssured = new GeneralAction(Quality.getInstance().getValues().get(0).getActionName(), Quality.getInstance().getValues().get(0).getMenuString(), Quality.getInstance().getValues().get(0).getToolTipText());
    private final AbstractAction togglePrinted = new GeneralAction(Printed.getInstance().getValues().get(0).getActionName(), Printed.getInstance().getValues().get(0).getMenuString(), Printed.getInstance().getValues().get(0).getToolTipText());
    private final AbstractAction manageSelectors = new GeneralAction("manageSelectors", "Manage content selectors");
    private final AbstractAction saveSessionAction = new SaveSessionAction();
    final AbstractAction loadSessionAction = new LoadSessionAction();
    private final AbstractAction incrementalSearch = new GeneralAction("incSearch", "Incremental search", Globals.lang("Start incremental search"), this.prefs.getKey("Incremental search"));
    private final AbstractAction normalSearch = new GeneralAction("search", "Search", Globals.lang("Search"), this.prefs.getKey("Search"));
    private final AbstractAction toggleSearch = new GeneralAction("toggleSearch", "Search", Globals.lang("Toggle search panel"));
    private final AbstractAction copyKey = new GeneralAction("copyKey", "Copy BibTeX key", this.prefs.getKey("Copy BibTeX key"));
    private final AbstractAction copyCiteKey = new GeneralAction("copyCiteKey", "Copy \\cite{BibTeX key}", this.prefs.getKey("Copy \\cite{BibTeX key}"));
    private final AbstractAction copyKeyAndTitle = new GeneralAction("copyKeyAndTitle", "Copy BibTeX key and title", this.prefs.getKey("Copy BibTeX key and title"));
    private final AbstractAction mergeDatabaseAction = new GeneralAction("mergeDatabase", "Append database", Globals.lang("Append contents from a BibTeX database into the currently viewed database"), GUIGlobals.getIconUrl("open"));
    private final AbstractAction selectAll = new GeneralAction("selectAll", "Select all", this.prefs.getKey("Select all"));
    private final AbstractAction replaceAll = new GeneralAction("replaceAll", "Replace string", this.prefs.getKey("Replace string"));
    private final AbstractAction editPreamble = new GeneralAction("editPreamble", "Edit preamble", Globals.lang("Edit preamble"), this.prefs.getKey("Edit preamble"));
    private final AbstractAction editStrings = new GeneralAction("editStrings", "Edit strings", Globals.lang("Edit strings"), this.prefs.getKey("Edit strings"));
    private final AbstractAction toggleToolbar = new GeneralAction("toggleToolbar", "Hide/show toolbar", Globals.lang("Hide/show toolbar"), this.prefs.getKey("Hide/show toolbar"));
    private final AbstractAction toggleGroups = new GeneralAction("toggleGroups", "Toggle groups interface", Globals.lang("Toggle groups interface"), this.prefs.getKey("Toggle groups interface"));
    private final AbstractAction togglePreview = new GeneralAction("togglePreview", "Toggle entry preview", Globals.lang("Toggle entry preview"), this.prefs.getKey("Toggle entry preview"));
    private final AbstractAction toggleHighlightAny = new GeneralAction("toggleHighlightGroupsMatchingAny", "Highlight groups matching any selected entry", Globals.lang("Highlight groups matching any selected entry"), GUIGlobals.getIconUrl("groupsHighlightAny"));
    private final AbstractAction toggleHighlightAll = new GeneralAction("toggleHighlightGroupsMatchingAll", "Highlight groups matching all selected entries", Globals.lang("Highlight groups matching all selected entries"), GUIGlobals.getIconUrl("groupsHighlightAll"));
    final AbstractAction switchPreview = new GeneralAction("switchPreview", "Switch preview layout", this.prefs.getKey("Switch preview layout"));
    private final AbstractAction makeKeyAction = new GeneralAction("makeKey", "Autogenerate BibTeX keys", Globals.lang("Autogenerate BibTeX keys"), this.prefs.getKey("Autogenerate BibTeX keys"));
    private final AbstractAction writeXmpAction = new GeneralAction("writeXMP", "Write XMP-metadata to PDFs", Globals.lang("Will write XMP-metadata to the PDFs linked from selected entries."), this.prefs.getKey("Write XMP"));
    private final AbstractAction openFolder = new GeneralAction("openFolder", "Open folder", Globals.lang("Open folder"), this.prefs.getKey("Open folder"));
    private final AbstractAction openFile = new GeneralAction("openExternalFile", "Open file", Globals.lang("Open file"), this.prefs.getKey("Open file"));
    private final AbstractAction openPdf = new GeneralAction("openFile", "Open PDF or PS", Globals.lang("Open PDF or PS"), this.prefs.getKey("Open PDF or PS"));
    private final AbstractAction openUrl = new GeneralAction("openUrl", "Open URL or DOI", Globals.lang("Open URL or DOI"), this.prefs.getKey("Open URL or DOI"));
    private final AbstractAction openSpires = new GeneralAction("openSpires", "Open SPIRES entry", Globals.lang("Open SPIRES entry"), this.prefs.getKey("Open SPIRES entry"));
    private final AbstractAction dupliCheck = new GeneralAction("dupliCheck", "Find duplicates");
    private final AbstractAction plainTextImport = new GeneralAction("plainTextImport", "New entry from plain text", this.prefs.getKey("New from plain text"));
    private final AbstractAction customExpAction = new CustomizeExportsAction();
    private final AbstractAction customImpAction = new CustomizeImportsAction();
    private final AbstractAction customFileTypesAction = ExternalFileTypeEditor.getAction(this);
    AbstractAction exportToClipboard = new GeneralAction("exportToClipboard", "Export selected entries to clipboard");
    private final AbstractAction autoSetPdf = new GeneralAction("autoSetPdf", Globals.lang("Synchronize %0 links", "PDF"), Globals.prefs.getKey("Synchronize PDF"));
    private final AbstractAction autoSetPs = new GeneralAction("autoSetPs", Globals.lang("Synchronize %0 links", "PS"), Globals.prefs.getKey("Synchronize PS"));
    private final AbstractAction autoSetFile = new GeneralAction("autoSetFile", Globals.lang("Synchronize file links"), Globals.prefs.getKey("Synchronize files"));
    private final AbstractAction abbreviateMedline = new GeneralAction("abbreviateMedline", "Abbreviate journal names (MEDLINE)", Globals.lang("Abbreviate journal names of the selected entries (MEDLINE abbreviation)"));
    private final AbstractAction abbreviateIso = new GeneralAction("abbreviateIso", "Abbreviate journal names (ISO)", Globals.lang("Abbreviate journal names of the selected entries (ISO abbreviation)"), Globals.prefs.getKey("Abbreviate"));
    private final AbstractAction unabbreviate = new GeneralAction("unabbreviate", "Unabbreviate journal names", Globals.lang("Unabbreviate journal names of the selected entries"), Globals.prefs.getKey("Unabbreviate"));
    private final AbstractAction manageJournals = new ManageJournalsAction(this);
    private final AbstractAction databaseProperties = new DatabasePropertiesAction();
    private final AbstractAction bibtexKeyPattern = new BibtexKeyPatternAction();
    private final AbstractAction errorConsole = new ErrorConsoleAction(this, Globals.streamEavesdropper, Globals.handler);
    AbstractAction test = new GeneralAction("test", "Test");
    private final AbstractAction dbConnect = new GeneralAction("dbConnect", "Connect to external SQL database", Globals.lang("Connect to external SQL database"), GUIGlobals.getIconUrl("dbConnect"));
    private final AbstractAction dbExport = new GeneralAction("dbExport", "Export to external SQL database", Globals.lang("Export to external SQL database"), GUIGlobals.getIconUrl("dbExport"));
    private final AbstractAction Cleanup = new GeneralAction("Cleanup", "Cleanup entries", Globals.lang("Cleanup entries"), this.prefs.getKey("Cleanup"), "cleanupentries");
    private final AbstractAction mergeEntries = new GeneralAction("mergeEntries", "Merge entries", Globals.lang("Merge entries"), GUIGlobals.getIconUrl("mergeentries"));
    private final AbstractAction dbImport = new DbImportAction(this).getAction();
    private final AbstractAction increaseFontSize = new IncreaseTableFontSizeAction();
    private final AbstractAction decreseFontSize = new DecreaseTableFontSizeAction();
    private final AbstractAction installPlugin = new PluginInstallerAction(this);
    private final AbstractAction resolveDuplicateKeys = new GeneralAction("resolveDuplicateKeys", "Resolve duplicate BibTeX keys", Globals.lang("Find and remove duplicate BibTeX keys"), this.prefs.getKey("Resolve duplicate BibTeX keys"));
    final MassSetFieldAction massSetField = new MassSetFieldAction(this);
    final ManageKeywordsAction manageKeywords = new ManageKeywordsAction(this);
    private final GeneralAction findUnlinkedFiles = new GeneralAction("findUnlinkedFiles", FindUnlinkedFilesDialog.ACTION_TITLE, FindUnlinkedFilesDialog.ACTION_SHORT_DESCRIPTION, "toggleSearch", this.prefs.getKey("Find unlinked files"));
    private final AutoLinkFilesAction autoLinkFile = new AutoLinkFilesAction();
    private PushToApplicationButton pushExternalButton;
    private final List<EntryFetcher> fetchers = new LinkedList<EntryFetcher>();
    private final List<Action> fetcherActions = new LinkedList<Action>();
    private SearchManager2 searchManager;
    public GroupSelector groupSelector;
    private final JMenu importMenu = JabRefFrame.subMenu("Import into current database");
    private final JMenu importNewMenu = JabRefFrame.subMenu("Import into new database");
    private final JMenu exportMenu = JabRefFrame.subMenu("Export");
    JMenu customExportMenu = JabRefFrame.subMenu("Custom export");
    private final JMenu newDatabaseMenu = JabRefFrame.subMenu("New database");
    private final JMenu checkAndFix = JabRefFrame.subMenu("Legacy tools...");
    private final NewEntryAction newEntryAction = new NewEntryAction(this.prefs.getKey("New entry"));
    private final NewEntryAction[] newSpecificEntryAction = new NewEntryAction[]{new NewEntryAction("article", this.prefs.getKey("New article")), new NewEntryAction("book", this.prefs.getKey("New book")), new NewEntryAction("phdthesis", this.prefs.getKey("New phdthesis")), new NewEntryAction("inbook", this.prefs.getKey("New inbook")), new NewEntryAction("mastersthesis", this.prefs.getKey("New mastersthesis")), new NewEntryAction("proceedings", this.prefs.getKey("New proceedings")), new NewEntryAction("inproceedings"), new NewEntryAction("conference"), new NewEntryAction("incollection"), new NewEntryAction("booklet"), new NewEntryAction("manual"), new NewEntryAction("techreport"), new NewEntryAction("unpublished", this.prefs.getKey("New unpublished")), new NewEntryAction("misc"), new NewEntryAction("other")};
    private List<Object> openDatabaseOnlyActions = new LinkedList<Object>();
    private List<Object> severalDatabasesOnlyActions = new LinkedList<Object>();
    private int previousTabCount = -1;
    private final CloseDatabaseAction closeDatabaseAction = new CloseDatabaseAction();
    private final AbstractAction showPrefs = new ShowPrefsAction();

    public JabRefFrame(JabRef jabRef) {
        this.jabRef = jabRef;
        this.init();
        this.updateEnabledState();
    }

    private void init() {
        this.tabbedPane = new DragDropPopupPane(this.manageSelectors, this.databaseProperties, this.bibtexKeyPattern);
        UIManager.put("FileChooser.readOnly", Globals.prefs.getBoolean("filechooserDisableRename"));
        MyGlassPane myGlassPane = new MyGlassPane();
        this.setGlassPane(myGlassPane);
        this.setTitle("JabRef");
        this.setIconImage(GUIGlobals.getImage("jabrefIcon48").getImage());
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                if (Globals.ON_MAC) {
                    JabRefFrame.this.setState(1);
                } else {
                    new CloseAction().actionPerformed(null);
                }
            }
        });
        this.initSidePane();
        this.initLayout();
        this.initActions();
        this.tlb.setVisible(Globals.prefs.getBoolean("toolbarVisible"));
        this.setBounds(GraphicsEnvironment.getLocalGraphicsEnvironment().getMaximumWindowBounds());
        if (!this.prefs.getBoolean("windowMaximised")) {
            int n = this.prefs.getInt("sizeX");
            int n2 = this.prefs.getInt("sizeY");
            int n3 = this.prefs.getInt("posX");
            int n4 = this.prefs.getInt("posY");
            if (GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices().length == 1) {
                Rectangle rectangle = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices()[0].getDefaultConfiguration().getBounds();
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                if (n3 < rectangle.x) {
                    n3 = rectangle.x;
                }
                if (n4 < rectangle.y) {
                    n4 = rectangle.y;
                }
                int n5 = (int)dimension.getHeight();
                int n6 = (int)dimension.getWidth();
                if (n3 + n > n6) {
                    if (n <= n6) {
                        n3 = n6 - n;
                    } else {
                        n3 = this.prefs.getIntDefault("posX");
                        n = this.prefs.getIntDefault("sizeX");
                    }
                }
                if (n4 + n2 > n5) {
                    if (n2 <= n5) {
                        n4 = n5 - n2;
                    } else {
                        n4 = this.prefs.getIntDefault("posY");
                        n2 = this.prefs.getIntDefault("sizeY");
                    }
                }
            }
            this.setBounds(n3, n4, n, n2);
        }
        this.tabbedPane.setBorder(null);
        this.tabbedPane.setForeground(GUIGlobals.inActiveTabbed);
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JabRefFrame.this.markActiveBasePanel();
                BasePanel basePanel = JabRefFrame.this.basePanel();
                if (basePanel != null) {
                    JabRefFrame.this.groupToggle.setSelected(JabRefFrame.this.sidePaneManager.isComponentVisible("groups"));
                    JabRefFrame.this.searchToggle.setSelected(JabRefFrame.this.sidePaneManager.isComponentVisible("search"));
                    JabRefFrame.this.previewToggle.setSelected(Globals.prefs.getBoolean("previewEnabled"));
                    JabRefFrame.this.highlightAny.setSelected(Globals.prefs.getBoolean("highlightGroupsMatchingAny"));
                    JabRefFrame.this.highlightAll.setSelected(Globals.prefs.getBoolean("highlightGroupsMatchingAll"));
                    Globals.focusListener.setFocused(basePanel.mainTable);
                    JabRefFrame.this.setWindowTitle();
                    basePanel.updateSearchManager();
                    basePanel.setBackAndForwardEnabledState();
                    new FocusRequester(basePanel.mainTable);
                }
            }
        });
        if (Globals.ON_MAC) {
            try {
                Class<?> clazz = Class.forName("osx.macadapter.MacAdapter");
                Method method = clazz.getMethod("registerMacEvents", JabRefFrame.class);
                method.invoke(clazz.newInstance(), this);
            }
            catch (Exception exception) {
                System.err.println("Exception (" + exception.getClass().toString() + "): " + exception.getMessage());
            }
        }
    }

    public void setWindowTitle() {
        String string;
        BasePanel basePanel = this.basePanel();
        if (basePanel == null) {
            this.setTitle("JabRef");
            return;
        }
        String string2 = string = basePanel.isBaseChanged() ? "*" : "";
        if (basePanel.getFile() != null) {
            this.setTitle("JabRef - " + basePanel.getFile().getPath() + string);
        } else {
            this.setTitle("JabRef - " + Globals.lang("untitled") + string);
        }
    }

    private void initSidePane() {
        Globals.sidePaneManager = this.sidePaneManager = new SidePaneManager(this);
        Globals.helpDiag = this.helpDiag;
        JabRefPlugin jabRefPlugin = JabRefPlugin.getInstance(PluginCore.getManager());
        if (jabRefPlugin != null) {
            for (_JabRefPlugin.EntryFetcherExtension entryFetcherExtension : jabRefPlugin.getEntryFetcherExtensions()) {
                try {
                    EntryFetcher entryFetcher = entryFetcherExtension.getEntryFetcher();
                    if (entryFetcher == null) continue;
                    this.fetchers.add(entryFetcher);
                }
                catch (ClassCastException classCastException) {
                    PluginCore.getManager().disablePlugin(entryFetcherExtension.getDeclaringPlugin().getDescriptor());
                    classCastException.printStackTrace();
                }
            }
        }
        this.groupSelector = new GroupSelector(this, this.sidePaneManager);
        this.searchManager = new SearchManager2(this, this.sidePaneManager);
        this.sidePaneManager.register("groups", this.groupSelector);
        this.sidePaneManager.register("search", this.searchManager);
        if (Globals.prefs.getBoolean("searchPanelVisible")) {
            this.sidePaneManager.show("search");
        }
    }

    public void openAction(String string) {
        File file = new File(string);
        for (int i = 0; i < this.getTabbedPane().getTabCount(); ++i) {
            BasePanel basePanel = this.baseAt(i);
            if (basePanel.getFile() == null || !basePanel.getFile().equals(file)) continue;
            this.getTabbedPane().setSelectedComponent(basePanel);
            return;
        }
        if (file.exists()) {
            final File file2 = new File(string);
            JabRefExecutorService.INSTANCE.execute(new Runnable(){

                @Override
                public void run() {
                    JabRefFrame.this.open.openIt(file2, true);
                }
            });
        }
    }

    public void about() {
        JDialog jDialog = new JDialog(this, Globals.lang("About JabRef"), true);
        JEditorPane jEditorPane = new JEditorPane();
        JScrollPane jScrollPane = new JScrollPane(jEditorPane, 20, 31);
        jEditorPane.setEditable(false);
        try {
            jEditorPane.setPage(GUIGlobals.class.getResource("/help/About.html"));
            jEditorPane.addHyperlinkListener(new HyperlinkListener(){

                @Override
                public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
                    if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                        try {
                            ((JEditorPane)hyperlinkEvent.getSource()).setPage(hyperlinkEvent.getURL());
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            });
            jDialog.getContentPane().add(jScrollPane);
            jDialog.setSize(GUIGlobals.aboutSize);
            Util.placeDialog(jDialog, this);
            jDialog.setVisible(true);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            JOptionPane.showMessageDialog(this, "Could not load file 'About.html'", "Error", 0);
        }
    }

    public void preferences() {
        AbstractWorker abstractWorker = new AbstractWorker(){

            @Override
            public void run() {
                JabRefFrame.this.output(Globals.lang("Opening preferences..."));
                if (JabRefFrame.this.prefsDialog == null) {
                    JabRefFrame.this.prefsDialog = new PrefsDialog3(JabRefFrame.this, JabRefFrame.this.jabRef);
                    Util.placeDialog(JabRefFrame.this.prefsDialog, JabRefFrame.this);
                } else {
                    JabRefFrame.this.prefsDialog.setValues();
                }
            }

            @Override
            public void update() {
                JabRefFrame.this.prefsDialog.setVisible(true);
                JabRefFrame.this.output("");
            }
        };
        abstractWorker.getWorker().run();
        abstractWorker.getCallBack().update();
    }

    public JabRefPreferences prefs() {
        return this.prefs;
    }

    private void tearDownJabRef(Vector<String> vector) {
        JabRefExecutorService.INSTANCE.shutdownEverything();
        this.dispose();
        if (this.basePanel() != null) {
            this.basePanel().saveDividerLocation();
        }
        this.prefs.putInt("posX", this.getLocation().x);
        this.prefs.putInt("posY", this.getLocation().y);
        this.prefs.putInt("sizeX", this.getSize().width);
        this.prefs.putInt("sizeY", this.getSize().height);
        this.prefs.putBoolean("windowMaximised", this.getExtendedState() == 6);
        this.prefs.putBoolean("toolbarVisible", this.tlb.isVisible());
        this.prefs.putBoolean("searchPanelVisible", this.sidePaneManager.isComponentVisible("search"));
        int n = this.contentPane.getDividerLocation();
        if (n > 0) {
            this.prefs.putInt("sidePaneWidth", n);
        }
        if (this.prefs.getBoolean("openLastEdited")) {
            if (vector.isEmpty()) {
                this.prefs.remove("lastEdited");
            } else {
                Object[] objectArray = new String[vector.size()];
                for (int i = 0; i < vector.size(); ++i) {
                    objectArray[i] = vector.elementAt(i);
                }
                this.prefs.putStringArray("lastEdited", (String[])objectArray);
            }
        }
        this.fileHistory.storeHistory();
        this.prefs.customExports.store();
        this.prefs.customImports.store();
        BibtexEntryType.saveCustomEntryTypes(this.prefs);
        if (Globals.autoSaveManager != null) {
            Globals.autoSaveManager.clearAutoSaves();
        }
        if (this.basePanel() != null) {
            this.searchManager.updatePrefs();
        }
        this.prefs.flush();
        if (this.sysTray != null) {
            this.sysTray.hide();
        }
        for (Window window : Window.getWindows()) {
            window.dispose();
        }
        if (Globals.autoSaveManager != null) {
            Globals.stopAutoSaveManager();
        }
    }

    public boolean quit() {
        int n;
        boolean bl = true;
        Vector<String> vector = new Vector<String>();
        if (this.tabbedPane.getTabCount() > 0) {
            for (n = 0; n < this.tabbedPane.getTabCount(); ++n) {
                block9: {
                    if (this.baseAt(n).isBaseChanged()) {
                        this.tabbedPane.setSelectedIndex(n);
                        int n2 = JOptionPane.showConfirmDialog(this, Globals.lang("Database has changed. Do you want to save before closing?"), Globals.lang("Save before closing"), 1);
                        if (n2 == 2 || n2 == -1) {
                            return false;
                        }
                        if (n2 == 0) {
                            try {
                                SaveDatabaseAction saveDatabaseAction = new SaveDatabaseAction(this.basePanel());
                                saveDatabaseAction.runCommand();
                                if (!saveDatabaseAction.isCancelled() && saveDatabaseAction.isSuccess()) break block9;
                                this.output(Globals.lang("Unable to save database"));
                                bl = false;
                            }
                            catch (Throwable throwable) {
                                bl = false;
                                break;
                            }
                        }
                    }
                }
                if (this.baseAt(n).getFile() == null) continue;
                vector.add(this.baseAt(n).getFile().getAbsolutePath());
            }
        }
        if (bl) {
            for (n = 0; n < this.tabbedPane.getTabCount(); ++n) {
                if (!this.baseAt(n).isSaving()) continue;
                WaitForSaveOperation waitForSaveOperation = new WaitForSaveOperation(this);
                waitForSaveOperation.show();
                if (!waitForSaveOperation.cancelled()) continue;
                return false;
            }
            this.tearDownJabRef(vector);
            return true;
        }
        return false;
    }

    private void initLayout() {
        this.tabbedPane.putClientProperty("jgoodies.noContentBorder", Boolean.TRUE);
        this.setProgressBarVisible(false);
        this.pushExternalButton = new PushToApplicationButton(this, PushToApplicationButton.applications);
        this.fillMenu();
        this.createToolBar();
        this.getContentPane().setLayout(this.gbl);
        this.contentPane.setDividerSize(2);
        this.contentPane.setBorder(null);
        this.con.fill = 2;
        this.con.anchor = 17;
        this.con.weightx = 1.0;
        this.con.weighty = 0.0;
        this.con.gridwidth = 0;
        this.setJMenuBar(this.mb);
        this.con.anchor = 11;
        this.gbl.setConstraints(this.tlb, this.con);
        this.getContentPane().add(this.tlb);
        Component component = Box.createGlue();
        this.gbl.setConstraints(component, this.con);
        this.con.gridwidth = 0;
        this.con.weightx = 1.0;
        this.con.weighty = 0.0;
        this.con.fill = 1;
        this.con.anchor = 17;
        this.con.insets = new Insets(0, 0, 0, 0);
        component = Box.createGlue();
        this.gbl.setConstraints(component, this.con);
        this.getContentPane().add(component);
        this.con.weighty = 1.0;
        this.gbl.setConstraints(this.contentPane, this.con);
        this.getContentPane().add(this.contentPane);
        this.contentPane.setRightComponent(this.tabbedPane);
        this.contentPane.setLeftComponent(this.sidePaneManager.getPanel());
        this.sidePaneManager.updateView();
        JPanel jPanel = new JPanel();
        jPanel.setLayout(this.gbl);
        this.con.weighty = 0.0;
        this.con.weightx = 0.0;
        this.con.gridwidth = 1;
        this.con.insets = new Insets(0, 2, 0, 0);
        this.gbl.setConstraints(this.statusLabel, this.con);
        jPanel.add(this.statusLabel);
        this.con.weightx = 1.0;
        this.con.insets = new Insets(0, 4, 0, 0);
        this.con.gridwidth = 1;
        this.gbl.setConstraints(this.statusLine, this.con);
        jPanel.add(this.statusLine);
        this.con.weightx = 0.0;
        this.con.gridwidth = 0;
        this.con.insets = new Insets(2, 4, 2, 2);
        this.gbl.setConstraints(this.progressBar, this.con);
        jPanel.add(this.progressBar);
        this.con.weightx = 1.0;
        this.con.gridwidth = 0;
        this.statusLabel.setForeground(GUIGlobals.entryEditorLabelColor.darker());
        this.con.insets = new Insets(0, 0, 0, 0);
        this.gbl.setConstraints(jPanel, this.con);
        this.getContentPane().add(jPanel);
        EntryTableTransferHandler entryTableTransferHandler = new EntryTableTransferHandler(null, this, null);
        this.tabbedPane.setTransferHandler(entryTableTransferHandler);
        this.tlb.setTransferHandler(entryTableTransferHandler);
        this.mb.setTransferHandler(entryTableTransferHandler);
        this.sidePaneManager.getPanel().setTransferHandler(entryTableTransferHandler);
    }

    public BasePanel baseAt(int n) {
        return (BasePanel)this.tabbedPane.getComponentAt(n);
    }

    public void showBaseAt(int n) {
        this.tabbedPane.setSelectedIndex(n);
    }

    public void showBasePanel(BasePanel basePanel) {
        this.tabbedPane.setSelectedComponent(basePanel);
    }

    public BasePanel basePanel() {
        return (BasePanel)this.tabbedPane.getSelectedComponent();
    }

    public int baseCount() {
        return this.tabbedPane.getComponentCount();
    }

    private void markActiveBasePanel() {
        int n = this.tabbedPane.getSelectedIndex();
        int n2 = this.tabbedPane.getTabCount();
        if (this.lastTabbedPanelSelectionIndex > -1 && this.lastTabbedPanelSelectionIndex < n2) {
            this.tabbedPane.setForegroundAt(this.lastTabbedPanelSelectionIndex, GUIGlobals.inActiveTabbed);
        }
        if (n > -1 && n < n2) {
            this.tabbedPane.setForegroundAt(n, GUIGlobals.activeTabbed);
        }
        this.lastTabbedPanelSelectionIndex = n;
    }

    private int getTabIndex(JComponent jComponent) {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            if (this.tabbedPane.getComponentAt(i) != jComponent) continue;
            return i;
        }
        return -1;
    }

    public JTabbedPane getTabbedPane() {
        return this.tabbedPane;
    }

    public String getTabTitle(JComponent jComponent) {
        return this.tabbedPane.getTitleAt(this.getTabIndex(jComponent));
    }

    public String getTabTooltip(JComponent jComponent) {
        return this.tabbedPane.getToolTipTextAt(this.getTabIndex(jComponent));
    }

    public void setTabTitle(JComponent jComponent, String string, String string2) {
        int n = this.getTabIndex(jComponent);
        this.tabbedPane.setTitleAt(n, string);
        this.tabbedPane.setToolTipTextAt(n, string2);
    }

    public void setUpImportMenus() {
        this.setUpImportMenu(this.importMenu, false);
        this.setUpImportMenu(this.importNewMenu, true);
    }

    private void fillMenu() {
        this.mb.setBorder(null);
        JMenu jMenu = JabRefFrame.subMenu("File");
        JMenu jMenu2 = JabRefFrame.subMenu("Sessions");
        JMenu jMenu3 = JabRefFrame.subMenu("Edit");
        JMenu jMenu4 = JabRefFrame.subMenu("Search");
        JMenu jMenu5 = JabRefFrame.subMenu("BibTeX");
        JMenu jMenu6 = JabRefFrame.subMenu("View");
        JMenu jMenu7 = JabRefFrame.subMenu("Tools");
        JMenu jMenu8 = JabRefFrame.subMenu("Options");
        JMenu jMenu9 = JabRefFrame.subMenu("New entry...");
        JMenu jMenu10 = JabRefFrame.subMenu("Help");
        this.setUpImportMenus();
        this.newDatabaseMenu.add(this.newDatabaseAction);
        this.newDatabaseMenu.add(this.newSubDatabaseAction);
        jMenu.add(this.newDatabaseAction);
        jMenu.add(this.open);
        jMenu.add(this.mergeDatabaseAction);
        jMenu.add(this.save);
        jMenu.add(this.saveAs);
        jMenu.add(this.saveAll);
        jMenu.add(this.saveSelectedAs);
        jMenu.add(this.saveSelectedAsPlain);
        jMenu.addSeparator();
        jMenu.add(this.importNew);
        jMenu.add(this.importCurrent);
        jMenu.add(this.exportAll);
        jMenu.add(this.exportSelected);
        jMenu.add(this.dbConnect);
        jMenu.add(this.dbImport);
        jMenu.add(this.dbExport);
        jMenu.addSeparator();
        jMenu.add(this.databaseProperties);
        jMenu.addSeparator();
        jMenu2.add(this.loadSessionAction);
        jMenu2.add(this.saveSessionAction);
        jMenu.add(jMenu2);
        jMenu.add(this.fileHistory);
        jMenu.addSeparator();
        jMenu.add(this.close);
        jMenu.add(new MinimizeToSysTrayAction());
        jMenu.add(this.quit);
        this.mb.add(jMenu);
        jMenu3.add(this.undo);
        jMenu3.add(this.redo);
        jMenu3.addSeparator();
        jMenu3.add(this.cut);
        jMenu3.add(this.copy);
        jMenu3.add(this.paste);
        jMenu3.add(this.delete);
        jMenu3.add(this.copyKey);
        jMenu3.add(this.copyCiteKey);
        jMenu3.add(this.copyKeyAndTitle);
        jMenu3.addSeparator();
        jMenu3.add(this.mark);
        JMenu jMenu11 = JabRefFrame.subMenu("Mark specific color");
        for (int i = 0; i < 5; ++i) {
            jMenu11.add(new MarkEntriesAction(this, i).getMenuItem());
        }
        jMenu3.add(jMenu11);
        jMenu3.add(this.unmark);
        jMenu3.add(this.unmarkAll);
        jMenu3.addSeparator();
        if (Globals.prefs.getBoolean("specialFieldsEnabled")) {
            if (Globals.prefs.getBoolean("showRankingColumn")) {
                JMenu jMenu12 = new JMenu();
                RightClickMenu.populateSpecialFieldMenu(jMenu12, Rank.getInstance(), this);
                jMenu3.add(jMenu12);
            }
            if (Globals.prefs.getBoolean("showRelevanceColumn")) {
                jMenu3.add(this.toggleRelevance);
            }
            if (Globals.prefs.getBoolean("showQualityColumn")) {
                jMenu3.add(this.toggleQualityAssured);
            }
            if (Globals.prefs.getBoolean("showPriorityColumn")) {
                JMenu jMenu13 = new JMenu();
                RightClickMenu.populateSpecialFieldMenu(jMenu13, Priority.getInstance(), this);
                jMenu3.add(jMenu13);
            }
            if (Globals.prefs.getBoolean("showPrintedColumn")) {
                jMenu3.add(this.togglePrinted);
            }
            if (Globals.prefs.getBoolean("showReadColumn")) {
                JMenu jMenu14 = new JMenu();
                RightClickMenu.populateSpecialFieldMenu(jMenu14, ReadStatus.getInstance(), this);
                jMenu3.add(jMenu14);
            }
        }
        jMenu3.addSeparator();
        jMenu3.add(this.manageKeywords);
        jMenu3.add(this.selectAll);
        this.mb.add(jMenu3);
        jMenu4.add(this.normalSearch);
        jMenu4.add(this.incrementalSearch);
        jMenu4.add(this.replaceAll);
        jMenu4.add(this.massSetField);
        jMenu4.addSeparator();
        jMenu4.add(this.dupliCheck);
        jMenu4.add(this.resolveDuplicateKeys);
        jMenu4.add(this.autoSetFile);
        jMenu4.addSeparator();
        GeneralFetcher generalFetcher = new GeneralFetcher(this.sidePaneManager, this, this.fetchers);
        jMenu4.add(generalFetcher.getAction());
        if (this.prefs.getBoolean("webSearchVisible")) {
            this.sidePaneManager.register(generalFetcher.getTitle(), generalFetcher);
            this.sidePaneManager.show(generalFetcher.getTitle());
        }
        this.mb.add(jMenu4);
        jMenu6.add(this.back);
        jMenu6.add(this.forward);
        jMenu6.add(this.focusTable);
        jMenu6.add(this.nextTab);
        jMenu6.add(this.prevTab);
        jMenu6.add(this.sortTabs);
        jMenu6.addSeparator();
        jMenu6.add(this.increaseFontSize);
        jMenu6.add(this.decreseFontSize);
        jMenu6.addSeparator();
        jMenu6.add(this.toggleToolbar);
        jMenu6.add(this.toggleGroups);
        jMenu6.add(this.togglePreview);
        jMenu6.add(this.switchPreview);
        jMenu6.addSeparator();
        jMenu6.add(this.toggleHighlightAny);
        jMenu6.add(this.toggleHighlightAll);
        this.mb.add(jMenu6);
        jMenu5.add(this.newEntryAction);
        for (NewEntryAction newEntryAction : this.newSpecificEntryAction) {
            jMenu9.add(newEntryAction);
        }
        jMenu5.add(jMenu9);
        jMenu5.add(this.plainTextImport);
        jMenu5.addSeparator();
        jMenu5.add(this.editEntry);
        jMenu5.add(this.editPreamble);
        jMenu5.add(this.editStrings);
        this.mb.add(jMenu5);
        jMenu7.add(this.makeKeyAction);
        jMenu7.add(this.Cleanup);
        jMenu7.add(this.mergeEntries);
        jMenu7.add(this.newSubDatabaseAction);
        jMenu7.add(this.writeXmpAction);
        OpenOfficePanel openOfficePanel = OpenOfficePanel.getInstance();
        openOfficePanel.init(this, this.sidePaneManager);
        jMenu7.add(openOfficePanel.getMenuItem());
        jMenu7.add(this.pushExternalButton.getMenuAction());
        jMenu7.addSeparator();
        jMenu7.add(this.manageSelectors);
        jMenu7.addSeparator();
        jMenu7.add(this.openFolder);
        jMenu7.add(this.openFile);
        jMenu7.add(this.openPdf);
        jMenu7.add(this.openUrl);
        jMenu7.add(this.findUnlinkedFiles);
        jMenu7.add(this.autoLinkFile);
        jMenu7.addSeparator();
        jMenu7.add(this.abbreviateIso);
        jMenu7.add(this.abbreviateMedline);
        jMenu7.add(this.unabbreviate);
        jMenu7.addSeparator();
        this.checkAndFix.add(this.autoSetPdf);
        this.checkAndFix.add(this.autoSetPs);
        this.checkAndFix.add(this.integrityCheckAction);
        jMenu7.add(this.checkAndFix);
        this.mb.add(jMenu7);
        jMenu8.add(this.showPrefs);
        CustomizeEntryTypeAction customizeEntryTypeAction = new CustomizeEntryTypeAction();
        GenFieldsCustomizationAction genFieldsCustomizationAction = new GenFieldsCustomizationAction();
        jMenu8.add(customizeEntryTypeAction);
        jMenu8.add(genFieldsCustomizationAction);
        jMenu8.add(this.customExpAction);
        jMenu8.add(this.customImpAction);
        jMenu8.add(this.customFileTypesAction);
        jMenu8.add(this.manageJournals);
        this.pluginMenu.add(this.installPlugin);
        this.mb.add(this.pluginMenu);
        jMenu8.add(this.selectKeys);
        this.mb.add(jMenu8);
        jMenu10.add(this.help);
        jMenu10.add(this.contents);
        jMenu10.addSeparator();
        jMenu10.add(this.errorConsole);
        jMenu10.add(this.forkMeOnGitHubAction);
        jMenu10.addSeparator();
        jMenu10.add(this.about);
        this.mb.add(jMenu10);
    }

    public static JMenu subMenu(String string) {
        JMenu jMenu;
        int n = (string = Globals.menuTitle(string)).indexOf(38);
        if (n >= 0) {
            jMenu = new JMenu(string.substring(0, n) + string.substring(n + 1));
            char c = Character.toUpperCase(string.charAt(n + 1));
            jMenu.setMnemonic((int)c);
        } else {
            jMenu = new JMenu(string);
        }
        return jMenu;
    }

    public void addParserResult(ParserResult parserResult, boolean bl) {
        if (parserResult.toOpenTab()) {
            BasePanel basePanel = this.basePanel();
            if (basePanel == null) {
                this.addTab(parserResult.getDatabase(), parserResult.getFile(), parserResult.getMetaData(), parserResult.getEncoding(), bl);
            } else {
                ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>(parserResult.getDatabase().getEntries());
                this.addImportedEntries(basePanel, arrayList, "", false);
            }
        } else {
            this.addTab(parserResult.getDatabase(), parserResult.getFile(), parserResult.getMetaData(), parserResult.getEncoding(), bl);
        }
    }

    public void addPluginMenuItem(JMenuItem jMenuItem) {
        if (!this.addedToPluginMenu) {
            this.pluginMenu.addSeparator();
            this.addedToPluginMenu = true;
        }
        this.pluginMenu.add(jMenuItem);
    }

    private void createToolBar() {
        this.tlb.putClientProperty("jgoodies.headerStyle", HeaderStyle.BOTH);
        this.tlb.setBorder(null);
        this.tlb.setRollover(true);
        this.tlb.setFloatable(false);
        this.tlb.addAction(this.newDatabaseAction);
        this.tlb.addAction(this.open);
        this.tlb.addAction(this.save);
        this.tlb.addAction(this.saveAll);
        this.tlb.addSeparator();
        this.tlb.addAction(this.cut);
        this.tlb.addAction(this.copy);
        this.tlb.addAction(this.paste);
        this.tlb.addAction(this.undo);
        this.tlb.addAction(this.redo);
        this.tlb.addSeparator();
        this.tlb.addAction(this.back);
        this.tlb.addAction(this.forward);
        this.tlb.addSeparator();
        this.tlb.addAction(this.newEntryAction);
        this.tlb.addAction(this.editEntry);
        this.tlb.addAction(this.editPreamble);
        this.tlb.addAction(this.editStrings);
        this.tlb.addAction(this.makeKeyAction);
        this.tlb.addAction(this.Cleanup);
        this.tlb.addAction(this.mergeEntries);
        this.tlb.addSeparator();
        this.tlb.addAction(this.mark);
        this.tlb.addAction(this.unmark);
        this.tlb.addSeparator();
        if (Globals.prefs.getBoolean("specialFieldsEnabled")) {
            if (Globals.prefs.getBoolean("showRankingColumn")) {
                this.tlb.add(SpecialFieldDropDown.generateSpecialFieldButtonWithDropDown(Rank.getInstance(), this));
            }
            if (Globals.prefs.getBoolean("showRelevanceColumn")) {
                this.tlb.addAction(this.toggleRelevance);
            }
            if (Globals.prefs.getBoolean("showQualityColumn")) {
                this.tlb.addAction(this.toggleQualityAssured);
            }
            if (Globals.prefs.getBoolean("showPriorityColumn")) {
                this.tlb.add(SpecialFieldDropDown.generateSpecialFieldButtonWithDropDown(Priority.getInstance(), this));
            }
            if (Globals.prefs.getBoolean("showPrintedColumn")) {
                this.tlb.addAction(this.togglePrinted);
            }
            if (Globals.prefs.getBoolean("showReadColumn")) {
                this.tlb.add(SpecialFieldDropDown.generateSpecialFieldButtonWithDropDown(ReadStatus.getInstance(), this));
            }
        }
        this.tlb.addSeparator();
        this.searchToggle = new JToggleButton(this.toggleSearch);
        this.searchToggle.setText(null);
        if (!Globals.ON_MAC) {
            this.searchToggle.setMargin(this.marg);
        }
        this.tlb.add(this.searchToggle);
        this.previewToggle = new JToggleButton(this.togglePreview);
        this.previewToggle.setText(null);
        if (!Globals.ON_MAC) {
            this.previewToggle.setMargin(this.marg);
        }
        this.tlb.add(this.previewToggle);
        this.tlb.addSeparator();
        this.groupToggle = new JToggleButton(this.toggleGroups);
        this.groupToggle.setText(null);
        if (!Globals.ON_MAC) {
            this.groupToggle.setMargin(this.marg);
        }
        this.tlb.add(this.groupToggle);
        this.highlightAny = new JToggleButton(this.toggleHighlightAny);
        this.highlightAny.setText(null);
        if (!Globals.ON_MAC) {
            this.highlightAny.setMargin(this.marg);
        }
        this.tlb.add(this.highlightAny);
        this.highlightAll = new JToggleButton(this.toggleHighlightAll);
        this.highlightAll.setText(null);
        if (!Globals.ON_MAC) {
            this.highlightAll.setMargin(this.marg);
        }
        this.tlb.add(this.highlightAll);
        this.tlb.addSeparator();
        this.tlb.add(this.pushExternalButton.getComponent());
        this.tlb.addAction(this.openFolder);
        this.tlb.addAction(this.openFile);
        this.tlb.add(Box.createHorizontalGlue());
        this.tlb.addAction(this.closeDatabaseAction);
    }

    public void output(final String string) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JabRefFrame.this.statusLine.setText(string);
                JabRefFrame.this.statusLine.repaint();
            }
        });
    }

    public void stopShowingSearchResults() {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            this.baseAt(i).stopShowingSearchResults();
        }
    }

    private void initActions() {
        this.openDatabaseOnlyActions = new LinkedList<Object>();
        this.openDatabaseOnlyActions.addAll(Arrays.asList(this.manageSelectors, this.mergeDatabaseAction, this.newSubDatabaseAction, this.close, this.save, this.saveAs, this.saveSelectedAs, this.saveSelectedAsPlain, this.undo, this.redo, this.cut, this.delete, this.copy, this.paste, this.mark, this.unmark, this.unmarkAll, this.editEntry, this.selectAll, this.copyKey, this.copyCiteKey, this.copyKeyAndTitle, this.editPreamble, this.editStrings, this.toggleGroups, this.toggleSearch, this.makeKeyAction, this.normalSearch, this.incrementalSearch, this.replaceAll, this.importMenu, this.exportMenu, this.openPdf, this.openUrl, this.openFolder, this.openFile, this.openSpires, this.togglePreview, this.dupliCheck, this.highlightAll, this.highlightAny, this.newEntryAction, this.plainTextImport, this.massSetField, this.manageKeywords, this.closeDatabaseAction, this.switchPreview, this.integrityCheckAction, this.autoSetPdf, this.autoSetPs, this.toggleHighlightAny, this.toggleHighlightAll, this.databaseProperties, this.abbreviateIso, this.abbreviateMedline, this.unabbreviate, this.exportAll, this.exportSelected, this.importCurrent, this.saveAll, this.dbConnect, this.dbExport, this.focusTable));
        this.openDatabaseOnlyActions.addAll(this.fetcherActions);
        this.openDatabaseOnlyActions.addAll(Arrays.asList(this.newSpecificEntryAction));
        this.severalDatabasesOnlyActions = new LinkedList<Object>();
        this.severalDatabasesOnlyActions.addAll(Arrays.asList(this.nextTab, this.prevTab, this.sortTabs));
        this.tabbedPane.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                JabRefFrame.this.updateEnabledState();
            }
        });
    }

    private static void setEnabled(List<Object> list, boolean bl) {
        for (Object object : list) {
            if (object instanceof Action) {
                ((Action)object).setEnabled(bl);
            }
            if (!(object instanceof Component)) continue;
            ((Component)object).setEnabled(bl);
        }
    }

    private void updateEnabledState() {
        int n = this.tabbedPane.getTabCount();
        if (n != this.previousTabCount) {
            this.previousTabCount = n;
            JabRefFrame.setEnabled(this.openDatabaseOnlyActions, n > 0);
            JabRefFrame.setEnabled(this.severalDatabasesOnlyActions, n > 1);
        }
        if (n == 0) {
            this.back.setEnabled(false);
            this.forward.setEnabled(false);
        }
    }

    public void setupAllTables() {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            BasePanel basePanel = this.baseAt(i);
            if (basePanel.database == null) continue;
            basePanel.setupMainPanel();
        }
    }

    public BasePanel addTab(BibtexDatabase bibtexDatabase, File file, MetaData metaData, String string, boolean bl) {
        if (metaData == null) {
            metaData = new MetaData();
        }
        if (string == null) {
            string = Globals.prefs.get("defaultEncoding");
        }
        BasePanel basePanel = new BasePanel(this, bibtexDatabase, file, metaData, string);
        this.addTab(basePanel, file, bl);
        return basePanel;
    }

    public void addTab(BasePanel basePanel, File file, boolean bl) {
        String string;
        if (file == null) {
            string = Globals.lang("untitled");
            if (!basePanel.database().getEntries().isEmpty()) {
                string = string + '*';
            }
        } else {
            string = file.getName();
        }
        this.tabbedPane.add(string, basePanel);
        this.tabbedPane.setToolTipTextAt(this.tabbedPane.getTabCount() - 1, file != null ? file.getAbsolutePath() : null);
        if (bl) {
            this.tabbedPane.setSelectedComponent(basePanel);
        }
    }

    public void closeCurrentTab() {
        this.closeDatabaseAction.actionPerformed(null);
    }

    public void closeCurrentTabNoWarning() {
        this.closeDatabaseAction.close();
    }

    private void addImportedEntries(final BasePanel basePanel, final List<BibtexEntry> list, String string, final boolean bl) {
        if (Globals.prefs.getBoolean("useImportInspectionDialog") && (Globals.prefs.getBoolean("useImportInspectionDialogForSingle") || list.size() > 1)) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    ImportInspectionDialog importInspectionDialog = new ImportInspectionDialog(JabRefFrame.this, basePanel, BibtexFields.DEFAULT_INSPECTION_FIELDS, Globals.lang("Import"), bl);
                    importInspectionDialog.addEntries(list);
                    importInspectionDialog.entryListComplete();
                    Util.placeDialog(importInspectionDialog, JabRefFrame.this);
                    importInspectionDialog.setVisible(true);
                    importInspectionDialog.toFront();
                }
            });
        } else {
            this.addBibEntries(list, string, bl);
            if (basePanel != null && list.size() == 1) {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        basePanel.highlightEntry((BibtexEntry)list.get(0));
                    }
                });
            }
        }
    }

    private int addBibEntries(List<BibtexEntry> list, String string, boolean bl) {
        if (list == null || list.isEmpty()) {
            JOptionPane.showMessageDialog(this, Globals.lang("No entries found. Please make sure you are using the correct import filter."), Globals.lang("Import failed"), 0);
            return 0;
        }
        int n = 0;
        Util.setAutomaticFields(list, Globals.prefs.getBoolean("overwriteOwner"), Globals.prefs.getBoolean("overwriteTimeStamp"), Globals.prefs.getBoolean("markImportedEntries"));
        if (bl || this.tabbedPane.getTabCount() == 0) {
            BibtexDatabase bibtexDatabase = new BibtexDatabase();
            for (BibtexEntry bibtexEntry : list) {
                try {
                    bibtexEntry.setId(IdGenerator.next());
                    bibtexDatabase.insertEntry(bibtexEntry);
                }
                catch (KeyCollisionException keyCollisionException) {
                    System.err.println("KeyCollisionException [ addBibEntries(...) ]");
                }
            }
            BasePanel basePanel = new BasePanel(this, bibtexDatabase, null, new MetaData(), Globals.prefs.get("defaultEncoding"));
            n = bibtexDatabase.getEntryCount();
            this.tabbedPane.add("untitled", basePanel);
            basePanel.markBaseChanged();
            this.tabbedPane.setSelectedComponent(basePanel);
            if (string != null) {
                this.output(Globals.lang("Imported database") + " '" + string + "' " + Globals.lang("with") + ' ' + bibtexDatabase.getEntryCount() + ' ' + Globals.lang("entries into new database") + '.');
            }
        } else {
            BasePanel basePanel = this.basePanel();
            BibtexDatabase bibtexDatabase = basePanel.database;
            int n2 = bibtexDatabase.getEntryCount();
            NamedCompound namedCompound = new NamedCompound(Globals.lang("Import entries"));
            block5: for (BibtexEntry bibtexEntry : list) {
                boolean bl2 = false;
                for (String string2 : bibtexDatabase.getKeySet()) {
                    BibtexEntry bibtexEntry2 = bibtexDatabase.getEntryById(string2);
                    if (!DuplicateCheck.isDuplicate(bibtexEntry, bibtexEntry2)) continue;
                    DuplicateResolverDialog duplicateResolverDialog = new DuplicateResolverDialog(this, bibtexEntry2, bibtexEntry, 2);
                    duplicateResolverDialog.setVisible(true);
                    int n3 = duplicateResolverDialog.getSelected();
                    if (n3 == 2) {
                        bl2 = true;
                        break;
                    }
                    if (n3 == 1) {
                        bibtexDatabase.removeEntry(bibtexEntry2.getId());
                        namedCompound.addEdit(new UndoableRemoveEntry(bibtexDatabase, bibtexEntry2, basePanel));
                        break;
                    }
                    if (n3 == 5) break block5;
                }
                if (bl2) continue;
                try {
                    bibtexEntry.setId(IdGenerator.next());
                    bibtexDatabase.insertEntry(bibtexEntry);
                    namedCompound.addEdit(new UndoableInsertEntry(bibtexDatabase, bibtexEntry, basePanel));
                    ++n;
                }
                catch (KeyCollisionException keyCollisionException) {
                    System.err.println("KeyCollisionException [ addBibEntries(...) ]");
                }
            }
            if (n > 0) {
                namedCompound.end();
                basePanel.undoManager.addEdit(namedCompound);
                basePanel.markBaseChanged();
                if (string != null) {
                    this.output(Globals.lang("Imported database") + " '" + string + "' " + Globals.lang("with") + ' ' + (bibtexDatabase.getEntryCount() - n2) + ' ' + Globals.lang("entries into new database") + '.');
                }
            }
        }
        return n;
    }

    private void setUpImportMenu(JMenu jMenu, boolean bl) {
        jMenu.removeAll();
        jMenu.add(new ImportMenuItem(this, bl));
        jMenu.addSeparator();
        SortedSet<ImportFormat> sortedSet = Globals.importFormatReader.getCustomImportFormats();
        JMenu jMenu2 = new JMenu(Globals.lang("Custom importers"));
        jMenu2.setMnemonic(83);
        for (ImportFormat importFormat : sortedSet) {
            jMenu2.add(new ImportMenuItem(this, bl, importFormat));
        }
        if (!sortedSet.isEmpty()) {
            jMenu2.addSeparator();
        }
        jMenu2.add(this.customImpAction);
        jMenu.add(jMenu2);
        jMenu.addSeparator();
        for (ImportFormat importFormat : Globals.importFormatReader.getBuiltInInputFormats()) {
            jMenu.add(new ImportMenuItem(this, bl, importFormat));
        }
    }

    public FileHistory getFileHistory() {
        return this.fileHistory;
    }

    public void setPreviewActive(boolean bl) {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            this.baseAt(i).setPreviewActive(bl);
        }
    }

    public void removeCachedEntryEditors() {
        for (int i = 0; i < this.tabbedPane.getTabCount(); ++i) {
            BasePanel basePanel = (BasePanel)this.tabbedPane.getComponentAt(i);
            basePanel.entryEditors.clear();
        }
    }

    public void block() {
        this.getGlassPane().setVisible(true);
    }

    public void unblock() {
        this.getGlassPane().setVisible(false);
    }

    public void setProgressBarVisible(final boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.progressBar.setVisible(bl);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JabRefFrame.this.progressBar.setVisible(bl);
                }
            });
        }
    }

    public void setProgressBarValue(final int n) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.progressBar.setValue(n);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JabRefFrame.this.progressBar.setValue(n);
                }
            });
        }
    }

    public void setProgressBarIndeterminate(final boolean bl) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.progressBar.setIndeterminate(bl);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JabRefFrame.this.progressBar.setIndeterminate(bl);
                }
            });
        }
    }

    public void setProgressBarMaximum(final int n) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.progressBar.setMaximum(n);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JabRefFrame.this.progressBar.setMaximum(n);
                }
            });
        }
    }

    public void showIfMinimizedToSysTray() {
        if (!this.isVisible()) {
            if (this.sysTray != null) {
                this.sysTray.hide();
            }
            this.setVisible(true);
            this.isActive();
            this.toFront();
        }
    }

    @Override
    public void showMessage(Object object, String string, int n) {
        JOptionPane.showMessageDialog(this, object, string, n);
    }

    @Override
    public void setStatus(String string) {
        this.output(string);
    }

    @Override
    public void showMessage(String string) {
        JOptionPane.showMessageDialog(this, string);
    }

    public SearchManager2 getSearchManager() {
        return this.searchManager;
    }

    private static class MyGlassPane
    extends JPanel {
        public MyGlassPane() {
            this.addKeyListener(new KeyAdapter(){});
            this.addMouseListener(new MouseAdapter(){});
            super.setCursor(Cursor.getPredefinedCursor(3));
        }

        @Override
        public boolean isOpaque() {
            return false;
        }
    }

    class MinimizeToSysTrayAction
    extends MnemonicAwareAction {
        public MinimizeToSysTrayAction() {
            this.putValue("Name", "Minimize to system tray");
            this.putValue("AcceleratorKey", Globals.prefs.getKey("Minimize to system tray"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (JabRefFrame.this.sysTray == null) {
                JabRefFrame.this.sysTray = new SysTray(JabRefFrame.this);
            }
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    JabRefFrame.this.sysTray.show();
                    JabRefFrame.this.setVisible(false);
                }
            });
        }
    }

    class DecreaseTableFontSizeAction
    extends MnemonicAwareAction {
        public DecreaseTableFontSizeAction() {
            this.putValue("Name", "Decrease table font size");
            this.putValue("AcceleratorKey", Globals.prefs.getKey("Decrease table font size"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = GUIGlobals.CURRENTFONT.getSize();
            if (n < 2) {
                return;
            }
            GUIGlobals.CURRENTFONT = new Font(GUIGlobals.CURRENTFONT.getFamily(), GUIGlobals.CURRENTFONT.getStyle(), n - 1);
            Globals.prefs.putInt("fontSize", n - 1);
            for (int i = 0; i < JabRefFrame.this.baseCount(); ++i) {
                JabRefFrame.this.baseAt(i).updateTableFont();
            }
        }
    }

    class IncreaseTableFontSizeAction
    extends MnemonicAwareAction {
        public IncreaseTableFontSizeAction() {
            this.putValue("Name", "Increase table font size");
            this.putValue("AcceleratorKey", Globals.prefs.getKey("Increase table font size"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n = GUIGlobals.CURRENTFONT.getSize();
            GUIGlobals.CURRENTFONT = new Font(GUIGlobals.CURRENTFONT.getFamily(), GUIGlobals.CURRENTFONT.getStyle(), n + 1);
            Globals.prefs.putInt("fontSize", n + 1);
            for (int i = 0; i < JabRefFrame.this.baseCount(); ++i) {
                JabRefFrame.this.baseAt(i).updateTableFont();
            }
        }
    }

    class BibtexKeyPatternAction
    extends MnemonicAwareAction {
        BibtexKeyPatternDialog bibtexKeyPatternDialog = null;

        public BibtexKeyPatternAction() {
            this.putValue("Name", "Bibtex key patterns");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JabRefPreferences.getInstance();
            if (this.bibtexKeyPatternDialog == null) {
                this.bibtexKeyPatternDialog = new BibtexKeyPatternDialog(JabRefFrame.this, JabRefFrame.this.basePanel());
            } else {
                this.bibtexKeyPatternDialog.setPanel(JabRefFrame.this.basePanel());
            }
            Util.placeDialog(this.bibtexKeyPatternDialog, JabRefFrame.this);
            this.bibtexKeyPatternDialog.setVisible(true);
        }
    }

    class DatabasePropertiesAction
    extends MnemonicAwareAction {
        DatabasePropertiesDialog propertiesDialog = null;

        public DatabasePropertiesAction() {
            this.putValue("Name", "Database properties");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (this.propertiesDialog == null) {
                this.propertiesDialog = new DatabasePropertiesDialog(JabRefFrame.this);
            }
            this.propertiesDialog.setPanel(JabRefFrame.this.basePanel());
            Util.placeDialog(this.propertiesDialog, JabRefFrame.this);
            this.propertiesDialog.setVisible(true);
        }
    }

    class GenFieldsCustomizationAction
    extends MnemonicAwareAction {
        public GenFieldsCustomizationAction() {
            this.putValue("Name", "Set up general fields");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GenFieldsCustomizer genFieldsCustomizer = new GenFieldsCustomizer(JabRefFrame.this);
            Util.placeDialog(genFieldsCustomizer, JabRefFrame.this);
            genFieldsCustomizer.setVisible(true);
        }
    }

    class CustomizeEntryTypeAction
    extends MnemonicAwareAction {
        public CustomizeEntryTypeAction() {
            this.putValue("Name", "Customize entry types");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            EntryCustomizationDialog2 entryCustomizationDialog2 = new EntryCustomizationDialog2(JabRefFrame.this);
            Util.placeDialog(entryCustomizationDialog2, JabRefFrame.this);
            entryCustomizationDialog2.setVisible(true);
        }
    }

    class CustomizeImportsAction
    extends MnemonicAwareAction {
        public CustomizeImportsAction() {
            this.putValue("Name", "Manage custom imports");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ImportCustomizationDialog importCustomizationDialog = new ImportCustomizationDialog(JabRefFrame.this);
            importCustomizationDialog.setVisible(true);
        }
    }

    class CustomizeExportsAction
    extends MnemonicAwareAction {
        public CustomizeExportsAction() {
            this.putValue("Name", "Manage custom exports");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            ExportCustomizationDialog exportCustomizationDialog = new ExportCustomizationDialog(JabRefFrame.this);
            exportCustomizationDialog.setVisible(true);
        }
    }

    class EditAction
    extends MnemonicAwareAction {
        private final String command;

        public EditAction(String string, URL uRL) {
            super(new ImageIcon(uRL));
            this.command = string;
            String string2 = StringUtil.nCase(string);
            this.putValue("Name", string2);
            this.putValue("AcceleratorKey", JabRefFrame.this.prefs.getKey(string2));
            this.putValue("ShortDescription", Globals.lang(string2));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JComponent jComponent = Globals.focusListener.getFocused();
            try {
                jComponent.getActionMap().get(this.command).actionPerformed(new ActionEvent(jComponent, 0, this.command));
            }
            catch (NullPointerException nullPointerException) {
                // empty catch block
            }
        }
    }

    class ChangeTabAction
    extends MnemonicAwareAction {
        private final boolean next;

        public ChangeTabAction(boolean bl) {
            this.putValue("Name", bl ? "Next tab" : "Previous tab");
            this.next = bl;
            this.putValue("AcceleratorKey", bl ? JabRefFrame.this.prefs.getKey("Next tab") : JabRefFrame.this.prefs.getKey("Previous tab"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            int n2 = JabRefFrame.this.tabbedPane.getSelectedIndex();
            int n3 = n = this.next ? n2 + 1 : n2 - 1;
            if (n < 0) {
                n = JabRefFrame.this.tabbedPane.getTabCount() - 1;
            }
            if (n == JabRefFrame.this.tabbedPane.getTabCount()) {
                n = 0;
            }
            JabRefFrame.this.tabbedPane.setSelectedIndex(n);
        }
    }

    class LoadSessionAction
    extends MnemonicAwareAction {
        volatile boolean running;

        public LoadSessionAction() {
            super(GUIGlobals.getImage("loadSession"));
            this.running = false;
            this.putValue("Name", "Load session");
            this.putValue("AcceleratorKey", JabRefFrame.this.prefs.getKey("Load session"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (JabRefFrame.this.prefs.get("savedSession") == null) {
                JabRefFrame.this.output(Globals.lang("No saved session found."));
                return;
            }
            if (this.running) {
                return;
            }
            this.running = true;
            JabRefFrame.this.output(Globals.lang("Loading session..."));
            JabRefExecutorService.INSTANCE.execute(new Runnable(){

                @Override
                public void run() {
                    int n;
                    HashSet<String> hashSet = new HashSet<String>();
                    if (JabRefFrame.this.tabbedPane.getTabCount() > 0) {
                        for (n = 0; n < JabRefFrame.this.tabbedPane.getTabCount(); ++n) {
                            if (JabRefFrame.this.baseAt(n).getFile() == null) continue;
                            hashSet.add(JabRefFrame.this.baseAt(n).getFile().getPath());
                        }
                    }
                    n = JabRefFrame.this.tabbedPane.getTabCount();
                    String[] stringArray = JabRefFrame.this.prefs.getStringArray("savedSession");
                    for (int i = 0; i < stringArray.length; ++i) {
                        File file;
                        if (hashSet.contains(stringArray[i]) || !(file = new File(stringArray[i])).exists()) continue;
                        JabRefFrame.this.open.openIt(file, i == 0);
                    }
                    JabRefFrame.this.output(Globals.lang("Files opened") + ": " + (JabRefFrame.this.tabbedPane.getTabCount() - n));
                    LoadSessionAction.this.running = false;
                }
            });
        }
    }

    class SaveSessionAction
    extends MnemonicAwareAction {
        public SaveSessionAction() {
            super(GUIGlobals.getImage("save"));
            this.putValue("Name", "Save session");
            this.putValue("AcceleratorKey", JabRefFrame.this.prefs.getKey("Save session"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            Vector<String> vector = new Vector<String>();
            if (JabRefFrame.this.tabbedPane.getTabCount() > 0) {
                for (int i = 0; i < JabRefFrame.this.tabbedPane.getTabCount(); ++i) {
                    if (JabRefFrame.this.tabbedPane.getTitleAt(i).equals("untitled")) {
                        JabRefFrame.this.tabbedPane.setSelectedIndex(i);
                        n = JOptionPane.showConfirmDialog(JabRefFrame.this, Globals.lang("This untitled database must be saved first to be included in the saved session. Save now?"), Globals.lang("Save database"), 0);
                        if (n == 0) {
                            try {
                                JabRefFrame.this.basePanel().runCommand("save");
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                        }
                    }
                    if (JabRefFrame.this.baseAt(i).getFile() == null) continue;
                    vector.add(JabRefFrame.this.baseAt(i).getFile().getPath());
                }
            }
            if (vector.isEmpty()) {
                JabRefFrame.this.output(Globals.lang("Not saved (empty session)") + '.');
            } else {
                String[] stringArray = new String[vector.size()];
                for (n = 0; n < vector.size(); ++n) {
                    stringArray[n] = (String)vector.elementAt(n);
                }
                JabRefFrame.this.prefs.putStringArray("savedSession", stringArray);
                JabRefFrame.this.output(Globals.lang("Saved session") + '.');
            }
        }
    }

    class ShowPrefsAction
    extends MnemonicAwareAction {
        public ShowPrefsAction() {
            super(GUIGlobals.getImage("preferences"));
            this.putValue("Name", "Preferences");
            this.putValue("ShortDescription", Globals.lang("Preferences"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JabRefFrame.this.preferences();
        }
    }

    class IntegrityCheckAction
    extends AbstractAction {
        public IntegrityCheckAction() {
            super(Globals.menuTitle("Integrity check"), GUIGlobals.getImage("integrityCheck"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BasePanel basePanel;
            BibtexDatabase bibtexDatabase;
            Component component = JabRefFrame.this.tabbedPane.getSelectedComponent();
            if (component != null && (bibtexDatabase = (basePanel = (BasePanel)component).getDatabase()) != null) {
                IntegrityWizard integrityWizard = new IntegrityWizard(JabRefFrame.this, JabRefFrame.this.basePanel());
                Util.placeDialog(integrityWizard, JabRefFrame.this);
                integrityWizard.setVisible(true);
            }
        }
    }

    class NewSubDatabaseAction
    extends MnemonicAwareAction {
        public NewSubDatabaseAction() {
            super(GUIGlobals.getImage("new"));
            this.putValue("Name", "New subdatabase based on AUX file");
            this.putValue("ShortDescription", Globals.lang("New BibTeX subdatabase"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            FromAuxDialog fromAuxDialog = new FromAuxDialog(JabRefFrame.this, "", true, JabRefFrame.this.tabbedPane);
            Util.placeDialog(fromAuxDialog, JabRefFrame.this);
            fromAuxDialog.setVisible(true);
            if (fromAuxDialog.generatePressed()) {
                BasePanel basePanel = new BasePanel(JabRefFrame.this, fromAuxDialog.getGenerateDB(), null, new MetaData(), Globals.prefs.get("defaultEncoding"));
                JabRefFrame.this.tabbedPane.add(Globals.lang("untitled"), basePanel);
                JabRefFrame.this.tabbedPane.setSelectedComponent(basePanel);
                JabRefFrame.this.output(Globals.lang("New database created."));
            }
        }
    }

    class NewDatabaseAction
    extends MnemonicAwareAction {
        public NewDatabaseAction() {
            super(GUIGlobals.getImage("new"));
            this.putValue("Name", "New database");
            this.putValue("ShortDescription", Globals.lang("New BibTeX database"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            BibtexDatabase bibtexDatabase = new BibtexDatabase();
            JabRefFrame.this.addTab(bibtexDatabase, null, new MetaData(), Globals.prefs.get("defaultEncoding"), true);
            JabRefFrame.this.output(Globals.lang("New database created."));
        }
    }

    class CloseDatabaseAction
    extends MnemonicAwareAction {
        public CloseDatabaseAction() {
            super(GUIGlobals.getImage("close"));
            this.putValue("Name", "Close database");
            this.putValue("ShortDescription", Globals.lang("Close the current database"));
            this.putValue("AcceleratorKey", JabRefFrame.this.prefs.getKey("Close database"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = true;
            if (JabRefFrame.this.basePanel() == null) {
                return;
            }
            if (JabRefFrame.this.basePanel().isBaseChanged()) {
                int n = JOptionPane.showConfirmDialog(JabRefFrame.this, Globals.lang("Database has changed. Do you want to save before closing?"), Globals.lang("Save before closing"), 1);
                if (n == 2 || n == -1) {
                    bl = false;
                }
                if (n == 0) {
                    try {
                        SaveDatabaseAction saveDatabaseAction = new SaveDatabaseAction(JabRefFrame.this.basePanel());
                        saveDatabaseAction.runCommand();
                        if (saveDatabaseAction.isCancelled() || !saveDatabaseAction.isSuccess()) {
                            bl = false;
                        }
                    }
                    catch (Throwable throwable) {
                        bl = false;
                    }
                }
            }
            if (bl) {
                this.close();
            }
        }

        public void close() {
            BasePanel basePanel = JabRefFrame.this.basePanel();
            basePanel.cleanUp();
            AutoSaveManager.deleteAutoSaveFile(basePanel);
            JabRefFrame.this.tabbedPane.remove(basePanel);
            if (JabRefFrame.this.tabbedPane.getTabCount() > 0) {
                JabRefFrame.this.markActiveBasePanel();
            }
            JabRefFrame.this.setWindowTitle();
            JabRefFrame.this.updateEnabledState();
            JabRefFrame.this.output(Globals.lang("Closed database") + '.');
            System.gc();
        }
    }

    class CloseAction
    extends MnemonicAwareAction {
        public CloseAction() {
            this.putValue("Name", "Quit");
            this.putValue("ShortDescription", Globals.lang("Quit JabRef"));
            this.putValue("AcceleratorKey", JabRefFrame.this.prefs.getKey("Quit JabRef"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            JabRefFrame.this.quit();
        }
    }

    class SelectKeysAction
    extends AbstractAction {
        public SelectKeysAction() {
            super(Globals.lang("Customize key bindings"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            KeyBindingsDialog keyBindingsDialog = new KeyBindingsDialog(new HashMap<String, String>(JabRefFrame.this.prefs.getKeyBindings()), JabRefFrame.this.prefs.getDefaultKeys());
            keyBindingsDialog.setDefaultCloseOperation(2);
            keyBindingsDialog.pack();
            Util.placeDialog(keyBindingsDialog, JabRefFrame.this);
            keyBindingsDialog.setVisible(true);
            if (keyBindingsDialog.getAction()) {
                JabRefFrame.this.prefs.setNewKeyBindings(keyBindingsDialog.getNewKeyBindings());
                JOptionPane.showMessageDialog(JabRefFrame.this, Globals.lang("Your new key bindings have been stored.") + '\n' + Globals.lang("You must restart JabRef for the new key bindings to work properly."), Globals.lang("Key bindings changed"), 1);
            }
        }
    }

    class NewEntryAction
    extends MnemonicAwareAction {
        String type;
        KeyStroke keyStroke;

        public NewEntryAction(KeyStroke keyStroke) {
            super(GUIGlobals.getImage("add"));
            this.type = null;
            this.keyStroke = null;
            this.putValue("Name", "New entry");
            this.putValue("AcceleratorKey", keyStroke);
            this.putValue("ShortDescription", Globals.lang("New BibTeX entry"));
        }

        public NewEntryAction(String string) {
            this.type = null;
            this.keyStroke = null;
            this.putValue("Name", StringUtil.nCase(string));
            this.type = string;
        }

        public NewEntryAction(String string, KeyStroke keyStroke) {
            this.type = null;
            this.keyStroke = null;
            this.putValue("Name", StringUtil.nCase(string));
            this.putValue("AcceleratorKey", keyStroke);
            this.type = string;
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            String string = this.type;
            if (string == null) {
                EntryTypeDialog entryTypeDialog = new EntryTypeDialog(JabRefFrame.this);
                Util.placeDialog(entryTypeDialog, JabRefFrame.this);
                entryTypeDialog.setVisible(true);
                BibtexEntryType bibtexEntryType = entryTypeDialog.getChoice();
                if (bibtexEntryType == null) {
                    return;
                }
                string = bibtexEntryType.getName();
            }
            if (JabRefFrame.this.tabbedPane.getTabCount() > 0) {
                ((BasePanel)JabRefFrame.this.tabbedPane.getSelectedComponent()).newEntry(BibtexEntryType.getType(string));
            } else {
                LOGGER.info("Action 'New entry' must be disabled when no database is open.");
            }
        }
    }

    class GeneralAction
    extends MnemonicAwareAction {
        private final String command;

        public GeneralAction(String string, String string2, String string3, URL uRL) {
            super(new ImageIcon(uRL));
            this.command = string;
            this.putValue("Name", string2);
            this.putValue("ShortDescription", Globals.lang(string3));
        }

        public GeneralAction(String string, String string2, String string3, String string4, KeyStroke keyStroke) {
            super(GUIGlobals.getImage(string4));
            this.command = string;
            this.putValue("Name", string2);
            this.putValue("AcceleratorKey", keyStroke);
            this.putValue("ShortDescription", Globals.lang(string3));
        }

        public GeneralAction(String string, String string2) {
            this.putValue("Name", string2);
            this.command = string;
        }

        public GeneralAction(String string, String string2, KeyStroke keyStroke) {
            this.command = string;
            this.putValue("Name", string2);
            this.putValue("AcceleratorKey", keyStroke);
        }

        public GeneralAction(String string, String string2, String string3) {
            this.command = string;
            ImageIcon imageIcon = GUIGlobals.getImage(string);
            if (imageIcon != null) {
                this.putValue("SmallIcon", imageIcon);
            }
            this.putValue("Name", string2);
            this.putValue("ShortDescription", Globals.lang(string3));
        }

        public GeneralAction(String string, String string2, String string3, KeyStroke keyStroke) {
            this.command = string;
            ImageIcon imageIcon = GUIGlobals.getImage(string);
            if (imageIcon != null) {
                this.putValue("SmallIcon", imageIcon);
            }
            this.putValue("Name", string2);
            this.putValue("ShortDescription", Globals.lang(string3));
            this.putValue("AcceleratorKey", keyStroke);
        }

        public GeneralAction(String string, String string2, String string3, KeyStroke keyStroke, String string4) {
            this.command = string;
            ImageIcon imageIcon = GUIGlobals.getImage(string4);
            if (imageIcon != null) {
                this.putValue("SmallIcon", imageIcon);
            }
            this.putValue("Name", string2);
            this.putValue("ShortDescription", Globals.lang(string3));
            this.putValue("AcceleratorKey", keyStroke);
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (JabRefFrame.this.tabbedPane.getTabCount() > 0) {
                try {
                    ((BasePanel)JabRefFrame.this.tabbedPane.getSelectedComponent()).runCommand(this.command);
                }
                catch (Throwable throwable) {
                    throwable.printStackTrace();
                }
            } else if (actionEvent.getActionCommand().equals("Hide/show toolbar")) {
                JabRefFrame.this.tlb.setVisible(!JabRefFrame.this.tlb.isVisible());
            } else {
                LOGGER.info("Action '" + this.command + "' must be disabled when no database is open.");
            }
        }
    }

    class ToolBar
    extends JToolBar {
        private static final long serialVersionUID = 1L;

        ToolBar() {
        }

        void addAction(Action action) {
            JButton jButton = new JButton(action);
            jButton.setText(null);
            if (!Globals.ON_MAC) {
                jButton.setMargin(JabRefFrame.this.marg);
            }
            this.add(jButton);
        }
    }
}

