/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import net.sf.jabref.Globals;
import net.sf.jabref.util.Util;

class KeyBindingsDialog
extends JDialog {
    private KeystrokeTable table;
    private final JTextField keyTF = new JTextField();
    private final JButton ok;
    private final JButton cancel;
    private final JButton defB;
    private final HashMap<String, String> bindHM;
    private final HashMap<String, String> defBinds;
    private boolean clickedSave = false;

    boolean getAction() {
        return this.clickedSave;
    }

    HashMap<String, String> getNewKeyBindings() {
        return this.bindHM;
    }

    public KeyBindingsDialog(HashMap<String, String> hashMap, HashMap<String, String> hashMap2) {
        this.defBinds = hashMap2;
        this.setTitle(Globals.lang("Key bindings"));
        this.setModal(true);
        this.getContentPane().setLayout(new BorderLayout());
        this.bindHM = hashMap;
        this.setupTable();
        this.setList();
        JScrollPane jScrollPane = new JScrollPane(this.table);
        jScrollPane.setPreferredSize(new Dimension(250, 400));
        this.getContentPane().add((Component)jScrollPane, "Center");
        Box box = new Box(0);
        this.ok = new JButton(Globals.lang("Ok"));
        this.cancel = new JButton(Globals.lang("Cancel"));
        JButton jButton = new JButton(Globals.lang("Grab"));
        this.defB = new JButton(Globals.lang("Default"));
        jButton.addKeyListener(new JBM_CustomKeyBindingsListener());
        box.add(jButton);
        box.add(this.defB);
        box.add(this.ok);
        box.add(this.cancel);
        this.getContentPane().add((Component)box, "South");
        this.setButtons();
        this.keyTF.setEditable(false);
        Util.bindCloseDialogKeyToCancelAction(this.getRootPane(), this.cancel.getAction());
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                KeyBindingsDialog.this.clickedSave = false;
                KeyBindingsDialog.this.dispose();
            }
        });
    }

    private void setupTable() {
        this.table = new KeystrokeTable();
        this.table.setRowSelectionAllowed(true);
        this.table.setColumnSelectionAllowed(false);
        this.table.setSelectionMode(0);
        this.table.setAutoCreateRowSorter(true);
    }

    private void setTop() {
        Box box = new Box(0);
        box.add(new JLabel(Globals.lang("Binding") + ":", 4));
        box.add(this.keyTF);
        this.getContentPane().add((Component)box, "North");
    }

    private void setList() {
        Object object;
        Iterator<String> iterator = this.bindHM.keySet().iterator();
        String[][] stringArray = new String[this.bindHM.size()][3];
        int n = 0;
        while (iterator.hasNext()) {
            stringArray[n][2] = object = iterator.next();
            stringArray[n][1] = this.bindHM.get(object);
            stringArray[n][0] = Globals.lang((String)object);
            ++n;
        }
        object = new TreeMap();
        for (n = 0; n < stringArray.length; ++n) {
            ((TreeMap)object).put(stringArray[n][0], stringArray[n]);
        }
        KeystrokeTableModel keystrokeTableModel = new KeystrokeTableModel((TreeMap<String, String[]>)object);
        this.table.setModel(keystrokeTableModel);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(200);
        tableColumnModel.getColumn(1).setPreferredWidth(80);
    }

    private void setButtons() {
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyBindingsDialog.this.dispose();
                KeyBindingsDialog.this.clickedSave = true;
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                KeyBindingsDialog.this.dispose();
                KeyBindingsDialog.this.clickedSave = false;
            }
        });
        this.defB.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int[] nArray = KeyBindingsDialog.this.table.getSelectedRows();
                if (nArray.length == 0) {
                    int n = JOptionPane.showOptionDialog(KeyBindingsDialog.this, Globals.lang("All key bindings will be reset to their defaults.") + " " + Globals.lang("Continue?"), Globals.lang("Resetting all key bindings"), 0, 3, null, new String[]{Globals.lang("Ok"), Globals.lang("Cancel")}, Globals.lang("Ok"));
                    if (n == 0) {
                        KeyBindingsDialog.this.bindHM.clear();
                        Set set = KeyBindingsDialog.this.defBinds.entrySet();
                        for (Map.Entry entry : set) {
                            KeyBindingsDialog.this.bindHM.put(entry.getKey(), entry.getValue());
                        }
                        KeyBindingsDialog.this.setList();
                    }
                } else {
                    for (int n : nArray) {
                        String string = (String)KeyBindingsDialog.this.table.getValueAt(n, 0);
                        String string2 = KeyBindingsDialog.this.setToDefault(string);
                        KeyBindingsDialog.this.keyTF.setText(string2);
                        KeyBindingsDialog.this.table.setValueAt(string2, n, 1);
                        KeyBindingsDialog.this.table.repaint();
                    }
                }
            }
        });
    }

    private String setToDefault(String string) {
        String string2 = this.defBinds.get(string);
        this.bindHM.put(string, string2);
        return string2;
    }

    private class KeystrokeTableModel
    extends AbstractTableModel {
        final String[][] data;

        public KeystrokeTableModel(TreeMap<String, String[]> treeMap) {
            this.data = new String[treeMap.size()][3];
            Iterator<String> iterator = treeMap.keySet().iterator();
            int n = 0;
            while (iterator.hasNext()) {
                this.data[n++] = treeMap.get(iterator.next());
            }
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        @Override
        public String getColumnName(int n) {
            return n == 0 ? Globals.lang("Action") : Globals.lang("Shortcut");
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        public int getRowCount() {
            return this.data.length;
        }

        @Override
        public Object getValueAt(int n, int n2) {
            return this.data[n][n2];
        }

        @Override
        public void setValueAt(Object object, int n, int n2) {
            this.data[n][n2] = (String)object;
        }
    }

    private class KeystrokeTable
    extends JTable {
        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }

        public String getOriginalName(int n) {
            return ((KeystrokeTableModel)this.getModel()).data[n][2];
        }
    }

    private class MyListSelectionListener
    implements ListSelectionListener {
        private MyListSelectionListener() {
        }

        @Override
        public void valueChanged(ListSelectionEvent listSelectionEvent) {
            if (!listSelectionEvent.getValueIsAdjusting()) {
                Object[] objectArray;
                JList jList = (JList)listSelectionEvent.getSource();
                for (Object object : objectArray = jList.getSelectedValues()) {
                    KeyBindingsDialog.this.keyTF.setText((String)KeyBindingsDialog.this.bindHM.get(object));
                }
            }
        }
    }

    private class JBM_CustomKeyBindingsListener
    extends KeyAdapter {
        private JBM_CustomKeyBindingsListener() {
        }

        @Override
        public void keyPressed(KeyEvent keyEvent) {
            int n;
            int n2 = KeyBindingsDialog.this.table.getSelectedRow();
            if (n2 < 0) {
                return;
            }
            String string = KeyEvent.getKeyText(keyEvent.getKeyCode());
            String string2 = KeyEvent.getKeyModifiersText(keyEvent.getModifiers());
            if (string2.equals("") && ((n = keyEvent.getKeyCode()) < 112 || n > 123) && n != 27 && n != 127) {
                return;
            }
            if (string.equals("Tab") || string.equals("Backspace") || string.equals("Enter") || string.equals("Space") || string.equals("Ctrl") || string.equals("Shift") || string.equals("Alt")) {
                return;
            }
            String string3 = !string2.equals("") ? string2.toLowerCase().replaceAll("\\+", " ") + " " + string : string;
            KeyBindingsDialog.this.keyTF.setText(string3);
            String string4 = KeyBindingsDialog.this.table.getOriginalName(n2);
            KeyBindingsDialog.this.table.setValueAt(string3, n2, 1);
            KeyBindingsDialog.this.table.revalidate();
            KeyBindingsDialog.this.table.repaint();
            KeyBindingsDialog.this.bindHM.put(string4, string3);
        }
    }
}

