/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JMenuItem;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.EntryMarker;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.undo.NamedCompound;

public class MarkEntriesAction
extends AbstractWorker
implements ActionListener {
    private final JabRefFrame frame;
    private final int level;
    private final JMenuItem menuItem;
    private int besLength = 0;

    public MarkEntriesAction(JabRefFrame jabRefFrame, int n) {
        this.frame = jabRefFrame;
        this.level = n;
        this.menuItem = new JMenuItem("               ");
        this.menuItem.setMnemonic(String.valueOf(n + 1).charAt(0));
        this.menuItem.setBackground(Globals.prefs.getColor("markedEntryBackground" + this.level));
        this.menuItem.setOpaque(true);
        this.menuItem.addActionListener(this);
    }

    public JMenuItem getMenuItem() {
        return this.menuItem;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        try {
            this.init();
            this.getWorker().run();
            this.getCallBack().update();
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
    }

    @Override
    public void run() {
        BasePanel basePanel = this.frame.basePanel();
        BibtexEntry[] bibtexEntryArray = basePanel.getSelectedEntries();
        this.besLength = bibtexEntryArray.length;
        if (bibtexEntryArray.length != 0) {
            NamedCompound namedCompound = new NamedCompound(Globals.lang("Mark entries"));
            for (BibtexEntry bibtexEntry : bibtexEntryArray) {
                EntryMarker.markEntry(bibtexEntry, this.level + 1, false, namedCompound);
            }
            namedCompound.end();
            basePanel.undoManager.addEdit(namedCompound);
        }
    }

    @Override
    public void update() {
        String string;
        switch (this.besLength) {
            case 0: {
                string = Globals.lang("No entries selected.");
                break;
            }
            case 1: {
                this.frame.basePanel().markBaseChanged();
                string = Globals.lang("Marked selected entry");
                break;
            }
            default: {
                this.frame.basePanel().markBaseChanged();
                string = Globals.lang("Marked all %0 selected entries", Integer.toString(this.besLength));
            }
        }
        this.frame.output(string);
    }
}

