/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.MetaData;
import net.sf.jabref.gui.FileListEntry;
import net.sf.jabref.gui.FileListTableModel;
import net.sf.jabref.util.FileUtil;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;

class PdfPreviewPanel
extends JPanel {
    private final JLabel picLabel;
    private final MetaData metaData;

    public PdfPreviewPanel(MetaData metaData) {
        this.metaData = metaData;
        this.picLabel = new JLabel();
        this.add(this.picLabel);
    }

    private void renderPDFFile(File file) {
        BufferedImage bufferedImage;
        PDDocument pDDocument;
        FileInputStream fileInputStream;
        try {
            fileInputStream = new FileInputStream(file);
        }
        catch (FileNotFoundException fileNotFoundException) {
            fileNotFoundException.printStackTrace();
            return;
        }
        try {
            pDDocument = PDDocument.load(fileInputStream);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        List list = pDDocument.getDocumentCatalog().getAllPages();
        PDPage pDPage = (PDPage)list.get(0);
        try {
            bufferedImage = pDPage.convertToImage();
        }
        catch (Exception exception) {
            bufferedImage = null;
        }
        if (bufferedImage != null) {
            int n = this.getParent().getWidth();
            int n2 = this.getParent().getHeight();
            BufferedImage bufferedImage2 = this.resizeImage(bufferedImage, n, n2, 1);
            ImageIcon imageIcon = new ImageIcon(bufferedImage2);
            this.picLabel.setText(null);
            this.picLabel.setIcon(imageIcon);
        } else {
            this.clearPreview();
        }
        try {
            pDDocument.close();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    private BufferedImage resizeImage(BufferedImage bufferedImage, int n, int n2, int n3) {
        int n4 = bufferedImage.getHeight();
        int n5 = bufferedImage.getWidth();
        if (n2 == 0 || n == 0) {
            n2 = n4;
            n = n5;
        } else {
            float f = (float)n2 / (float)n4;
            float f2 = (float)n / (float)n5;
            n = f < f2 ? Math.round((float)n5 * f) : Math.round((float)n4 * f2);
        }
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, n3);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage(bufferedImage, 0, 0, n, n2, null);
        return bufferedImage2;
    }

    public void updatePanel(BibtexEntry bibtexEntry) {
        if (bibtexEntry == null) {
            this.clearPreview();
            return;
        }
        this.picLabel.setText("rendering preview...");
        this.picLabel.setIcon(null);
        FileListTableModel fileListTableModel = new FileListTableModel();
        fileListTableModel.setContent(bibtexEntry.getField("file"));
        FileListEntry fileListEntry = null;
        for (int i = 0; i < fileListTableModel.getRowCount() && !(fileListEntry = fileListTableModel.getEntry(i)).getType().getName().toLowerCase().equals("pdf"); ++i) {
        }
        if (fileListEntry != null) {
            File file = FileUtil.expandFilename(this.metaData, fileListEntry.getLink());
            if (file != null) {
                this.renderPDFFile(file);
            } else {
                this.clearPreview();
            }
        } else {
            this.clearPreview();
        }
    }

    private void clearPreview() {
        this.picLabel.setIcon(null);
        this.picLabel.setText(Globals.lang("no preview available"));
    }
}

