/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.AdvancedTab;
import net.sf.jabref.AppearancePrefsTab;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.EntryEditorPrefsTab;
import net.sf.jabref.ExternalTab;
import net.sf.jabref.FileSortTab;
import net.sf.jabref.FileTab;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.GeneralTab;
import net.sf.jabref.Globals;
import net.sf.jabref.ImportSettingsTab;
import net.sf.jabref.JabRef;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.NameFormatterTab;
import net.sf.jabref.NetworkTab;
import net.sf.jabref.PrefsTab;
import net.sf.jabref.PreviewPrefsTab;
import net.sf.jabref.TabLabelPattern;
import net.sf.jabref.TableColumnsTab;
import net.sf.jabref.TablePrefsTab;
import net.sf.jabref.XmpPrefsTab;
import net.sf.jabref.export.ExportFormats;
import net.sf.jabref.groups.GroupsPrefsTab;
import net.sf.jabref.gui.FileDialogs;
import net.sf.jabref.gui.MainTable;
import net.sf.jabref.util.Util;

class PrefsDialog3
extends JDialog {
    private final JPanel main;
    private final JabRefFrame frame;
    private final JabRef jabRef;

    public PrefsDialog3(JabRefFrame jabRefFrame, JabRef jabRef) {
        super(jabRefFrame, Globals.lang("JabRef preferences"), false);
        Object object;
        this.jabRef = jabRef;
        final JabRefPreferences jabRefPreferences = JabRefPreferences.getInstance();
        this.frame = jabRefFrame;
        JButton jButton = new JButton(Globals.lang("Import preferences"));
        JButton jButton2 = new JButton(Globals.lang("Export preferences"));
        this.main = new JPanel();
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        this.getContentPane().setLayout(new BorderLayout());
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)jPanel2, "South");
        final CardLayout cardLayout = new CardLayout();
        this.main.setLayout(cardLayout);
        ArrayList<JPanel> arrayList = new ArrayList<JPanel>();
        arrayList.add(new GeneralTab(this.frame, jabRefPreferences));
        arrayList.add(new NetworkTab(this.frame, jabRefPreferences));
        arrayList.add(new FileTab(this.frame, jabRefPreferences));
        arrayList.add(new FileSortTab(this.frame, jabRefPreferences));
        arrayList.add(new EntryEditorPrefsTab(this.frame, jabRefPreferences));
        arrayList.add(new GroupsPrefsTab(jabRefPreferences));
        arrayList.add(new AppearancePrefsTab(jabRefPreferences));
        arrayList.add(new ExternalTab(this.frame, this, jabRefPreferences, jabRefFrame.helpDiag));
        arrayList.add(new TablePrefsTab(jabRefPreferences, jabRefFrame));
        arrayList.add(new TableColumnsTab(jabRefPreferences, jabRefFrame));
        arrayList.add(new TabLabelPattern(jabRefPreferences, jabRefFrame.helpDiag));
        arrayList.add(new PreviewPrefsTab(jabRefPreferences));
        arrayList.add(new NameFormatterTab(jabRefFrame.helpDiag));
        arrayList.add(new ImportSettingsTab());
        arrayList.add(new XmpPrefsTab());
        arrayList.add(new AdvancedTab(jabRefPreferences, jabRefFrame.helpDiag, jabRef));
        Iterator iterator = arrayList.iterator();
        String[] stringArray = new String[arrayList.size()];
        int n = 0;
        while (iterator.hasNext()) {
            object = (PrefsTab)iterator.next();
            stringArray[n] = object.getTabName();
            ++n;
            this.main.add((Component)object, object.getTabName());
        }
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        final JList<String> jList = new JList<String>(stringArray);
        jList.setBorder(BorderFactory.createEtchedBorder());
        jList.setPrototypeCellValue("This should be wide enough");
        jList.setSelectedIndex(0);
        jList.setSelectionMode(0);
        jList.addListSelectionListener(new ListSelectionListener(){

            @Override
            public void valueChanged(ListSelectionEvent listSelectionEvent) {
                if (listSelectionEvent.getValueIsAdjusting()) {
                    return;
                }
                String string = (String)jList.getSelectedValue();
                cardLayout.show(PrefsDialog3.this.main, string);
            }
        });
        object = new JPanel();
        JPanel jPanel3 = new JPanel();
        ((Container)object).setLayout(new BorderLayout());
        jPanel3.setLayout(new BorderLayout());
        ((Container)object).add(jList, "Center");
        ((Container)object).add((Component)jButton, "South");
        jPanel3.add((Component)object, "Center");
        jPanel3.add((Component)jButton2, "South");
        jPanel.setLayout(new BorderLayout());
        jPanel.add((Component)jPanel3, "West");
        jPanel.add((Component)this.main, "Center");
        JButton jButton3 = new JButton(Globals.lang("Ok"));
        JButton jButton4 = new JButton(Globals.lang("Cancel"));
        jButton3.addActionListener(new OkAction());
        CancelAction cancelAction = new CancelAction();
        jButton4.addActionListener(cancelAction);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder(jPanel2);
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addButton((JComponent)jButton3);
        buttonBarBuilder.addButton((JComponent)jButton4);
        buttonBarBuilder.addGlue();
        Util.bindCloseDialogKeyToCancelAction(this.getRootPane(), cancelAction);
        jButton2.setToolTipText(Globals.lang("Export preferences to file"));
        jButton.setToolTipText(Globals.lang("Import preferences from file"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = FileDialogs.getNewFile(PrefsDialog3.this.frame, new File(System.getProperty("user.home")), ".xml", 1, false);
                if (string == null) {
                    return;
                }
                File file = new File(string);
                if (!file.exists() || JOptionPane.showConfirmDialog(PrefsDialog3.this, '\'' + file.getName() + "' " + Globals.lang("exists. Overwrite file?"), Globals.lang("Export preferences"), 2) == 0) {
                    try {
                        jabRefPreferences.exportPreferences(string);
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(PrefsDialog3.this, Globals.lang("Could not export preferences") + ": " + iOException.getMessage(), Globals.lang("Export preferences"), 0);
                    }
                }
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = FileDialogs.getNewFile(PrefsDialog3.this.frame, new File(System.getProperty("user.home")), ".xml", 0, false);
                if (string == null) {
                    return;
                }
                try {
                    jabRefPreferences.importPreferences(string);
                    PrefsDialog3.this.setValues();
                    BibtexEntryType.loadCustomEntryTypes(jabRefPreferences);
                    ExportFormats.initAllExports();
                    PrefsDialog3.this.frame.removeCachedEntryEditors();
                    Globals.prefs.updateEntryEditorTabList();
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(PrefsDialog3.this, Globals.lang("Could not import preferences") + ": " + iOException.getMessage(), Globals.lang("Import preferences"), 0);
                }
            }
        });
        this.setValues();
        this.pack();
    }

    public void setValues() {
        int n = this.main.getComponentCount();
        Component[] componentArray = this.main.getComponents();
        for (int i = 0; i < n; ++i) {
            ((PrefsTab)((Object)componentArray[i])).setValues();
        }
    }

    class CancelAction
    extends AbstractAction {
        public CancelAction() {
            super("Cancel");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            PrefsDialog3.this.setVisible(false);
        }
    }

    class OkAction
    extends AbstractAction {
        public OkAction() {
            super("Ok");
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            AbstractWorker abstractWorker = new AbstractWorker(){
                boolean ready = true;

                @Override
                public void run() {
                    int n;
                    int n2 = PrefsDialog3.this.main.getComponentCount();
                    Component[] componentArray = PrefsDialog3.this.main.getComponents();
                    for (n = 0; n < n2; ++n) {
                        if (((PrefsTab)((Object)componentArray[n])).readyToClose()) continue;
                        this.ready = false;
                        return;
                    }
                    for (n = 0; n < n2; ++n) {
                        ((PrefsTab)((Object)componentArray[n])).storeSettings();
                    }
                    Globals.prefs.flush();
                }

                @Override
                public void update() {
                    if (!this.ready) {
                        return;
                    }
                    PrefsDialog3.this.setVisible(false);
                    MainTable.updateRenderers();
                    GUIGlobals.updateEntryEditorColors();
                    PrefsDialog3.this.frame.setupAllTables();
                    ((PrefsDialog3)PrefsDialog3.this).frame.groupSelector.revalidateGroups();
                    PrefsDialog3.this.frame.output(Globals.lang("Preferences recorded."));
                }
            };
            abstractWorker.getWorker().run();
            abstractWorker.getCallBack().update();
        }
    }
}

