/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JTextArea;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryType;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.IdGenerator;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.MetaData;
import net.sf.jabref.PrefsTab;
import net.sf.jabref.PreviewPanel;
import net.sf.jabref.help.HelpAction;

public class PreviewPrefsTab
extends JPanel
implements PrefsTab {
    private final JabRefPreferences _prefs;
    JabRefFrame _frame;
    JPanel pan = new JPanel();
    private final JTextArea layout1 = new JTextArea("", 1, 1);
    private final JTextArea layout2 = new JTextArea("", 1, 1);
    JButton help;
    private final JCheckBox pdfPreview = new JCheckBox(Globals.lang("Enable PDF preview"));
    private static BibtexEntry entry;

    public PreviewPrefsTab(JabRefPreferences jabRefPreferences) {
        this._prefs = jabRefPreferences;
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(gridBagLayout);
        this.setLayout(gridBagLayout);
        JLabel jLabel = new JLabel(Globals.lang("Preview") + " 1");
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        JScrollPane jScrollPane = new JScrollPane(this.layout1);
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel.add(jScrollPane);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 17;
        JButton jButton = new JButton(Globals.lang("Test"));
        gridBagLayout.setConstraints(jButton, gridBagConstraints);
        jPanel.add(jButton);
        JButton jButton2 = new JButton(Globals.lang("Default"));
        gridBagLayout.setConstraints(jButton2, gridBagConstraints);
        jPanel.add(jButton2);
        gridBagConstraints.gridwidth = 0;
        JPanel jPanel3 = new JPanel();
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel.add(jPanel3);
        jLabel = new JLabel(Globals.lang("Preview") + " 2");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        JScrollPane jScrollPane2 = new JScrollPane(this.layout2);
        gridBagLayout.setConstraints(jScrollPane2, gridBagConstraints);
        jPanel2.add(jScrollPane2);
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridwidth = 1;
        JButton jButton3 = new JButton(Globals.lang("Test"));
        gridBagLayout.setConstraints(jButton3, gridBagConstraints);
        jPanel2.add(jButton3);
        JButton jButton4 = new JButton(Globals.lang("Default"));
        gridBagLayout.setConstraints(jButton4, gridBagConstraints);
        jPanel2.add(jButton4);
        gridBagConstraints.gridwidth = 1;
        jPanel3 = new JPanel();
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(jPanel3, gridBagConstraints);
        jPanel2.add(jPanel3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.gridwidth = 0;
        jLabel = new JLabel(Globals.lang("Preview") + " 1");
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(jPanel, gridBagConstraints);
        this.add(jPanel);
        jLabel = new JLabel(Globals.lang("Preview") + " 2");
        gridBagConstraints.weighty = 0.0;
        JSeparator jSeparator = new JSeparator(0);
        gridBagLayout.setConstraints(jSeparator, gridBagConstraints);
        this.add(jSeparator);
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        this.add(jLabel);
        gridBagConstraints.weighty = 1.0;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        this.add(jPanel2);
        JPanel jPanel4 = new JPanel(new BorderLayout());
        jPanel4.add((Component)this.pdfPreview, "West");
        HelpAction helpAction = new HelpAction(Globals.helpDiag, "PreviewHelp.html", Globals.lang("Help on Preview Settings"), GUIGlobals.getIconUrl("helpSmall"));
        JButton jButton5 = helpAction.getIconButton();
        jPanel4.add((Component)jButton5, "East");
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(jPanel4, gridBagConstraints);
        this.add(jPanel4);
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = PreviewPrefsTab.this.layout1.getText().replaceAll("\n", "__NEWLINE__");
                PreviewPrefsTab.this._prefs.remove("preview0");
                PreviewPrefsTab.this.layout1.setText(PreviewPrefsTab.this._prefs.get("preview0").replaceAll("__NEWLINE__", "\n"));
                PreviewPrefsTab.this._prefs.put("preview0", string);
            }
        });
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                String string = PreviewPrefsTab.this.layout2.getText().replaceAll("\n", "__NEWLINE__");
                PreviewPrefsTab.this._prefs.remove("preview1");
                PreviewPrefsTab.this.layout2.setText(PreviewPrefsTab.this._prefs.get("preview1").replaceAll("__NEWLINE__", "\n"));
                PreviewPrefsTab.this._prefs.put("preview1", string);
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PreviewPrefsTab.getTestEntry();
                try {
                    PreviewPanel previewPanel = new PreviewPanel(null, entry, null, new MetaData(), PreviewPrefsTab.this.layout1.getText());
                    previewPanel.setPreferredSize(new Dimension(800, 350));
                    JOptionPane.showMessageDialog(null, previewPanel, Globals.lang("Preview"), -1);
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    stringIndexOutOfBoundsException.printStackTrace();
                    JOptionPane.showMessageDialog(null, Globals.lang("Parsing error") + ": " + Globals.lang("illegal backslash expression") + ".\n" + stringIndexOutOfBoundsException.getMessage() + '\n' + Globals.lang("Look at stderr for details") + '.', Globals.lang("Parsing error"), 0);
                }
            }
        });
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                PreviewPrefsTab.getTestEntry();
                try {
                    PreviewPanel previewPanel = new PreviewPanel(null, entry, null, new MetaData(), PreviewPrefsTab.this.layout2.getText());
                    previewPanel.setPreferredSize(new Dimension(800, 350));
                    JOptionPane.showMessageDialog(null, new JScrollPane(previewPanel), Globals.lang("Preview"), -1);
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    stringIndexOutOfBoundsException.printStackTrace();
                    JOptionPane.showMessageDialog(null, "Parsing error: illegal backslash expression.\n" + stringIndexOutOfBoundsException.getMessage() + "\nLook at stderr for details.", "Parsing error", 0);
                }
            }
        });
    }

    private static BibtexEntry getTestEntry() {
        if (entry != null) {
            return entry;
        }
        entry = new BibtexEntry(IdGenerator.next(), BibtexEntryType.getType("article"));
        entry.setField("bibtexkey", "conceicao1997");
        entry.setField("author", "Luis E. C. Conceic{\\~a}o and Terje van der Meeren and Johan A. J. Verreth and M S. Evjen and D. F. Houlihan and H. J. Fyhn");
        entry.setField("title", "Amino acid metabolism and protein turnover in larval turbot (Scophthalmus maximus) fed natural zooplankton or Artemia");
        entry.setField("year", "1997");
        entry.setField("journal", "Marine Biology");
        entry.setField("month", "January");
        entry.setField("number", "2");
        entry.setField("volume", "123");
        entry.setField("pdf", "conceicao1997.pdf");
        entry.setField("pages", "255--265");
        entry.setField("keywords", "energetics, artemia, metabolism, amino acid, turbot");
        entry.setField("url", "http://ejournals.ebsco.com/direct.asp?ArticleID=TYY4NT82XA9H7R8PFPPV");
        entry.setField("abstract", "Abstract The present paper studied the influence of different food regimes on the free amino acid (FAA) pool, the rate of protein turnover, the flux of amino acids, and their relation to growth of larval turbot (Scophthalmus maximus L.) from first feeding until metamorphosis. The amino acid profile of protein was stable during the larval period although some small, but significant, differences were found. Turbot larvae had proteins which were rich in leucine and aspartate, and poor in glutamate, suggesting a high leucine requirement. The profile of the FAA pool was highly variable and quite different from the amino acid profile in protein. The proportion of essential FAA decreased with development. High contents of free tyrosine and phenylalanine were found on Day 3, while free taurine was present at high levels throughout the experimental period. Larval growth rates were positively correlated with taurine levels, suggesting a dietary dependency for taurine and/or sulphur amino acids.\n\nReduced growth rates in Artemia-fed larvae were associated with lower levels of free methionine, indicating that this diet is deficient in methionine for turbot larvae. Leucine might also be limiting turbot growth as the different diet organisms had lower levels of this amino acid in the free pool than was found in the larval protein. A previously presented model was used to describe the flux of amino acids in growing turbot larvae. The FAA pool was found to be small and variable. It was estimated that the daily dietary amino acid intake might be up to ten times the larval FAA pool. In addition, protein synthesis and protein degradation might daily remove and return, respectively, the equivalent of up to 20 and 10 times the size of the FAA pool. In an early phase (Day 11) high growth rates were associated with a relatively low protein turnover, while at a later stage (Day 17), a much higher turnover was observed.");
        return entry;
    }

    @Override
    public void setValues() {
        this.layout1.setText(this._prefs.get("preview0").replaceAll("__NEWLINE__", "\n"));
        this.layout2.setText(this._prefs.get("preview1").replaceAll("__NEWLINE__", "\n"));
        this.pdfPreview.setSelected(this._prefs.getBoolean("pdfPreview"));
    }

    @Override
    public void storeSettings() {
        this._prefs.put("preview0", this.layout1.getText().replaceAll("\n", "__NEWLINE__"));
        this._prefs.put("preview1", this.layout2.getText().replaceAll("\n", "__NEWLINE__"));
        this._prefs.putBoolean("pdfPreview", this.pdfPreview.isSelected());
    }

    @Override
    public boolean readyToClose() {
        return true;
    }

    @Override
    public String getTabName() {
        return Globals.lang("Entry preview");
    }
}

