/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.SwingUtilities;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.IncrementalSearcher;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.SearchTextListener;
import net.sf.jabref.SidePaneComponent;
import net.sf.jabref.SidePaneManager;
import net.sf.jabref.gui.AutoCompleteListener;
import net.sf.jabref.gui.SearchResultsDialog;
import net.sf.jabref.help.HelpAction;
import net.sf.jabref.search.SearchRule;
import net.sf.jabref.search.SearchRules;
import net.sf.jabref.search.matchers.SearchMatcher;
import net.sf.jabref.search.rules.GrammarBasedSearchRule;

public class SearchManager2
extends SidePaneComponent
implements ActionListener,
KeyListener,
ItemListener,
CaretListener {
    private final JabRefFrame frame;
    private final IncrementalSearcher incSearcher;
    private SearchResultsDialog searchDialog = null;
    private AutoCompleteListener autoCompleteListener = null;
    private final Vector<SearchTextListener> listeners = new Vector();
    private final JTextField searchField = new JTextField("", 12);
    private final JPopupMenu settings = new JPopupMenu();
    private final JButton openset = new JButton(Globals.lang("Settings"));
    private final JButton escape = new JButton(Globals.lang("Clear"));
    private final JButton search = new JButton();
    private final JCheckBoxMenuItem searchReq;
    private final JCheckBoxMenuItem searchOpt;
    private final JCheckBoxMenuItem searchGen;
    private final JCheckBoxMenuItem searchAll;
    private final JCheckBoxMenuItem caseSensitive;
    private final JCheckBoxMenuItem regExpSearch;
    private final JCheckBoxMenuItem highLightWords;
    private final JCheckBoxMenuItem searchAutoComplete;
    private final JRadioButton increment;
    private final JRadioButton floatSearch;
    private final JRadioButton hideSearch;
    private final JRadioButton showResultsInDialog;
    private final JRadioButton searchAllBases;
    private final JCheckBoxMenuItem select;
    private boolean incSearch = false;
    private boolean startedFloatSearch = false;
    private boolean startedFilterSearch = false;
    private int incSearchPos = -1;

    public SearchManager2(JabRefFrame jabRefFrame, SidePaneManager sidePaneManager) {
        super(sidePaneManager, GUIGlobals.getIconUrl("search"), Globals.lang("Search"));
        this.frame = jabRefFrame;
        this.incSearcher = new IncrementalSearcher(Globals.prefs);
        this.searchReq = new JCheckBoxMenuItem(Globals.lang("Search required fields"), Globals.prefs.getBoolean("searchReq"));
        this.searchOpt = new JCheckBoxMenuItem(Globals.lang("Search optional fields"), Globals.prefs.getBoolean("searchOpt"));
        this.searchGen = new JCheckBoxMenuItem(Globals.lang("Search general fields"), Globals.prefs.getBoolean("searchGen"));
        this.searchAll = new JCheckBoxMenuItem(Globals.lang("Search all fields"), Globals.prefs.getBoolean("searchAll"));
        this.regExpSearch = new JCheckBoxMenuItem(Globals.lang("Use regular expressions"), Globals.prefs.getBoolean("regExpSearch"));
        this.increment = new JRadioButton(Globals.lang("Incremental"), false);
        this.floatSearch = new JRadioButton(Globals.lang("Float"), true);
        this.hideSearch = new JRadioButton(Globals.lang("Filter"), true);
        this.showResultsInDialog = new JRadioButton(Globals.lang("Show results in dialog"), true);
        this.searchAllBases = new JRadioButton(Globals.lang("Global search"), Globals.prefs.getBoolean("searchAllBases"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.increment);
        buttonGroup.add(this.floatSearch);
        buttonGroup.add(this.hideSearch);
        buttonGroup.add(this.showResultsInDialog);
        buttonGroup.add(this.searchAllBases);
        this.select = new JCheckBoxMenuItem(Globals.lang("Select matches"), false);
        this.increment.setToolTipText(Globals.lang("Incremental search"));
        this.floatSearch.setToolTipText(Globals.lang("Gray out non-matching entries"));
        this.hideSearch.setToolTipText(Globals.lang("Hide non-matching entries"));
        this.showResultsInDialog.setToolTipText(Globals.lang("Show search results in a window"));
        this.increment.addItemListener(this);
        this.floatSearch.addItemListener(this);
        this.hideSearch.addItemListener(this);
        this.showResultsInDialog.addItemListener(this);
        this.searchField.addFocusListener(Globals.focusListener);
        if (this.searchAll.isSelected()) {
            this.searchReq.setEnabled(false);
            this.searchOpt.setEnabled(false);
            this.searchGen.setEnabled(false);
        }
        this.searchAll.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                boolean bl = !SearchManager2.this.searchAll.isSelected();
                SearchManager2.this.searchReq.setEnabled(bl);
                SearchManager2.this.searchOpt.setEnabled(bl);
                SearchManager2.this.searchGen.setEnabled(bl);
            }
        });
        this.caseSensitive = new JCheckBoxMenuItem(Globals.lang("Case sensitive"), Globals.prefs.getBoolean("caseSensitiveSearch"));
        this.highLightWords = new JCheckBoxMenuItem(Globals.lang("Highlight Words"), Globals.prefs.getBoolean("highLightWords"));
        this.searchAutoComplete = new JCheckBoxMenuItem(Globals.lang("Autocomplete names"), Globals.prefs.getBoolean("searchAutoComplete"));
        this.settings.add(this.select);
        this.settings.addSeparator();
        this.settings.add(this.caseSensitive);
        this.settings.add(this.regExpSearch);
        this.settings.addSeparator();
        this.settings.add(this.highLightWords);
        this.settings.addSeparator();
        this.settings.add(this.searchAutoComplete);
        this.searchField.addActionListener(this);
        this.searchField.addCaretListener(this);
        this.search.addActionListener(this);
        this.searchField.addFocusListener(new FocusAdapter(){

            @Override
            public void focusGained(FocusEvent focusEvent) {
                if (SearchManager2.this.increment.isSelected()) {
                    SearchManager2.this.searchField.setText("");
                }
            }

            @Override
            public void focusLost(FocusEvent focusEvent) {
                SearchManager2.this.incSearch = false;
                SearchManager2.this.incSearchPos = -1;
                if (SearchManager2.this.increment.isSelected()) {
                    // empty if block
                }
            }
        });
        this.escape.addActionListener(this);
        this.escape.setEnabled(false);
        this.openset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!SearchManager2.this.settings.isVisible()) {
                    JButton jButton = (JButton)actionEvent.getSource();
                    SearchManager2.this.settings.show(jButton, 0, SearchManager2.this.openset.getHeight());
                }
            }
        });
        this.searchAutoComplete.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                Globals.prefs.putBoolean("searchAutoComplete", SearchManager2.this.searchAutoComplete.isSelected());
                if (SearchManager2.this.frame.basePanel() != null) {
                    SearchManager2.this.frame.basePanel().updateSearchManager();
                }
            }
        });
        Insets insets = new Insets(0, 2, 0, 2);
        this.escape.setMargin(insets);
        this.openset.setMargin(insets);
        JButton jButton = new JButton(GUIGlobals.getImage("help"));
        int n = jButton.getIcon().getIconHeight() + 5;
        Dimension dimension = new Dimension(n, n);
        jButton.setPreferredSize(dimension);
        jButton.setMinimumSize(dimension);
        jButton.setMargin(insets);
        jButton.addActionListener(new HelpAction(Globals.helpDiag, "SearchHelp.html", "Help"));
        if (Globals.prefs.getBoolean("incrementS")) {
            this.increment.setSelected(true);
        } else if (Globals.prefs.getBoolean("floatSearch")) {
            this.floatSearch.setSelected(true);
        } else if (Globals.prefs.getBoolean("showSearchInDialog")) {
            this.showResultsInDialog.setSelected(true);
        } else if (Globals.prefs.getBoolean("searchAllBases")) {
            this.searchAllBases.setSelected(true);
        } else {
            this.hideSearch.setSelected(true);
        }
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagLayout.setConstraints(this.searchField, gridBagConstraints);
        jPanel.add(this.searchField);
        gridBagLayout.setConstraints(this.search, gridBagConstraints);
        jPanel.add(this.search);
        gridBagConstraints.gridwidth = 0;
        gridBagLayout.setConstraints(this.escape, gridBagConstraints);
        jPanel.add(this.escape);
        gridBagConstraints.insets = new Insets(0, 2, 0, 0);
        gridBagLayout.setConstraints(this.increment, gridBagConstraints);
        jPanel.add(this.increment);
        gridBagLayout.setConstraints(this.floatSearch, gridBagConstraints);
        jPanel.add(this.floatSearch);
        gridBagLayout.setConstraints(this.hideSearch, gridBagConstraints);
        jPanel.add(this.hideSearch);
        gridBagLayout.setConstraints(this.showResultsInDialog, gridBagConstraints);
        jPanel.add(this.showResultsInDialog);
        gridBagLayout.setConstraints(this.searchAllBases, gridBagConstraints);
        jPanel.add(this.searchAllBases);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel2.setLayout(gridBagLayout2);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout2.setConstraints(this.openset, gridBagConstraints);
        jPanel2.add(this.openset);
        gridBagConstraints.weightx = 0.0;
        gridBagLayout2.setConstraints(jButton, gridBagConstraints);
        jPanel2.add(jButton);
        jPanel.add(jPanel2);
        jPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.setContentContainer(jPanel);
        this.searchField.getInputMap().put(Globals.prefs.getKey("Repeat incremental search"), "repeat");
        this.searchField.getActionMap().put("repeat", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (SearchManager2.this.increment.isSelected()) {
                    SearchManager2.this.repeatIncremental();
                }
            }
        });
        this.searchField.getInputMap().put(Globals.prefs.getKey("Clear search"), "escape");
        this.searchField.getActionMap().put("escape", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                SearchManager2.this.hideAway();
            }
        });
        this.setSearchButtonSizes();
        this.updateSearchButtonText();
    }

    public void setAutoCompleteListener(AutoCompleteListener autoCompleteListener) {
        this.autoCompleteListener = autoCompleteListener;
        this.updateKeyListeners();
    }

    private void updateKeyListeners() {
        KeyListener[] keyListenerArray;
        for (KeyListener keyListener : keyListenerArray = this.searchField.getKeyListeners()) {
            this.searchField.removeKeyListener(keyListener);
        }
        if (this.increment.isSelected()) {
            this.searchField.addKeyListener(this);
        } else if (this.searchAutoComplete.isSelected() && this.autoCompleteListener != null) {
            this.searchField.addKeyListener(this.autoCompleteListener);
        }
    }

    public void addSearchListener(SearchTextListener searchTextListener) {
        if (this.listeners.contains(searchTextListener)) {
            return;
        }
        this.listeners.add(searchTextListener);
        searchTextListener.searchText(this.getSearchwords(this.searchField.getText()));
    }

    public void removeSearchListener(SearchTextListener searchTextListener) {
        this.listeners.remove(searchTextListener);
    }

    private ArrayList<String> getSearchwords(String string) {
        String[] stringArray = string.split(" ");
        ArrayList<String> arrayList = new ArrayList<String>(stringArray.length);
        Collections.addAll(arrayList, stringArray);
        return arrayList;
    }

    private void fireSearchlistenerEvent(String string) {
        ArrayList<String> arrayList = string == null || string.isEmpty() ? null : this.getSearchwords(string);
        for (SearchTextListener searchTextListener : this.listeners) {
            searchTextListener.searchText(arrayList);
        }
    }

    private void setSearchButtonSizes() {
        this.search.setText(Globals.lang("Search specified field(s)"));
        Dimension dimension = this.search.getPreferredSize();
        this.search.setText(Globals.lang("Search all fields"));
        Dimension dimension2 = this.search.getPreferredSize();
        dimension2.width = Math.max(dimension.width, dimension2.width);
        this.search.setMinimumSize(dimension2);
        this.search.setPreferredSize(dimension2);
    }

    private void instantiateSearchDialog() {
        if (this.searchDialog == null) {
            this.searchDialog = new SearchResultsDialog(this.frame, Globals.lang("Search results"));
        }
    }

    public void updatePrefs() {
        Globals.prefs.putBoolean("searchReq", this.searchReq.isSelected());
        Globals.prefs.putBoolean("searchOpt", this.searchOpt.isSelected());
        Globals.prefs.putBoolean("searchGen", this.searchGen.isSelected());
        Globals.prefs.putBoolean("searchAll", this.searchAll.isSelected());
        Globals.prefs.putBoolean("incrementS", this.increment.isSelected());
        Globals.prefs.putBoolean("selectS", this.select.isSelected());
        Globals.prefs.putBoolean("floatSearch", this.floatSearch.isSelected());
        Globals.prefs.putBoolean("caseSensitiveSearch", this.caseSensitive.isSelected());
        Globals.prefs.putBoolean("regExpSearch", this.regExpSearch.isSelected());
        Globals.prefs.putBoolean("highLightWords", this.highLightWords.isSelected());
        Globals.prefs.putBoolean("showSearchInDialog", this.showResultsInDialog.isSelected());
        Globals.prefs.putBoolean("searchAllBases", this.searchAllBases.isSelected());
    }

    public void startIncrementalSearch() {
        this.increment.setSelected(true);
        this.searchField.setText("");
        this.searchField.requestFocus();
    }

    public void startSearch() {
        if (this.increment.isSelected() && this.incSearch) {
            this.repeatIncremental();
            return;
        }
        if (!this.searchField.hasFocus()) {
            this.searchField.selectAll();
            this.searchField.requestFocus();
        } else {
            if (this.increment.isSelected()) {
                this.floatSearch.setSelected(true);
            } else if (this.floatSearch.isSelected()) {
                this.hideSearch.setSelected(true);
            } else if (this.hideSearch.isSelected()) {
                this.showResultsInDialog.setSelected(true);
            } else if (this.showResultsInDialog.isSelected()) {
                this.searchAllBases.setSelected(true);
            } else {
                this.increment.setSelected(true);
            }
            this.increment.revalidate();
            this.increment.repaint();
            this.searchField.requestFocus();
        }
    }

    private void clearSearchLater() {
        if (this.panel == null) {
            return;
        }
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                SearchManager2.this.clearSearch();
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.escape) {
            this.incSearch = false;
            this.clearSearchLater();
        } else if (!(actionEvent.getSource() != this.searchField && actionEvent.getSource() != this.search || this.increment.isSelected() || this.panel == null)) {
            this.updatePrefs();
            if (this.searchField.getText().isEmpty()) {
                this.clearSearchLater();
                return;
            }
            this.fireSearchlistenerEvent(this.searchField.getText());
            SearchRule searchRule = SearchRules.getSearchRuleByQuery(this.searchField.getText(), Globals.prefs.getBoolean("caseSensitiveSearch"), Globals.prefs.getBoolean("regExpSearch"));
            if (!searchRule.validateSearchStrings(this.searchField.getText())) {
                this.panel.output(Globals.lang("Search failed: illegal search expression"));
                this.panel.stopShowingSearchResults();
                return;
            }
            SearchWorker searchWorker = new SearchWorker(searchRule, this.searchField.getText());
            searchWorker.getWorker().run();
            searchWorker.getCallBack().update();
            this.escape.setEnabled(true);
            this.frame.basePanel().mainTable.setSelected(0);
        }
    }

    private void clearSearch() {
        if (this.panel.isShowingFloatSearch()) {
            this.startedFloatSearch = false;
            this.panel.mainTable.stopShowingFloatSearch();
        } else if (this.panel.isShowingFilterSearch()) {
            this.startedFilterSearch = false;
            this.panel.stopShowingSearchResults();
        }
        this.fireSearchlistenerEvent(null);
        this.escape.setEnabled(false);
    }

    @Override
    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getSource() == this.increment) {
            if (this.startedFilterSearch || this.startedFloatSearch) {
                this.clearSearch();
            }
            this.updateSearchButtonText();
            this.updateKeyListeners();
        } else {
            this.updateSearchButtonText();
        }
    }

    private void repeatIncremental() {
        ++this.incSearchPos;
        if (this.panel != null) {
            this.goIncremental();
        }
    }

    @Override
    public void keyTyped(KeyEvent keyEvent) {
        if (keyEvent.isControlDown()) {
            return;
        }
        if (this.panel != null) {
            this.goIncremental();
        }
    }

    private void goIncremental() {
        this.incSearch = true;
        this.escape.setEnabled(true);
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                String string = SearchManager2.this.searchField.getText();
                if (SearchManager2.this.incSearchPos >= SearchManager2.this.panel.getDatabase().getEntryCount()) {
                    SearchManager2.this.panel.output('\'' + string + "' : " + Globals.lang("Incremental search failed. Repeat to search from top.") + '.');
                    SearchManager2.this.incSearchPos = -1;
                    return;
                }
                if (SearchManager2.this.searchField.getText().isEmpty()) {
                    return;
                }
                if (SearchManager2.this.incSearchPos < 0) {
                    SearchManager2.this.incSearchPos = 0;
                }
                BibtexEntry bibtexEntry = SearchManager2.this.panel.mainTable.getEntryAt(SearchManager2.this.incSearchPos);
                while (!SearchManager2.this.incSearcher.search(string, bibtexEntry)) {
                    SearchManager2.this.incSearchPos++;
                    if (SearchManager2.this.incSearchPos < SearchManager2.this.panel.getDatabase().getEntryCount()) {
                        bibtexEntry = SearchManager2.this.panel.mainTable.getEntryAt(SearchManager2.this.incSearchPos);
                        continue;
                    }
                    SearchManager2.this.panel.output('\'' + string + "' : " + Globals.lang("Incremental search failed. Repeat to search from top."));
                    SearchManager2.this.incSearchPos = -1;
                    return;
                }
                if (SearchManager2.this.incSearchPos >= 0) {
                    SearchManager2.this.panel.selectSingleEntry(SearchManager2.this.incSearchPos);
                    SearchManager2.this.panel.output('\'' + string + "' " + Globals.lang("found") + '.');
                }
            }
        });
    }

    @Override
    public void componentClosing() {
        this.frame.searchToggle.setSelected(false);
        if (this.panel != null && (this.startedFilterSearch || this.startedFloatSearch)) {
            this.clearSearch();
        }
    }

    @Override
    public void keyPressed(KeyEvent keyEvent) {
    }

    @Override
    public void keyReleased(KeyEvent keyEvent) {
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
        if (caretEvent.getSource() == this.searchField) {
            this.updateSearchButtonText();
        }
    }

    private void updateSearchButtonText() {
        this.search.setText(this.isSpecificSearch() ? Globals.lang("Search specified field(s)") : Globals.lang("Search all fields"));
    }

    private boolean isSpecificSearch() {
        return !this.increment.isSelected() && GrammarBasedSearchRule.isValid(this.caseSensitive.isSelected(), this.regExpSearch.isSelected(), this.searchField.getText());
    }

    @Override
    public void setActiveBasePanel(BasePanel basePanel) {
        super.setActiveBasePanel(basePanel);
        if (basePanel != null) {
            this.escape.setEnabled(basePanel.isShowingFloatSearch() || basePanel.isShowingFilterSearch());
        } else {
            this.escape.setEnabled(false);
        }
    }

    class SearchWorker
    extends AbstractWorker {
        private final SearchRule rule;
        private final String searchTerm;
        int hits = 0;

        public SearchWorker(SearchRule searchRule, String string) {
            this.rule = searchRule;
            this.searchTerm = string;
        }

        @Override
        public void run() {
            if (!SearchManager2.this.searchAllBases.isSelected()) {
                for (BibtexEntry bibtexEntry : SearchManager2.this.panel.getDatabase().getEntries()) {
                    boolean bl = this.rule.applyRule(this.searchTerm, bibtexEntry);
                    bibtexEntry.setSearchHit(bl);
                    if (!bl) continue;
                    ++this.hits;
                }
            } else {
                for (int i = 0; i < SearchManager2.this.frame.getTabbedPane().getTabCount(); ++i) {
                    BasePanel basePanel = SearchManager2.this.frame.baseAt(i);
                    for (BibtexEntry bibtexEntry : basePanel.getDatabase().getEntries()) {
                        boolean bl = this.rule.applyRule(this.searchTerm, bibtexEntry);
                        bibtexEntry.setSearchHit(bl);
                        if (!bl) continue;
                        ++this.hits;
                    }
                }
            }
        }

        @Override
        public void update() {
            SearchManager2.this.panel.output(Globals.lang("Searched database. Number of hits") + ": " + this.hits);
            if (SearchManager2.this.searchAllBases.isSelected()) {
                if (SearchManager2.this.startedFloatSearch) {
                    SearchManager2.this.panel.mainTable.stopShowingFloatSearch();
                    SearchManager2.this.startedFloatSearch = false;
                }
                if (SearchManager2.this.startedFilterSearch) {
                    SearchManager2.this.panel.stopShowingSearchResults();
                    SearchManager2.this.startedFilterSearch = false;
                }
                SearchManager2.this.instantiateSearchDialog();
                SearchManager2.this.searchDialog.clear();
                for (int i = 0; i < SearchManager2.this.frame.getTabbedPane().getTabCount(); ++i) {
                    BasePanel basePanel = SearchManager2.this.frame.baseAt(i);
                    for (BibtexEntry bibtexEntry : basePanel.getDatabase().getEntries()) {
                        if (!bibtexEntry.isSearchHit()) continue;
                        SearchManager2.this.searchDialog.addEntry(bibtexEntry, basePanel);
                    }
                }
                SearchManager2.this.searchDialog.selectFirstEntry();
                SearchManager2.this.searchDialog.setVisible(true);
            } else if (SearchManager2.this.showResultsInDialog.isSelected()) {
                if (SearchManager2.this.startedFloatSearch) {
                    SearchManager2.this.panel.mainTable.stopShowingFloatSearch();
                    SearchManager2.this.startedFloatSearch = false;
                }
                if (SearchManager2.this.startedFilterSearch) {
                    SearchManager2.this.panel.stopShowingSearchResults();
                    SearchManager2.this.startedFilterSearch = false;
                }
                SearchManager2.this.instantiateSearchDialog();
                SearchManager2.this.searchDialog.clear();
                for (BibtexEntry bibtexEntry : SearchManager2.this.panel.getDatabase().getEntries()) {
                    if (!bibtexEntry.isSearchHit()) continue;
                    SearchManager2.this.searchDialog.addEntry(bibtexEntry, SearchManager2.this.panel);
                }
                SearchManager2.this.searchDialog.selectFirstEntry();
                SearchManager2.this.searchDialog.setVisible(true);
            } else if (SearchManager2.this.hideSearch.isSelected()) {
                if (SearchManager2.this.startedFloatSearch) {
                    SearchManager2.this.panel.mainTable.stopShowingFloatSearch();
                    SearchManager2.this.startedFloatSearch = false;
                }
                SearchManager2.this.startedFilterSearch = true;
                SearchManager2.this.panel.setSearchMatcher(new SearchMatcher());
            } else {
                if (SearchManager2.this.startedFilterSearch) {
                    SearchManager2.this.panel.stopShowingSearchResults();
                    SearchManager2.this.startedFilterSearch = false;
                }
                SearchManager2.this.startedFloatSearch = true;
                SearchManager2.this.panel.mainTable.showFloatSearch(new SearchMatcher());
            }
            SearchManager2.this.searchField.select(0, SearchManager2.this.searchField.getText().length());
        }
    }
}

