/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.util.Collection;
import javax.swing.Box;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import net.sf.jabref.SidePaneComponent;

public class SidePane
extends JPanel {
    private final Dimension PREFERRED_SIZE = new Dimension(160, 100);
    private final GridBagLayout gridBagLayout = new GridBagLayout();
    private final GridBagConstraints constraint = new GridBagConstraints();
    private final JPanel mainPanel = new JPanel();

    public SidePane() {
        this.setLayout(new BorderLayout());
        this.mainPanel.setLayout(this.gridBagLayout);
        this.constraint.anchor = 11;
        this.constraint.fill = 1;
        this.constraint.gridwidth = 0;
        this.constraint.insets = new Insets(1, 1, 1, 1);
        this.constraint.gridheight = 1;
        this.constraint.weightx = 1.0;
        JScrollPane jScrollPane = new JScrollPane(this.mainPanel, 20, 30);
        jScrollPane.setBorder(null);
        super.add(jScrollPane);
    }

    public void setComponents(Collection<SidePaneComponent> collection) {
        this.mainPanel.removeAll();
        this.constraint.weighty = 0.0;
        for (Component component : collection) {
            this.gridBagLayout.setConstraints(component, this.constraint);
            this.mainPanel.add(component);
        }
        this.constraint.weighty = 1.0;
        Component component = Box.createVerticalGlue();
        this.gridBagLayout.setConstraints(component, this.constraint);
        this.mainPanel.add(component);
        this.revalidate();
        this.repaint();
    }

    @Override
    public void remove(Component component) {
        this.mainPanel.remove(component);
    }

    @Override
    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.PREFERRED_SIZE;
    }
}

