/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.Component;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URL;
import javax.swing.JOptionPane;
import net.sf.jabref.EntryEditor;
import net.sf.jabref.FieldEditor;
import net.sf.jabref.Globals;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class SimpleUrlDragDrop
implements DropTargetListener {
    private static final Log LOGGER = LogFactory.getLog(SimpleUrlDragDrop.class);
    private final FieldEditor editor;
    private final EntryEditor.StoreFieldAction storeFieldAction;

    public SimpleUrlDragDrop(FieldEditor fieldEditor, EntryEditor.StoreFieldAction storeFieldAction) {
        this.editor = fieldEditor;
        this.storeFieldAction = storeFieldAction;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Transferable transferable = dropTargetDropEvent.getTransferable();
        dropTargetDropEvent.acceptDrop(3);
        DataFlavor dataFlavor = null;
        try {
            dataFlavor = new DataFlavor("application/x-java-url; class=java.net.URL");
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOGGER.warn("Could not find DropTargetDropEvent class", classNotFoundException);
        }
        try {
            URL uRL = (URL)transferable.getTransferData(dataFlavor);
            this.editor.setText(uRL.toString());
            this.storeFieldAction.actionPerformed(new ActionEvent(this.editor, 0, ""));
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            JOptionPane.showMessageDialog((Component)((Object)this.editor), Globals.lang("Operation not supported"), Globals.lang("Drag and Drop Error"), 0);
            LOGGER.warn("Could not perform drage and drop", unsupportedFlavorException);
        }
        catch (IOException iOException) {
            LOGGER.warn("Could not perform drage and drop", iOException);
        }
    }
}

