/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.io.StringWriter;
import javax.swing.JOptionPane;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.BibtexEntryWriter;
import net.sf.jabref.export.LatexFieldFormatter;

public class TransferableBibtexEntry
implements Transferable {
    private final BibtexEntry[] data;
    public static final DataFlavor entryFlavor = new DataFlavor(BibtexEntry.class, "JabRef entry");

    public TransferableBibtexEntry(BibtexEntry[] bibtexEntryArray) {
        this.data = bibtexEntryArray;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return new DataFlavor[]{entryFlavor, DataFlavor.stringFlavor};
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return dataFlavor.equals(entryFlavor) || dataFlavor.equals(DataFlavor.stringFlavor);
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException {
        if (dataFlavor.equals(entryFlavor)) {
            return this.data;
        }
        if (dataFlavor.equals(DataFlavor.stringFlavor)) {
            try {
                StringWriter stringWriter = new StringWriter();
                BibtexEntryWriter bibtexEntryWriter = new BibtexEntryWriter(new LatexFieldFormatter(), false);
                for (BibtexEntry bibtexEntry : this.data) {
                    bibtexEntryWriter.write(bibtexEntry, stringWriter);
                }
                return stringWriter.toString();
            }
            catch (IOException iOException) {
                JOptionPane.showMessageDialog(null, "Could not paste entry as text:\n" + iOException.getMessage(), "Clipboard", 0);
                return "";
            }
        }
        throw new UnsupportedFlavorException(dataFlavor);
    }
}

