/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.List;
import javax.swing.JOptionPane;
import net.sf.jabref.EntryEditor;
import net.sf.jabref.FieldEditor;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.net.URLDownload;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UrlDragDrop
implements DropTargetListener {
    private static final Log LOGGER = LogFactory.getLog(UrlDragDrop.class);
    private final FieldEditor feditor;
    private final EntryEditor editor;
    private final JabRefFrame frame;

    public UrlDragDrop(EntryEditor entryEditor, JabRefFrame jabRefFrame, FieldEditor fieldEditor) {
        this.editor = entryEditor;
        this.feditor = fieldEditor;
        this.frame = jabRefFrame;
    }

    @Override
    public void dragEnter(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragOver(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dropActionChanged(DropTargetDragEvent dropTargetDragEvent) {
    }

    @Override
    public void dragExit(DropTargetEvent dropTargetEvent) {
    }

    @Override
    public void drop(DropTargetDropEvent dropTargetDropEvent) {
        Transferable transferable = dropTargetDropEvent.getTransferable();
        dropTargetDropEvent.acceptDrop(3);
        DataFlavor dataFlavor = null;
        try {
            dataFlavor = new DataFlavor("application/x-java-url; class=java.net.URL");
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOGGER.warn("Could not find DropTargetDropEvent class", classNotFoundException);
        }
        try {
            URL uRL = (URL)transferable.getTransferData(dataFlavor);
            JOptionChoice jOptionChoice = (JOptionChoice)JOptionPane.showInputDialog(this.editor, "", Globals.lang("Select action"), 3, null, new JOptionChoice[]{new JOptionChoice(Globals.lang("Insert URL"), 0), new JOptionChoice(Globals.lang("Download file"), 1)}, new JOptionChoice(Globals.lang("Insert URL"), 0));
            switch (jOptionChoice.getId()) {
                case 0: {
                    this.feditor.setText(uRL.toString());
                    this.editor.updateField(this.feditor);
                    break;
                }
                case 1: {
                    try {
                        File file = new File(new File(Globals.prefs.get("pdfDirectory")), this.editor.getEntry().getField("bibtexkey") + ".pdf");
                        this.frame.output(Globals.lang("Downloading..."));
                        URLDownload.buildMonitoredDownload(this.editor, uRL).downloadToFile(file);
                        this.frame.output(Globals.lang("Download completed"));
                        this.feditor.setText(file.toURI().toURL().toString());
                        this.editor.updateField(this.feditor);
                        break;
                    }
                    catch (IOException iOException) {
                        LOGGER.error("Error while downloading file", iOException);
                        JOptionPane.showMessageDialog(this.editor, Globals.lang("File download"), Globals.lang("Error while downloading file:" + iOException.getMessage()), 0);
                    }
                }
            }
            return;
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            LOGGER.warn("Could not parse URL", unsupportedFlavorException);
        }
        catch (IOException iOException) {
            LOGGER.warn("Could not perform drage and drop", iOException);
        }
        try {
            List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
            if (list.size() > 1) {
                JOptionPane.showMessageDialog(this.editor, Globals.lang("Only one item is supported"), Globals.lang("Drag and Drop Error"), 0);
                return;
            }
            File file = (File)list.get(0);
            this.feditor.setText(file.toURI().toURL().toString());
            this.editor.updateField(this.feditor);
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            JOptionPane.showMessageDialog(this.editor, Globals.lang("Operation not supported"), Globals.lang("Drag and Drop Error"), 0);
            LOGGER.warn("Could not perform drage and drop", unsupportedFlavorException);
        }
        catch (IOException iOException) {
            LOGGER.warn("Could not perform drage and drop", iOException);
        }
    }

    private static class JOptionChoice {
        private final String label;
        private final int id;

        public JOptionChoice(String string, int n) {
            this.label = string;
            this.id = n;
        }

        public String toString() {
            return this.label;
        }

        public int getId() {
            return this.id;
        }
    }
}

