/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref;

import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JToolBar;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableColumnModel;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefPreferences;
import net.sf.jabref.PrefsTab;

class XmpPrefsTab
extends JPanel
implements PrefsTab {
    private boolean tableChanged = false;
    private int rowCount;
    private final JTable table;
    private final JCheckBox privacyFilterCheckBox = new JCheckBox(Globals.lang("Do not write the following fields to XMP Metadata:"));
    private final Vector<Object> tableRows = new Vector(10);

    public XmpPrefsTab() {
        this.setLayout(new BorderLayout());
        AbstractTableModel abstractTableModel = new AbstractTableModel(){

            @Override
            public int getRowCount() {
                return XmpPrefsTab.this.rowCount;
            }

            @Override
            public int getColumnCount() {
                return 1;
            }

            @Override
            public Object getValueAt(int n, int n2) {
                if (n >= XmpPrefsTab.this.tableRows.size()) {
                    return "";
                }
                Object e = XmpPrefsTab.this.tableRows.elementAt(n);
                if (e == null) {
                    return "";
                }
                return e;
            }

            @Override
            public String getColumnName(int n) {
                return Globals.lang("Field to filter");
            }

            @Override
            public Class<?> getColumnClass(int n) {
                return String.class;
            }

            @Override
            public boolean isCellEditable(int n, int n2) {
                return true;
            }

            @Override
            public void setValueAt(Object object, int n, int n2) {
                XmpPrefsTab.this.tableChanged = true;
                if (XmpPrefsTab.this.tableRows.size() <= n) {
                    XmpPrefsTab.this.tableRows.setSize(n + 1);
                }
                XmpPrefsTab.this.tableRows.setElementAt(object, n);
            }
        };
        this.table = new JTable(abstractTableModel);
        TableColumnModel tableColumnModel = this.table.getColumnModel();
        tableColumnModel.getColumn(0).setPreferredWidth(140);
        FormLayout formLayout = new FormLayout("1dlu, 8dlu, left:pref, 4dlu, fill:pref", "");
        DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new BorderLayout());
        JScrollPane jScrollPane = new JScrollPane(this.table, 20, 31);
        this.table.setPreferredScrollableViewportSize(new Dimension(250, 200));
        jScrollPane.setMinimumSize(new Dimension(250, 300));
        jPanel2.add((Component)jScrollPane, "Center");
        JToolBar jToolBar = new JToolBar(1);
        jToolBar.setFloatable(false);
        jToolBar.setBorder(null);
        jToolBar.add(new AddRowAction());
        jToolBar.add(new DeleteRowAction());
        jPanel2.add((Component)jToolBar, "East");
        defaultFormBuilder.appendSeparator(Globals.lang("XMP Export Privacy Settings"));
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder.append(this.privacyFilterCheckBox);
        defaultFormBuilder.nextLine();
        defaultFormBuilder.append(jPanel);
        defaultFormBuilder.append(jPanel2);
        defaultFormBuilder.nextLine();
        jPanel = defaultFormBuilder.getPanel();
        jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.add((Component)jPanel, "Center");
    }

    @Override
    public void setValues() {
        this.tableRows.clear();
        String[] stringArray = JabRefPreferences.getInstance().getStringArray("xmpPrivacyFilters");
        Collections.addAll(this.tableRows, stringArray);
        this.rowCount = this.tableRows.size() + 5;
        this.privacyFilterCheckBox.setSelected(JabRefPreferences.getInstance().getBoolean("useXmpPrivacyFilter"));
    }

    @Override
    public void storeSettings() {
        int n;
        if (this.table.isEditing()) {
            n = this.table.getEditingColumn();
            int n2 = this.table.getEditingRow();
            this.table.getCellEditor(n2, n).stopCellEditing();
        }
        if (this.tableChanged || this.privacyFilterCheckBox.isSelected() && !Globals.prefs.hasKey("xmpPrivacyFilters")) {
            for (n = this.tableRows.size() - 1; n >= 0; --n) {
                if (!this.tableRows.elementAt(n).equals("")) continue;
                this.tableRows.removeElementAt(n);
            }
            JabRefPreferences.getInstance().putStringArray("xmpPrivacyFilters", this.tableRows.toArray(new String[this.tableRows.size()]));
        }
        JabRefPreferences.getInstance().putBoolean("useXmpPrivacyFilter", this.privacyFilterCheckBox.isSelected());
    }

    @Override
    public boolean readyToClose() {
        return true;
    }

    @Override
    public String getTabName() {
        return Globals.lang("XMP metadata");
    }

    class AddRowAction
    extends AbstractAction {
        public AddRowAction() {
            super("Add row", GUIGlobals.getImage("add"));
            this.putValue("ShortDescription", Globals.lang("Insert rows"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = XmpPrefsTab.this.table.getSelectedRows();
            if (nArray.length == 0) {
                XmpPrefsTab.this.rowCount++;
                XmpPrefsTab.this.table.revalidate();
                XmpPrefsTab.this.table.repaint();
                return;
            }
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] + i >= XmpPrefsTab.this.tableRows.size()) continue;
                XmpPrefsTab.this.tableRows.add(nArray[i] + i, "");
            }
            XmpPrefsTab.this.rowCount = XmpPrefsTab.this.rowCount + nArray.length;
            if (nArray.length > 1) {
                XmpPrefsTab.this.table.clearSelection();
            }
            XmpPrefsTab.this.table.revalidate();
            XmpPrefsTab.this.table.repaint();
            XmpPrefsTab.this.tableChanged = true;
        }
    }

    class DeleteRowAction
    extends AbstractAction {
        public DeleteRowAction() {
            super("Delete row", GUIGlobals.getImage("remove"));
            this.putValue("ShortDescription", Globals.lang("Delete rows"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            int[] nArray = XmpPrefsTab.this.table.getSelectedRows();
            if (nArray.length == 0) {
                return;
            }
            for (int i = nArray.length - 1; i >= 0; --i) {
                if (nArray[i] >= XmpPrefsTab.this.tableRows.size()) continue;
                XmpPrefsTab.this.tableRows.remove(nArray[i]);
            }
            XmpPrefsTab.this.rowCount = XmpPrefsTab.this.rowCount - nArray.length;
            if (nArray.length > 1) {
                XmpPrefsTab.this.table.clearSelection();
            }
            XmpPrefsTab.this.table.revalidate();
            XmpPrefsTab.this.table.repaint();
            XmpPrefsTab.this.tableChanged = true;
        }
    }
}

