/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.autocompleter;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.SortedSet;
import java.util.TreeSet;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.autocompleter.AutoCompleter;
import net.sf.jabref.autocompleter.AutoCompleterFactory;

abstract class AbstractAutoCompleter
implements AutoCompleter {
    private static final int SHORTEST_WORD = 4;
    private final TreeSet<String> indexCaseSensitive = new TreeSet();
    private final TreeSet<String> indexCaseInsensitive = new TreeSet();
    private final HashMap<String, TreeSet<String>> possibleStringsForSearchString = new HashMap();

    AbstractAutoCompleter() {
    }

    @Override
    public abstract void addBibtexEntry(BibtexEntry var1);

    @Override
    public String[] complete(String string) {
        if (AbstractAutoCompleter.stringMinLength(string)) {
            return null;
        }
        String string2 = string.toLowerCase();
        if (string2.equals(string)) {
            String string3 = AbstractAutoCompleter.incrementLastCharacter(string2);
            SortedSet<String> sortedSet = this.indexCaseInsensitive.subSet(string2, string3);
            ArrayList arrayList = new ArrayList();
            for (String string4 : sortedSet) {
                arrayList.addAll(this.possibleStringsForSearchString.get(string4));
            }
            return arrayList.toArray(new String[arrayList.size()]);
        }
        String string5 = AbstractAutoCompleter.incrementLastCharacter(string);
        SortedSet<String> sortedSet = this.indexCaseSensitive.subSet(string, string5);
        return sortedSet.toArray(new String[sortedSet.size()]);
    }

    private static String incrementLastCharacter(String string) {
        char c = string.charAt(string.length() - 1);
        return string.substring(0, string.length() - 1) + Character.toString((char)(c + '\u0001'));
    }

    private static boolean stringMinLength(String string) {
        return string.length() < AutoCompleterFactory.SHORTEST_TO_COMPLETE;
    }

    @Override
    public void addWordToIndex(String string) {
        if (string.length() >= 4) {
            this.indexCaseSensitive.add(string);
            String string2 = string.toLowerCase();
            this.indexCaseInsensitive.add(string2);
            TreeSet<String> treeSet = this.possibleStringsForSearchString.get(string2);
            if (treeSet == null) {
                treeSet = new TreeSet();
            }
            treeSet.add(string);
            this.possibleStringsForSearchString.put(string2, treeSet);
        }
    }

    @Override
    public boolean indexContainsWord(String string) {
        return this.indexCaseInsensitive.contains(string.toLowerCase());
    }

    @Override
    public String getPrefix() {
        return "";
    }
}

