/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.bst;

import java.util.Stack;
import net.sf.jabref.AuthorList;
import net.sf.jabref.bst.BibtexNameFormatter;
import net.sf.jabref.bst.VM;
import net.sf.jabref.bst.VMException;

public class FormatNameFunction
implements VM.BstFunction {
    private final VM vm;

    public FormatNameFunction(VM vM) {
        this.vm = vM;
    }

    @Override
    public void execute(VM.BstEntry bstEntry) {
        Stack<Object> stack = this.vm.getStack();
        if (stack.size() < 3) {
            throw new VMException("Not enough operands on stack for operation format.name$");
        }
        Object object = stack.pop();
        Object object2 = stack.pop();
        Object object3 = stack.pop();
        if (!(object instanceof String || object2 instanceof Integer || object3 instanceof String)) {
            stack.push("");
            return;
        }
        String string = (String)object;
        Integer n = (Integer)object2;
        String string2 = (String)object3;
        if (string2 != null) {
            AuthorList authorList = AuthorList.getAuthorList(string2);
            if (n > authorList.size()) {
                throw new VMException("Author Out of Bounds. Number " + n + " invalid for " + string2);
            }
            AuthorList.Author author = authorList.getAuthor(n - 1);
            stack.push(BibtexNameFormatter.formatName(author, string, this.vm));
        } else {
            stack.push("");
        }
    }
}

