/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.collab;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.Globals;
import net.sf.jabref.collab.Change;
import net.sf.jabref.undo.NamedCompound;

class ChangeDisplayDialog
extends JDialog
implements TreeSelectionListener {
    private BibtexDatabase secondary;
    private final JTree tree;
    private final JPanel infoPanel = new JPanel();
    private final JCheckBox cb = new JCheckBox(Globals.lang("Accept change"));
    private final JLabel rootInfo = new JLabel(Globals.lang("Select the tree nodes to view and accept or reject changes") + '.');
    private Change selected = null;
    private JComponent infoShown = null;
    private boolean okPressed = false;

    public ChangeDisplayDialog(JFrame jFrame, final BasePanel basePanel, BibtexDatabase bibtexDatabase, final DefaultMutableTreeNode defaultMutableTreeNode) {
        super(jFrame, Globals.lang("External changes"), true);
        this.secondary = bibtexDatabase;
        if (bibtexDatabase == null) {
            this.secondary = new BibtexDatabase();
        }
        this.tree = new JTree(defaultMutableTreeNode);
        this.tree.addTreeSelectionListener(this);
        JSplitPane jSplitPane = new JSplitPane();
        jSplitPane.setLeftComponent(new JScrollPane(this.tree));
        JPanel jPanel = new JPanel();
        jSplitPane.setRightComponent(jPanel);
        this.cb.setMargin(new Insets(2, 2, 2, 2));
        this.cb.setEnabled(false);
        this.infoPanel.setLayout(new BorderLayout());
        jPanel.setLayout(new BorderLayout());
        jPanel.setBorder(BorderFactory.createEtchedBorder());
        jPanel.add((Component)this.infoPanel, "Center");
        this.setInfo(this.rootInfo);
        this.infoPanel.add((Component)this.cb, "South");
        JButton jButton = new JButton(Globals.lang("Ok"));
        JPanel jPanel2 = new JPanel();
        jPanel2.add(jButton);
        JButton jButton2 = new JButton(Globals.lang("Cancel"));
        jPanel2.add(jButton2);
        this.getContentPane().add((Component)jSplitPane, "Center");
        this.getContentPane().add((Component)jPanel2, "South");
        this.cb.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                if (ChangeDisplayDialog.this.selected != null) {
                    ChangeDisplayDialog.this.selected.setAccepted(ChangeDisplayDialog.this.cb.isSelected());
                }
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ChangeDisplayDialog.this.dispose();
            }
        });
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                NamedCompound namedCompound = new NamedCompound(Globals.lang("Merged external changes"));
                Enumeration<TreeNode> enumeration = defaultMutableTreeNode.children();
                boolean bl = false;
                while (enumeration.hasMoreElements()) {
                    Change change = (Change)enumeration.nextElement();
                    boolean bl2 = false;
                    if (change.isAcceptable() && change.isAccepted()) {
                        bl2 = change.makeChange(basePanel, ChangeDisplayDialog.this.secondary, namedCompound);
                    }
                    if (bl2) continue;
                    bl = true;
                }
                namedCompound.end();
                basePanel.undoManager.addEdit(namedCompound);
                if (bl) {
                    basePanel.markBaseChanged();
                }
                basePanel.setUpdatedExternally(false);
                ChangeDisplayDialog.this.dispose();
                ChangeDisplayDialog.this.okPressed = true;
            }
        });
        this.pack();
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    private void setInfo(JComponent jComponent) {
        if (this.infoShown != null) {
            this.infoPanel.remove(this.infoShown);
        }
        this.infoShown = jComponent;
        this.infoPanel.add((Component)this.infoShown, "Center");
        this.infoPanel.revalidate();
        this.infoPanel.repaint();
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        Object object = this.tree.getLastSelectedPathComponent();
        if (object instanceof Change) {
            this.selected = (Change)object;
            this.setInfo(this.selected.description());
            this.cb.setSelected(this.selected.isAccepted());
            this.cb.setEnabled(this.selected.isAcceptable());
        } else {
            this.setInfo(this.rootInfo);
            this.selected = null;
            this.cb.setEnabled(false);
        }
    }
}

