/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.collab;

import javax.swing.JComponent;
import javax.swing.JScrollPane;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.DuplicateCheck;
import net.sf.jabref.Globals;
import net.sf.jabref.MetaData;
import net.sf.jabref.PreviewPanel;
import net.sf.jabref.collab.Change;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableRemoveEntry;

class EntryDeleteChange
extends Change {
    private final BibtexEntry memEntry;
    private final BibtexEntry tmpEntry;
    BibtexEntry diskEntry;
    private final JScrollPane sp;

    public EntryDeleteChange(BibtexEntry bibtexEntry, BibtexEntry bibtexEntry2) {
        super("Deleted entry");
        this.memEntry = bibtexEntry;
        this.tmpEntry = bibtexEntry2;
        double d = DuplicateCheck.compareEntriesStrictly(bibtexEntry, bibtexEntry2);
        boolean bl = !(d > 1.0);
        PreviewPanel previewPanel = new PreviewPanel(null, bibtexEntry, null, new MetaData(), Globals.prefs.get("preview0"));
        this.sp = new JScrollPane(previewPanel);
    }

    @Override
    public boolean makeChange(BasePanel basePanel, BibtexDatabase bibtexDatabase, NamedCompound namedCompound) {
        basePanel.database().removeEntry(this.memEntry.getId());
        namedCompound.addEdit(new UndoableRemoveEntry(basePanel.database(), this.memEntry, basePanel));
        bibtexDatabase.removeEntry(this.tmpEntry.getId());
        return true;
    }

    @Override
    JComponent description() {
        return this.sp;
    }
}

