/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.collab;

import javax.swing.JComponent;
import javax.swing.JScrollPane;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexString;
import net.sf.jabref.Globals;
import net.sf.jabref.IdGenerator;
import net.sf.jabref.KeyCollisionException;
import net.sf.jabref.collab.Change;
import net.sf.jabref.collab.InfoPane;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableInsertString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class StringAddChange
extends Change {
    private static final long serialVersionUID = 1L;
    private final BibtexString string;
    private final InfoPane tp = new InfoPane();
    private final JScrollPane sp = new JScrollPane(this.tp);
    private static final Log LOGGER = LogFactory.getLog(StringAddChange.class);

    public StringAddChange(BibtexString bibtexString) {
        this.name = Globals.lang("Added string") + ": '" + bibtexString.getName() + '\'';
        this.string = bibtexString;
        this.tp.setText("<HTML><H2>" + Globals.lang("Added string") + "</H2><H3>" + Globals.lang("Label") + ":</H3>" + bibtexString.getName() + "<H3>" + Globals.lang("Content") + ":</H3>" + bibtexString.getContent() + "</HTML>");
    }

    @Override
    public boolean makeChange(BasePanel basePanel, BibtexDatabase bibtexDatabase, NamedCompound namedCompound) {
        if (basePanel.database().hasStringLabel(this.string.getName())) {
            LOGGER.info("Cannot add string '" + this.string.getName() + "' because the name " + "is already in use.");
        }
        try {
            basePanel.database().addString(this.string);
            namedCompound.addEdit(new UndoableInsertString(basePanel, basePanel.database(), this.string));
        }
        catch (KeyCollisionException keyCollisionException) {
            LOGGER.info("Error: could not add string '" + this.string.getName() + "': " + keyCollisionException.getMessage(), keyCollisionException);
        }
        try {
            bibtexDatabase.addString(new BibtexString(IdGenerator.next(), this.string.getName(), this.string.getContent()));
        }
        catch (KeyCollisionException keyCollisionException) {
            LOGGER.info("Error: could not add string '" + this.string.getName() + "' to tmp database: " + keyCollisionException.getMessage(), keyCollisionException);
        }
        return true;
    }

    @Override
    JComponent description() {
        return this.sp;
    }
}

