/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.collab;

import javax.swing.JComponent;
import javax.swing.JScrollPane;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexString;
import net.sf.jabref.Globals;
import net.sf.jabref.collab.Change;
import net.sf.jabref.collab.InfoPane;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableRemoveString;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

class StringRemoveChange
extends Change {
    private static final long serialVersionUID = 1L;
    private final BibtexString string;
    private final BibtexString inMem;
    private final InfoPane tp = new InfoPane();
    private final JScrollPane sp = new JScrollPane(this.tp);
    private final BibtexString tmpString;
    private static final Log LOGGER = LogFactory.getLog(StringRemoveChange.class);

    public StringRemoveChange(BibtexString bibtexString, BibtexString bibtexString2, BibtexString bibtexString3) {
        this.tmpString = bibtexString2;
        this.name = Globals.lang("Removed string") + ": '" + bibtexString.getName() + '\'';
        this.string = bibtexString;
        this.inMem = bibtexString3;
        this.tp.setText("<HTML><H2>" + Globals.lang("Removed string") + "</H2><H3>" + Globals.lang("Label") + ":</H3>" + bibtexString.getName() + "<H3>" + Globals.lang("Content") + ":</H3>" + bibtexString.getContent() + "</HTML>");
    }

    @Override
    public boolean makeChange(BasePanel basePanel, BibtexDatabase bibtexDatabase, NamedCompound namedCompound) {
        try {
            basePanel.database().removeString(this.inMem.getId());
            namedCompound.addEdit(new UndoableRemoveString(basePanel, basePanel.database(), this.string));
        }
        catch (Exception exception) {
            LOGGER.info("Error: could not add string '" + this.string.getName() + "': " + exception.getMessage(), exception);
        }
        bibtexDatabase.removeString(this.tmpString.getId());
        return true;
    }

    @Override
    JComponent description() {
        return this.sp;
    }
}

