/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.gui.FileDialogs;
import net.sf.jabref.util.Util;

class CustomExportDialog
extends JDialog {
    private final JTextField name = new JTextField(60);
    private final JTextField layoutFile = new JTextField(60);
    private final JTextField extension = new JTextField(60);
    private boolean ok_pressed = false;
    private int index;
    private final JabRefFrame parent;
    private String oldName;
    private String oldRegexp;
    private String oldField;

    public CustomExportDialog(JabRefFrame jabRefFrame, String string, String string2, String string3) {
        this(jabRefFrame);
        this.name.setText(string);
        this.layoutFile.setText(string2);
        this.extension.setText(string3);
    }

    public CustomExportDialog(JabRefFrame jabRefFrame) {
        super(jabRefFrame, Globals.lang("Edit custom export"), true);
        this.parent = jabRefFrame;
        ActionListener actionListener = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (CustomExportDialog.this.layoutFile.getText().isEmpty() || CustomExportDialog.this.name.getText().isEmpty() || CustomExportDialog.this.extension.getText().isEmpty() || !CustomExportDialog.this.layoutFile.getText().endsWith(".layout")) {
                    return;
                }
                CustomExportDialog.this.ok_pressed = true;
                CustomExportDialog.this.dispose();
            }
        };
        JButton jButton = new JButton(Globals.lang("Ok"));
        jButton.addActionListener(actionListener);
        this.name.addActionListener(actionListener);
        this.layoutFile.addActionListener(actionListener);
        this.extension.addActionListener(actionListener);
        AbstractAction abstractAction = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                CustomExportDialog.this.dispose();
            }
        };
        JButton jButton2 = new JButton(Globals.lang("Cancel"));
        jButton2.addActionListener(abstractAction);
        JButton jButton3 = new JButton(Globals.lang("Browse"));
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                File file = new File(Globals.prefs.get("exportWorkingDirectory"));
                String string = FileDialogs.getNewFile(CustomExportDialog.this.parent, file, ".layout", 0, false);
                if (string == null) {
                    return;
                }
                File file2 = new File(string);
                Globals.prefs.put("exportWorkingDirectory", file2.getParent());
                CustomExportDialog.this.layoutFile.setText(file2.getPath());
            }
        });
        JPanel jPanel = new JPanel();
        ActionMap actionMap = jPanel.getActionMap();
        InputMap inputMap = jPanel.getInputMap(2);
        inputMap.put(this.parent.prefs().getKey("Close dialog"), "close");
        actionMap.put("close", abstractAction);
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), Globals.lang("Export properties")));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.insets = new Insets(3, 5, 3, 5);
        gridBagConstraints.anchor = 13;
        gridBagConstraints.fill = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        JLabel jLabel = new JLabel(Globals.lang("Export name") + ':');
        gridBagLayout.setConstraints(jLabel, gridBagConstraints);
        jPanel.add(jLabel);
        gridBagConstraints.gridy = 1;
        JLabel jLabel2 = new JLabel(Globals.lang("Main layout file") + ':');
        gridBagLayout.setConstraints(jLabel2, gridBagConstraints);
        jPanel.add(jLabel2);
        gridBagConstraints.gridy = 2;
        JLabel jLabel3 = new JLabel(Globals.lang("File extension") + ':');
        gridBagLayout.setConstraints(jLabel3, gridBagConstraints);
        jPanel.add(jLabel3);
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(this.name, gridBagConstraints);
        jPanel.add(this.name);
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagLayout.setConstraints(this.layoutFile, gridBagConstraints);
        jPanel.add(this.layoutFile);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.weightx = 0.0;
        gridBagLayout.setConstraints(jButton3, gridBagConstraints);
        jPanel.add(jButton3);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagLayout.setConstraints(this.extension, gridBagConstraints);
        jPanel.add(this.extension);
        JPanel jPanel2 = new JPanel();
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder(jPanel2);
        jPanel2.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addButton((JComponent)jButton);
        buttonBarBuilder.addButton((JComponent)jButton2);
        buttonBarBuilder.addGlue();
        this.getContentPane().add((Component)jPanel, "Center");
        this.getContentPane().add((Component)jPanel2, "South");
        this.setSize(600, 170);
        Util.placeDialog(this, this.parent);
    }

    public boolean okPressed() {
        return this.ok_pressed;
    }

    public int index() {
        return this.index;
    }

    public String oldField() {
        return this.oldField;
    }

    public String oldName() {
        return this.oldName;
    }

    public String oldRegexp() {
        return this.oldRegexp;
    }

    public String layoutFile() {
        return this.layoutFile.getText();
    }

    public String name() {
        return this.name.getText();
    }

    public String extension() {
        String string = this.extension.getText();
        if (string.startsWith(".")) {
            return string;
        }
        if (string.startsWith("*.")) {
            return string.substring(1);
        }
        return '.' + string;
    }
}

