/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Set;
import javax.swing.filechooser.FileFilter;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.MetaData;
import net.sf.jabref.export.ExportFileFilter;
import net.sf.jabref.export.ExportFormats;
import net.sf.jabref.export.FileActions;
import net.sf.jabref.export.IExportFormat;
import net.sf.jabref.export.SaveSession;
import net.sf.jabref.export.VerifyingWriter;
import net.sf.jabref.export.layout.Layout;
import net.sf.jabref.export.layout.LayoutHelper;

public class ExportFormat
implements IExportFormat {
    private String displayName;
    private String consoleName;
    private String lfFileName;
    private String directory;
    private String extension;
    String encoding = null;
    private FileFilter fileFilter;
    private boolean customExport = false;

    public ExportFormat(String string, String string2, String string3, String string4, String string5) {
        this.displayName = string;
        this.consoleName = string2;
        this.lfFileName = string3;
        this.directory = string4;
        this.extension = string5;
    }

    ExportFormat() {
    }

    public void setCustomExport(boolean bl) {
        this.customExport = bl;
    }

    @Override
    public String getConsoleName() {
        return this.consoleName;
    }

    @Override
    public String getDisplayName() {
        return this.displayName;
    }

    void setEncoding(String string) {
        this.encoding = string;
    }

    Reader getReader(String string) throws IOException {
        String string2 = this.customExport ? "" : "/resource/layout/" + (this.directory == null ? "" : this.directory + '/');
        return FileActions.getReader(string2 + string);
    }

    @Override
    public void performExport(BibtexDatabase bibtexDatabase, MetaData metaData, String string, String string2, Set<String> set) throws Exception {
        Object object;
        Object object2;
        Object object3;
        Reader reader;
        File file = new File(string);
        SaveSession saveSession = null;
        if (this.encoding != null) {
            try {
                saveSession = this.getSaveSession(this.encoding, file);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        }
        if (saveSession == null) {
            saveSession = this.getSaveSession(string2, file);
        }
        VerifyingWriter verifyingWriter = saveSession.getWriter();
        Layout layout = null;
        Globals.prefs.customExportNameFormatters = this.readFormatterFile(this.lfFileName);
        ArrayList<String> arrayList = new ArrayList<String>(1);
        try {
            reader = this.getReader(this.lfFileName + ".begin.layout");
            object3 = new LayoutHelper(reader);
            layout = ((LayoutHelper)object3).getLayoutFromText("net.sf.jabref.export.layout.format.");
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (layout != null) {
            verifyingWriter.write(layout.doLayout(bibtexDatabase, string2));
            arrayList.addAll(layout.getMissingFormatters());
        }
        object3 = FileActions.getSortedEntries(bibtexDatabase, metaData, set, false);
        reader = this.getReader(this.lfFileName + ".layout");
        LayoutHelper layoutHelper = new LayoutHelper(reader);
        Layout layout2 = layoutHelper.getLayoutFromText("net.sf.jabref.export.layout.format.");
        reader.close();
        if (layout2 != null) {
            arrayList.addAll(layout2.getMissingFormatters());
            System.out.println(layout2.getMissingFormatters());
        }
        HashMap<Object, Layout> hashMap = new HashMap<Object, Layout>();
        ExportFormats.entryNumber = 0;
        Object object4 = object3.iterator();
        while (object4.hasNext()) {
            Layout layout3;
            object2 = (BibtexEntry)object4.next();
            ++ExportFormats.entryNumber;
            object = ((BibtexEntry)object2).getType().getName().toLowerCase();
            if (hashMap.containsKey(object)) {
                layout3 = (Layout)hashMap.get(object);
            } else {
                try {
                    reader = this.getReader(this.lfFileName + '.' + (String)object + ".layout");
                    layoutHelper = new LayoutHelper(reader);
                    layout3 = layoutHelper.getLayoutFromText("net.sf.jabref.export.layout.format.");
                    hashMap.put(object, layout3);
                    reader.close();
                    if (layout3 != null) {
                        arrayList.addAll(layout3.getMissingFormatters());
                    }
                }
                catch (IOException iOException) {
                    layout3 = layout2;
                }
            }
            verifyingWriter.write(layout3.doLayout((BibtexEntry)object2, bibtexDatabase));
        }
        object4 = null;
        try {
            reader = this.getReader(this.lfFileName + ".end.layout");
            layoutHelper = new LayoutHelper(reader);
            object4 = layoutHelper.getLayoutFromText("net.sf.jabref.export.layout.format.");
            reader.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (object4 != null) {
            verifyingWriter.write(((Layout)object4).doLayout(bibtexDatabase, string2));
            arrayList.addAll(((Layout)object4).getMissingFormatters());
        }
        Globals.prefs.customExportNameFormatters = null;
        if (!arrayList.isEmpty()) {
            object2 = new StringBuilder("The following formatters could not be found").append(": ");
            object = arrayList.iterator();
            while (object.hasNext()) {
                ((StringBuilder)object2).append((String)object.next());
                if (!object.hasNext()) continue;
                ((StringBuilder)object2).append(", ");
            }
            System.err.println(((StringBuilder)object2).toString());
        }
        this.finalizeSaveSession(saveSession);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private HashMap<String, String> readFormatterFile(String string) {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        File file = new File(string + ".formatters");
        if (file.exists()) {
            FileReader fileReader = null;
            try {
                String[] stringArray;
                int n;
                fileReader = new FileReader(file);
                StringBuilder stringBuilder = new StringBuilder();
                while ((n = ((Reader)fileReader).read()) != -1) {
                    stringBuilder.append((char)n);
                }
                for (String string2 : stringArray = stringBuilder.toString().split("\n")) {
                    int n2;
                    String string3 = string2.trim();
                    if (string3.isEmpty() || (n2 = string3.indexOf(":")) <= 0 || n2 + 1 >= string3.length()) continue;
                    String string4 = string3.substring(0, n2);
                    String string5 = string3.substring(n2 + 1);
                    hashMap.put(string4, string5);
                }
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
            finally {
                if (fileReader != null) {
                    try {
                        ((Reader)fileReader).close();
                    }
                    catch (IOException iOException) {
                        iOException.printStackTrace();
                    }
                }
            }
        }
        return hashMap;
    }

    SaveSession getSaveSession(String string, File file) throws IOException {
        return new SaveSession(file, string, false);
    }

    @Override
    public FileFilter getFileFilter() {
        if (this.fileFilter == null) {
            this.fileFilter = new ExportFileFilter(this, this.extension);
        }
        return this.fileFilter;
    }

    void finalizeSaveSession(SaveSession saveSession) throws Exception {
        saveSession.getWriter().flush();
        saveSession.getWriter().close();
        if (!saveSession.getWriter().couldEncodeAll()) {
            System.err.println("Could not encode...");
        }
        saveSession.commit();
    }
}

