/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export;

import java.awt.event.ActionEvent;
import net.sf.jabref.BasePanel;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MnemonicAwareAction;
import net.sf.jabref.Worker;
import spin.Spin;

public class SaveAllAction
extends MnemonicAwareAction
implements Worker {
    private final JabRefFrame frame;
    private int databases = 0;
    private int saved = 0;

    public SaveAllAction(JabRefFrame jabRefFrame) {
        super(GUIGlobals.getImage("saveAll"));
        this.frame = jabRefFrame;
        this.putValue("AcceleratorKey", Globals.prefs.getKey("Save all"));
        this.putValue("ShortDescription", Globals.lang("Save all open databases"));
        this.putValue("Name", "Save all");
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        this.databases = this.frame.getTabbedPane().getTabCount();
        this.saved = 0;
        this.frame.output(Globals.lang("Saving all databases..."));
        Spin.off(this);
        this.run();
        this.frame.output(Globals.lang("Save all finished."));
    }

    @Override
    public void run() {
        for (int i = 0; i < this.databases; ++i) {
            if (i >= this.frame.getTabbedPane().getTabCount()) continue;
            BasePanel basePanel = this.frame.baseAt(i);
            if (basePanel.getFile() == null) {
                this.frame.showBaseAt(i);
            }
            basePanel.runCommand("save");
            ++this.saved;
        }
    }
}

