/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export.layout;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.export.layout.LayoutEntry;
import net.sf.jabref.export.layout.LayoutFormatter;
import net.sf.jabref.export.layout.StringInt;

public class Layout {
    private final LayoutEntry[] layoutEntries;
    private final ArrayList<String> missingFormatters = new ArrayList();

    public Layout(Vector<StringInt> vector, String string) throws Exception {
        Vector<LayoutEntry> vector2 = new Vector<LayoutEntry>(vector.size());
        Vector<StringInt> vector3 = null;
        String string2 = null;
        Iterator<StringInt> iterator = vector.iterator();
        while (iterator.hasNext()) {
            StringInt stringInt;
            StringInt stringInt2 = stringInt = iterator.next();
            if (stringInt2.i != 1 && stringInt2.i != 2) {
                LayoutEntry layoutEntry;
                if (stringInt2.i == 3) {
                    vector3 = new Vector<StringInt>();
                    string2 = stringInt2.s;
                } else if (stringInt2.i == 4) {
                    if (string2 != null && vector3 != null) {
                        if (string2.equals(stringInt2.s)) {
                            vector3.add(stringInt2);
                            layoutEntry = new LayoutEntry(vector3, string, 3);
                            vector2.add(layoutEntry);
                            vector3 = null;
                        } else {
                            System.out.println(string2 + '\n' + stringInt2.s);
                            System.out.println("Nested field entries are not implemented !!!");
                            Thread.dumpStack();
                        }
                    }
                } else if (stringInt2.i == 6) {
                    vector3 = new Vector();
                    string2 = stringInt2.s;
                } else if (stringInt2.i == 7) {
                    if (string2 != null && vector3 != null) {
                        if (string2.equals(stringInt2.s)) {
                            vector3.add(stringInt2);
                            layoutEntry = new LayoutEntry(vector3, string, 6);
                            vector2.add(layoutEntry);
                            vector3 = null;
                        } else {
                            System.out.println("Nested field entries are not implemented !!!");
                            Thread.dumpStack();
                        }
                    }
                } else if (stringInt2.i == 5) {
                    // empty if block
                }
            }
            if (vector3 == null) {
                vector2.add(new LayoutEntry(stringInt2, string));
                continue;
            }
            vector3.add(stringInt2);
        }
        this.layoutEntries = new LayoutEntry[vector2.size()];
        for (int i = 0; i < vector2.size(); ++i) {
            this.layoutEntries[i] = (LayoutEntry)vector2.get(i);
            if (!this.layoutEntries[i].isInvalidFormatter()) continue;
            this.missingFormatters.addAll(this.layoutEntries[i].getInvalidFormatters());
        }
    }

    public void setPostFormatter(LayoutFormatter layoutFormatter) {
        for (LayoutEntry layoutEntry : this.layoutEntries) {
            layoutEntry.setPostFormatter(layoutFormatter);
        }
    }

    public String doLayout(BibtexEntry bibtexEntry, BibtexDatabase bibtexDatabase) {
        return this.doLayout(bibtexEntry, bibtexDatabase, null);
    }

    public String doLayout(BibtexEntry bibtexEntry, BibtexDatabase bibtexDatabase, ArrayList<String> arrayList) {
        StringBuilder stringBuilder = new StringBuilder(100);
        for (LayoutEntry layoutEntry : this.layoutEntries) {
            String string = layoutEntry.doLayout(bibtexEntry, bibtexDatabase, arrayList);
            if (string == null) {
                string = "";
            }
            stringBuilder.append(string);
        }
        return stringBuilder.toString();
    }

    public String doLayout(BibtexDatabase bibtexDatabase, String string) {
        StringBuilder stringBuilder = new StringBuilder(100);
        boolean bl = false;
        for (LayoutEntry layoutEntry : this.layoutEntries) {
            String string2 = layoutEntry.doLayout(bibtexDatabase, string);
            if (string2 == null) {
                string2 = "";
                if (bl) {
                    int n;
                    for (n = 0; n < string2.length() && (string2.charAt(n) == '\n' || string2.charAt(n) == '\r'); ++n) {
                    }
                    if (n < string2.length()) {
                        stringBuilder.append(string2.substring(n));
                    }
                }
            } else {
                stringBuilder.append(string2);
            }
            bl = false;
        }
        return stringBuilder.toString();
    }

    public ArrayList<String> getMissingFormatters() {
        return this.missingFormatters;
    }
}

