/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export.layout;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Vector;
import java.util.regex.Matcher;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.Globals;
import net.sf.jabref.NameFormatterTab;
import net.sf.jabref.export.layout.LayoutFormatter;
import net.sf.jabref.export.layout.LayoutHelper;
import net.sf.jabref.export.layout.ParamLayoutFormatter;
import net.sf.jabref.export.layout.StringInt;
import net.sf.jabref.export.layout.WSITools;
import net.sf.jabref.export.layout.format.NotFoundFormatter;
import net.sf.jabref.export.layout.format.plugin.NameFormat;
import net.sf.jabref.plugin.PluginCore;
import net.sf.jabref.plugin.core.JabRefPlugin;
import net.sf.jabref.plugin.core.generated._JabRefPlugin;
import net.sf.jabref.util.Util;

class LayoutEntry {
    private LayoutFormatter[] option;
    private LayoutFormatter postFormatter = null;
    private String text;
    private LayoutEntry[] layoutEntries;
    private final int type;
    private final String classPrefix;
    private ArrayList<String> invalidFormatter = null;
    private static Map<String, LayoutFormatter> pluginLayoutFormatter;

    public LayoutEntry(StringInt stringInt, String string) throws Exception {
        this.type = stringInt.i;
        this.classPrefix = string;
        if (stringInt.i == 1) {
            this.text = stringInt.s;
        } else if (stringInt.i == 2) {
            this.text = stringInt.s.trim();
        } else if (stringInt.i != 3 && stringInt.i != 4 && stringInt.i == 5) {
            Vector<String> vector = new Vector<String>();
            WSITools.tokenize(vector, stringInt.s, "\n");
            if (vector.size() == 1) {
                this.text = vector.get(0);
            } else {
                this.text = vector.get(0).trim();
                for (LayoutFormatter layoutFormatter : this.option = LayoutEntry.getOptionalLayout(vector.get(1), this.classPrefix)) {
                    if (!(layoutFormatter instanceof NotFoundFormatter)) continue;
                    String string2 = ((NotFoundFormatter)layoutFormatter).getNotFound();
                    if (this.invalidFormatter == null) {
                        this.invalidFormatter = new ArrayList();
                    }
                    this.invalidFormatter.add(string2);
                }
            }
        }
    }

    public LayoutEntry(Vector<StringInt> vector, String string, int n) throws Exception {
        int n2;
        this.classPrefix = string;
        Vector<StringInt> vector2 = null;
        Vector<LayoutEntry> vector3 = new Vector<LayoutEntry>();
        StringInt stringInt = vector.get(0);
        String string2 = stringInt.s;
        stringInt = vector.get(vector.size() - 1);
        String string3 = stringInt.s;
        if (!string2.equals(string3)) {
            System.err.println("Field start and end entry must be equal.");
        }
        this.type = n;
        this.text = stringInt.s;
        for (n2 = 1; n2 < vector.size() - 1; ++n2) {
            stringInt = vector.get(n2);
            if (stringInt.i != 1 && stringInt.i != 2) {
                if (stringInt.i == 3 || stringInt.i == 6) {
                    vector2 = new Vector<StringInt>();
                    string2 = stringInt.s;
                } else if (stringInt.i == 4 || stringInt.i == 7) {
                    if (string2.equals(stringInt.s)) {
                        vector2.add(stringInt);
                        LayoutEntry layoutEntry = stringInt.i == 7 ? new LayoutEntry(vector2, this.classPrefix, 6) : new LayoutEntry(vector2, this.classPrefix, 3);
                        vector3.add(layoutEntry);
                        vector2 = null;
                    } else {
                        System.out.println("Nested field entries are not implemented !!!");
                    }
                } else if (stringInt.i == 5) {
                    // empty if block
                }
            }
            if (vector2 == null) {
                vector3.add(new LayoutEntry(stringInt, this.classPrefix));
                continue;
            }
            vector2.add(stringInt);
        }
        this.layoutEntries = new LayoutEntry[vector3.size()];
        for (n2 = 0; n2 < vector3.size(); ++n2) {
            this.layoutEntries[n2] = (LayoutEntry)vector3.get(n2);
            if (!this.layoutEntries[n2].isInvalidFormatter()) continue;
            if (this.invalidFormatter == null) {
                this.invalidFormatter = new ArrayList(1);
            }
            this.invalidFormatter.addAll(this.layoutEntries[n2].getInvalidFormatters());
        }
    }

    public void setPostFormatter(LayoutFormatter layoutFormatter) {
        this.postFormatter = layoutFormatter;
    }

    private String doLayout(BibtexEntry bibtexEntry, BibtexDatabase bibtexDatabase) {
        return this.doLayout(bibtexEntry, bibtexDatabase, null);
    }

    public String doLayout(BibtexEntry bibtexEntry, BibtexDatabase bibtexDatabase, ArrayList<String> arrayList) {
        switch (this.type) {
            case 1: {
                return this.text;
            }
            case 2: {
                String string = BibtexDatabase.getResolvedField(this.text, bibtexEntry, bibtexDatabase);
                if (string == null) {
                    string = "";
                }
                if (this.postFormatter != null) {
                    string = this.postFormatter.format(string);
                }
                return string;
            }
            case 3: 
            case 6: {
                String string;
                int n;
                int n2;
                Object object;
                Object object2;
                String string2;
                if (this.type == 6) {
                    string2 = BibtexDatabase.getResolvedField(this.text, bibtexEntry, bibtexDatabase);
                } else if (this.text.matches(".*(;|(\\&+)).*")) {
                    object2 = this.text.split("\\s*(;|(\\&+))\\s*");
                    string2 = null;
                    object = object2;
                    n2 = ((String[])object).length;
                    for (n = 0; n < n2 && (string2 = BibtexDatabase.getResolvedField(string = object[n], bibtexEntry, bibtexDatabase)) != null; ++n) {
                    }
                } else {
                    object2 = this.text.split("\\s*(\\|+)\\s*");
                    string2 = null;
                    object = object2;
                    n2 = ((String[])object).length;
                    for (n = 0; n < n2 && (string2 = BibtexDatabase.getResolvedField(string = object[n], bibtexEntry, bibtexDatabase)) == null; ++n) {
                    }
                }
                if (string2 == null || this.type == 6 && string2.equalsIgnoreCase(LayoutHelper.getCurrentGroup())) {
                    return null;
                }
                if (this.type == 6) {
                    LayoutHelper.setCurrentGroup(string2);
                }
                object2 = new StringBuilder(100);
                n2 = 0;
                for (n = 0; n < this.layoutEntries.length; ++n) {
                    object = this.layoutEntries[n].doLayout(bibtexEntry, bibtexDatabase);
                    if (object == null) {
                        if (n + 1 < this.layoutEntries.length && this.layoutEntries[n + 1].doLayout(bibtexEntry, bibtexDatabase).trim().isEmpty()) {
                            ++n;
                            n2 = 1;
                            continue;
                        }
                    } else if (n2 != 0) {
                        int n3;
                        for (n3 = 0; n3 < ((String)object).length() && (((String)object).charAt(n3) == '\n' || ((String)object).charAt(n3) == '\r'); ++n3) {
                        }
                        if (n3 < ((String)object).length()) {
                            ((StringBuilder)object2).append(((String)object).substring(n3));
                        }
                    } else if (bibtexEntry.isSearchHit()) {
                        ((StringBuilder)object2).append(this.highlightWords((String)object, arrayList));
                    } else {
                        ((StringBuilder)object2).append((String)object);
                    }
                    n2 = 0;
                }
                return ((StringBuilder)object2).toString();
            }
            case 4: 
            case 7: {
                return "";
            }
            case 5: {
                Object object;
                if (this.text.equals("bibtextype")) {
                    object = bibtexEntry.getType().getName();
                } else {
                    LayoutFormatter[] layoutFormatterArray = this.text.startsWith("\\") ? BibtexDatabase.getResolvedField(this.text.substring(1), bibtexEntry, bibtexDatabase) : BibtexDatabase.getText(this.text, bibtexDatabase);
                    object = layoutFormatterArray == null ? "" : layoutFormatterArray;
                }
                if (this.option != null) {
                    for (LayoutFormatter layoutFormatter : this.option) {
                        object = layoutFormatter.format((String)object);
                    }
                }
                if (this.postFormatter != null) {
                    object = this.postFormatter.format((String)object);
                }
                return object;
            }
            case 8: {
                return BibtexDatabase.getResolvedField("encoding", bibtexEntry, bibtexDatabase);
            }
        }
        return "";
    }

    public String doLayout(BibtexDatabase bibtexDatabase, String string) {
        if (this.type == 1) {
            return this.text;
        }
        if (this.type == 2) {
            throw new UnsupportedOperationException("bibtex entry fields not allowed in begin or end layout");
        }
        if (this.type == 3 || this.type == 6) {
            throw new UnsupportedOperationException("field and group starts not allowed in begin or end layout");
        }
        if (this.type == 4 || this.type == 7) {
            throw new UnsupportedOperationException("field and group ends not allowed in begin or end layout");
        }
        if (this.type == 5) {
            String string2 = BibtexDatabase.getText(this.text, bibtexDatabase);
            if (this.option != null) {
                for (LayoutFormatter layoutFormatter : this.option) {
                    string2 = layoutFormatter.format(string2);
                }
            }
            if (this.postFormatter != null) {
                string2 = this.postFormatter.format(string2);
            }
            return string2;
        }
        if (this.type == 8) {
            String string3 = Globals.ENCODING_NAMES_LOOKUP.get(string);
            return string3 != null ? string3 : string;
        }
        if (this.type == 9) {
            File file = Globals.prefs.databaseFile;
            return file != null ? file.getName() : "";
        }
        if (this.type == 10) {
            File file = Globals.prefs.databaseFile;
            return file != null ? file.getPath() : "";
        }
        return "";
    }

    private static LayoutFormatter getLayoutFormatterFromPlugins(String string) {
        Object object;
        if (pluginLayoutFormatter == null) {
            pluginLayoutFormatter = new HashMap<String, LayoutFormatter>();
            object = JabRefPlugin.getInstance(PluginCore.getManager());
            if (object != null) {
                for (_JabRefPlugin.LayoutFormatterExtension layoutFormatterExtension : ((_JabRefPlugin)object).getLayoutFormatterExtensions()) {
                    LayoutFormatter layoutFormatter = layoutFormatterExtension.getLayoutFormatter();
                    String string2 = layoutFormatterExtension.getName();
                    if (string2 == null) {
                        string2 = layoutFormatterExtension.getId();
                    }
                    if (layoutFormatter == null) continue;
                    pluginLayoutFormatter.put(string2, layoutFormatter);
                }
            }
        }
        if (pluginLayoutFormatter.containsKey(string)) {
            object = pluginLayoutFormatter.get(string).getClass();
            try {
                return (LayoutFormatter)((Class)object).getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Throwable throwable) {
                throwable.printStackTrace();
                return pluginLayoutFormatter.get(string);
            }
        }
        return null;
    }

    private static LayoutFormatter getLayoutFormatterByClassName(String string, String string2) throws Exception {
        if (!string.isEmpty()) {
            try {
                try {
                    return (LayoutFormatter)Class.forName(string2 + string).newInstance();
                }
                catch (Throwable throwable) {
                    return (LayoutFormatter)Class.forName(string).newInstance();
                }
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new Exception(Globals.lang("Formatter not found") + ": " + string);
            }
            catch (InstantiationException instantiationException) {
                throw new Exception(string + " can not be instantiated.");
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new Exception(string + " can't be accessed.");
            }
        }
        return null;
    }

    private static LayoutFormatter[] getOptionalLayout(String string, String string2) {
        ArrayList<String[]> arrayList = Util.parseMethodsCalls(string);
        ArrayList<Object> arrayList2 = new ArrayList<Object>(arrayList.size());
        Map<String, String> map = NameFormatterTab.getNameFormatters();
        for (String[] stringArray : arrayList) {
            LayoutFormatter layoutFormatter;
            Object object;
            String string3 = stringArray[0].trim();
            if (Globals.prefs.customExportNameFormatters != null && (object = Globals.prefs.customExportNameFormatters.get(string3)) != null) {
                layoutFormatter = new NameFormat();
                ((NameFormat)layoutFormatter).setParameter((String)object);
                arrayList2.add(layoutFormatter);
                continue;
            }
            try {
                object = LayoutEntry.getLayoutFormatterByClassName(string3, string2);
                if (object instanceof ParamLayoutFormatter && stringArray.length >= 2) {
                    ((ParamLayoutFormatter)object).setArgument(stringArray[1]);
                }
                arrayList2.add(object);
            }
            catch (Exception exception) {
                object = map.get(string3);
                if (object != null) {
                    layoutFormatter = new NameFormat();
                    ((NameFormat)layoutFormatter).setParameter((String)object);
                    arrayList2.add(layoutFormatter);
                    continue;
                }
                layoutFormatter = LayoutEntry.getLayoutFormatterFromPlugins(string3);
                if (layoutFormatter != null) {
                    if (layoutFormatter instanceof ParamLayoutFormatter && stringArray.length >= 2) {
                        ((ParamLayoutFormatter)layoutFormatter).setArgument(stringArray[1]);
                    }
                    arrayList2.add(layoutFormatter);
                    continue;
                }
                arrayList2.add(new NotFoundFormatter(string3));
            }
        }
        return arrayList2.toArray(new LayoutFormatter[arrayList2.size()]);
    }

    public boolean isInvalidFormatter() {
        return this.invalidFormatter != null;
    }

    public ArrayList<String> getInvalidFormatters() {
        return this.invalidFormatter;
    }

    private String highlightWords(String string, ArrayList<String> arrayList) {
        if (arrayList == null) {
            return string;
        }
        Matcher matcher = Globals.getPatternForWords(arrayList).matcher(string);
        if (Character.isLetterOrDigit(string.charAt(0))) {
            String string2 = "#3399FF";
            StringBuffer stringBuffer = new StringBuffer();
            boolean bl = false;
            while (matcher.find()) {
                matcher.end();
                String string3 = matcher.group();
                matcher.appendReplacement(stringBuffer, "<span style=\"background-color:" + string2 + ";\">" + string3 + "</span>");
                bl = true;
            }
            if (bl) {
                matcher.appendTail(stringBuffer);
                string = stringBuffer.toString();
            }
        }
        return string;
    }
}

