/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.export.layout;

import java.io.IOException;
import java.io.PushbackReader;
import java.io.Reader;
import java.util.Iterator;
import java.util.Vector;
import net.sf.jabref.Globals;
import net.sf.jabref.export.layout.Layout;
import net.sf.jabref.export.layout.StringInt;

public class LayoutHelper {
    public static final int IS_LAYOUT_TEXT = 1;
    public static final int IS_SIMPLE_FIELD = 2;
    public static final int IS_FIELD_START = 3;
    public static final int IS_FIELD_END = 4;
    public static final int IS_OPTION_FIELD = 5;
    public static final int IS_GROUP_START = 6;
    public static final int IS_GROUP_END = 7;
    public static final int IS_ENCODING_NAME = 8;
    public static final int IS_FILENAME = 9;
    public static final int IS_FILEPATH = 10;
    private static String currentGroup = null;
    private final PushbackReader _in;
    private final Vector<StringInt> parsedEntries = new Vector();
    private boolean _eof = false;
    private int line = 1;

    public LayoutHelper(Reader reader) {
        if (reader == null) {
            throw new NullPointerException();
        }
        this._in = new PushbackReader(reader);
    }

    public Layout getLayoutFromText(String string) throws Exception {
        this.parse();
        Iterator<StringInt> iterator = this.parsedEntries.iterator();
        while (iterator.hasNext()) {
            StringInt stringInt;
            StringInt stringInt2 = stringInt = iterator.next();
            if (stringInt2.i != 2 && stringInt2.i != 3 && stringInt2.i != 4 && stringInt2.i != 6 && stringInt2.i != 7) continue;
            stringInt2.s = stringInt2.s.trim().toLowerCase();
        }
        return new Layout(this.parsedEntries, string);
    }

    public static String getCurrentGroup() {
        return currentGroup;
    }

    public static void setCurrentGroup(String string) {
        currentGroup = string;
    }

    private String getBracketedField(int n) throws IOException {
        StringBuffer stringBuffer = null;
        boolean bl = false;
        while (!this._eof) {
            int n2 = this.read();
            if (n2 == -1) {
                this._eof = true;
                if (stringBuffer != null) {
                    this.parsedEntries.add(new StringInt(stringBuffer.toString(), n));
                }
                return null;
            }
            if (n2 == 123 || n2 == 125) {
                if (n2 == 125) {
                    if (stringBuffer == null) continue;
                    this.parsedEntries.add(new StringInt(stringBuffer.toString(), n));
                    return null;
                }
                bl = true;
                continue;
            }
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(100);
            }
            if (!bl || n2 == 125) continue;
            stringBuffer.append((char)n2);
        }
        return null;
    }

    private String getBracketedOptionField(int n) throws IOException {
        StringBuffer stringBuffer = null;
        boolean bl = false;
        boolean bl2 = false;
        boolean bl3 = false;
        String string = null;
        while (!this._eof) {
            int n2 = this.read();
            if (n2 == -1) {
                this._eof = true;
                if (stringBuffer != null) {
                    String string2 = string != null ? stringBuffer.toString() + '\n' + string : stringBuffer.toString();
                    this.parsedEntries.add(new StringInt(string2, 5));
                }
                return null;
            }
            if (!bl2 && (n2 == 93 || n2 == 91 || bl3 && (n2 == 123 || n2 == 125))) {
                if (n2 == 93 || bl3 && n2 == 125) {
                    if (n2 == 93 && stringBuffer != null) {
                        string = stringBuffer.toString();
                        stringBuffer = null;
                        bl = false;
                        bl3 = true;
                        continue;
                    }
                    if (n2 != 125) continue;
                    String string3 = stringBuffer == null ? " " : stringBuffer.toString();
                    String string4 = string != null ? string3 + '\n' + string : string3;
                    this.parsedEntries.add(new StringInt(string4, 5));
                    return null;
                }
                bl = true;
                continue;
            }
            if (n2 == 34) {
                boolean bl4 = bl2 = !bl2;
                if (stringBuffer == null) {
                    stringBuffer = new StringBuffer(100);
                }
                stringBuffer.append('\"');
                continue;
            }
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(100);
            }
            if (!bl) continue;
            stringBuffer.append((char)n2);
        }
        return null;
    }

    private Object parse() throws IOException, StringIndexOutOfBoundsException {
        this.skipWhitespace();
        StringBuffer stringBuffer = null;
        boolean bl = false;
        while (!this._eof) {
            int n = this.read();
            if (n == -1) {
                this._eof = true;
                if (stringBuffer != null) {
                    this.parsedEntries.add(new StringInt(stringBuffer.toString(), 1));
                }
                return null;
            }
            if (n == 92 && this.peek() != 92 && !bl) {
                if (stringBuffer != null) {
                    this.parsedEntries.add(new StringInt(stringBuffer.toString(), 1));
                    stringBuffer = null;
                }
                this.parseField();
                bl = false;
                continue;
            }
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(100);
            }
            if (n != 92 || bl) {
                stringBuffer.append((char)n);
            }
            bl = n == 92 && !bl;
        }
        return null;
    }

    private void parseField() throws IOException, StringIndexOutOfBoundsException {
        StringBuffer stringBuffer = null;
        while (!this._eof) {
            int n = this.read();
            if (n == -1) {
                this._eof = true;
            }
            if (!Character.isLetter((char)n) && n != 95 && n != 45) {
                char c;
                this.unread(n);
                String string = stringBuffer != null ? stringBuffer.toString() : "";
                try {
                    c = string.charAt(0);
                }
                catch (StringIndexOutOfBoundsException stringIndexOutOfBoundsException) {
                    StringBuilder stringBuilder = new StringBuilder(10);
                    for (StringInt stringInt : this.parsedEntries.subList(Math.max(0, this.parsedEntries.size() - 6), this.parsedEntries.size() - 1)) {
                        stringBuilder.append(stringInt.s);
                    }
                    throw new StringIndexOutOfBoundsException(Globals.lang("Backslash parsing error near") + " '" + stringBuilder.toString().replace("\n", " ") + '\'');
                }
                if (c == 'b') {
                    if (string.equalsIgnoreCase("begin")) {
                        this.getBracketedField(3);
                        return;
                    }
                    if (string.equalsIgnoreCase("begingroup")) {
                        this.getBracketedField(6);
                        return;
                    }
                } else if (c == 'f') {
                    if (string.equalsIgnoreCase("format")) {
                        if (n == 91) {
                            this.getBracketedOptionField(5);
                            return;
                        }
                        this.getBracketedField(5);
                        return;
                    }
                    if (string.equalsIgnoreCase("filename")) {
                        this.parsedEntries.add(new StringInt(string, 9));
                        return;
                    }
                    if (string.equalsIgnoreCase("filepath")) {
                        this.parsedEntries.add(new StringInt(string, 10));
                        return;
                    }
                } else if (c == 'e') {
                    if (string.equalsIgnoreCase("end")) {
                        this.getBracketedField(4);
                        return;
                    }
                    if (string.equalsIgnoreCase("endgroup")) {
                        this.getBracketedField(7);
                        return;
                    }
                    if (string.equalsIgnoreCase("encoding")) {
                        this.parsedEntries.add(new StringInt(string, 8));
                        return;
                    }
                }
                this.parsedEntries.add(new StringInt(string, 2));
                return;
            }
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer(100);
            }
            stringBuffer.append((char)n);
        }
    }

    private int peek() throws IOException {
        int n = this.read();
        this.unread(n);
        return n;
    }

    private int read() throws IOException {
        int n = this._in.read();
        if (n == 10) {
            ++this.line;
        }
        return n;
    }

    private void skipWhitespace() throws IOException {
        int n;
        do {
            if ((n = this.read()) != -1 && n != 65535) continue;
            this._eof = true;
            return;
        } while (Character.isWhitespace((char)n));
        this.unread(n);
    }

    private void unread(int n) throws IOException {
        if (n == 10) {
            --this.line;
        }
        this._in.unread(n);
    }
}

