/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import net.sf.jabref.BaseAction;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.gui.FileListEntry;
import net.sf.jabref.gui.FileListEntryEditor;
import net.sf.jabref.gui.FileListTableModel;
import net.sf.jabref.undo.UndoableFieldChange;

public class AttachFileAction
implements BaseAction {
    private final BasePanel panel;

    public AttachFileAction(BasePanel basePanel) {
        this.panel = basePanel;
    }

    @Override
    public void action() {
        if (this.panel.getSelectedEntries().length != 1) {
            return;
        }
        BibtexEntry bibtexEntry = this.panel.getSelectedEntries()[0];
        FileListEntry fileListEntry = new FileListEntry("", "", null);
        FileListEntryEditor fileListEntryEditor = new FileListEntryEditor(this.panel.frame(), fileListEntry, false, true, this.panel.metaData());
        fileListEntryEditor.setVisible(true, true);
        if (fileListEntryEditor.okPressed()) {
            FileListTableModel fileListTableModel = new FileListTableModel();
            String string = bibtexEntry.getField("file");
            if (string != null) {
                fileListTableModel.setContent(string);
            }
            fileListTableModel.addEntry(fileListTableModel.getRowCount(), fileListEntry);
            String string2 = fileListTableModel.getStringRepresentation();
            UndoableFieldChange undoableFieldChange = new UndoableFieldChange(bibtexEntry, "file", string, string2);
            bibtexEntry.setField("file", string2);
            this.panel.undoManager.addEdit(undoableFieldChange);
            this.panel.markBaseChanged();
        }
    }
}

