/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.FieldTextField;
import net.sf.jabref.FocusRequester;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefExecutorService;
import net.sf.jabref.OpenFileFilter;
import net.sf.jabref.external.ExternalFilePanel;
import net.sf.jabref.gui.AttachFileDialog;
import net.sf.jabref.undo.NamedCompound;
import net.sf.jabref.undo.UndoableFieldChange;
import net.sf.jabref.util.FileUtil;
import net.sf.jabref.util.Util;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AutoSetExternalFileForEntries
extends AbstractWorker {
    private final String fieldName;
    private final BasePanel panel;
    private BibtexEntry[] sel = null;
    private OptionsDialog optDiag = null;
    private static final Log log = LogFactory.getLog(AutoSetExternalFileForEntries.class);
    private final Object[] brokenLinkOptions = new Object[]{Globals.lang("Ignore"), Globals.lang("Assign new file"), Globals.lang("Clear field"), Globals.lang("Quit synchronization")};
    private boolean goOn = true;
    private boolean autoSet = true;
    private boolean overWriteAllowed = true;
    private boolean checkExisting = true;
    private int entriesChanged = 0;

    public AutoSetExternalFileForEntries(BasePanel basePanel, String string) {
        this.fieldName = string;
        this.panel = basePanel;
    }

    @Override
    public void init() {
        Collection<BibtexEntry> collection = this.panel.database().getEntries();
        this.sel = collection.toArray(new BibtexEntry[collection.size()]);
        if (this.optDiag == null) {
            this.optDiag = new OptionsDialog(this.panel.frame(), this.fieldName);
        }
        Util.placeDialog(this.optDiag, this.panel.frame());
        this.optDiag.setVisible(true);
        if (this.optDiag.canceled()) {
            this.goOn = false;
            return;
        }
        this.autoSet = !this.optDiag.autoSetNone.isSelected();
        this.overWriteAllowed = this.optDiag.autoSetAll.isSelected();
        this.checkExisting = this.optDiag.checkLinks.isSelected();
        this.panel.output(Globals.lang("Synchronizing %0 links...", this.fieldName.toUpperCase()));
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void run() {
        String string;
        if (!this.goOn) {
            this.panel.output(Globals.lang("No entries selected."));
            return;
        }
        this.panel.frame().setProgressBarValue(0);
        this.panel.frame().setProgressBarVisible(true);
        int n = 10;
        int n2 = (this.autoSet ? n * this.sel.length : 0) + (this.checkExisting ? this.sel.length : 0);
        this.panel.frame().setProgressBarMaximum(n2);
        int n3 = 0;
        this.entriesChanged = 0;
        int n4 = 0;
        NamedCompound namedCompound = new NamedCompound(Globals.lang("Autoset %0 field", this.fieldName));
        OpenFileFilter openFileFilter = Util.getFileFilterForField(this.fieldName);
        ExternalFilePanel externalFilePanel = new ExternalFilePanel(this.fieldName, this.panel.metaData(), null, null, openFileFilter);
        FieldTextField fieldTextField = new FieldTextField(this.fieldName, "", false);
        String[] stringArray = this.panel.metaData().getFileDirectory(this.fieldName);
        if (this.autoSet) {
            for (BibtexEntry bibtexEntry : this.sel) {
                this.panel.frame().setProgressBarValue(n3 += n);
                string = bibtexEntry.getField(this.fieldName);
                if (string != null && !string.equals("") && !this.overWriteAllowed) continue;
                externalFilePanel.setEntry(bibtexEntry, this.panel.getDatabase());
                fieldTextField.setText(string != null ? string : "");
                JabRefExecutorService.INSTANCE.executeAndWait(externalFilePanel.autoSetFile(this.fieldName, fieldTextField));
                if (fieldTextField.getText().equals("") || fieldTextField.getText().equals(string)) continue;
                namedCompound.addEdit(new UndoableFieldChange(bibtexEntry, this.fieldName, string, fieldTextField.getText()));
                bibtexEntry.setField(this.fieldName, fieldTextField.getText());
                ++this.entriesChanged;
            }
        }
        if (this.checkExisting) {
            block6: for (BibtexEntry bibtexEntry : this.sel) {
                File file;
                this.panel.frame().setProgressBarValue(n3++);
                string = bibtexEntry.getField(this.fieldName);
                if (string == null || string.equals("") || (file = FileUtil.expandFilename(string, stringArray)) != null && file.exists()) continue;
                int n5 = JOptionPane.showOptionDialog(this.panel.frame(), Globals.lang("<HTML>Could not find file '%0'<BR>linked from entry '%1'</HTML>", new String[]{string, bibtexEntry.getCiteKey()}), Globals.lang("Broken link"), 1, 3, null, this.brokenLinkOptions, this.brokenLinkOptions[0]);
                switch (n5) {
                    case 1: {
                        AttachFileDialog attachFileDialog = new AttachFileDialog((Frame)this.panel.frame(), this.panel.metaData(), bibtexEntry, this.fieldName);
                        Util.placeDialog(attachFileDialog, this.panel.frame());
                        attachFileDialog.setVisible(true);
                        if (attachFileDialog.cancelled()) break;
                        namedCompound.addEdit(new UndoableFieldChange(bibtexEntry, this.fieldName, string, attachFileDialog.getValue()));
                        bibtexEntry.setField(this.fieldName, attachFileDialog.getValue());
                        ++this.entriesChanged;
                        break;
                    }
                    case 2: {
                        namedCompound.addEdit(new UndoableFieldChange(bibtexEntry, this.fieldName, string, null));
                        bibtexEntry.setField(this.fieldName, null);
                        ++this.entriesChanged;
                        break;
                    }
                    case 3: {
                        break block6;
                    }
                }
                ++n4;
            }
        }
        if (n4 > 0) {
            log.warn(Globals.lang("Found %0 broken links", n4 + ""));
        }
        if (this.entriesChanged > 0) {
            namedCompound.end();
            this.panel.undoManager.addEdit(namedCompound);
        }
    }

    @Override
    public void update() {
        if (!this.goOn) {
            return;
        }
        this.panel.output(Globals.lang("Finished synchronizing %0 links. Entries changed%c %1.", new String[]{this.fieldName.toUpperCase(), String.valueOf(this.entriesChanged)}));
        this.panel.frame().setProgressBarVisible(false);
        if (this.entriesChanged > 0) {
            this.panel.markBaseChanged();
        }
    }

    class OptionsDialog
    extends JDialog {
        private static final long serialVersionUID = 1L;
        final JRadioButton autoSetUnset;
        final JRadioButton autoSetAll;
        final JRadioButton autoSetNone;
        final JCheckBox checkLinks;
        final JButton ok;
        final JButton cancel;
        JLabel description;
        private boolean canceled;
        private final String fieldName;

        public OptionsDialog(JFrame jFrame, String string) {
            super(jFrame, Globals.lang("Synchronize %0 links", string.toUpperCase()), true);
            this.ok = new JButton(Globals.lang("Ok"));
            this.cancel = new JButton(Globals.lang("Cancel"));
            this.canceled = true;
            String string2 = string.toUpperCase();
            this.fieldName = string;
            this.ok.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsDialog.this.canceled = false;
                    OptionsDialog.this.dispose();
                }
            });
            AbstractAction abstractAction = new AbstractAction(){
                private static final long serialVersionUID = 1L;

                @Override
                public void actionPerformed(ActionEvent actionEvent) {
                    OptionsDialog.this.dispose();
                }
            };
            this.cancel.addActionListener(abstractAction);
            InputMap inputMap = this.cancel.getInputMap(2);
            ActionMap actionMap = this.cancel.getActionMap();
            inputMap.put(Globals.prefs.getKey("Close dialog"), "close");
            actionMap.put("close", abstractAction);
            this.autoSetUnset = new JRadioButton(Globals.lang("Autoset %0 links. Do not overwrite existing links.", string2), true);
            this.autoSetAll = new JRadioButton(Globals.lang("Autoset %0 links. Allow overwriting existing links.", string2), false);
            this.autoSetNone = new JRadioButton(Globals.lang("Do not autoset"), false);
            this.checkLinks = new JCheckBox(Globals.lang("Check existing %0 links", string2), true);
            ButtonGroup buttonGroup = new ButtonGroup();
            buttonGroup.add(this.autoSetUnset);
            buttonGroup.add(this.autoSetNone);
            buttonGroup.add(this.autoSetAll);
            FormLayout formLayout = new FormLayout("fill:pref", "");
            DefaultFormBuilder defaultFormBuilder = new DefaultFormBuilder(formLayout);
            this.description = new JLabel("<HTML>" + Globals.lang("Attempt to autoset %0 links for your entries. Autoset works if a %0 file in your %0 directory or a subdirectory<BR>is named identically to an entry's BibTeX key, plus extension.", string2) + "</HTML>");
            defaultFormBuilder.appendSeparator(Globals.lang("Autoset"));
            defaultFormBuilder.append(this.description);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(this.autoSetUnset);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(this.autoSetAll);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(this.autoSetNone);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.appendSeparator(Globals.lang("Check links"));
            this.description = new JLabel("<HTML>" + Globals.lang("This makes JabRef look up each %0 link and check if the file exists. If not, you will be given options<BR>to resolve the problem.", string2) + "</HTML>");
            defaultFormBuilder.append(this.description);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.append(this.checkLinks);
            defaultFormBuilder.nextLine();
            defaultFormBuilder.appendSeparator();
            JPanel jPanel = defaultFormBuilder.getPanel();
            jPanel.setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
            ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
            buttonBarBuilder.addGlue();
            buttonBarBuilder.addButton((JComponent)this.ok);
            buttonBarBuilder.addButton((JComponent)this.cancel);
            buttonBarBuilder.addGlue();
            this.getContentPane().add((Component)jPanel, "Center");
            this.getContentPane().add((Component)buttonBarBuilder.getPanel(), "South");
            this.pack();
        }

        @Override
        public void setVisible(boolean bl) {
            String[] stringArray;
            if (bl) {
                this.canceled = true;
            }
            if ((stringArray = AutoSetExternalFileForEntries.this.panel.metaData().getFileDirectory(this.fieldName)).length == 0) {
                this.autoSetNone.setSelected(true);
                this.autoSetNone.setEnabled(false);
                this.autoSetAll.setEnabled(false);
                this.autoSetUnset.setEnabled(false);
            } else {
                this.autoSetNone.setEnabled(true);
                this.autoSetAll.setEnabled(true);
                this.autoSetUnset.setEnabled(true);
            }
            new FocusRequester(this.ok);
            super.setVisible(bl);
        }

        public boolean canceled() {
            return this.canceled;
        }
    }
}

