/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import java.awt.Component;
import java.awt.GridLayout;
import java.awt.dnd.DropTarget;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.LinkedList;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.xml.transform.TransformerException;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.EntryEditor;
import net.sf.jabref.FieldEditor;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefExecutorService;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MetaData;
import net.sf.jabref.OpenFileFilter;
import net.sf.jabref.UrlDragDrop;
import net.sf.jabref.gui.FileDialogs;
import net.sf.jabref.net.URLDownload;
import net.sf.jabref.util.FileUtil;
import net.sf.jabref.util.UtilFindFiles;
import net.sf.jabref.util.XMPUtil;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class ExternalFilePanel
extends JPanel {
    private static final long serialVersionUID = 3653290879640642718L;
    private EntryEditor entryEditor;
    private final JabRefFrame frame;
    private final OpenFileFilter off;
    private BibtexEntry entry;
    private BibtexDatabase database;
    private final MetaData metaData;
    private static final Log LOGGER = LogFactory.getLog(ExternalFilePanel.class);

    public ExternalFilePanel(String string, MetaData metaData, BibtexEntry bibtexEntry, FieldEditor fieldEditor, OpenFileFilter openFileFilter) {
        this(null, metaData, null, string, openFileFilter, fieldEditor);
        this.entry = bibtexEntry;
        this.entryEditor = null;
    }

    public ExternalFilePanel(final JabRefFrame jabRefFrame, MetaData metaData, final EntryEditor entryEditor, final String string, OpenFileFilter openFileFilter, final FieldEditor fieldEditor) {
        this.frame = jabRefFrame;
        this.metaData = metaData;
        this.off = openFileFilter;
        this.entryEditor = entryEditor;
        this.setLayout(new GridLayout(2, 2));
        JButton jButton = new JButton(Globals.lang("Browse"));
        JButton jButton2 = new JButton(Globals.lang("Download"));
        JButton jButton3 = new JButton(Globals.lang("Auto"));
        JButton jButton4 = new JButton(Globals.lang("Write XMP"));
        jButton4.setToolTipText(Globals.lang("Write BibtexEntry as XMP-metadata to PDF."));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExternalFilePanel.this.browseFile(string, fieldEditor);
                entryEditor.storeFieldAction.actionPerformed(new ActionEvent(fieldEditor, 0, ""));
            }
        });
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExternalFilePanel.this.downLoadFile(string, fieldEditor, jabRefFrame);
            }
        });
        jButton3.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JabRefExecutorService.INSTANCE.execute(ExternalFilePanel.this.autoSetFile(string, fieldEditor));
            }
        });
        jButton4.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                ExternalFilePanel.this.pushXMP(string, fieldEditor);
            }
        });
        this.add(jButton);
        this.add(jButton2);
        this.add(jButton3);
        this.add(jButton4);
        if (fieldEditor != null) {
            ((JComponent)((Object)fieldEditor)).setDropTarget(new DropTarget((Component)((Object)fieldEditor), 0, new UrlDragDrop(entryEditor, jabRefFrame, fieldEditor)));
        }
    }

    public void setEntry(BibtexEntry bibtexEntry, BibtexDatabase bibtexDatabase) {
        this.entry = bibtexEntry;
        this.database = bibtexDatabase;
    }

    private BibtexDatabase getDatabase() {
        return this.database != null ? this.database : this.entryEditor.getDatabase();
    }

    private BibtexEntry getEntry() {
        return this.entry != null ? this.entry : this.entryEditor.getEntry();
    }

    private Object getKey() {
        return this.getEntry().getField("bibtexkey");
    }

    private void output(String string) {
        if (this.frame != null) {
            this.frame.output(string);
        }
    }

    private void pushXMP(final String string, final FieldEditor fieldEditor) {
        JabRefExecutorService.INSTANCE.execute(new Runnable(){

            @Override
            public void run() {
                File file;
                ExternalFilePanel.this.output(Globals.lang("Looking for pdf..."));
                String[] stringArray = ExternalFilePanel.this.metaData.getFileDirectory(string);
                File file2 = null;
                if (stringArray.length > 0 && (file = FileUtil.expandFilename(fieldEditor.getText(), stringArray)) != null) {
                    file2 = file;
                }
                if (file2 == null) {
                    file2 = new File(fieldEditor.getText());
                }
                file = file2;
                ExternalFilePanel.this.output(Globals.lang("Writing XMP to '%0'...", file.getName()));
                try {
                    XMPUtil.writeXMP(file, ExternalFilePanel.this.getEntry(), ExternalFilePanel.this.getDatabase());
                    ExternalFilePanel.this.output(Globals.lang("Wrote XMP to '%0'.", file.getName()));
                }
                catch (IOException iOException) {
                    JOptionPane.showMessageDialog(fieldEditor.getParent(), Globals.lang("Error writing XMP to file: %0", iOException.getLocalizedMessage()), Globals.lang("Writing XMP"), 0);
                    LOGGER.info(Globals.lang("Error writing XMP to file: %0", file.getAbsolutePath()), iOException);
                    ExternalFilePanel.this.output(Globals.lang("Error writing XMP to file: %0", file.getName()));
                }
                catch (TransformerException transformerException) {
                    JOptionPane.showMessageDialog(fieldEditor.getParent(), Globals.lang("Error converting BibTeX to XMP: %0", transformerException.getLocalizedMessage()), Globals.lang("Writing XMP"), 0);
                    LOGGER.info(Globals.lang("Error while converting BibtexEntry to XMP %0", file.getAbsolutePath()), transformerException);
                    ExternalFilePanel.this.output(Globals.lang("Error converting XMP to '%0'...", file.getName()));
                }
            }
        });
    }

    public void browseFile(String string, FieldEditor fieldEditor) {
        String string2;
        String[] stringArray = this.metaData.getFileDirectory(string);
        String string3 = null;
        if (stringArray.length > 0) {
            string3 = stringArray[0];
        }
        String string4 = fieldEditor.getText();
        if (string3 == null || !new File(string4).isAbsolute()) {
            string4 = string3 != null ? string3 : Globals.prefs.get(string + "_dir", "");
        }
        if ((string2 = FileDialogs.getNewFile(this.frame, new File(string4), '.' + string, 0, false)) != null) {
            String string5;
            File file = new File(string2);
            String string6 = file.getParent();
            if (string3 != null && string6.startsWith(string3)) {
                String string7 = string6.substring(string3.length(), string6.length()) + File.separator + file.getName();
                if (string7.startsWith(File.separator)) {
                    string7 = string7.substring(File.separator.length(), string7.length());
                }
                string5 = string7;
            } else {
                string5 = file.getPath();
            }
            fieldEditor.setText(string5);
            Globals.prefs.put(string + "_dir", file.getPath());
        }
    }

    public void downLoadFile(final String string, final FieldEditor fieldEditor, final Component component) {
        final String string2 = JOptionPane.showInputDialog(component, (Object)Globals.lang("Enter URL to download"));
        if (string2 == null || string2.trim().isEmpty()) {
            return;
        }
        final BibtexEntry bibtexEntry = this.entryEditor != null ? this.entryEditor.getEntry() : this.entry;
        JabRefExecutorService.INSTANCE.execute(new Runnable(){

            public String getPlannedFileName(String string4) {
                String string22;
                String string3 = ExternalFilePanel.this.off.getSuffix(string4);
                if (string3 == null) {
                    string3 = '.' + string.toLowerCase();
                }
                if (ExternalFilePanel.this.getKey() != null) {
                    string22 = ExternalFilePanel.this.getKey() + string3;
                } else {
                    string22 = JOptionPane.showInputDialog(component, (Object)Globals.lang("BibTeX key not set. Enter a name for the downloaded file"));
                    if (string22 != null && !ExternalFilePanel.this.off.accept(string22)) {
                        string22 = string22 + string3;
                    }
                }
                if (Globals.ON_WIN) {
                    string22 = string22.replaceAll("\\?|\\*|\\<|\\>|\\||\\\"|\\:|\\.$|\\[|\\]", "");
                } else if (Globals.ON_MAC) {
                    string22 = string22.replaceAll(":", "");
                }
                return string22;
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                String string6 = fieldEditor.getText();
                fieldEditor.setEnabled(false);
                boolean bl = true;
                try {
                    fieldEditor.setText(Globals.lang("Downloading..."));
                    ExternalFilePanel.this.output(Globals.lang("Downloading..."));
                    String string22 = this.getPlannedFileName(string2);
                    String[] stringArray = ExternalFilePanel.this.metaData.getFileDirectory(string);
                    String string3 = null;
                    for (String string4 : stringArray) {
                        if (!new File(string4).exists()) continue;
                        string3 = string4;
                        break;
                    }
                    if (string3 == null) {
                        if (stringArray.length > 0) {
                            JOptionPane.showMessageDialog(component, Globals.lang("Could not find directory for %0-files: %1", string, stringArray[0]), Globals.lang("Download file"), 0);
                        } else {
                            JOptionPane.showMessageDialog(component, Globals.lang("No directory defined for %0-files", string), Globals.lang("Download file"), 0);
                        }
                        return;
                    }
                    File file = new File(new File(string3), string22);
                    URL uRL = new URL(string2);
                    try {
                        URLDownload.buildMonitoredDownload(component, uRL).downloadToFile(file);
                    }
                    catch (IOException iOException) {
                        JOptionPane.showMessageDialog(component, Globals.lang("Invalid URL") + ": " + iOException.getMessage(), Globals.lang("Download file"), 0);
                        LOGGER.info("Error while downloading " + uRL.toString(), iOException);
                        if (bl) {
                            fieldEditor.setText(string6);
                            fieldEditor.setEnabled(true);
                        }
                        return;
                    }
                    ExternalFilePanel.this.output(Globals.lang("Download completed"));
                    String string5 = file.getPath();
                    if (string5.startsWith(string3) && (string5 = string5.substring(string3.length(), string5.length())).startsWith(File.separator)) {
                        string5 = string5.substring(File.separator.length());
                    }
                    if (ExternalFilePanel.this.entryEditor == null || ExternalFilePanel.this.entryEditor.getEntry() != bibtexEntry) {
                        bibtexEntry.setField(string, string5);
                        fieldEditor.setText(string5);
                        fieldEditor.setEnabled(true);
                        bl = false;
                    } else {
                        fieldEditor.setText(string5);
                        fieldEditor.setEnabled(true);
                        bl = false;
                        SwingUtilities.invokeLater(new Runnable(){

                            @Override
                            public void run() {
                                ExternalFilePanel.this.entryEditor.updateField(fieldEditor);
                            }
                        });
                    }
                }
                catch (MalformedURLException malformedURLException) {
                    JOptionPane.showMessageDialog(component, Globals.lang("Invalid URL"), Globals.lang("Download file"), 0);
                }
                finally {
                    if (bl) {
                        fieldEditor.setText(string6);
                        fieldEditor.setEnabled(true);
                    }
                }
            }
        });
    }

    public Runnable autoSetFile(final String string, final FieldEditor fieldEditor) {
        Object object = this.getKey();
        if (object == null || Globals.prefs.get(string + "Directory") == null) {
            this.output(Globals.lang("You must set both BibTeX key and %0 directory", string.toUpperCase()) + '.');
            return null;
        }
        this.output(Globals.lang("Searching for %0 file", string.toUpperCase()) + " '" + object + '.' + string + "'...");
        return new Runnable(){

            @Override
            public void run() {
                LinkedList linkedList = new LinkedList();
                String[] stringArray = ExternalFilePanel.this.metaData.getFileDirectory(string);
                Collections.addAll(linkedList, stringArray);
                String string2 = UtilFindFiles.findPdf(ExternalFilePanel.this.getEntry(), string, linkedList.toArray(new String[linkedList.size()]));
                if (string2 != null) {
                    fieldEditor.setText(string2);
                    if (ExternalFilePanel.this.entryEditor != null) {
                        ExternalFilePanel.this.entryEditor.updateField(fieldEditor);
                    }
                    ExternalFilePanel.this.output(Globals.lang("%0 field set", string.toUpperCase()) + '.');
                } else {
                    ExternalFilePanel.this.output(Globals.lang("No %0 found", string.toUpperCase()) + '.');
                }
            }
        };
    }
}

