/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import com.jgoodies.forms.builder.ButtonBarBuilder;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JScrollPane;
import javax.swing.ListCellRenderer;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;

class IconSelection
extends JDialog {
    private JList icons;
    private List<String> iconKeys;
    private final JButton ok = new JButton(Globals.lang("Ok"));
    private final JButton cancel = new JButton(Globals.lang("Cancel"));
    private boolean okPressed = false;
    private int selected = -1;
    private final JDialog parent;

    public IconSelection(JDialog jDialog, String string) {
        super(jDialog, Globals.lang("Select icon"), true);
        this.parent = jDialog;
        this.init(string);
    }

    @Override
    public void setVisible(boolean bl) {
        if (bl) {
            this.okPressed = false;
            this.selected = -1;
        }
        super.setVisible(bl);
    }

    public boolean isOkPressed() {
        return this.okPressed;
    }

    public String getSelectedIconKey() {
        if (this.selected >= 0) {
            return this.iconKeys.get(this.selected);
        }
        return null;
    }

    private void init(String string) {
        int n = -1;
        this.iconKeys = new ArrayList<String>();
        Map<String, String> map = GUIGlobals.getAllIcons();
        LinkedHashSet<ImageIcon> linkedHashSet = new LinkedHashSet<ImageIcon>();
        for (String object2 : map.keySet()) {
            ImageIcon imageIcon = GUIGlobals.getImage(object2);
            if (!linkedHashSet.contains(imageIcon)) {
                this.iconKeys.add(object2);
                if (object2.equals(string)) {
                    n = this.iconKeys.size() - 1;
                }
            }
            linkedHashSet.add(imageIcon);
        }
        DefaultListModel defaultListModel = new DefaultListModel();
        this.icons = new JList(defaultListModel);
        for (ImageIcon imageIcon : linkedHashSet) {
            defaultListModel.addElement(new JLabel(imageIcon));
        }
        if (n >= 0) {
            this.icons.setSelectedIndex(n);
        }
        class MyRenderer
        implements ListCellRenderer {
            final JLabel comp = new JLabel();

            public MyRenderer() {
                this.comp.setOpaque(true);
                this.comp.setIconTextGap(0);
                this.comp.setHorizontalAlignment(0);
            }

            public Component getListCellRendererComponent(JList jList, Object object, int n, boolean bl, boolean bl2) {
                this.comp.setText(null);
                this.comp.setIcon(((JLabel)object).getIcon());
                if (bl) {
                    this.comp.setBackground(jList.getSelectionBackground());
                    this.comp.setForeground(jList.getSelectionForeground());
                    this.comp.setBorder(BorderFactory.createEtchedBorder());
                } else {
                    this.comp.setBackground(jList.getBackground());
                    this.comp.setForeground(jList.getForeground());
                    this.comp.setBorder(null);
                }
                return this.comp;
            }
        }
        this.icons.setCellRenderer(new MyRenderer());
        this.icons.setSelectionMode(0);
        this.icons.setLayoutOrientation(2);
        ButtonBarBuilder buttonBarBuilder = new ButtonBarBuilder();
        buttonBarBuilder.addGlue();
        buttonBarBuilder.addButton((JComponent)this.ok);
        buttonBarBuilder.addButton((JComponent)this.cancel);
        buttonBarBuilder.addGlue();
        buttonBarBuilder.getPanel().setBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.ok.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IconSelection.this.okPressed = true;
                if (IconSelection.this.icons.getSelectedValue() != null) {
                    IconSelection.this.selected = IconSelection.this.icons.getSelectedIndex();
                }
                IconSelection.this.dispose();
            }
        });
        this.cancel.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                IconSelection.this.okPressed = false;
                IconSelection.this.dispose();
            }
        });
        this.getContentPane().add((Component)new JScrollPane(this.icons), "Center");
        this.getContentPane().add((Component)buttonBarBuilder.getPanel(), "South");
        this.pack();
        this.setLocationRelativeTo(this.parent);
    }
}

