/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.util.StringUtil;
import net.sf.jabref.util.Util;

public class RegExpFileSearch {
    private static final String EXT_MARKER = "__EXTENSION__";

    public static Map<BibtexEntry, List<File>> findFilesForSet(Collection<BibtexEntry> collection, Collection<String> collection2, List<File> list, String string) {
        HashMap<BibtexEntry, List<File>> hashMap = new HashMap<BibtexEntry, List<File>>();
        for (BibtexEntry bibtexEntry : collection) {
            hashMap.put(bibtexEntry, RegExpFileSearch.findFiles(bibtexEntry, collection2, list, string));
        }
        return hashMap;
    }

    private static List<File> findFiles(BibtexEntry bibtexEntry, Collection<String> collection, Collection<File> collection2, String string) {
        StringBuilder stringBuilder = new StringBuilder();
        Object object = collection.iterator();
        while (object.hasNext()) {
            stringBuilder.append(object.next());
            if (!object.hasNext()) continue;
            stringBuilder.append('|');
        }
        object = '(' + stringBuilder.toString() + ')';
        return RegExpFileSearch.findFile(bibtexEntry, null, collection2, string, (String)object, true);
    }

    private static List<File> findFile(BibtexEntry bibtexEntry, BibtexDatabase bibtexDatabase, Collection<File> collection, String string, String string2, boolean bl) {
        ArrayList<File> arrayList = new ArrayList<File>();
        for (File file : collection) {
            List<File> list = RegExpFileSearch.findFile(bibtexEntry, bibtexDatabase, file.getPath(), string, string2, bl);
            if (list == null) continue;
            arrayList.addAll(list);
        }
        return arrayList;
    }

    private static List<File> findFile(BibtexEntry bibtexEntry, BibtexDatabase bibtexDatabase, String string, String string2, String string3, boolean bl) {
        File file = string == null ? new File(".") : new File(string);
        if (!file.exists()) {
            return null;
        }
        List<File> list = RegExpFileSearch.findFile(bibtexEntry, bibtexDatabase, file, string2, string3);
        if (!list.isEmpty()) {
            for (int i = 0; i < list.size(); ++i) {
                try {
                    String string4 = list.get(i).getCanonicalPath().substring(file.getCanonicalPath().length());
                    if (string4.length() > 1 && string4.charAt(0) == File.separatorChar) {
                        string4 = string4.substring(1);
                    }
                    list.set(i, new File(string4));
                    continue;
                }
                catch (IOException iOException) {
                    iOException.printStackTrace();
                }
            }
        }
        return list;
    }

    private static List<File> findFile(BibtexEntry bibtexEntry, BibtexDatabase bibtexDatabase, File file, String string, String string2) {
        Object object;
        Object object2;
        String string3;
        ArrayList<File> arrayList = new ArrayList<File>();
        if (string.startsWith("/")) {
            file = new File(".");
            string = string.substring(1);
        }
        Matcher matcher = Pattern.compile("([^\\\\])\\\\([^\\\\])").matcher(string);
        StringBuffer stringBuffer = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(stringBuffer, matcher.group(1) + '/' + matcher.group(2));
        }
        matcher.appendTail(stringBuffer);
        string = stringBuffer.toString();
        String[] stringArray = string.split("/");
        if (stringArray.length == 0) {
            return arrayList;
        }
        if (stringArray.length > 1) {
            for (int i = 0; i < stringArray.length - 1; ++i) {
                string3 = stringArray[i];
                if ((string3 = Util.expandBrackets(string3, bibtexEntry, bibtexDatabase)).matches("^.:$")) {
                    file = new File(string3 + '/');
                    continue;
                }
                if (string3.equals(".")) continue;
                if (string3.equals("..")) {
                    file = new File(file.getParent());
                    continue;
                }
                if (string3.equals("*") && (object2 = file.listFiles()) != null) {
                    object = StringUtil.join(stringArray, "/", i + 1, stringArray.length);
                    for (Object object3 : object2) {
                        if (!((File)object3).isDirectory()) continue;
                        arrayList.addAll(RegExpFileSearch.findFile(bibtexEntry, bibtexDatabase, (File)object3, (String)object, string2));
                    }
                }
                if (!string3.equals("**")) continue;
                object2 = new LinkedList();
                object2.add(file);
                object = StringUtil.join(stringArray, "/", i + 1, stringArray.length);
                while (!object2.isEmpty()) {
                    File[] fileArray = ((File)object2.remove(0)).listFiles();
                    if (fileArray == null) continue;
                    object2.addAll(Arrays.asList(fileArray));
                    for (File file2 : fileArray) {
                        if (!file2.isDirectory()) continue;
                        arrayList.addAll(RegExpFileSearch.findFile(bibtexEntry, bibtexDatabase, file2, (String)object, string2));
                    }
                }
            }
        }
        String string4 = stringArray[stringArray.length - 1].replaceAll("\\[extension\\]", EXT_MARKER);
        string3 = Util.expandBrackets(string4, bibtexEntry, bibtexDatabase).replaceAll(EXT_MARKER, string2);
        object2 = Pattern.compile('^' + string3.replaceAll("\\\\\\\\", "\\\\") + '$', 2);
        object = file.listFiles(new FilenameFilter((Pattern)object2){
            final /* synthetic */ Pattern val$toMatch;
            {
                this.val$toMatch = pattern;
            }

            @Override
            public boolean accept(File file, String string) {
                return this.val$toMatch.matcher(string).matches();
            }
        });
        if (object != null && ((File[])object).length > 0) {
            Collections.addAll(arrayList, object);
        }
        return arrayList;
    }
}

