/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.external;

import java.awt.event.ActionEvent;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.EntryEditor;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.gui.FileListEntry;
import net.sf.jabref.gui.FileListTableModel;
import net.sf.jabref.util.FileUtil;
import net.sf.jabref.util.XMPUtil;

public class WriteXMPEntryEditorAction
extends AbstractAction {
    private final BasePanel panel;
    private final EntryEditor editor;
    private String message = null;

    public WriteXMPEntryEditorAction(BasePanel basePanel, EntryEditor entryEditor) {
        this.panel = basePanel;
        this.editor = entryEditor;
        this.putValue("Name", Globals.lang("Write XMP"));
        this.putValue("SmallIcon", GUIGlobals.getImage("pdfSmall"));
        this.putValue("ShortDescription", Globals.lang("Write BibtexEntry as XMP-metadata to PDF."));
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        Object object;
        this.setEnabled(false);
        this.panel.output(Globals.lang("Writing XMP metadata..."));
        this.panel.frame().setProgressBarIndeterminate(true);
        this.panel.frame().setProgressBarVisible(true);
        BibtexEntry bibtexEntry = this.editor.getEntry();
        ArrayList<File> arrayList = new ArrayList<File>();
        String string = bibtexEntry.getField("pdf");
        String[] stringArray = this.panel.metaData().getFileDirectory("pdf");
        File file = FileUtil.expandFilename(string, stringArray);
        if (file != null) {
            arrayList.add(file);
        }
        stringArray = this.panel.metaData().getFileDirectory("file");
        String string2 = bibtexEntry.getField("file");
        if (string2 != null) {
            object = new FileListTableModel();
            ((FileListTableModel)object).setContent(string2);
            for (int i = 0; i < ((FileListTableModel)object).getRowCount(); ++i) {
                FileListEntry fileListEntry = ((FileListTableModel)object).getEntry(i);
                if (fileListEntry.getType() == null || !fileListEntry.getType().getName().toLowerCase().equals("pdf") || (file = FileUtil.expandFilename(fileListEntry.getLink(), stringArray)) == null) continue;
                arrayList.add(file);
            }
        }
        object = new WriteXMPWorker(arrayList, bibtexEntry);
        ((AbstractWorker)object).getWorker().run();
        this.panel.output(this.message);
        this.panel.frame().setProgressBarVisible(false);
        this.setEnabled(true);
    }

    class WriteXMPWorker
    extends AbstractWorker {
        private final List<File> files;
        private final BibtexEntry entry;

        public WriteXMPWorker(List<File> list, BibtexEntry bibtexEntry) {
            this.files = list;
            this.entry = bibtexEntry;
        }

        @Override
        public void run() {
            if (this.files.size() == 0) {
                WriteXMPEntryEditorAction.this.message = Globals.lang("No PDF linked") + ".\n";
            } else {
                int n = 0;
                int n2 = 0;
                for (File file : this.files) {
                    if (!file.exists()) {
                        if (this.files.size() == 1) {
                            WriteXMPEntryEditorAction.this.message = Globals.lang("PDF does not exist");
                        }
                        ++n2;
                        continue;
                    }
                    try {
                        XMPUtil.writeXMP(file, this.entry, WriteXMPEntryEditorAction.this.panel.database());
                        if (this.files.size() == 1) {
                            WriteXMPEntryEditorAction.this.message = Globals.lang("Wrote XMP-metadata");
                        }
                        ++n;
                    }
                    catch (Exception exception) {
                        if (this.files.size() == 1) {
                            WriteXMPEntryEditorAction.this.message = Globals.lang("Error while writing") + " '" + file.getPath() + "'";
                        }
                        ++n2;
                    }
                }
                if (this.files.size() > 1) {
                    StringBuilder stringBuilder = new StringBuilder();
                    stringBuilder.append(Globals.lang("Finished writing XMP-metadata. Wrote to %0 file(s).", String.valueOf(n)));
                    if (n2 > 0) {
                        stringBuilder.append(" ").append(Globals.lang("Error writing to %0 file(s).", String.valueOf(n2)));
                    }
                    WriteXMPEntryEditorAction.this.message = stringBuilder.toString();
                }
            }
        }
    }
}

