/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.TransferHandler;
import net.sf.jabref.BasePanel;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefExecutorService;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.OutputPrinter;
import net.sf.jabref.external.DroppedFileHandler;
import net.sf.jabref.external.ExternalFileType;
import net.sf.jabref.external.TransferableFileLinkSelection;
import net.sf.jabref.groups.TransferableEntrySelection;
import net.sf.jabref.gui.MainTable;
import net.sf.jabref.gui.MainTableFormat;
import net.sf.jabref.imports.ImportMenuItem;
import net.sf.jabref.imports.OpenDatabaseAction;
import net.sf.jabref.imports.ParserResult;
import net.sf.jabref.net.URLDownload;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import spl.PdfImporter;

public class EntryTableTransferHandler
extends TransferHandler {
    private static final long serialVersionUID = 1L;
    private final MainTable entryTable;
    private final JabRefFrame frame;
    private final BasePanel panel;
    private DataFlavor urlFlavor;
    private final DataFlavor stringFlavor;
    private static final boolean DROP_ALLOWED = true;
    private static final Log LOGGER = LogFactory.getLog(EntryTableTransferHandler.class);
    private boolean draggingFile = false;

    public EntryTableTransferHandler(MainTable mainTable, JabRefFrame jabRefFrame, BasePanel basePanel) {
        this.entryTable = mainTable;
        this.frame = jabRefFrame;
        this.panel = basePanel;
        this.stringFlavor = DataFlavor.stringFlavor;
        try {
            this.urlFlavor = new DataFlavor("application/x-java-url; class=java.net.URL");
        }
        catch (ClassNotFoundException classNotFoundException) {
            LOGGER.info("Unable to configure drag and drop for main table", classNotFoundException);
        }
    }

    @Override
    public int getSourceActions(JComponent jComponent) {
        return 0x40000000;
    }

    @Override
    public Transferable createTransferable(JComponent jComponent) {
        if (!this.draggingFile) {
            return new TransferableEntrySelection(this.entryTable.getSelectedEntries());
        }
        this.draggingFile = false;
        return new TransferableFileLinkSelection(this.panel, this.entryTable.getSelectedEntries());
    }

    @Override
    public boolean importData(JComponent jComponent, Transferable transferable) {
        DataFlavor[] dataFlavorArray;
        int n = -1;
        if (jComponent instanceof JTable) {
            n = ((JTable)jComponent).getSelectedRow();
        }
        try {
            if (transferable.isDataFlavorSupported(DataFlavor.javaFileListFlavor)) {
                List list = (List)transferable.getTransferData(DataFlavor.javaFileListFlavor);
                return this.handleDraggedFiles(list, n);
            }
            if (transferable.isDataFlavorSupported(this.urlFlavor)) {
                URL uRL = (URL)transferable.getTransferData(this.urlFlavor);
                return this.handleDropTransfer(uRL, n);
            }
            if (transferable.isDataFlavorSupported(this.stringFlavor)) {
                String string = (String)transferable.getTransferData(this.stringFlavor);
                return this.handleDropTransfer(string, n);
            }
        }
        catch (IOException iOException) {
            System.err.println("failed to read dropped data: " + iOException.toString());
        }
        catch (UnsupportedFlavorException unsupportedFlavorException) {
            System.err.println("drop type error: " + unsupportedFlavorException.toString());
        }
        System.err.println("can't transfer input: ");
        for (DataFlavor dataFlavor : dataFlavorArray = transferable.getTransferDataFlavors()) {
            System.out.println("  " + dataFlavor.toString());
        }
        return false;
    }

    @Override
    public boolean canImport(JComponent jComponent, DataFlavor[] dataFlavorArray) {
        for (DataFlavor dataFlavor : dataFlavorArray) {
            if (!dataFlavor.match(this.urlFlavor) && !dataFlavor.match(this.stringFlavor) && !dataFlavor.match(DataFlavor.javaFileListFlavor)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void exportAsDrag(JComponent jComponent, InputEvent inputEvent, int n) {
        if (inputEvent instanceof MouseEvent) {
            MouseEvent mouseEvent = (MouseEvent)inputEvent;
            int n2 = this.entryTable.columnAtPoint(mouseEvent.getPoint());
            String[] stringArray = this.entryTable.getIconTypeForColumn(n2);
            if (stringArray == null) {
                super.exportAsDrag(jComponent, inputEvent, 0x40000000);
                return;
            }
            if (stringArray == MainTableFormat.FILE) {
                System.out.println("dragging file");
                this.draggingFile = true;
            }
        }
        super.exportAsDrag(jComponent, inputEvent, 0x40000000);
    }

    @Override
    protected void exportDone(JComponent jComponent, Transferable transferable, int n) {
        super.exportDone(jComponent, transferable, n);
    }

    @Override
    public void exportToClipboard(JComponent jComponent, Clipboard clipboard, int n) {
        super.exportToClipboard(jComponent, clipboard, n);
    }

    private boolean handleDropTransfer(String string, int n) throws IOException {
        if (string.startsWith("file:")) {
            if (this.handleDraggedFilenames(string, n)) {
                return true;
            }
        } else if (string.startsWith("http:")) {
            URL uRL = new URL(string);
            return this.handleDropTransfer(uRL, n);
        }
        File file = File.createTempFile("jabrefimport", "");
        file.deleteOnExit();
        FileWriter fileWriter = new FileWriter(file);
        fileWriter.write(string);
        fileWriter.close();
        ImportMenuItem importMenuItem = new ImportMenuItem(this.frame, false);
        importMenuItem.automatedImport(new String[]{file.getAbsolutePath()});
        return true;
    }

    public static List<File> getFilesFromDraggedFilesString(String string) {
        String[] stringArray = string.replaceAll("\r", "").split("\n");
        ArrayList<File> arrayList = new ArrayList<File>();
        String[] stringArray2 = stringArray;
        int n = stringArray2.length;
        for (int i = 0; i < n; ++i) {
            Serializable serializable;
            String string2;
            String string3 = string2 = stringArray2[i];
            File file = null;
            try {
                serializable = new URL(string3);
                file = new File(((URL)serializable).toURI());
            }
            catch (URISyntaxException uRISyntaxException) {
                uRISyntaxException.printStackTrace();
            }
            catch (MalformedURLException malformedURLException) {
                malformedURLException.printStackTrace();
            }
            if (file != null) {
                string3 = file.getPath();
            } else {
                if (!string3.startsWith("file:")) continue;
                string3 = string3.substring(5);
            }
            if (string3.startsWith("//")) {
                string3 = string3.substring(2);
            }
            if (!((File)(serializable = new File(string3))).exists()) continue;
            arrayList.add((File)serializable);
        }
        return arrayList;
    }

    private boolean handleDraggedFilenames(String string, int n) {
        return this.handleDraggedFiles(EntryTableTransferHandler.getFilesFromDraggedFilesString(string), n);
    }

    private boolean handleDraggedFiles(List<File> list, final int n) {
        final String[] stringArray = new String[list.size()];
        int n2 = 0;
        for (File file : list) {
            stringArray[n2] = file.getAbsolutePath();
            ++n2;
        }
        JabRefExecutorService.INSTANCE.execute(new Runnable(){

            @Override
            public void run() {
                PdfImporter.ImportPdfFilesResult importPdfFilesResult = new PdfImporter(EntryTableTransferHandler.this.frame, EntryTableTransferHandler.this.panel, EntryTableTransferHandler.this.entryTable, n).importPdfFiles(stringArray, (OutputPrinter)EntryTableTransferHandler.this.frame);
                if (importPdfFilesResult.noPdfFiles.length > 0) {
                    EntryTableTransferHandler.this.loadOrImportFiles(importPdfFilesResult.noPdfFiles, n);
                }
            }
        });
        return true;
    }

    private void loadOrImportFiles(String[] stringArray, int n) {
        OpenDatabaseAction openDatabaseAction = new OpenDatabaseAction(this.frame, false);
        ArrayList<String> arrayList = new ArrayList<String>();
        String string = Globals.prefs.get("defaultEncoding");
        for (String string2 : stringArray) {
            Object object;
            String string3 = "";
            ExternalFileType externalFileType = null;
            int n2 = string2.lastIndexOf(46);
            if (n2 >= 0 && n2 < string2.length()) {
                string3 = string2.substring(n2 + 1).toLowerCase();
                externalFileType = Globals.prefs.getExternalFileTypeByExt(string3);
            }
            if (string3.equals("bib")) {
                File file = new File(string2);
                try {
                    object = OpenDatabaseAction.loadDatabase(file, string);
                    if (object == null || object == ParserResult.INVALID_FORMAT) {
                        arrayList.add(string2);
                        continue;
                    }
                    openDatabaseAction.addNewDatabase((ParserResult)object, file, true);
                    this.frame.getFileHistory().newFile(string2);
                }
                catch (IOException iOException) {
                    arrayList.add(string2);
                }
                continue;
            }
            if (externalFileType != null && n >= 0) {
                boolean bl = true;
                object = new DroppedFileHandler(this.frame, this.panel);
                ((DroppedFileHandler)object).handleDroppedfile(string2, externalFileType, bl, this.entryTable, n);
                continue;
            }
            arrayList.add(string2);
        }
        if (arrayList.size() > 0) {
            String[] stringArray2 = new String[arrayList.size()];
            arrayList.toArray(stringArray2);
            ImportMenuItem importMenuItem = new ImportMenuItem(this.frame, this.entryTable == null);
            importMenuItem.automatedImport(stringArray2);
        }
    }

    private boolean handleDropTransfer(URL uRL, int n) throws IOException {
        File file = File.createTempFile("jabrefimport", "");
        file.deleteOnExit();
        URLDownload.buildMonitoredDownload(this.entryTable, uRL).downloadToFile(file);
        ImportMenuItem importMenuItem = new ImportMenuItem(this.frame, this.entryTable == null);
        importMenuItem.automatedImport(new String[]{file.getAbsolutePath()});
        return true;
    }
}

