/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import javax.swing.border.Border;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreePath;
import javax.swing.undo.AbstractUndoableEdit;
import javax.swing.undo.CompoundEdit;
import net.sf.jabref.AbstractWorker;
import net.sf.jabref.BasePanel;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.GUIGlobals;
import net.sf.jabref.Globals;
import net.sf.jabref.JabRefFrame;
import net.sf.jabref.MetaData;
import net.sf.jabref.SidePaneComponent;
import net.sf.jabref.SidePaneManager;
import net.sf.jabref.groups.AddToGroupAction;
import net.sf.jabref.groups.AutoGroupDialog;
import net.sf.jabref.groups.GroupDialog;
import net.sf.jabref.groups.GroupMatcher;
import net.sf.jabref.groups.GroupTreeNode;
import net.sf.jabref.groups.GroupsTree;
import net.sf.jabref.groups.RemoveFromGroupAction;
import net.sf.jabref.groups.UndoableAddOrRemoveGroup;
import net.sf.jabref.groups.UndoableModifyGroup;
import net.sf.jabref.groups.UndoableModifySubtree;
import net.sf.jabref.groups.structure.AbstractGroup;
import net.sf.jabref.groups.structure.AllEntriesGroup;
import net.sf.jabref.help.HelpAction;
import net.sf.jabref.search.SearchRule;
import net.sf.jabref.search.rules.InvertSearchRule;
import net.sf.jabref.search.rules.sets.SearchRuleSet;
import net.sf.jabref.search.rules.sets.SearchRuleSets;
import net.sf.jabref.undo.NamedCompound;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class GroupSelector
extends SidePaneComponent
implements TreeSelectionListener,
ActionListener {
    private static final Log LOGGER = LogFactory.getLog(GroupSelector.class);
    private final JButton newButton = new JButton(GUIGlobals.getImage("new"));
    private final JButton refresh = new JButton(GUIGlobals.getImage("refresh"));
    private final JButton autoGroup = new JButton(GUIGlobals.getImage("autoGroup"));
    private final JButton openset = new JButton(Globals.lang("Settings"));
    Color bgColor = Color.white;
    private GroupsTree groupsTree;
    private DefaultTreeModel groupsTreeModel;
    private GroupTreeNode groupsRoot;
    final JabRefFrame frame;
    private final JPopupMenu groupsContextMenu = new JPopupMenu();
    private final JPopupMenu settings = new JPopupMenu();
    private final JRadioButtonMenuItem hideNonHits;
    private final JRadioButtonMenuItem grayOut;
    private final JRadioButtonMenuItem andCb = new JRadioButtonMenuItem(Globals.lang("Intersection"), true);
    private final JRadioButtonMenuItem floatCb = new JRadioButtonMenuItem(Globals.lang("Float"), true);
    private final JCheckBoxMenuItem invCb = new JCheckBoxMenuItem(Globals.lang("Inverted"), false);
    private final JCheckBoxMenuItem select = new JCheckBoxMenuItem(Globals.lang("Select matches"), false);
    private final JCheckBoxMenuItem showOverlappingGroups = new JCheckBoxMenuItem(Globals.lang("Highlight overlapping groups"));
    private final JCheckBoxMenuItem showNumberOfElements = new JCheckBoxMenuItem(Globals.lang("Show number of elements contained in each group"));
    private final JCheckBoxMenuItem autoAssignGroup = new JCheckBoxMenuItem(Globals.lang("Automatically assign new entry to selected groups"));
    private final JCheckBoxMenuItem editModeCb = new JCheckBoxMenuItem(Globals.lang("Edit Group Membership"), false);
    private final Border editModeBorder = BorderFactory.createTitledBorder(BorderFactory.createMatteBorder(2, 2, 2, 2, Color.RED), "Edit mode", 3, 2, Font.getFont("Default"), Color.RED);
    private boolean editModeIndicator;
    private final AbstractAction editGroupAction = new EditGroupAction();
    private final NodeAction editGroupPopupAction = new EditGroupAction();
    private final NodeAction addGroupPopupAction = new AddGroupAction();
    private final NodeAction addSubgroupPopupAction = new AddSubgroupAction();
    private final NodeAction removeGroupAndSubgroupsPopupAction = new RemoveGroupAndSubgroupsAction();
    private final NodeAction removeSubgroupsPopupAction = new RemoveSubgroupsAction();
    private final NodeAction removeGroupKeepSubgroupsPopupAction = new RemoveGroupKeepSubgroupsAction();
    private final NodeAction moveNodeUpPopupAction = new MoveNodeUpAction();
    private final NodeAction moveNodeDownPopupAction = new MoveNodeDownAction();
    private final NodeAction moveNodeLeftPopupAction = new MoveNodeLeftAction();
    private final NodeAction moveNodeRightPopupAction = new MoveNodeRightAction();
    private final NodeAction expandSubtreePopupAction = new ExpandSubtreeAction();
    private final NodeAction collapseSubtreePopupAction = new CollapseSubtreeAction();
    private final NodeAction sortDirectSubgroupsPopupAction = new SortDirectSubgroupsAction();
    private final NodeAction sortAllSubgroupsPopupAction = new SortAllSubgroupsAction();
    private final AddToGroupAction addToGroup = new AddToGroupAction(false);
    private final AddToGroupAction moveToGroup = new AddToGroupAction(true);
    private final RemoveFromGroupAction removeFromGroup = new RemoveFromGroupAction();
    public final AbstractAction clearHighlightAction = new AbstractAction(Globals.lang("Clear highlight")){

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GroupSelector.this.groupsTree.setHighlight3Cells(null);
        }
    };
    private final JMenu moveSubmenu = new JMenu(Globals.lang("Move"));
    private final JMenu sortSubmenu = new JMenu(Globals.lang("Sort alphabetically"));

    public GroupSelector(JabRefFrame jabRefFrame, SidePaneManager sidePaneManager) {
        super(sidePaneManager, GUIGlobals.getIconUrl("toggleGroups"), Globals.lang("Groups"));
        this.groupsRoot = new GroupTreeNode(new AllEntriesGroup());
        this.frame = jabRefFrame;
        this.hideNonHits = new JRadioButtonMenuItem(Globals.lang("Hide non-hits"), !Globals.prefs.getBoolean("grayOutNonHits"));
        this.grayOut = new JRadioButtonMenuItem(Globals.lang("Gray out non-hits"), Globals.prefs.getBoolean("grayOutNonHits"));
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(this.hideNonHits);
        buttonGroup.add(this.grayOut);
        this.floatCb.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Globals.prefs.putBoolean("groupFloatSelections", GroupSelector.this.floatCb.isSelected());
            }
        });
        this.andCb.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Globals.prefs.putBoolean("groupIntersectSelections", GroupSelector.this.andCb.isSelected());
            }
        });
        this.invCb.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Globals.prefs.putBoolean("groupInvertSelections", GroupSelector.this.invCb.isSelected());
            }
        });
        this.showOverlappingGroups.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Globals.prefs.putBoolean("groupShowOverlapping", GroupSelector.this.showOverlappingGroups.isSelected());
                if (!GroupSelector.this.showOverlappingGroups.isSelected()) {
                    GroupSelector.this.groupsTree.setHighlight2Cells(null);
                }
            }
        });
        this.select.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Globals.prefs.putBoolean("groupSelectMatches", GroupSelector.this.select.isSelected());
            }
        });
        this.grayOut.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Globals.prefs.putBoolean("grayOutNonHits", GroupSelector.this.grayOut.isSelected());
            }
        });
        JRadioButtonMenuItem jRadioButtonMenuItem = new JRadioButtonMenuItem(Globals.lang("Highlight"), false);
        if (Globals.prefs.getBoolean("groupFloatSelections")) {
            this.floatCb.setSelected(true);
            jRadioButtonMenuItem.setSelected(false);
        } else {
            jRadioButtonMenuItem.setSelected(true);
            this.floatCb.setSelected(false);
        }
        JRadioButtonMenuItem jRadioButtonMenuItem2 = new JRadioButtonMenuItem(Globals.lang("Union"), false);
        if (Globals.prefs.getBoolean("groupIntersectSelections")) {
            this.andCb.setSelected(true);
            jRadioButtonMenuItem2.setSelected(false);
        } else {
            jRadioButtonMenuItem2.setSelected(true);
            this.andCb.setSelected(false);
        }
        this.showNumberOfElements.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Globals.prefs.putBoolean("groupShowNumberOfElements", GroupSelector.this.showNumberOfElements.isSelected());
                if (GroupSelector.this.groupsTree != null) {
                    GroupSelector.this.groupsTree.invalidate();
                    GroupSelector.this.groupsTree.validate();
                    GroupSelector.this.groupsTree.repaint();
                }
            }
        });
        this.autoAssignGroup.addChangeListener(new ChangeListener(){

            @Override
            public void stateChanged(ChangeEvent changeEvent) {
                Globals.prefs.putBoolean("autoAssignGroup", GroupSelector.this.autoAssignGroup.isSelected());
            }
        });
        this.invCb.setSelected(Globals.prefs.getBoolean("groupInvertSelections"));
        this.showOverlappingGroups.setSelected(Globals.prefs.getBoolean("groupShowOverlapping"));
        this.select.setSelected(Globals.prefs.getBoolean("groupSelectMatches"));
        this.editModeIndicator = Globals.prefs.getBoolean("groupEditGroupMembershipMode");
        this.editModeCb.setSelected(this.editModeIndicator);
        this.showNumberOfElements.setSelected(Globals.prefs.getBoolean("groupShowNumberOfElements"));
        this.autoAssignGroup.setSelected(Globals.prefs.getBoolean("autoAssignGroup"));
        this.openset.setMargin(new Insets(0, 0, 0, 0));
        this.settings.add(this.andCb);
        this.settings.add(jRadioButtonMenuItem2);
        this.settings.addSeparator();
        this.settings.add(this.invCb);
        this.settings.addSeparator();
        this.settings.add(this.select);
        this.settings.addSeparator();
        this.settings.add(this.editModeCb);
        this.settings.addSeparator();
        this.settings.add(this.grayOut);
        this.settings.add(this.hideNonHits);
        this.settings.addSeparator();
        this.settings.add(this.showOverlappingGroups);
        this.settings.addSeparator();
        this.settings.add(this.showNumberOfElements);
        this.settings.add(this.autoAssignGroup);
        this.openset.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                if (!GroupSelector.this.settings.isVisible()) {
                    JButton jButton = (JButton)actionEvent.getSource();
                    GroupSelector.this.showNumberOfElements.setSelected(Globals.prefs.getBoolean("groupShowNumberOfElements"));
                    GroupSelector.this.autoAssignGroup.setSelected(Globals.prefs.getBoolean("autoAssignGroup"));
                    GroupSelector.this.settings.show(jButton, 0, GroupSelector.this.openset.getHeight());
                }
            }
        });
        JButton jButton = new JButton(GUIGlobals.getImage("down"));
        jButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = Globals.prefs.getInt("groupsVisibleRows") + 1;
                GroupSelector.this.groupsTree.setVisibleRowCount(n);
                GroupSelector.this.groupsTree.revalidate();
                GroupSelector.this.groupsTree.repaint();
                GroupSelector.this.revalidate();
                GroupSelector.this.repaint();
                Globals.prefs.putInt("groupsVisibleRows", n);
                LOGGER.info("Height: " + GroupSelector.this.getHeight() + "; Preferred height: " + GroupSelector.this.getPreferredSize().getHeight());
            }
        });
        JButton jButton2 = new JButton(GUIGlobals.getImage("up"));
        jButton2.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                int n = Globals.prefs.getInt("groupsVisibleRows") - 1;
                if (n < 1) {
                    n = 1;
                }
                GroupSelector.this.groupsTree.setVisibleRowCount(n);
                GroupSelector.this.groupsTree.revalidate();
                GroupSelector.this.groupsTree.repaint();
                GroupSelector.this.revalidate();
                GroupSelector.this.repaint();
                Globals.prefs.putInt("groupsVisibleRows", n);
            }
        });
        this.editModeCb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                GroupSelector.this.editModeIndicator = GroupSelector.this.editModeCb.getState();
                GroupSelector.this.updateBorder(GroupSelector.this.editModeIndicator);
                Globals.prefs.putBoolean("groupEditGroupMembershipMode", GroupSelector.this.editModeIndicator);
            }
        });
        int n = this.newButton.getIcon().getIconHeight() + 5;
        Dimension dimension = new Dimension(n, n);
        this.newButton.setPreferredSize(dimension);
        this.newButton.setMinimumSize(dimension);
        this.refresh.setPreferredSize(dimension);
        this.refresh.setMinimumSize(dimension);
        JButton jButton3 = new JButton(GUIGlobals.getImage("help"));
        jButton3.setPreferredSize(dimension);
        jButton3.setMinimumSize(dimension);
        this.autoGroup.setPreferredSize(dimension);
        this.autoGroup.setMinimumSize(dimension);
        this.openset.setPreferredSize(dimension);
        this.openset.setMinimumSize(dimension);
        jButton.setPreferredSize(dimension);
        jButton.setMinimumSize(dimension);
        jButton2.setPreferredSize(dimension);
        jButton2.setMinimumSize(dimension);
        Insets insets = new Insets(0, 0, 0, 0);
        jButton3.setMargin(insets);
        jButton2.setMargin(insets);
        jButton.setMargin(insets);
        this.openset.setMargin(insets);
        this.newButton.addActionListener(this);
        this.refresh.addActionListener(this);
        this.andCb.addActionListener(this);
        jRadioButtonMenuItem2.addActionListener(this);
        this.invCb.addActionListener(this);
        this.showOverlappingGroups.addActionListener(this);
        this.autoGroup.addActionListener(this);
        this.floatCb.addActionListener(this);
        jRadioButtonMenuItem.addActionListener(this);
        this.select.addActionListener(this);
        this.hideNonHits.addActionListener(this);
        this.grayOut.addActionListener(this);
        this.newButton.setToolTipText(Globals.lang("New group"));
        this.refresh.setToolTipText(Globals.lang("Refresh view"));
        this.andCb.setToolTipText(Globals.lang("Display only entries belonging to all selected groups."));
        jRadioButtonMenuItem2.setToolTipText(Globals.lang("Display all entries belonging to one or more of the selected groups."));
        this.autoGroup.setToolTipText(Globals.lang("Automatically create groups for database."));
        this.invCb.setToolTipText(Globals.lang("Show entries *not* in group selection"));
        this.showOverlappingGroups.setToolTipText("Highlight groups that contain entries contained in any currently selected group");
        this.floatCb.setToolTipText(Globals.lang("Move entries in group selection to the top"));
        jRadioButtonMenuItem.setToolTipText(Globals.lang("Gray out entries not in group selection"));
        this.select.setToolTipText(Globals.lang("Select entries in group selection"));
        jButton.setToolTipText(Globals.lang("Show one more row"));
        jButton2.setToolTipText(Globals.lang("Show one less rows"));
        this.editModeCb.setToolTipText(Globals.lang("Click group to toggle membership of selected entries"));
        ButtonGroup buttonGroup2 = new ButtonGroup();
        buttonGroup2.add(this.andCb);
        buttonGroup2.add(jRadioButtonMenuItem2);
        ButtonGroup buttonGroup3 = new ButtonGroup();
        buttonGroup3.add(this.floatCb);
        buttonGroup3.add(jRadioButtonMenuItem);
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagLayout.setConstraints(this.newButton, gridBagConstraints);
        jPanel.add(this.newButton);
        gridBagConstraints.gridx = 1;
        gridBagLayout.setConstraints(this.refresh, gridBagConstraints);
        jPanel.add(this.refresh);
        gridBagConstraints.gridx = 2;
        gridBagLayout.setConstraints(this.autoGroup, gridBagConstraints);
        jPanel.add(this.autoGroup);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridwidth = 0;
        HelpAction helpAction = new HelpAction(jabRefFrame.helpDiag, "GroupsHelp.html", "Help on groups");
        jButton3.addActionListener(helpAction);
        jButton3.setToolTipText(Globals.lang("Help on groups"));
        gridBagLayout.setConstraints(jButton3, gridBagConstraints);
        jPanel.add(jButton3);
        this.groupsTree = new GroupsTree(this);
        this.groupsTree.addTreeSelectionListener(this);
        this.groupsTreeModel = new DefaultTreeModel(this.groupsRoot);
        this.groupsTree.setModel(this.groupsTreeModel);
        JScrollPane jScrollPane = new JScrollPane(this.groupsTree, 20, 30);
        this.revalidateGroups();
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridy = 1;
        gridBagLayout.setConstraints(jScrollPane, gridBagConstraints);
        jPanel.add(jScrollPane);
        JPanel jPanel2 = new JPanel();
        GridBagLayout gridBagLayout2 = new GridBagLayout();
        gridBagConstraints.weighty = 0.0;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel2.setLayout(gridBagLayout2);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.fill = 2;
        gridBagLayout2.setConstraints(this.openset, gridBagConstraints);
        jPanel2.add(this.openset);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 4;
        gridBagConstraints.gridy = 0;
        gridBagLayout2.setConstraints(jButton, gridBagConstraints);
        jPanel2.add(jButton);
        gridBagConstraints.gridx = 5;
        gridBagLayout2.setConstraints(jButton2, gridBagConstraints);
        jPanel2.add(jButton2);
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagLayout.setConstraints(jPanel2, gridBagConstraints);
        jPanel.add(jPanel2);
        jPanel.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        this.add((Component)jPanel, "Center");
        this.updateBorder(this.editModeIndicator);
        this.definePopup();
        MoveNodeUpAction moveNodeUpAction = new MoveNodeUpAction();
        moveNodeUpAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(38, 2));
        MoveNodeDownAction moveNodeDownAction = new MoveNodeDownAction();
        moveNodeDownAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(40, 2));
        MoveNodeLeftAction moveNodeLeftAction = new MoveNodeLeftAction();
        moveNodeLeftAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(37, 2));
        MoveNodeRightAction moveNodeRightAction = new MoveNodeRightAction();
        moveNodeRightAction.putValue("AcceleratorKey", KeyStroke.getKeyStroke(39, 2));
    }

    private void definePopup() {
        this.groupsContextMenu.add(this.editGroupPopupAction);
        this.groupsContextMenu.add(this.addGroupPopupAction);
        this.groupsContextMenu.add(this.addSubgroupPopupAction);
        this.groupsContextMenu.addSeparator();
        this.groupsContextMenu.add(this.removeGroupAndSubgroupsPopupAction);
        this.groupsContextMenu.add(this.removeGroupKeepSubgroupsPopupAction);
        this.groupsContextMenu.add(this.removeSubgroupsPopupAction);
        this.groupsContextMenu.addSeparator();
        this.groupsContextMenu.add(this.expandSubtreePopupAction);
        this.groupsContextMenu.add(this.collapseSubtreePopupAction);
        this.groupsContextMenu.addSeparator();
        this.groupsContextMenu.add(this.moveSubmenu);
        this.sortSubmenu.add(this.sortDirectSubgroupsPopupAction);
        this.sortSubmenu.add(this.sortAllSubgroupsPopupAction);
        this.groupsContextMenu.add(this.sortSubmenu);
        this.moveSubmenu.add(this.moveNodeUpPopupAction);
        this.moveSubmenu.add(this.moveNodeDownPopupAction);
        this.moveSubmenu.add(this.moveNodeLeftPopupAction);
        this.moveSubmenu.add(this.moveNodeRightPopupAction);
        this.groupsContextMenu.addSeparator();
        this.groupsContextMenu.add(this.addToGroup);
        this.groupsContextMenu.add(this.moveToGroup);
        this.groupsContextMenu.add(this.removeFromGroup);
        this.groupsTree.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    GroupSelector.this.showPopup(mouseEvent);
                }
            }

            @Override
            public void mouseReleased(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    GroupSelector.this.showPopup(mouseEvent);
                }
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                TreePath treePath = GroupSelector.this.groupsTree.getPathForLocation(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
                if (treePath == null) {
                    return;
                }
                GroupTreeNode groupTreeNode = (GroupTreeNode)treePath.getLastPathComponent();
                if (groupTreeNode.isRoot()) {
                    return;
                }
                if (mouseEvent.getClickCount() == 2 && mouseEvent.getButton() == 1) {
                    GroupSelector.this.editGroupAction.actionPerformed(null);
                } else if (mouseEvent.getClickCount() == 1 && mouseEvent.getButton() == 1) {
                    GroupSelector.this.annotationEvent(groupTreeNode);
                }
            }
        });
        this.groupsContextMenu.addPopupMenuListener(new PopupMenuListener(){

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent popupMenuEvent) {
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent popupMenuEvent) {
                GroupSelector.this.groupsTree.setHighlightBorderCell(null);
            }

            @Override
            public void popupMenuCanceled(PopupMenuEvent popupMenuEvent) {
                GroupSelector.this.groupsTree.setHighlightBorderCell(null);
            }
        });
    }

    private void showPopup(MouseEvent mouseEvent) {
        TreePath treePath = this.groupsTree.getPathForLocation(mouseEvent.getPoint().x, mouseEvent.getPoint().y);
        this.addGroupPopupAction.setEnabled(true);
        this.addSubgroupPopupAction.setEnabled(treePath != null);
        this.editGroupPopupAction.setEnabled(treePath != null);
        this.removeGroupAndSubgroupsPopupAction.setEnabled(treePath != null);
        this.removeGroupKeepSubgroupsPopupAction.setEnabled(treePath != null);
        this.moveSubmenu.setEnabled(treePath != null);
        this.expandSubtreePopupAction.setEnabled(treePath != null);
        this.collapseSubtreePopupAction.setEnabled(treePath != null);
        this.removeSubgroupsPopupAction.setEnabled(treePath != null);
        this.sortSubmenu.setEnabled(treePath != null);
        this.addToGroup.setEnabled(false);
        this.moveToGroup.setEnabled(false);
        this.removeFromGroup.setEnabled(false);
        if (treePath != null) {
            GroupTreeNode groupTreeNode = (GroupTreeNode)treePath.getLastPathComponent();
            this.editGroupPopupAction.setNode(groupTreeNode);
            this.addSubgroupPopupAction.setNode(groupTreeNode);
            this.removeGroupAndSubgroupsPopupAction.setNode(groupTreeNode);
            this.removeSubgroupsPopupAction.setNode(groupTreeNode);
            this.removeGroupKeepSubgroupsPopupAction.setNode(groupTreeNode);
            this.expandSubtreePopupAction.setNode(groupTreeNode);
            this.collapseSubtreePopupAction.setNode(groupTreeNode);
            this.sortDirectSubgroupsPopupAction.setNode(groupTreeNode);
            this.sortAllSubgroupsPopupAction.setNode(groupTreeNode);
            this.groupsTree.setHighlightBorderCell(groupTreeNode);
            AbstractGroup abstractGroup = groupTreeNode.getGroup();
            if (abstractGroup instanceof AllEntriesGroup) {
                this.editGroupPopupAction.setEnabled(false);
                this.addGroupPopupAction.setEnabled(false);
                this.removeGroupAndSubgroupsPopupAction.setEnabled(false);
                this.removeGroupKeepSubgroupsPopupAction.setEnabled(false);
            } else {
                this.editGroupPopupAction.setEnabled(true);
                this.addGroupPopupAction.setEnabled(true);
                this.addGroupPopupAction.setNode(groupTreeNode);
                this.removeGroupAndSubgroupsPopupAction.setEnabled(true);
                this.removeGroupKeepSubgroupsPopupAction.setEnabled(true);
            }
            this.expandSubtreePopupAction.setEnabled(this.groupsTree.isCollapsed(treePath) || this.groupsTree.hasCollapsedDescendant(treePath));
            this.collapseSubtreePopupAction.setEnabled(this.groupsTree.isExpanded(treePath) || this.groupsTree.hasExpandedDescendant(treePath));
            this.sortSubmenu.setEnabled(!groupTreeNode.isLeaf());
            this.removeSubgroupsPopupAction.setEnabled(!groupTreeNode.isLeaf());
            this.moveNodeUpPopupAction.setEnabled(groupTreeNode.canMoveUp());
            this.moveNodeDownPopupAction.setEnabled(groupTreeNode.canMoveDown());
            this.moveNodeLeftPopupAction.setEnabled(groupTreeNode.canMoveLeft());
            this.moveNodeRightPopupAction.setEnabled(groupTreeNode.canMoveRight());
            this.moveSubmenu.setEnabled(this.moveNodeUpPopupAction.isEnabled() || this.moveNodeDownPopupAction.isEnabled() || this.moveNodeLeftPopupAction.isEnabled() || this.moveNodeRightPopupAction.isEnabled());
            this.moveNodeUpPopupAction.setNode(groupTreeNode);
            this.moveNodeDownPopupAction.setNode(groupTreeNode);
            this.moveNodeLeftPopupAction.setNode(groupTreeNode);
            this.moveNodeRightPopupAction.setNode(groupTreeNode);
            BibtexEntry[] bibtexEntryArray = this.frame.basePanel().getSelectedEntries();
            if (bibtexEntryArray.length > 0) {
                if (groupTreeNode.getGroup().supportsAdd() && !groupTreeNode.getGroup().containsAll(bibtexEntryArray)) {
                    this.addToGroup.setNode(groupTreeNode);
                    this.addToGroup.setBasePanel(this.panel);
                    this.addToGroup.setEnabled(true);
                    this.moveToGroup.setNode(groupTreeNode);
                    this.moveToGroup.setBasePanel(this.panel);
                    this.moveToGroup.setEnabled(true);
                }
                if (groupTreeNode.getGroup().supportsRemove() && groupTreeNode.getGroup().containsAny(bibtexEntryArray)) {
                    this.removeFromGroup.setNode(groupTreeNode);
                    this.removeFromGroup.setBasePanel(this.panel);
                    this.removeFromGroup.setEnabled(true);
                }
            }
        } else {
            this.editGroupPopupAction.setNode(null);
            this.addGroupPopupAction.setNode(null);
            this.addSubgroupPopupAction.setNode(null);
            this.removeGroupAndSubgroupsPopupAction.setNode(null);
            this.removeSubgroupsPopupAction.setNode(null);
            this.removeGroupKeepSubgroupsPopupAction.setNode(null);
            this.moveNodeUpPopupAction.setNode(null);
            this.moveNodeDownPopupAction.setNode(null);
            this.moveNodeLeftPopupAction.setNode(null);
            this.moveNodeRightPopupAction.setNode(null);
            this.expandSubtreePopupAction.setNode(null);
            this.collapseSubtreePopupAction.setNode(null);
            this.sortDirectSubgroupsPopupAction.setNode(null);
            this.sortAllSubgroupsPopupAction.setNode(null);
        }
        this.groupsContextMenu.show(this.groupsTree, mouseEvent.getPoint().x, mouseEvent.getPoint().y);
    }

    private void updateBorder(boolean bl) {
        if (bl) {
            this.groupsTree.setBorder(this.editModeBorder);
            this.setTitle("<html><font color='red'>Groups Edit mode</font></html>");
        } else {
            this.groupsTree.setBorder(null);
            this.setTitle(Globals.lang("Groups"));
        }
        this.groupsTree.revalidate();
        this.groupsTree.repaint();
    }

    private void updateGroupContent(GroupTreeNode groupTreeNode) {
        BibtexEntry[] bibtexEntryArray = this.panel.getSelectedEntries();
        AbstractGroup abstractGroup = groupTreeNode.getGroup();
        AbstractUndoableEdit abstractUndoableEdit = null;
        AbstractUndoableEdit abstractUndoableEdit2 = null;
        ArrayList<BibtexEntry> arrayList = new ArrayList<BibtexEntry>(bibtexEntryArray.length);
        ArrayList<BibtexEntry> arrayList2 = new ArrayList<BibtexEntry>(bibtexEntryArray.length);
        for (BibtexEntry bibtexEntry : bibtexEntryArray) {
            if (abstractGroup.contains(bibtexEntry)) {
                LOGGER.info("Removing entry " + bibtexEntry.toString());
                arrayList.add(bibtexEntry);
                continue;
            }
            LOGGER.info("Adding entry " + bibtexEntry.toString());
            arrayList2.add(bibtexEntry);
        }
        if (!arrayList.isEmpty()) {
            abstractUndoableEdit = groupTreeNode.removeFromGroup(arrayList.toArray(new BibtexEntry[arrayList.size()]));
        }
        if (!arrayList2.isEmpty()) {
            abstractUndoableEdit2 = groupTreeNode.addToGroup(arrayList2.toArray(new BibtexEntry[arrayList2.size()]));
        }
        if (abstractUndoableEdit != null) {
            if (abstractUndoableEdit2 != null) {
                abstractUndoableEdit.addEdit(abstractUndoableEdit2);
            }
            this.panel.undoManager.addEdit(abstractUndoableEdit);
        } else if (abstractUndoableEdit2 != null) {
            this.panel.undoManager.addEdit(abstractUndoableEdit2);
        }
    }

    public void updateGroupContentIfEnabled(boolean bl) {
        if (this.groupsTree == null || this.groupsTree.getSelectionCount() == 0) {
            return;
        }
        if (!this.editModeIndicator) {
            return;
        }
        GroupTreeNode groupTreeNode = (GroupTreeNode)this.groupsTree.getSelectionPaths()[0].getLastPathComponent();
        this.updateGroupContent(groupTreeNode);
    }

    private void annotationEvent(GroupTreeNode groupTreeNode) {
        LOGGER.info("Performing annotation " + groupTreeNode.toString());
        if (this.editModeIndicator) {
            this.updateGroupContent(groupTreeNode);
            this.panel.markBaseChanged();
            this.panel.updateEntryEditorIfShowing();
            this.updateSelections();
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
        if (this.panel == null) {
            return;
        }
        TreePath[] treePathArray = this.groupsTree.getSelectionPaths();
        if (treePathArray == null || treePathArray.length == 0 || treePathArray.length == 1 && ((GroupTreeNode)treePathArray[0].getLastPathComponent()).getGroup() instanceof AllEntriesGroup) {
            this.panel.stopShowingGroup();
            this.panel.mainTable.stopShowingFloatGrouping();
            if (this.showOverlappingGroups.isSelected()) {
                this.groupsTree.setHighlight2Cells(null);
            }
            this.frame.output(Globals.lang("Displaying no groups") + ".");
            return;
        }
        if (!this.editModeIndicator) {
            this.updateSelections();
        }
    }

    private void updateSelections() {
        TreePath[] treePathArray;
        SearchRuleSet searchRuleSet = SearchRuleSets.build(this.andCb.isSelected() ? SearchRuleSets.RuleSetType.AND : SearchRuleSets.RuleSetType.OR);
        for (TreePath treePath : treePathArray = this.groupsTree.getSelectionPaths()) {
            SearchRule searchRule = ((GroupTreeNode)treePath.getLastPathComponent()).getSearchRule();
            searchRuleSet.addRule(searchRule);
        }
        SearchRule searchRule = this.invCb.isSelected() ? new InvertSearchRule(searchRuleSet) : searchRuleSet;
        GroupingWorker groupingWorker = new GroupingWorker(searchRule, "dummy");
        groupingWorker.getWorker().run();
        groupingWorker.getCallBack().update();
    }

    public void revalidateGroups(TreePath[] treePathArray, Enumeration<TreePath> enumeration) {
        this.revalidateGroups(treePathArray, enumeration, null);
    }

    private void revalidateGroups(TreePath[] treePathArray, Enumeration<TreePath> enumeration, GroupTreeNode groupTreeNode) {
        this.groupsTreeModel.reload();
        this.groupsTree.clearSelection();
        if (treePathArray != null) {
            this.groupsTree.setSelectionPaths(treePathArray);
        }
        if (enumeration != null) {
            while (enumeration.hasMoreElements()) {
                this.groupsTree.expandPath(enumeration.nextElement());
            }
        }
        this.groupsTree.revalidate();
        if (groupTreeNode != null) {
            this.groupsTree.scrollPathToVisible(new TreePath(groupTreeNode.getPath()));
        }
    }

    public void revalidateGroups() {
        this.revalidateGroups(null);
    }

    private void revalidateGroups(GroupTreeNode groupTreeNode) {
        this.revalidateGroups(this.groupsTree.getSelectionPaths(), this.getExpandedPaths(), groupTreeNode);
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() == this.refresh) {
            this.valueChanged(null);
        } else if (actionEvent.getSource() == this.newButton) {
            GroupDialog groupDialog = new GroupDialog(this.frame, this.panel, null);
            groupDialog.setVisible(true);
            if (groupDialog.okPressed()) {
                AbstractGroup abstractGroup = groupDialog.getResultingGroup();
                GroupTreeNode groupTreeNode = new GroupTreeNode(abstractGroup);
                this.groupsRoot.add(groupTreeNode);
                this.revalidateGroups();
                UndoableAddOrRemoveGroup undoableAddOrRemoveGroup = new UndoableAddOrRemoveGroup(this, this.groupsRoot, groupTreeNode, 0);
                this.panel.undoManager.addEdit(undoableAddOrRemoveGroup);
                this.panel.markBaseChanged();
                this.frame.output(Globals.lang("Created_group_\"%0\".", abstractGroup.getName()));
            }
        } else if (actionEvent.getSource() == this.autoGroup) {
            AutoGroupDialog autoGroupDialog = new AutoGroupDialog(this.frame, this.panel, this, this.groupsRoot, Globals.prefs.get("groupsDefaultField"), " .,", ",");
            autoGroupDialog.setVisible(true);
        } else if (actionEvent.getSource() instanceof JCheckBox) {
            this.valueChanged(null);
        } else if (actionEvent.getSource() instanceof JCheckBoxMenuItem) {
            this.valueChanged(null);
        } else if (actionEvent.getSource() instanceof JRadioButtonMenuItem) {
            this.valueChanged(null);
        }
    }

    @Override
    public void componentOpening() {
        this.valueChanged(null);
    }

    @Override
    public void componentClosing() {
        if (this.panel != null) {
            this.panel.stopShowingGroup();
            this.panel.mainTable.stopShowingFloatGrouping();
        }
        this.frame.groupToggle.setSelected(false);
    }

    private void setGroups(GroupTreeNode groupTreeNode) {
        this.groupsTreeModel = new DefaultTreeModel(groupTreeNode);
        this.groupsTree.setModel(this.groupsTreeModel);
        this.groupsRoot = groupTreeNode;
        if (Globals.prefs.getBoolean("groupExpandTree")) {
            this.groupsTree.expandSubtree(groupTreeNode);
        }
    }

    public void addGroups(GroupTreeNode groupTreeNode, CompoundEdit compoundEdit) {
        if (groupTreeNode.getGroup() instanceof AllEntriesGroup) {
            return;
        }
        this.groupsRoot.add(groupTreeNode);
        UndoableAddOrRemoveGroup undoableAddOrRemoveGroup = new UndoableAddOrRemoveGroup(this, this.groupsRoot, groupTreeNode, 0);
        compoundEdit.addEdit(undoableAddOrRemoveGroup);
    }

    public TreePath getSelectionPath() {
        return this.groupsTree.getSelectionPath();
    }

    public boolean moveNodeUp(GroupTreeNode groupTreeNode, boolean bl) {
        AbstractUndoableEdit abstractUndoableEdit;
        if (bl && this.groupsTree.getSelectionCount() != 1) {
            this.frame.output(Globals.lang("Please select exactly one group to move."));
            return false;
        }
        if (!groupTreeNode.canMoveUp() || (abstractUndoableEdit = groupTreeNode.moveUp(this)) == null) {
            this.frame.output(Globals.lang("Cannot move group \"%0\" up.", groupTreeNode.getGroup().getName()));
            return false;
        }
        this.revalidateGroups(this.groupsTree.refreshPaths(this.groupsTree.getSelectionPaths()), this.groupsTree.refreshPaths(this.getExpandedPaths()));
        this.concludeMoveGroup(abstractUndoableEdit, groupTreeNode);
        return true;
    }

    public boolean moveNodeDown(GroupTreeNode groupTreeNode, boolean bl) {
        AbstractUndoableEdit abstractUndoableEdit;
        if (bl && this.groupsTree.getSelectionCount() != 1) {
            this.frame.output(Globals.lang("Please select exactly one group to move."));
            return false;
        }
        if (!groupTreeNode.canMoveDown() || (abstractUndoableEdit = groupTreeNode.moveDown(this)) == null) {
            this.frame.output(Globals.lang("Cannot move group \"%0\" down.", groupTreeNode.getGroup().getName()));
            return false;
        }
        this.revalidateGroups(this.groupsTree.refreshPaths(this.groupsTree.getSelectionPaths()), this.groupsTree.refreshPaths(this.getExpandedPaths()));
        this.concludeMoveGroup(abstractUndoableEdit, groupTreeNode);
        return true;
    }

    public boolean moveNodeLeft(GroupTreeNode groupTreeNode, boolean bl) {
        AbstractUndoableEdit abstractUndoableEdit;
        if (bl && this.groupsTree.getSelectionCount() != 1) {
            this.frame.output(Globals.lang("Please select exactly one group to move."));
            return false;
        }
        if (!groupTreeNode.canMoveLeft() || (abstractUndoableEdit = groupTreeNode.moveLeft(this)) == null) {
            this.frame.output(Globals.lang("Cannot move group \"%0\" left.", groupTreeNode.getGroup().getName()));
            return false;
        }
        this.revalidateGroups(this.groupsTree.refreshPaths(this.groupsTree.getSelectionPaths()), this.groupsTree.refreshPaths(this.getExpandedPaths()));
        this.concludeMoveGroup(abstractUndoableEdit, groupTreeNode);
        return true;
    }

    public boolean moveNodeRight(GroupTreeNode groupTreeNode, boolean bl) {
        AbstractUndoableEdit abstractUndoableEdit;
        if (bl && this.groupsTree.getSelectionCount() != 1) {
            this.frame.output(Globals.lang("Please select exactly one group to move."));
            return false;
        }
        if (!groupTreeNode.canMoveRight() || (abstractUndoableEdit = groupTreeNode.moveRight(this)) == null) {
            this.frame.output(Globals.lang("Cannot move group \"%0\" right.", groupTreeNode.getGroup().getName()));
            return false;
        }
        this.revalidateGroups(this.groupsTree.refreshPaths(this.groupsTree.getSelectionPaths()), this.groupsTree.refreshPaths(this.getExpandedPaths()));
        this.concludeMoveGroup(abstractUndoableEdit, groupTreeNode);
        return true;
    }

    public void concludeMoveGroup(AbstractUndoableEdit abstractUndoableEdit, GroupTreeNode groupTreeNode) {
        this.panel.undoManager.addEdit(abstractUndoableEdit);
        this.panel.markBaseChanged();
        this.frame.output(Globals.lang("Moved group \"%0\".", groupTreeNode.getGroup().getName()));
    }

    public void concludeAssignment(AbstractUndoableEdit abstractUndoableEdit, GroupTreeNode groupTreeNode, int n) {
        if (abstractUndoableEdit == null) {
            this.frame.output(Globals.lang("The group \"%0\" already contains the selection.", new String[]{groupTreeNode.getGroup().getName()}));
            return;
        }
        this.panel.undoManager.addEdit(abstractUndoableEdit);
        this.panel.markBaseChanged();
        this.panel.updateEntryEditorIfShowing();
        String string = groupTreeNode.getGroup().getName();
        if (n == 1) {
            this.frame.output(Globals.lang("Assigned 1 entry to group \"%0\".", string));
        } else {
            this.frame.output(Globals.lang("Assigned %0 entries to group \"%1\".", String.valueOf(n), string));
        }
    }

    public GroupTreeNode getGroupTreeRoot() {
        return this.groupsRoot;
    }

    public Enumeration<TreePath> getExpandedPaths() {
        return this.groupsTree.getExpandedDescendants(new TreePath(this.groupsRoot.getPath()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setActiveBasePanel(BasePanel basePanel) {
        Object object;
        super.setActiveBasePanel(basePanel);
        if (basePanel == null) {
            this.frame.sidePaneManager.hide("groups");
            return;
        }
        MetaData metaData = basePanel.metaData();
        if (metaData.getGroups() != null) {
            this.setGroups(metaData.getGroups());
        } else {
            object = new GroupTreeNode(new AllEntriesGroup());
            metaData.setGroups((GroupTreeNode)object);
            this.setGroups((GroupTreeNode)object);
        }
        if (Globals.prefs.getBoolean("groupAutoShow") && !this.groupsRoot.isLeaf()) {
            this.frame.sidePaneManager.show("groups");
            this.frame.groupToggle.setSelected(true);
        } else if (Globals.prefs.getBoolean("groupAutoHide") && this.groupsRoot.isLeaf()) {
            this.frame.sidePaneManager.hide("groups");
            this.frame.groupToggle.setSelected(false);
        }
        object = this.getTreeLock();
        synchronized (object) {
            this.validateTree();
        }
    }

    public void showMatchingGroups(BibtexEntry[] bibtexEntryArray, boolean bl) {
        GroupTreeNode groupTreeNode;
        if (bibtexEntryArray == null || bibtexEntryArray.length == 0) {
            this.groupsTree.setHighlight3Cells(null);
            this.groupsTree.revalidate();
            return;
        }
        Vector<GroupTreeNode> vector = new Vector<GroupTreeNode>();
        Enumeration<GroupTreeNode> enumeration = this.groupsRoot.preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            int n;
            groupTreeNode = enumeration.nextElement();
            AbstractGroup abstractGroup = groupTreeNode.getGroup();
            for (n = 0; n < bibtexEntryArray.length; ++n) {
                if (bl) {
                    if (abstractGroup.contains(bibtexEntryArray[n])) continue;
                    break;
                }
                if (!abstractGroup.contains(bibtexEntryArray[n])) continue;
                vector.add(groupTreeNode);
            }
            if (!bl || n < bibtexEntryArray.length) continue;
            vector.add(groupTreeNode);
        }
        this.groupsTree.setHighlight3Cells(vector.toArray());
        for (int i = 0; i < vector.size(); ++i) {
            groupTreeNode = (GroupTreeNode)((GroupTreeNode)vector.elementAt(i)).getParent();
            if (groupTreeNode == null) continue;
            this.groupsTree.expandPath(new TreePath(groupTreeNode.getPath()));
        }
        this.groupsTree.revalidate();
    }

    private void showOverlappingGroups(List<BibtexEntry> list) {
        ArrayList<GroupTreeNode> arrayList = new ArrayList<GroupTreeNode>();
        Enumeration<GroupTreeNode> enumeration = this.groupsRoot.depthFirstEnumeration();
        block0: while (enumeration.hasMoreElements()) {
            GroupTreeNode groupTreeNode = enumeration.nextElement();
            SearchRule searchRule = groupTreeNode.getSearchRule();
            for (BibtexEntry bibtexEntry : list) {
                if (!searchRule.applyRule("dummy", bibtexEntry)) continue;
                arrayList.add(groupTreeNode);
                continue block0;
            }
        }
        this.groupsTree.setHighlight2Cells(arrayList.toArray());
    }

    public GroupsTree getGroupsTree() {
        return this.groupsTree;
    }

    private class MoveNodeRightAction
    extends NodeAction {
        public MoveNodeRightAction() {
            super(Globals.lang("Right"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GroupTreeNode groupTreeNode = this.getNodeToUse();
            GroupSelector.this.moveNodeRight(groupTreeNode, false);
        }
    }

    private class MoveNodeLeftAction
    extends NodeAction {
        public MoveNodeLeftAction() {
            super(Globals.lang("Left"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GroupTreeNode groupTreeNode = this.getNodeToUse();
            GroupSelector.this.moveNodeLeft(groupTreeNode, false);
        }
    }

    private class MoveNodeDownAction
    extends NodeAction {
        public MoveNodeDownAction() {
            super(Globals.lang("Down"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GroupTreeNode groupTreeNode = this.getNodeToUse();
            GroupSelector.this.moveNodeDown(groupTreeNode, false);
        }
    }

    private class MoveNodeUpAction
    extends NodeAction {
        public MoveNodeUpAction() {
            super(Globals.lang("Up"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GroupTreeNode groupTreeNode = this.getNodeToUse();
            GroupSelector.this.moveNodeUp(groupTreeNode, false);
        }
    }

    private class CollapseSubtreeAction
    extends NodeAction {
        public CollapseSubtreeAction() {
            super(Globals.lang("Collapse subtree"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GroupTreeNode groupTreeNode = this.getNodeToUse();
            TreePath treePath = new TreePath(groupTreeNode.getPath());
            GroupSelector.this.groupsTree.collapseSubtree((GroupTreeNode)treePath.getLastPathComponent());
            GroupSelector.this.revalidateGroups();
        }
    }

    private class ExpandSubtreeAction
    extends NodeAction {
        public ExpandSubtreeAction() {
            super(Globals.lang("Expand subtree"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GroupTreeNode groupTreeNode = this.getNodeToUse();
            TreePath treePath = new TreePath(groupTreeNode.getPath());
            GroupSelector.this.groupsTree.expandSubtree((GroupTreeNode)treePath.getLastPathComponent());
            GroupSelector.this.revalidateGroups();
        }
    }

    private class SortAllSubgroupsAction
    extends NodeAction {
        public SortAllSubgroupsAction() {
            super(Globals.lang("All subgroups (recursively)"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GroupTreeNode groupTreeNode = this.getNodeToUse();
            UndoableModifySubtree undoableModifySubtree = new UndoableModifySubtree(GroupSelector.this, GroupSelector.this.getGroupTreeRoot(), groupTreeNode, Globals.lang("sort subgroups"));
            GroupSelector.this.groupsTree.sort(groupTreeNode, true);
            ((GroupSelector)GroupSelector.this).panel.undoManager.addEdit(undoableModifySubtree);
            GroupSelector.this.panel.markBaseChanged();
            GroupSelector.this.frame.output(Globals.lang("Sorted all subgroups recursively."));
        }
    }

    private class SortDirectSubgroupsAction
    extends NodeAction {
        public SortDirectSubgroupsAction() {
            super(Globals.lang("Immediate subgroups"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GroupTreeNode groupTreeNode = this.getNodeToUse();
            UndoableModifySubtree undoableModifySubtree = new UndoableModifySubtree(GroupSelector.this, GroupSelector.this.getGroupTreeRoot(), groupTreeNode, Globals.lang("sort subgroups"));
            GroupSelector.this.groupsTree.sort(groupTreeNode, false);
            ((GroupSelector)GroupSelector.this).panel.undoManager.addEdit(undoableModifySubtree);
            GroupSelector.this.panel.markBaseChanged();
            GroupSelector.this.frame.output(Globals.lang("Sorted immediate subgroups."));
        }
    }

    private class RemoveGroupKeepSubgroupsAction
    extends NodeAction {
        public RemoveGroupKeepSubgroupsAction() {
            super(Globals.lang("Remove group, keep subgroups"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GroupTreeNode groupTreeNode = this.getNodeToUse();
            AbstractGroup abstractGroup = groupTreeNode.getGroup();
            int n = JOptionPane.showConfirmDialog(GroupSelector.this.frame, Globals.lang("Remove group \"%0\"?", abstractGroup.getName()), Globals.lang("Remove group"), 0);
            if (n == 0) {
                UndoableAddOrRemoveGroup undoableAddOrRemoveGroup = new UndoableAddOrRemoveGroup(GroupSelector.this, GroupSelector.this.groupsRoot, groupTreeNode, 1);
                GroupTreeNode groupTreeNode2 = (GroupTreeNode)groupTreeNode.getParent();
                int n2 = groupTreeNode2.getIndex(groupTreeNode);
                groupTreeNode.removeFromParent();
                while (groupTreeNode.getChildCount() > 0) {
                    groupTreeNode2.insert((GroupTreeNode)groupTreeNode.getFirstChild(), n2);
                }
                GroupSelector.this.revalidateGroups();
                ((GroupSelector)GroupSelector.this).panel.undoManager.addEdit(undoableAddOrRemoveGroup);
                GroupSelector.this.panel.markBaseChanged();
                GroupSelector.this.frame.output(Globals.lang("Removed group \"%0\".", abstractGroup.getName()));
            }
        }
    }

    private class RemoveSubgroupsAction
    extends NodeAction {
        public RemoveSubgroupsAction() {
            super(Globals.lang("Remove all subgroups"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GroupTreeNode groupTreeNode = this.getNodeToUse();
            AbstractGroup abstractGroup = groupTreeNode.getGroup();
            int n = JOptionPane.showConfirmDialog(GroupSelector.this.frame, Globals.lang("Remove all subgroups of \"%0\"?", abstractGroup.getName()), Globals.lang("Remove all subgroups"), 0);
            if (n == 0) {
                UndoableModifySubtree undoableModifySubtree = new UndoableModifySubtree(GroupSelector.this, GroupSelector.this.getGroupTreeRoot(), groupTreeNode, "Remove all subgroups");
                groupTreeNode.removeAllChildren();
                GroupSelector.this.revalidateGroups();
                ((GroupSelector)GroupSelector.this).panel.undoManager.addEdit(undoableModifySubtree);
                GroupSelector.this.panel.markBaseChanged();
                GroupSelector.this.frame.output(Globals.lang("Removed all subgroups of group \"%0\".", abstractGroup.getName()));
            }
        }
    }

    private class RemoveGroupAndSubgroupsAction
    extends NodeAction {
        public RemoveGroupAndSubgroupsAction() {
            super(Globals.lang("Remove group and subgroups"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GroupTreeNode groupTreeNode = this.getNodeToUse();
            AbstractGroup abstractGroup = groupTreeNode.getGroup();
            int n = JOptionPane.showConfirmDialog(GroupSelector.this.frame, Globals.lang("Remove group \"%0\" and its subgroups?", abstractGroup.getName()), Globals.lang("Remove group and subgroups"), 0);
            if (n == 0) {
                UndoableAddOrRemoveGroup undoableAddOrRemoveGroup = new UndoableAddOrRemoveGroup(GroupSelector.this, GroupSelector.this.groupsRoot, groupTreeNode, 2);
                groupTreeNode.removeFromParent();
                GroupSelector.this.revalidateGroups();
                ((GroupSelector)GroupSelector.this).panel.undoManager.addEdit(undoableAddOrRemoveGroup);
                GroupSelector.this.panel.markBaseChanged();
                GroupSelector.this.frame.output(Globals.lang("Removed group \"%0\" and its subgroups.", abstractGroup.getName()));
            }
        }
    }

    private class AddSubgroupAction
    extends NodeAction {
        public AddSubgroupAction() {
            super(Globals.lang("Add Subgroup"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GroupTreeNode groupTreeNode = this.getNodeToUse();
            GroupDialog groupDialog = new GroupDialog(GroupSelector.this.frame, GroupSelector.this.panel, null);
            groupDialog.setVisible(true);
            if (!groupDialog.okPressed()) {
                return;
            }
            AbstractGroup abstractGroup = groupDialog.getResultingGroup();
            GroupTreeNode groupTreeNode2 = new GroupTreeNode(abstractGroup);
            groupTreeNode.add(groupTreeNode2);
            UndoableAddOrRemoveGroup undoableAddOrRemoveGroup = new UndoableAddOrRemoveGroup(GroupSelector.this, GroupSelector.this.groupsRoot, groupTreeNode2, 0);
            GroupSelector.this.revalidateGroups();
            GroupSelector.this.groupsTree.expandPath(new TreePath(groupTreeNode.getPath()));
            ((GroupSelector)GroupSelector.this).panel.undoManager.addEdit(undoableAddOrRemoveGroup);
            GroupSelector.this.panel.markBaseChanged();
            GroupSelector.this.frame.output(Globals.lang("Added group \"%0\".", abstractGroup.getName()));
        }
    }

    private class AddGroupAction
    extends NodeAction {
        public AddGroupAction() {
            super(Globals.lang("Add Group"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GroupTreeNode groupTreeNode = this.getNodeToUse();
            GroupDialog groupDialog = new GroupDialog(GroupSelector.this.frame, GroupSelector.this.panel, null);
            groupDialog.setVisible(true);
            if (!groupDialog.okPressed()) {
                return;
            }
            AbstractGroup abstractGroup = groupDialog.getResultingGroup();
            GroupTreeNode groupTreeNode2 = new GroupTreeNode(abstractGroup);
            if (groupTreeNode == null) {
                GroupSelector.this.groupsRoot.add(groupTreeNode2);
            } else {
                ((GroupTreeNode)groupTreeNode.getParent()).insert(groupTreeNode2, groupTreeNode.getParent().getIndex(groupTreeNode) + 1);
            }
            UndoableAddOrRemoveGroup undoableAddOrRemoveGroup = new UndoableAddOrRemoveGroup(GroupSelector.this, GroupSelector.this.groupsRoot, groupTreeNode2, 0);
            GroupSelector.this.revalidateGroups();
            GroupSelector.this.groupsTree.expandPath(new TreePath((groupTreeNode != null ? groupTreeNode : GroupSelector.this.groupsRoot).getPath()));
            ((GroupSelector)GroupSelector.this).panel.undoManager.addEdit(undoableAddOrRemoveGroup);
            GroupSelector.this.panel.markBaseChanged();
            GroupSelector.this.frame.output(Globals.lang("Added group \"%0\".", abstractGroup.getName()));
        }
    }

    private class EditGroupAction
    extends NodeAction {
        public EditGroupAction() {
            super(Globals.lang("Edit group"));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            GroupTreeNode groupTreeNode = this.getNodeToUse();
            AbstractGroup abstractGroup = groupTreeNode.getGroup();
            GroupDialog groupDialog = new GroupDialog(GroupSelector.this.frame, GroupSelector.this.panel, abstractGroup);
            groupDialog.setVisible(true);
            if (groupDialog.okPressed()) {
                AbstractGroup abstractGroup2 = groupDialog.getResultingGroup();
                AbstractUndoableEdit abstractUndoableEdit = groupDialog.getUndoForAddPreviousEntries();
                UndoableModifyGroup undoableModifyGroup = new UndoableModifyGroup(GroupSelector.this, GroupSelector.this.groupsRoot, groupTreeNode, abstractGroup2);
                groupTreeNode.setGroup(abstractGroup2);
                GroupSelector.this.revalidateGroups(groupTreeNode);
                if (abstractUndoableEdit == null) {
                    ((GroupSelector)GroupSelector.this).panel.undoManager.addEdit(undoableModifyGroup);
                } else {
                    NamedCompound namedCompound = new NamedCompound("Modify Group");
                    namedCompound.addEdit(undoableModifyGroup);
                    namedCompound.addEdit(abstractUndoableEdit);
                    namedCompound.end();
                    ((GroupSelector)GroupSelector.this).panel.undoManager.addEdit(namedCompound);
                }
                GroupSelector.this.panel.markBaseChanged();
                GroupSelector.this.frame.output(Globals.lang("Modified group \"%0\".", abstractGroup2.getName()));
            }
        }
    }

    private abstract class NodeAction
    extends AbstractAction {
        GroupTreeNode m_node;

        public NodeAction(String string) {
            super(string);
            this.m_node = null;
        }

        public GroupTreeNode getNode() {
            return this.m_node;
        }

        public void setNode(GroupTreeNode groupTreeNode) {
            this.m_node = groupTreeNode;
        }

        public GroupTreeNode getNodeToUse() {
            if (this.m_node != null) {
                return this.m_node;
            }
            TreePath treePath = GroupSelector.this.groupsTree.getSelectionPath();
            if (treePath != null) {
                return (GroupTreeNode)treePath.getLastPathComponent();
            }
            return null;
        }
    }

    class GroupingWorker
    extends AbstractWorker {
        private final SearchRule rules;
        private final String searchTerm;
        private final ArrayList<BibtexEntry> matches = new ArrayList();
        private final boolean showOverlappingGroupsP;
        int hits = 0;

        public GroupingWorker(SearchRule searchRule, String string) {
            this.rules = searchRule;
            this.searchTerm = string;
            this.showOverlappingGroupsP = GroupSelector.this.showOverlappingGroups.isSelected();
        }

        @Override
        public void run() {
            for (BibtexEntry bibtexEntry : GroupSelector.this.panel.getDatabase().getEntries()) {
                boolean bl = this.rules.applyRule(this.searchTerm, bibtexEntry);
                bibtexEntry.setGroupHit(bl);
                if (!bl) continue;
                ++this.hits;
                if (!this.showOverlappingGroupsP) continue;
                this.matches.add(bibtexEntry);
            }
        }

        @Override
        public void update() {
            if (GroupSelector.this.hideNonHits.isSelected()) {
                ((GroupSelector)GroupSelector.this).panel.mainTable.stopShowingFloatGrouping();
                GroupSelector.this.panel.setGroupMatcher(GroupMatcher.INSTANCE);
            } else if (GroupSelector.this.grayOut.isSelected()) {
                GroupSelector.this.panel.stopShowingGroup();
                ((GroupSelector)GroupSelector.this).panel.mainTable.showFloatGrouping(GroupMatcher.INSTANCE);
            }
            if (this.showOverlappingGroupsP) {
                GroupSelector.this.showOverlappingGroups(this.matches);
            }
            GroupSelector.this.frame.output(Globals.lang("Updated group selection") + ".");
        }
    }
}

