/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jabref.groups;

import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.datatransfer.UnsupportedFlavorException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import javax.swing.undo.AbstractUndoableEdit;
import net.sf.jabref.BibtexDatabase;
import net.sf.jabref.BibtexEntry;
import net.sf.jabref.groups.GroupSelector;
import net.sf.jabref.groups.UndoableChangeAssignment;
import net.sf.jabref.groups.UndoableMoveGroup;
import net.sf.jabref.groups.structure.AbstractGroup;
import net.sf.jabref.groups.structure.AllEntriesGroup;
import net.sf.jabref.groups.structure.GroupHierarchyType;
import net.sf.jabref.search.SearchRule;
import net.sf.jabref.search.rules.sets.SearchRuleSet;
import net.sf.jabref.search.rules.sets.SearchRuleSets;

public class GroupTreeNode
extends DefaultMutableTreeNode
implements Transferable {
    public static final DataFlavor flavor;
    private static final DataFlavor[] flavors;

    public GroupTreeNode(AbstractGroup abstractGroup) {
        this.setGroup(abstractGroup);
    }

    public AbstractGroup getGroup() {
        return (AbstractGroup)this.getUserObject();
    }

    public void setGroup(AbstractGroup abstractGroup) {
        this.setUserObject(abstractGroup);
    }

    public String getTreeAsString() {
        StringBuilder stringBuilder = new StringBuilder();
        Enumeration<GroupTreeNode> enumeration = this.preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            GroupTreeNode groupTreeNode = enumeration.nextElement();
            stringBuilder.append(groupTreeNode.getLevel()).append(" ").append(groupTreeNode.getGroup().toString()).append("\n");
        }
        return stringBuilder.toString();
    }

    public GroupTreeNode deepCopy() {
        GroupTreeNode groupTreeNode = new GroupTreeNode(this.getGroup());
        for (int i = 0; i < this.getChildCount(); ++i) {
            groupTreeNode.add(((GroupTreeNode)this.getChildAt(i)).deepCopy());
        }
        return groupTreeNode;
    }

    public void refreshGroupsForNewDatabase(BibtexDatabase bibtexDatabase) {
        for (int i = 0; i < this.getChildCount(); ++i) {
            GroupTreeNode groupTreeNode = (GroupTreeNode)this.getChildAt(i);
            groupTreeNode.getGroup().refreshForNewDatabase(bibtexDatabase);
            groupTreeNode.refreshGroupsForNewDatabase(bibtexDatabase);
        }
    }

    public int[] getIndexedPath() {
        TreeNode[] treeNodeArray = this.getPath();
        int[] nArray = new int[treeNodeArray.length - 1];
        for (int i = 1; i < treeNodeArray.length; ++i) {
            nArray[i - 1] = treeNodeArray[i - 1].getIndex(treeNodeArray[i]);
        }
        return nArray;
    }

    public GroupTreeNode getNode(int[] nArray) {
        GroupTreeNode groupTreeNode = this;
        for (int n : nArray) {
            groupTreeNode = (GroupTreeNode)groupTreeNode.getChildAt(n);
        }
        return groupTreeNode;
    }

    public GroupTreeNode getDescendant(int[] nArray) {
        GroupTreeNode groupTreeNode = this;
        for (int n = 0; n < nArray.length && groupTreeNode != null; groupTreeNode = (GroupTreeNode)groupTreeNode.getChildAt(nArray[n]), ++n) {
        }
        return groupTreeNode;
    }

    public SearchRule getSearchRule() {
        return this.getSearchRule(this.getGroup().getHierarchicalContext());
    }

    private SearchRule getSearchRule(GroupHierarchyType groupHierarchyType) {
        GroupHierarchyType groupHierarchyType2 = this.getGroup().getHierarchicalContext();
        if (groupHierarchyType2 == GroupHierarchyType.INDEPENDENT) {
            return this.getGroup().getSearchRule();
        }
        SearchRuleSet searchRuleSet = SearchRuleSets.build(groupHierarchyType2 == GroupHierarchyType.REFINING ? SearchRuleSets.RuleSetType.AND : SearchRuleSets.RuleSetType.OR);
        searchRuleSet.addRule(this.getGroup().getSearchRule());
        if (groupHierarchyType2 == GroupHierarchyType.INCLUDING && groupHierarchyType != GroupHierarchyType.REFINING) {
            for (int i = 0; i < this.getChildCount(); ++i) {
                searchRuleSet.addRule(((GroupTreeNode)this.getChildAt(i)).getSearchRule(groupHierarchyType));
            }
        } else if (groupHierarchyType2 == GroupHierarchyType.REFINING && !this.isRoot() && groupHierarchyType != GroupHierarchyType.INCLUDING) {
            searchRuleSet.addRule(((GroupTreeNode)this.getParent()).getSearchRule(groupHierarchyType));
        }
        return searchRuleSet;
    }

    public Enumeration<GroupTreeNode> preorderEnumeration() {
        return super.preorderEnumeration();
    }

    public Enumeration<GroupTreeNode> depthFirstEnumeration() {
        return super.depthFirstEnumeration();
    }

    public Enumeration<GroupTreeNode> breadthFirstEnumeration() {
        return super.breadthFirstEnumeration();
    }

    public Enumeration<GroupTreeNode> children() {
        return super.children();
    }

    public AbstractGroup[] getMatchingGroups(BibtexEntry bibtexEntry) {
        Vector<AbstractGroup> vector = new Vector<AbstractGroup>();
        Enumeration<GroupTreeNode> enumeration = this.preorderEnumeration();
        while (enumeration.hasMoreElements()) {
            AbstractGroup abstractGroup = enumeration.nextElement().getGroup();
            if (!abstractGroup.contains(null, bibtexEntry)) continue;
            vector.add(abstractGroup);
        }
        AbstractGroup[] abstractGroupArray = new AbstractGroup[vector.size()];
        return vector.toArray(abstractGroupArray);
    }

    public boolean canMoveUp() {
        return this.getPreviousSibling() != null && !(this.getGroup() instanceof AllEntriesGroup);
    }

    public boolean canMoveDown() {
        return this.getNextSibling() != null && !(this.getGroup() instanceof AllEntriesGroup);
    }

    public boolean canMoveLeft() {
        return !(this.getGroup() instanceof AllEntriesGroup) && !(((GroupTreeNode)this.getParent()).getGroup() instanceof AllEntriesGroup);
    }

    public boolean canMoveRight() {
        return this.getPreviousSibling() != null && !(this.getGroup() instanceof AllEntriesGroup);
    }

    public AbstractUndoableEdit moveUp(GroupSelector groupSelector) {
        GroupTreeNode groupTreeNode = (GroupTreeNode)this.getParent();
        int n = groupTreeNode.getIndex(this);
        if (n > 0) {
            UndoableMoveGroup undoableMoveGroup = new UndoableMoveGroup(groupSelector, groupSelector.getGroupTreeRoot(), this, groupTreeNode, n - 1);
            groupTreeNode.insert(this, n - 1);
            return undoableMoveGroup;
        }
        return null;
    }

    public AbstractUndoableEdit moveDown(GroupSelector groupSelector) {
        GroupTreeNode groupTreeNode = (GroupTreeNode)this.getParent();
        int n = groupTreeNode.getIndex(this);
        if (n < this.parent.getChildCount() - 1) {
            UndoableMoveGroup undoableMoveGroup = new UndoableMoveGroup(groupSelector, groupSelector.getGroupTreeRoot(), this, groupTreeNode, n + 1);
            groupTreeNode.insert(this, n + 1);
            return undoableMoveGroup;
        }
        return null;
    }

    public AbstractUndoableEdit moveLeft(GroupSelector groupSelector) {
        GroupTreeNode groupTreeNode = (GroupTreeNode)this.getParent();
        GroupTreeNode groupTreeNode2 = (GroupTreeNode)groupTreeNode.getParent();
        if (groupTreeNode2 == null) {
            return null;
        }
        int n = groupTreeNode2.getIndex(groupTreeNode);
        UndoableMoveGroup undoableMoveGroup = new UndoableMoveGroup(groupSelector, groupSelector.getGroupTreeRoot(), this, groupTreeNode2, n + 1);
        groupTreeNode2.insert(this, n + 1);
        return undoableMoveGroup;
    }

    public AbstractUndoableEdit moveRight(GroupSelector groupSelector) {
        GroupTreeNode groupTreeNode = (GroupTreeNode)this.getPreviousSibling();
        if (groupTreeNode == null) {
            return null;
        }
        UndoableMoveGroup undoableMoveGroup = new UndoableMoveGroup(groupSelector, groupSelector.getGroupTreeRoot(), this, groupTreeNode, groupTreeNode.getChildCount());
        groupTreeNode.add(this);
        return undoableMoveGroup;
    }

    public GroupTreeNode getChildAt(int[] nArray) {
        GroupTreeNode groupTreeNode = this;
        for (int n = 0; n < nArray.length && groupTreeNode != null; groupTreeNode = (GroupTreeNode)groupTreeNode.getChildAt(nArray[n]), ++n) {
        }
        return groupTreeNode;
    }

    public AbstractUndoableEdit addToGroup(BibtexEntry[] bibtexEntryArray) {
        if (this.getGroup() == null) {
            return null;
        }
        AbstractUndoableEdit abstractUndoableEdit = this.getGroup().add(bibtexEntryArray);
        if (abstractUndoableEdit instanceof UndoableChangeAssignment) {
            ((UndoableChangeAssignment)abstractUndoableEdit).setEditedNode(this);
        }
        return abstractUndoableEdit;
    }

    public AbstractUndoableEdit removeFromGroup(BibtexEntry[] bibtexEntryArray) {
        if (this.getGroup() == null) {
            return null;
        }
        AbstractUndoableEdit abstractUndoableEdit = this.getGroup().remove(bibtexEntryArray);
        if (abstractUndoableEdit instanceof UndoableChangeAssignment) {
            ((UndoableChangeAssignment)abstractUndoableEdit).setEditedNode(this);
        }
        return abstractUndoableEdit;
    }

    @Override
    public DataFlavor[] getTransferDataFlavors() {
        return flavors;
    }

    @Override
    public boolean isDataFlavorSupported(DataFlavor dataFlavor) {
        return dataFlavor.equals(flavor);
    }

    @Override
    public Object getTransferData(DataFlavor dataFlavor) throws UnsupportedFlavorException, IOException {
        if (!this.isDataFlavorSupported(dataFlavor)) {
            throw new UnsupportedFlavorException(dataFlavor);
        }
        return this;
    }

    public boolean equals(Object object) {
        if (!(object instanceof GroupTreeNode)) {
            return false;
        }
        GroupTreeNode groupTreeNode = (GroupTreeNode)object;
        if (this.getChildCount() != groupTreeNode.getChildCount()) {
            return false;
        }
        AbstractGroup abstractGroup = this.getGroup();
        AbstractGroup abstractGroup2 = groupTreeNode.getGroup();
        if (abstractGroup == null && abstractGroup2 != null || abstractGroup != null && abstractGroup2 == null) {
            return false;
        }
        if (abstractGroup != null && abstractGroup2 != null && !abstractGroup.equals(abstractGroup2)) {
            return false;
        }
        for (int i = 0; i < this.getChildCount(); ++i) {
            if (this.getChildAt(i).equals(groupTreeNode.getChildAt(i))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return this.getGroup().getName().hashCode();
    }

    static {
        DataFlavor dataFlavor = null;
        try {
            dataFlavor = new DataFlavor("application/x-java-jvm-local-objectref;class=net.sf.jabref.groups.GroupTreeNode");
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        flavor = dataFlavor;
        flavors = new DataFlavor[]{flavor};
    }
}

